/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles.place;

import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import java.util.ArrayList;
import java.util.List;

public class PlacePreviews
extends ArrayList<PlacePreviewTile> {
    public LittleGridContext context;

    public PlacePreviews(LittleGridContext context, List<PlacePreviewTile> previews) {
        super(previews);
        this.context = context;
        this.convertToSmallest();
    }

    public PlacePreviews(LittleGridContext context) {
        this.context = context;
    }

    public void ensureBothAreEqual(TileEntityLittleTiles te) {
        if (te.getContext() != this.context) {
            if (te.getContext().size > this.context.size) {
                this.convertTo(te.getContext());
            } else {
                te.convertTo(this.context);
            }
        }
    }

    public void convertTo(LittleGridContext to) {
        for (PlacePreviewTile preview : this) {
            preview.convertTo(this.context, to);
        }
        this.context = to;
    }

    public void convertToSmallest() {
        int size = LittleGridContext.minSize;
        for (PlacePreviewTile preview : this) {
            size = Math.max(size, preview.getSmallestContext(this.context));
        }
        if (size < this.context.size) {
            this.convertTo(LittleGridContext.get(size));
        }
    }

    public PlacePreviews copy() {
        PlacePreviews previews = new PlacePreviews(this.context);
        previews.addAll(this);
        return previews;
    }
}

