/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles.combine;

import com.creativemd.littletiles.common.tiles.combine.BasicCombiner;
import com.creativemd.littletiles.common.tiles.combine.ICombinable;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import java.util.ArrayList;
import java.util.List;

public class AdvancedCombiner<T extends ICombinable>
extends BasicCombiner {
    protected List<T> tiles;
    protected T currentTile;

    public AdvancedCombiner(List<T> tiles) {
        super(new ArrayList<LittleTileBox>());
        this.setCombinables(tiles);
    }

    public void setCombinables(List<T> tiles) {
        this.boxes.clear();
        for (ICombinable tile : tiles) {
            this.boxes.add(tile.getBox());
        }
        this.tiles = tiles;
    }

    public List<T> getCombinables() {
        return this.tiles;
    }

    public void onCombined(T first, T second) {
    }

    protected boolean shouldScan(T tile) {
        return !((ICombinable)this.tiles.get(this.i)).isChildOfStructure();
    }

    @Override
    public void combine() {
        this.modified = true;
        while (this.modified) {
            this.modified = false;
            this.i = 0;
            while (this.i < this.tiles.size()) {
                if (!this.shouldScan((ICombinable)this.tiles.get(this.i))) {
                    ++this.i;
                    continue;
                }
                this.j = 0;
                while (this.j < this.tiles.size()) {
                    if (!this.shouldScan((ICombinable)this.tiles.get(this.j))) {
                        ++this.j;
                        continue;
                    }
                    if (this.i != this.j && ((ICombinable)this.tiles.get(this.i)).canCombine((ICombinable)this.tiles.get(this.j))) {
                        this.currentTile = (ICombinable)this.tiles.get(this.i);
                        LittleTileBox box = ((ICombinable)this.tiles.get(this.i)).getBox().combineBoxes(((ICombinable)this.tiles.get(this.j)).getBox(), this);
                        if (box != null) {
                            this.onCombined((ICombinable)this.tiles.get(this.i), (ICombinable)this.tiles.get(this.j));
                            ((ICombinable)this.tiles.get(this.i)).setBox(box);
                            ((ICombinable)this.tiles.get(this.i)).combine((ICombinable)this.tiles.get(this.j));
                            this.tiles.remove(this.j);
                            this.boxes.set(this.i, box);
                            this.boxes.remove(this.j);
                            if (this.i > this.j) {
                                --this.i;
                            }
                            this.modified = true;
                            continue;
                        }
                    }
                    ++this.j;
                }
                ++this.i;
            }
        }
        this.tiles = null;
        this.currentTile = null;
    }

    public void addCuttedTile(T cutTile) {
        this.tiles.add(cutTile);
    }

    protected boolean canCutOut(T tile, T searching) {
        return !tile.isChildOfStructure() && tile.canCombine((ICombinable)searching);
    }

    public boolean cutOut(LittleTileBox searching, T toCombine) {
        boolean intersects = false;
        for (ICombinable tile : this.tiles) {
            if (tile.getBox().containsBox(searching)) {
                boolean canBeCombined = this.canCutOut(tile, toCombine);
                if (!canBeCombined || searching.getClass() != tile.getBox().getClass()) continue;
                List<LittleTileBox> cutOut = tile.getBox().cutOut(searching);
                if (cutOut != null) {
                    this.boxes.addAll(cutOut);
                    for (LittleTileBox cutBox : cutOut) {
                        ICombinable cutTile = toCombine.copy();
                        cutTile.setBox(cutBox);
                        this.addCuttedTile(cutTile);
                    }
                }
                this.removeBox(tile.getBox());
                return true;
            }
            if (!LittleTileBox.intersectsWith(tile.getBox(), searching)) continue;
            intersects = true;
            break;
        }
        if (intersects) {
            boolean canBeCombined;
            LittleTileSize size = searching.getSize();
            boolean[][][] filled = new boolean[size.sizeX][size.sizeY][size.sizeZ];
            for (ICombinable tile : this.tiles) {
                if (!LittleTileBox.intersectsWith(tile.getBox(), searching) || !(canBeCombined = tile.canCombine((ICombinable)toCombine)) || searching.getClass() != tile.getBox().getClass()) continue;
                tile.fillInSpace(searching, filled);
            }
            for (int x = 0; x < filled.length; ++x) {
                for (int y = 0; y < filled[x].length; ++y) {
                    for (int z = 0; z < filled[x][y].length; ++z) {
                        if (filled[x][y][z]) continue;
                        return false;
                    }
                }
            }
            int i = 0;
            while (i < this.tiles.size()) {
                ICombinable tile = (ICombinable)this.tiles.get(i);
                if (LittleTileBox.intersectsWith(tile.getBox(), searching) && (canBeCombined = this.canCutOut(tile, toCombine)) && searching.getClass() == tile.getBox().getClass()) {
                    List<LittleTileBox> cutOut = tile.getBox().cutOut(searching);
                    if (cutOut != null) {
                        this.boxes.addAll(cutOut);
                        for (LittleTileBox cutBox : cutOut) {
                            ICombinable cutTile = toCombine.copy();
                            cutTile.setBox(cutBox);
                            this.addCuttedTile(cutTile);
                        }
                    }
                    this.removeBox(tile.getBox());
                    continue;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean cutOut(LittleTileBox searching) {
        if (this.currentTile != null) {
            return this.cutOut(searching, this.currentTile);
        }
        return super.cutOut(searching);
    }

    @Override
    protected void removeBox(int index) {
        super.removeBox(index);
        this.tiles.remove(index);
    }
}

