/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiIconButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlClickEvent;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.littletiles.common.entity.DoorController;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.gui.controls.GuiDirectionIndicator;
import com.creativemd.littletiles.common.gui.controls.GuiLTDistance;
import com.creativemd.littletiles.common.gui.controls.GuiTileViewer;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.relative.StructureAbsolute;
import com.creativemd.littletiles.common.structure.type.LittleDoorBase;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.preview.LittleAbsolutePreviewsStructure;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVecContext;
import com.creativemd.littletiles.common.utils.animation.AnimationState;
import com.creativemd.littletiles.common.utils.animation.transformation.OffsetTransformation;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleSlidingDoor
extends LittleDoorBase {
    public EnumFacing moveDirection;
    public int moveDistance;
    public LittleGridContext moveContext;

    public LittleSlidingDoor(LittleStructureType type) {
        super(type);
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        super.loadFromNBTExtra(nbt);
        this.moveDistance = nbt.func_74762_e("distance");
        this.moveDirection = EnumFacing.func_82600_a((int)nbt.func_74762_e("direction"));
        this.moveContext = LittleGridContext.get(nbt);
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        super.writeToNBTExtra(nbt);
        nbt.func_74768_a("distance", this.moveDistance);
        nbt.func_74768_a("direction", this.moveDirection.func_176745_a());
        this.moveContext.set(nbt);
    }

    @Override
    public boolean tryToPlacePreviews(World world, EntityPlayer player, UUID uuid, StructureAbsolute absolute) {
        LittleTileVec offsetVec = new LittleTileVec(this.moveDirection);
        offsetVec.scale(this.moveDistance);
        LittleTileVecContext offset = new LittleTileVecContext(this.moveContext, offsetVec);
        LittleAbsolutePreviewsStructure previews = this.getAbsolutePreviews(this.getMainTile().te.func_174877_v().func_177971_a((Vec3i)offset.vec.getBlockPos(this.moveContext)));
        LittleSlidingDoor structure = (LittleSlidingDoor)previews.getStructure();
        structure.duration = this.duration;
        structure.moveDirection = this.moveDirection.func_176734_d();
        structure.moveDistance = this.moveDistance;
        structure.moveContext = this.moveContext;
        structure.setTiles((HashMapList<TileEntityLittleTiles, LittleTile>)new HashMapList());
        if (offset.context.size > previews.context.size) {
            previews.convertTo(offset.context);
        } else if (offset.context.size < previews.context.size) {
            offset.convertTo(previews.context);
        }
        previews.movePreviews(world, player, null, previews.context, offset.vec);
        return this.place(world, player, previews, new DoorController(new AnimationState("closed", null, new OffsetTransformation(this.moveDirection, this.moveContext, -this.moveDistance)), new AnimationState("opened", null, null), true, this.duration), uuid, absolute);
    }

    @Override
    public void onFlip(World world, EntityPlayer player, ItemStack stack, LittleGridContext context, EnumFacing.Axis axis, LittleTileVec doubledCenter) {
        if (axis == this.moveDirection.func_176740_k()) {
            this.moveDirection = this.moveDirection.func_176734_d();
        }
    }

    @Override
    public void onRotate(World world, EntityPlayer player, ItemStack stack, LittleGridContext context, Rotation rotation, LittleTileVec doubledCenter) {
        this.moveDirection = RotationUtils.rotate((EnumFacing)this.moveDirection, (Rotation)rotation);
    }

    @Override
    public StructureAbsolute getAbsoluteAxis() {
        return new StructureAbsolute(this.getMainTile().te.func_174877_v(), this.getMainTile().box, this.getMainTile().getContext());
    }

    @Override
    public LittleGridContext getMinContext() {
        return LittleGridContext.max(super.getMinContext(), this.moveContext);
    }

    public static class LittleSlidingDoorParser
    extends LittleDoorBase.LittleDoorBaseParser {
        public LittleSlidingDoorParser(GuiParent parent) {
            super(parent);
        }

        @SideOnly(value=Side.CLIENT)
        @CustomEventSubscribe
        public void buttonClicked(GuiControlClickEvent event) {
            if (event.source.is(new String[]{"direction"})) {
                GuiTileViewer viewer = (GuiTileViewer)this.parent.get("tileviewer");
                EnumFacing direction = EnumFacing.func_82600_a((int)((GuiStateButton)event.source).getState());
                GuiDirectionIndicator relativeDirection = (GuiDirectionIndicator)this.parent.get("relativeDirection");
                LittleSlidingDoorParser.updateDirection(viewer, direction, relativeDirection);
            }
        }

        @SideOnly(value=Side.CLIENT)
        public static void updateDirection(GuiTileViewer viewer, EnumFacing direction, GuiDirectionIndicator relativeDirection) {
            EnumFacing newDirection = EnumFacing.EAST;
            if (viewer.getXFacing().func_176740_k() == direction.func_176740_k()) {
                newDirection = viewer.getXFacing().func_176743_c() == direction.func_176743_c() ? EnumFacing.EAST : EnumFacing.WEST;
            } else if (viewer.getYFacing().func_176740_k() == direction.func_176740_k()) {
                newDirection = viewer.getYFacing().func_176743_c() == direction.func_176743_c() ? EnumFacing.DOWN : EnumFacing.UP;
            } else if (viewer.getZFacing().func_176740_k() == direction.func_176740_k()) {
                newDirection = viewer.getZFacing().func_176743_c() == direction.func_176743_c() ? EnumFacing.SOUTH : EnumFacing.NORTH;
            }
            relativeDirection.setDirection(newDirection);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void createControls(ItemStack stack, @Nullable LittleStructure structure) {
            LittleSlidingDoor door = null;
            if (structure instanceof LittleSlidingDoor) {
                door = (LittleSlidingDoor)structure;
            }
            LittleTileSize size = LittleTilePreview.getSize(stack);
            int index = EnumFacing.UP.ordinal();
            if (door != null) {
                index = door.moveDirection.ordinal();
            }
            final EnumFacing direction = EnumFacing.func_82600_a((int)index);
            LittleGridContext context = LittleGridContext.get(stack.func_77978_p());
            final GuiTileViewer viewer = new GuiTileViewer("tileviewer", 0, 0, 100, 100, context);
            viewer.visibleAxis = false;
            this.parent.addControl((GuiControl)viewer);
            this.parent.addControl((GuiControl)new GuiStateButton("direction", index, 110, 0, 37, 12, RotationUtils.getFacingNames()));
            final GuiDirectionIndicator relativeDirection = new GuiDirectionIndicator("relativeDirection", 155, 0, EnumFacing.UP);
            this.parent.addControl((GuiControl)relativeDirection);
            int distance = size.getSizeOfAxis(direction.func_176740_k());
            if (door != null) {
                distance = door.moveDistance;
                context = door.moveContext;
            }
            this.parent.addControl((GuiControl)new GuiLTDistance("distance", 110, 21, context, distance));
            this.parent.addControl(new GuiIconButton("reset view", 20, 107, 8){

                public void onClicked(int x, int y, int button) {
                    viewer.offsetX.set(0.0);
                    viewer.offsetY.set(0.0);
                    viewer.scale.set(40.0);
                }
            }.setCustomTooltip(new String[]{"reset view"}));
            this.parent.addControl(new GuiIconButton("change view", 40, 107, 7){

                public void onClicked(int x, int y, int button) {
                    switch (viewer.getAxis()) {
                        case X: {
                            viewer.setViewAxis(EnumFacing.Axis.Y);
                            break;
                        }
                        case Y: {
                            viewer.setViewAxis(EnumFacing.Axis.Z);
                            break;
                        }
                        case Z: {
                            viewer.setViewAxis(EnumFacing.Axis.X);
                            break;
                        }
                    }
                    LittleSlidingDoorParser.updateDirection(viewer, direction, relativeDirection);
                }
            }.setCustomTooltip(new String[]{"change view"}));
            this.parent.addControl(new GuiIconButton("flip view", 60, 107, 4){

                public void onClicked(int x, int y, int button) {
                    viewer.setViewDirection(viewer.getViewDirection().func_176734_d());
                    LittleSlidingDoorParser.updateDirection(viewer, direction, relativeDirection);
                }
            }.setCustomTooltip(new String[]{"flip view"}));
            super.createControls(stack, structure);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public LittleSlidingDoor parseStructure(int duration) {
            EnumFacing direction = EnumFacing.func_82600_a((int)((GuiStateButton)this.parent.get("direction")).getState());
            GuiLTDistance distance = (GuiLTDistance)this.parent.get("distance");
            LittleSlidingDoor door = this.createStructure(LittleSlidingDoor.class);
            door.duration = duration;
            door.moveDirection = direction;
            door.moveDistance = distance.getDistance();
            door.moveContext = distance.getDistanceContext();
            return door;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void onLoaded(EntityAnimation animation, LittleTileBox entireBox, LittleGridContext context, AxisAlignedBB box) {
            super.onLoaded(animation, entireBox, context, box);
            GuiTileViewer viewer = (GuiTileViewer)this.parent.get("tileviewer");
            GuiDirectionIndicator relativeDirection = (GuiDirectionIndicator)this.parent.get("relativeDirection");
            EnumFacing direction = EnumFacing.func_82600_a((int)((GuiStateButton)this.parent.get("direction")).getState());
            LittleSlidingDoorParser.updateDirection(viewer, direction, relativeDirection);
        }
    }
}

