/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.connection;

import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.attribute.LittleStructureAttribute;
import com.creativemd.littletiles.common.structure.connection.IStructureChildConnector;
import com.creativemd.littletiles.common.structure.connection.StructureLinkBaseRelative;
import com.creativemd.littletiles.common.structure.connection.StructureLinkFromSubWorld;
import com.creativemd.littletiles.common.structure.connection.StructureLinkToSubWorld;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StructureLink
extends StructureLinkBaseRelative<LittleStructure>
implements IStructureChildConnector<LittleStructure> {
    public final boolean isChild;
    public final int childID;

    public StructureLink(TileEntity te, BlockPos coord, LittleGridContext context, int[] identifier, LittleStructureAttribute attribute, LittleStructure parent, int childID, boolean isChild) {
        super(te, coord, context, identifier, attribute, parent);
        this.childID = childID;
        this.isChild = isChild;
    }

    public StructureLink(BlockPos origin, BlockPos coord, LittleGridContext context, int[] identifier, LittleStructureAttribute attribute, LittleStructure parent, int childID, boolean isChild) {
        super(origin, coord, context, identifier, attribute, parent);
        this.childID = childID;
        this.isChild = isChild;
    }

    public StructureLink(int baseX, int baseY, int baseZ, BlockPos coord, LittleGridContext context, int[] identifier, LittleStructureAttribute attribute, LittleStructure parent, int childID, boolean isChild) {
        super(baseX, baseY, baseZ, coord, context, identifier, attribute, parent);
        this.childID = childID;
        this.isChild = isChild;
    }

    public StructureLink(NBTTagCompound nbt, LittleStructure parent, boolean isChild) {
        super(nbt, parent);
        this.childID = nbt.func_74762_e("childID");
        this.isChild = isChild;
    }

    protected StructureLink(int relativeX, int relativeY, int relativeZ, LittleGridContext context, int[] identifier, LittleStructureAttribute attribute, LittleStructure parent, int childID, boolean isChild) {
        super(relativeX, relativeY, relativeZ, context, identifier, attribute, parent);
        this.childID = childID;
        this.isChild = isChild;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74768_a("childID", this.childID);
        return nbt;
    }

    @Override
    public BlockPos getStructurePosition() {
        return this.getAbsolutePosition((TileEntity)((LittleStructure)this.parent).getMainTile().te);
    }

    @Override
    protected void connect(World world, LittleTile mainTile) {
        this.connectedStructure = mainTile.connection.getStructureWithoutLoading();
        if (this.isChild) {
            IStructureChildConnector link = this.connectedStructure.children.get(this.childID);
            if (link == null) {
                new RuntimeException("Parent does not remember child! coord=" + this).printStackTrace();
                return;
            }
            link.setLoadedStructure((LittleStructure)this.parent, ((LittleStructure)this.parent).attribute);
        } else {
            if (this.connectedStructure.parent == null) {
                this.connectedStructure.updateParentConnection(this.childID, (LittleStructure)this.parent);
            }
            this.connectedStructure.parent.setLoadedStructure((LittleStructure)this.parent, ((LittleStructure)this.parent).attribute);
        }
    }

    @Override
    protected void failedConnect(World world) {
        new RuntimeException("Failed to connect to parent/ child structure! coord=" + this + "").printStackTrace();
    }

    public StructureLink copy(LittleStructure parent) {
        return new StructureLink(this.coord.func_177958_n(), this.coord.func_177956_o(), this.coord.func_177952_p(), this.context, (int[])this.identifier.clone(), this.attribute, parent, this.childID, this.isChild);
    }

    @Override
    public boolean isChild() {
        return this.isChild;
    }

    @Override
    public int getChildID() {
        return this.childID;
    }

    public static IStructureChildConnector loadFromNBT(LittleStructure structure, NBTTagCompound nbt, boolean isChild) {
        if (nbt.func_74764_b("entity")) {
            return new StructureLinkToSubWorld(nbt, structure);
        }
        if (nbt.func_74767_n("subWorld")) {
            return new StructureLinkFromSubWorld(nbt, structure);
        }
        return new StructureLink(nbt, structure, isChild);
    }

    @Override
    public void destroyStructure() {
        if (this.connectedStructure.hasLoaded() && this.connectedStructure.loadChildren()) {
            for (Map.Entry<TileEntityLittleTiles, ArrayList<LittleTile>> entry : this.connectedStructure.getEntrySet()) {
                entry.getKey().removeTiles((Collection<LittleTile>)entry.getValue());
            }
            for (IStructureChildConnector child : this.connectedStructure.children.values()) {
                child.destroyStructure();
            }
        }
    }
}

