/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.world.WorldFake;
import com.creativemd.creativecore.gui.container.GuiParent;
import com.creativemd.creativecore.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.gui.controls.gui.GuiSteppedSlider;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceRelative;
import com.creativemd.littletiles.common.entity.EntityDoorAnimation;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.LittleStructureParser;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.place.PlacePreviews;
import com.creativemd.littletiles.common.tiles.vec.LittleTilePos;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.placing.PlacementMode;
import com.creativemd.littletiles.common.utils.transformation.DoorTransformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class LittleDoorBase
extends LittleStructure {
    public boolean isWaitingForApprove = false;
    public int duration = 50;

    @Override
    public void onUpdatePacketReceived() {
        this.isWaitingForApprove = false;
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        this.duration = nbt.func_74764_b("duration") ? nbt.func_74762_e("duration") : 50;
        this.isWaitingForApprove = false;
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        nbt.func_74768_a("duration", this.duration);
    }

    public boolean place(World world, LittleDoorBase structure, EntityPlayer player, PlacePreviews previews, BlockPos pos, DoorTransformation transformation, UUID uuid, LittleTilePos absolute, LittleTileVec additional) {
        HashMap<BlockPos, PlacePreviews> splitted = LittleActionPlaceRelative.getSplittedTiles(previews.context, previews, pos);
        if (LittleActionPlaceRelative.canPlaceTiles(player, world, splitted, PlacementMode.all.getCoordsToCheck(splitted, pos), PlacementMode.all)) {
            ArrayList<TileEntityLittleTiles> blocks = new ArrayList<TileEntityLittleTiles>();
            WorldFake fakeWorld = WorldFake.createFakeWorld((World)world);
            LittleActionPlaceRelative.placeTilesWithoutPlayer((World)fakeWorld, previews.context, splitted, (LittleStructure)structure, PlacementMode.all, pos, null, null, null, EnumFacing.EAST);
            for (Object te : fakeWorld.field_147482_g) {
                if (!(te instanceof TileEntityLittleTiles)) continue;
                blocks.add((TileEntityLittleTiles)te);
            }
            if (world.field_72995_K) {
                for (Object te : this.tiles.keySet()) {
                    if (te.waitingAnimation == null) continue;
                    te.waitingAnimation.removeWaitingTe((TileEntityLittleTiles)te);
                    te.waitingAnimation = null;
                }
            }
            EntityDoorAnimation animation = new EntityDoorAnimation(world, fakeWorld, structure, blocks, previews, absolute, transformation, uuid, player, additional, pos);
            world.func_72838_d((Entity)animation);
            return true;
        }
        return false;
    }

    public Rotation getDefaultRotation() {
        return null;
    }

    public abstract boolean activate(World var1, @Nullable EntityPlayer var2, Rotation var3, BlockPos var4);

    public abstract LittleTilePos getAbsoluteAxisVec();

    public abstract LittleTileVec getAdditionalAxisVec();

    public abstract LittleDoorBase copyToPlaceDoor();

    public List<PlacePreviewTile> getAdditionalPreviews(PlacePreviews previews) {
        return new ArrayList<PlacePreviewTile>();
    }

    public static abstract class LittleDoorBaseParser<T extends LittleDoorBase>
    extends LittleStructureParser<T> {
        public LittleDoorBaseParser(String id, GuiParent parent) {
            super(id, parent);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void createControls(ItemStack stack, LittleStructure structure) {
            this.parent.controls.add(new GuiLabel("Duration:", 0, 141));
            this.parent.controls.add(new GuiSteppedSlider("duration_s", 50, 140, 50, 12, structure instanceof LittleDoorBase ? ((LittleDoorBase)structure).duration : 50, 1, 500));
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public T parseStructure(ItemStack stack) {
            GuiSteppedSlider slider = (GuiSteppedSlider)this.parent.get("duration_s");
            return this.parseStructure((int)slider.value);
        }

        @SideOnly(value=Side.CLIENT)
        public abstract T parseStructure(int var1);
    }
}

