/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.events.LittleDoorHandler;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;

public class LittleEntityInteractPacket
extends CreativeCorePacket {
    public UUID uuid;

    public LittleEntityInteractPacket(UUID uuid) {
        this.uuid = uuid;
    }

    public LittleEntityInteractPacket() {
    }

    public void writeBytes(ByteBuf buf) {
        LittleEntityInteractPacket.writeString((ByteBuf)buf, (String)this.uuid.toString());
    }

    public void readBytes(ByteBuf buf) {
        this.uuid = UUID.fromString(LittleEntityInteractPacket.readString((ByteBuf)buf));
    }

    public void executeClient(EntityPlayer player) {
        for (EntityAnimation animation : LittleDoorHandler.client.openDoors) {
            if (!animation.func_110124_au().equals(this.uuid)) continue;
            animation.onRightClick(player);
            break;
        }
    }

    public void executeServer(EntityPlayer player) {
        for (EntityAnimation animation : LittleDoorHandler.server.openDoors) {
            if (!animation.func_110124_au().equals(this.uuid)) continue;
            if (!animation.onRightClick(player)) break;
            for (EntityPlayer toPlayer : ((WorldServer)animation.field_70170_p).func_73039_n().getTrackingPlayers((Entity)animation)) {
                PacketHandler.sendPacketToPlayer((CreativeCorePacket)new LittleEntityInteractPacket(this.uuid), (EntityPlayerMP)((EntityPlayerMP)toPlayer));
            }
        }
    }
}

