/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.items;

import com.creativemd.creativecore.client.avatar.AvatarItemStack;
import com.creativemd.creativecore.client.rendering.RenderCubeObject;
import com.creativemd.creativecore.client.rendering.model.CreativeBakedModel;
import com.creativemd.creativecore.client.rendering.model.ICreativeRendered;
import com.creativemd.creativecore.common.gui.controls.gui.GuiAvatarLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiColorPicker;
import com.creativemd.creativecore.common.gui.controls.gui.GuiSteppedSlider;
import com.creativemd.creativecore.common.gui.controls.gui.custom.GuiStackSelectorAll;
import com.creativemd.creativecore.common.gui.event.container.SlotChangeEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlClickEvent;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.block.LittleActionReplace;
import com.creativemd.littletiles.common.api.ILittleTile;
import com.creativemd.littletiles.common.blocks.BlockTile;
import com.creativemd.littletiles.common.config.SpecialServerConfig;
import com.creativemd.littletiles.common.container.SubContainerConfigure;
import com.creativemd.littletiles.common.gui.LittleSubGuiUtils;
import com.creativemd.littletiles.common.gui.SubGuiGrabber;
import com.creativemd.littletiles.common.gui.configure.SubGuiConfigure;
import com.creativemd.littletiles.common.gui.configure.SubGuiModeSelector;
import com.creativemd.littletiles.common.items.ItemBlockTiles;
import com.creativemd.littletiles.common.items.ItemMultiTiles;
import com.creativemd.littletiles.common.packet.LittleBlockPacket;
import com.creativemd.littletiles.common.packet.LittleVanillaBlockPacket;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.LittleTileBlock;
import com.creativemd.littletiles.common.tiles.LittleTileBlockColored;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.placing.PlacementHelper;
import com.creativemd.littletiles.common.utils.placing.PlacementMode;
import com.creativemd.littletiles.common.utils.tooltip.TooltipUtils;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.Color;

public class ItemLittleGrabber
extends Item
implements ICreativeRendered,
ILittleTile {
    public ItemLittleGrabber() {
        this.func_77637_a(LittleTiles.littleTab);
        this.field_77787_bX = true;
        this.func_77625_d(1);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        ItemLittleGrabber.getMode(stack).addExtraInformation(stack.func_77978_p(), tooltip);
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public List<RenderCubeObject> getRenderingCubes(IBlockState state, TileEntity te, ItemStack stack) {
        return ItemLittleGrabber.getMode(stack).getRenderingCubes(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void applyCustomOpenGLHackery(ItemStack stack, ItemCameraTransforms.TransformType cameraTransformType) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179094_E();
        IBakedModel model = mc.func_175599_af().func_175037_a().func_178083_a().func_174953_a(new ModelResourceLocation("littletiles:grabber_background", "inventory"));
        ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)cameraTransformType, (boolean)false);
        mc.func_175599_af().func_180454_a(new ItemStack(Items.field_151121_aF), model);
        if (cameraTransformType == ItemCameraTransforms.TransformType.GUI) {
            GlStateManager.func_179139_a((double)0.9, (double)0.9, (double)0.9);
            GrabberMode mode = ItemLittleGrabber.getMode(stack);
            if (mode.renderBlockSeparately(stack)) {
                LittleTilePreview preview = mode.getSeparateRenderingPreview(stack);
                ItemStack blockStack = new ItemStack(preview.getPreviewBlock(), 1, preview.getPreviewBlockMeta());
                model = mc.func_175599_af().func_184393_a(blockStack, (World)mc.field_71441_e, (EntityLivingBase)mc.field_71439_g);
                if (!(model instanceof CreativeBakedModel)) {
                    ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)cameraTransformType, (boolean)false);
                }
                GlStateManager.func_179097_i();
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
                try {
                    if (model.func_188618_c()) {
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        GlStateManager.func_179091_B();
                        TileEntityItemStackRenderer.field_147719_a.func_179022_a(blockStack);
                    } else {
                        Color color = preview.hasColor() ? ColorUtils.IntToRGBA((int)preview.getColor()) : ColorUtils.IntToRGBA((int)-1);
                        color.setAlpha(255);
                        ReflectionHelper.findMethod(RenderItem.class, (String)"renderModel", (String)"func_191967_a", (Class[])new Class[]{IBakedModel.class, Integer.TYPE, ItemStack.class}).invoke((Object)mc.func_175599_af(), model, ColorUtils.RGBAToInt((Color)color), blockStack);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179126_j();
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean hasLittlePreview(ItemStack stack) {
        return true;
    }

    @Override
    public LittlePreviews getLittlePreview(ItemStack stack) {
        return ItemLittleGrabber.getMode(stack).getPreviews(stack);
    }

    @Override
    public void saveLittlePreview(ItemStack stack, LittlePreviews previews) {
        ItemLittleGrabber.getMode(stack).setPreviews(previews, stack);
    }

    @Override
    public boolean containsIngredients(ItemStack stack) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClickAir(EntityPlayer player, ItemStack stack) {
        ItemLittleGrabber.getMode(stack).onClickBlock(player, stack, null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onClickBlock(EntityPlayer player, ItemStack stack, PlacementHelper.PositionResult position, RayTraceResult result) {
        ItemLittleGrabber.getMode(stack).onClickBlock(player, stack, result);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onRightClick(EntityPlayer player, ItemStack stack, PlacementHelper.PositionResult position, RayTraceResult result) {
        return ItemLittleGrabber.getMode(stack).onRightClick(player, stack, result);
    }

    @Override
    public boolean onMouseWheelClickBlock(EntityPlayer player, ItemStack stack, RayTraceResult result) {
        return ItemLittleGrabber.getMode(stack).onMouseWheelClickBlock(player, stack, result);
    }

    @Override
    public PlacementMode getPlacementMode(ItemStack stack) {
        return ItemMultiTiles.currentMode;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SubGuiConfigure getConfigureGUI(EntityPlayer player, ItemStack stack) {
        return ItemLittleGrabber.getMode(stack).getGui(player, stack, ((ILittleTile)stack.func_77973_b()).getPositionContext(stack));
    }

    @Override
    public SubContainerConfigure getConfigureContainer(EntityPlayer player, ItemStack stack) {
        return ItemLittleGrabber.getMode(stack).getContainer(player, stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SubGuiConfigure getConfigureGUIAdvanced(EntityPlayer player, ItemStack stack) {
        return new SubGuiModeSelector(stack, ItemMultiTiles.currentContext, ItemMultiTiles.currentMode){

            @Override
            public void saveConfiguration(LittleGridContext context, PlacementMode mode) {
                ItemMultiTiles.currentContext = context;
                ItemMultiTiles.currentMode = mode;
            }
        };
    }

    @Override
    public LittleGridContext getPositionContext(ItemStack stack) {
        return ItemMultiTiles.currentContext;
    }

    public static GrabberMode getMode(String name) {
        GrabberMode mode = GrabberMode.modes.get(name);
        if (mode != null) {
            return mode;
        }
        return GrabberMode.defaultMode;
    }

    public static GrabberMode getMode(ItemStack stack) {
        GrabberMode mode;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((mode = GrabberMode.modes.get(stack.func_77978_p().func_74779_i("mode"))) != null) {
            return mode;
        }
        return GrabberMode.defaultMode;
    }

    public static void setMode(ItemStack stack, GrabberMode mode) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74778_a("mode", mode.name);
    }

    public static GrabberMode[] getModes() {
        return GrabberMode.modes.values().toArray(new GrabberMode[0]);
    }

    public static int indexOf(GrabberMode mode) {
        GrabberMode[] modes = ItemLittleGrabber.getModes();
        for (int i = 0; i < modes.length; ++i) {
            if (modes[i] != mode) continue;
            return i;
        }
        return -1;
    }

    public static class ReplaceMode
    extends SimpleMode {
        public ReplaceMode() {
            super("replace");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public SubGuiGrabber getGui(EntityPlayer player, ItemStack stack, LittleGridContext context) {
            return new SubGuiGrabber(this, stack, 140, 140, context){

                @Override
                public void createControls() {
                    LittleTilePreview preview = SimpleMode.getPreview(this.stack);
                    GuiStackSelectorAll selector = new GuiStackSelectorAll("preview", 0, 120, 112, this.getPlayer(), LittleSubGuiUtils.getCollector(this.getPlayer()), true);
                    selector.setSelectedForce(preview.getBlockStack());
                    this.controls.add(selector);
                    super.createControls();
                }

                public LittleTilePreview getPreview(LittleGridContext context) {
                    GuiStackSelectorAll selector = (GuiStackSelectorAll)this.get("preview");
                    ItemStack selected = selector.getSelected();
                    if (!selected.func_190926_b() && selected.func_77973_b() instanceof ItemBlock) {
                        LittleTileBlock tile = new LittleTileBlock(((ItemBlock)selected.func_77973_b()).func_179223_d(), selected.func_77952_i());
                        tile.box = new LittleTileBox(0, 0, 0, 1, 1, 1);
                        return ((LittleTile)tile).getPreviewTile();
                    }
                    return SimpleMode.getPreview(this.stack);
                }

                @Override
                public void saveConfiguration() {
                    LittleTilePreview preview = this.getPreview(this.context);
                    preview.box.set(0, 0, 0, 1, 1, 1);
                    SimpleMode.setPreview(this.stack, preview);
                    this.context.set(this.stack.func_77978_p());
                }
            };
        }

        @Override
        public SubContainerConfigure getContainer(EntityPlayer player, ItemStack stack) {
            return new SubContainerConfigure(player, stack);
        }

        @Override
        public LittlePreviews getPreviews(ItemStack stack) {
            return new LittlePreviews(LittleGridContext.get());
        }

        @Override
        public boolean onRightClick(EntityPlayer player, ItemStack stack, RayTraceResult result) {
            if (PlacementHelper.canBlockBeUsed(player.field_70170_p, result.func_178782_a())) {
                new LittleActionReplace(result.func_178782_a(), player, ReplaceMode.getPreview(stack)).execute();
            }
            return false;
        }

        @Override
        public LittleTilePreview getSeparateRenderingPreview(ItemStack stack) {
            return ReplaceMode.getPreview(stack);
        }
    }

    public static class PlacePreviewMode
    extends GrabberMode {
        public PlacePreviewMode() {
            super("place_preview");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public boolean onMouseWheelClickBlock(EntityPlayer player, ItemStack stack, RayTraceResult result) {
            IBlockState state = player.field_70170_p.func_180495_p(result.func_178782_a());
            if (state.func_177230_c() instanceof BlockTile) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74757_a("secondMode", LittleAction.isUsingSecondMode(player));
                PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleBlockPacket(result.func_178782_a(), player, LittleBlockPacket.BlockPacketAction.GRABBER, nbt));
                return true;
            }
            return false;
        }

        @Override
        public void vanillaBlockAction(World world, ItemStack stack, BlockPos pos, IBlockState state) {
        }

        @Override
        public void littleBlockAction(World world, TileEntityLittleTiles te, LittleTile tile, ItemStack stack, BlockPos pos, NBTTagCompound nbt) {
            LittlePreviews previews = new LittlePreviews(te.getContext());
            if (nbt.func_74767_n("secondMode")) {
                for (LittleTile tileFromTE : te.getTiles()) {
                    previews.addWithoutCheckingPreview(tileFromTE.getPreviewTile());
                }
            } else {
                previews.addWithoutCheckingPreview(tile.getPreviewTile());
            }
            PlacePreviewMode.setPreview(stack, previews);
        }

        public static LittlePreviews getPreview(ItemStack stack) {
            LittlePreviews previews;
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if ((previews = LittleTilePreview.getPreview(stack)).size() == 0) {
                IBlockState state = stack.func_77978_p().func_74764_b("state") ? Block.func_176220_d((int)stack.func_77978_p().func_74762_e("state")) : Blocks.field_150348_b.func_176223_P();
                LittleTileBlock tile = stack.func_77978_p().func_74764_b("color") ? new LittleTileBlockColored(state.func_177230_c(), state.func_177230_c().func_176201_c(state), stack.func_77978_p().func_74762_e("color")) : new LittleTileBlock(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
                tile.box = new LittleTileBox(LittleGridContext.get().minPos, LittleGridContext.get().minPos, LittleGridContext.get().minPos, 1, 1, 1);
                LittleTilePreview preview = ((LittleTile)tile).getPreviewTile();
                previews.addWithoutCheckingPreview(preview);
                PlacePreviewMode.setPreview(stack, previews);
            }
            return previews;
        }

        public static void setPreview(ItemStack stack, LittlePreviews previews) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            LittleTilePreview.savePreview(previews, stack);
        }

        public static BlockPos getOrigin(ItemStack stack) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            return new BlockPos(stack.func_77978_p().func_74762_e("ox"), stack.func_77978_p().func_74762_e("oy"), stack.func_77978_p().func_74762_e("oz"));
        }

        public static void setOrigin(ItemStack stack, BlockPos pos) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74768_a("ox", pos.func_177958_n());
            stack.func_77978_p().func_74768_a("oy", pos.func_177956_o());
            stack.func_77978_p().func_74768_a("oz", pos.func_177952_p());
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public List<RenderCubeObject> getRenderingCubes(ItemStack stack) {
            return LittleTilePreview.getCubes(stack);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public boolean renderBlockSeparately(ItemStack stack) {
            return false;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public SubGuiGrabber getGui(EntityPlayer player, ItemStack stack, LittleGridContext context) {
            return new SubGuiGrabber(this, stack, 140, 140, context){

                @Override
                public void saveConfiguration() {
                }
            };
        }

        @Override
        public SubContainerConfigure getContainer(EntityPlayer player, ItemStack stack) {
            return new SubContainerConfigure(player, stack);
        }

        @Override
        public LittlePreviews getPreviews(ItemStack stack) {
            return PlacePreviewMode.getPreview(stack);
        }

        @Override
        public void setPreviews(LittlePreviews previews, ItemStack stack) {
            PlacePreviewMode.setPreview(stack, previews);
        }
    }

    public static class PixelMode
    extends SimpleMode {
        public PixelMode() {
            super("pixel");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public SubGuiGrabber getGui(EntityPlayer player, ItemStack stack, LittleGridContext context) {
            return new SubGuiGrabber(this, stack, 140, 140, context){
                public LittleTileSize size;
                public boolean isColored;
                {
                    super(mode, stack, width, height, context);
                    this.isColored = false;
                }

                @Override
                public void createControls() {
                    super.createControls();
                    LittleGridContext oldContext = LittleGridContext.get(this.stack.func_77978_p());
                    LittleTilePreview preview = SimpleMode.getPreview(this.stack);
                    preview.convertTo(oldContext, this.context);
                    if (preview.box.minX == preview.box.maxX) {
                        ++preview.box.maxX;
                    }
                    if (preview.box.minY == preview.box.maxY) {
                        ++preview.box.maxY;
                    }
                    if (preview.box.minZ == preview.box.maxZ) {
                        ++preview.box.maxZ;
                    }
                    this.size = preview.box.getSize();
                    this.controls.add(new GuiSteppedSlider("sizeX", 25, 20, 50, 10, this.size.sizeX, 1, this.context.size));
                    this.controls.add(new GuiSteppedSlider("sizeY", 25, 35, 50, 10, this.size.sizeY, 1, this.context.size));
                    this.controls.add(new GuiSteppedSlider("sizeZ", 25, 50, 50, 10, this.size.sizeZ, 1, this.context.size));
                    Color color = ColorUtils.IntToRGBA((int)preview.getColor());
                    this.controls.add(new GuiColorPicker("picker", 0, 70, color, SpecialServerConfig.isTransparencyEnabled(this.getPlayer()), SpecialServerConfig.getMinimumTransparency(this.getPlayer())));
                    GuiAvatarLabel label = new GuiAvatarLabel("", 110, 20, 0, null);
                    label.name = "avatar";
                    label.height = 60;
                    label.avatarSize = 32;
                    this.controls.add(label);
                    GuiStackSelectorAll selector = new GuiStackSelectorAll("preview", 0, 120, 112, this.getPlayer(), LittleSubGuiUtils.getCollector(this.getPlayer()), true);
                    selector.setSelectedForce(preview.getBlockStack());
                    this.controls.add(selector);
                    this.updateLabel();
                }

                public LittleTilePreview getPreview(LittleGridContext context) {
                    GuiStackSelectorAll selector = (GuiStackSelectorAll)this.get("preview");
                    ItemStack selected = selector.getSelected();
                    if (!selected.func_190926_b() && selected.func_77973_b() instanceof ItemBlock) {
                        LittleTileBlock tile = new LittleTileBlock(((ItemBlock)selected.func_77973_b()).func_179223_d(), selected.func_77952_i());
                        tile.box = new LittleTileBox(context.minPos, context.minPos, context.minPos, context.size, context.size, context.size);
                        return ((LittleTile)tile).getPreviewTile();
                    }
                    return SimpleMode.getPreview(this.stack);
                }

                public void updateLabel() {
                    GuiAvatarLabel label = (GuiAvatarLabel)this.get("avatar");
                    LittleTilePreview preview = this.getPreview(this.context);
                    GuiColorPicker picker = (GuiColorPicker)this.get("picker");
                    preview.setColor(ColorUtils.RGBAToInt((Color)picker.color));
                    preview.box.set(0, 0, 0, this.size.sizeX, this.size.sizeY, this.size.sizeZ);
                    label.avatar = new AvatarItemStack(ItemBlockTiles.getStackFromPreview(this.context, preview));
                }

                @CustomEventSubscribe
                public void onSlotChange(SlotChangeEvent event) {
                    LittlePreviews previews;
                    ItemStack slotStack = ((Slot)this.container.getSlots().get(0)).func_75211_c();
                    Block block = Block.func_149634_a((Item)slotStack.func_77973_b());
                    if (block instanceof BlockTile && (previews = ((ILittleTile)slotStack.func_77973_b()).getLittlePreview(slotStack)).size() > 0) {
                        int colorInt = previews.get(0).getColor();
                        Vec3i color = ColorUtils.IntToRGB((int)colorInt);
                        if (colorInt == -1) {
                            color = new Vec3i(255, 255, 255);
                        }
                        GuiColorPicker picker = (GuiColorPicker)this.get("picker");
                        picker.color.set(color.func_177958_n(), color.func_177956_o(), color.func_177952_p());
                    }
                    this.updateLabel();
                }

                @CustomEventSubscribe
                public void onClick(GuiControlClickEvent event) {
                    if (event.source.is(new String[]{"sliced"})) {
                        this.updateLabel();
                    }
                }

                @CustomEventSubscribe
                public void onChange(GuiControlChangedEvent event) {
                    this.size.sizeX = (int)((GuiSteppedSlider)this.get((String)"sizeX")).value;
                    this.size.sizeY = (int)((GuiSteppedSlider)this.get((String)"sizeY")).value;
                    this.size.sizeZ = (int)((GuiSteppedSlider)this.get((String)"sizeZ")).value;
                    this.updateLabel();
                }

                @Override
                public void saveConfiguration() {
                    LittleTilePreview preview = this.getPreview(this.context);
                    preview.box.set(this.context.minPos, this.context.minPos, this.context.minPos, this.size.sizeX, this.size.sizeY, this.size.sizeZ);
                    GuiColorPicker picker = (GuiColorPicker)this.get("picker");
                    preview.setColor(ColorUtils.RGBAToInt((Color)picker.color));
                    SimpleMode.setPreview(this.stack, preview);
                    this.context.set(this.stack.func_77978_p());
                }
            };
        }

        @Override
        public SubContainerConfigure getContainer(EntityPlayer player, ItemStack stack) {
            return new SubContainerConfigure(player, stack);
        }

        @Override
        public void addExtraInformation(NBTTagCompound nbt, List<String> tooltip) {
            super.addExtraInformation(nbt, tooltip);
            LittleTilePreview preview = SimpleMode.getPreview(nbt);
            tooltip.add(TooltipUtils.printRGB(preview.hasColor() ? preview.getColor() : -1));
        }
    }

    public static abstract class SimpleMode
    extends GrabberMode {
        public SimpleMode(String name) {
            super(name);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public boolean onMouseWheelClickBlock(EntityPlayer player, ItemStack stack, RayTraceResult result) {
            IBlockState state = player.field_70170_p.func_180495_p(result.func_178782_a());
            if (LittleAction.isBlockValid(state.func_177230_c())) {
                PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleVanillaBlockPacket(result.func_178782_a(), LittleVanillaBlockPacket.VanillaBlockAction.GRABBER));
                return true;
            }
            if (state.func_177230_c() instanceof BlockTile) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74757_a("secondMode", LittleAction.isUsingSecondMode(player));
                PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleBlockPacket(result.func_178782_a(), player, LittleBlockPacket.BlockPacketAction.GRABBER, nbt));
                return true;
            }
            return false;
        }

        public LittleGridContext getContext(ItemStack stack) {
            return LittleGridContext.get(stack.func_77978_p());
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public List<RenderCubeObject> getRenderingCubes(ItemStack stack) {
            return Collections.emptyList();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public boolean renderBlockSeparately(ItemStack stack) {
            return true;
        }

        @Override
        public LittlePreviews getPreviews(ItemStack stack) {
            LittlePreviews previews = new LittlePreviews(this.getContext(stack));
            previews.addWithoutCheckingPreview(SimpleMode.getPreview(stack));
            return previews;
        }

        @Override
        public void setPreviews(LittlePreviews previews, ItemStack stack) {
            SimpleMode.setPreview(stack, previews.get(0));
        }

        @Override
        public void vanillaBlockAction(World world, ItemStack stack, BlockPos pos, IBlockState state) {
            LittleTilePreview oldPreview = SimpleMode.getPreview(stack);
            LittleTileBlock tile = new LittleTileBlock(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
            tile.box = oldPreview.box;
            SimpleMode.setPreview(stack, ((LittleTile)tile).getPreviewTile());
        }

        @Override
        public void littleBlockAction(World world, TileEntityLittleTiles te, LittleTile tile, ItemStack stack, BlockPos pos, NBTTagCompound nbt) {
            LittleTilePreview oldPreview = SimpleMode.getPreview(stack);
            LittleTilePreview preview = tile.getPreviewTile();
            preview.box = oldPreview.box;
            SimpleMode.setPreview(stack, preview);
        }

        public static LittleTilePreview getPreview(ItemStack stack) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (stack.func_77978_p().func_74764_b("preview")) {
                return SimpleMode.getPreview(stack.func_77978_p());
            }
            LittleTilePreview preview = SimpleMode.getPreview(stack.func_77978_p());
            SimpleMode.setPreview(stack, preview);
            return preview;
        }

        public static LittleTilePreview getPreview(NBTTagCompound nbt) {
            if (nbt.func_74764_b("preview")) {
                return LittleTilePreview.loadPreviewFromNBT(nbt.func_74775_l("preview"));
            }
            IBlockState state = nbt.func_74764_b("state") ? Block.func_176220_d((int)nbt.func_74762_e("state")) : Blocks.field_150348_b.func_176223_P();
            LittleTileBlock tile = nbt.func_74764_b("color") ? new LittleTileBlockColored(state.func_177230_c(), state.func_177230_c().func_176201_c(state), nbt.func_74762_e("color")) : new LittleTileBlock(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
            tile.box = new LittleTileBox(LittleGridContext.get().minPos, LittleGridContext.get().minPos, LittleGridContext.get().minPos, 1, 1, 1);
            return ((LittleTile)tile).getPreviewTile();
        }

        public static void setPreview(ItemStack stack, LittleTilePreview preview) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound nbt = new NBTTagCompound();
            preview.writeToNBT(nbt);
            stack.func_77978_p().func_74782_a("preview", (NBTBase)nbt);
        }
    }

    public static abstract class GrabberMode {
        public static HashMap<String, GrabberMode> modes = new LinkedHashMap<String, GrabberMode>();
        public static PixelMode pixelMode = new PixelMode();
        public static PlacePreviewMode placePreviewMode = new PlacePreviewMode();
        public static ReplaceMode replaceMode = new ReplaceMode();
        public static GrabberMode defaultMode = pixelMode;
        public final String name;
        public final String title;

        public GrabberMode(String name) {
            this.name = name;
            this.title = "grabber.mode." + name;
            modes.put(name, this);
        }

        public void addExtraInformation(NBTTagCompound nbt, List<String> tooltip) {
        }

        public String getLocalizedName() {
            return I18n.func_74838_a((String)this.title);
        }

        @SideOnly(value=Side.CLIENT)
        public void onClickBlock(EntityPlayer player, ItemStack stack, @Nullable RayTraceResult result) {
        }

        @SideOnly(value=Side.CLIENT)
        public boolean onRightClick(EntityPlayer player, ItemStack stack, RayTraceResult result) {
            return true;
        }

        @SideOnly(value=Side.CLIENT)
        public abstract boolean onMouseWheelClickBlock(EntityPlayer var1, ItemStack var2, RayTraceResult var3);

        @SideOnly(value=Side.CLIENT)
        public abstract List<RenderCubeObject> getRenderingCubes(ItemStack var1);

        @SideOnly(value=Side.CLIENT)
        public abstract boolean renderBlockSeparately(ItemStack var1);

        @SideOnly(value=Side.CLIENT)
        public abstract SubGuiGrabber getGui(EntityPlayer var1, ItemStack var2, LittleGridContext var3);

        public abstract SubContainerConfigure getContainer(EntityPlayer var1, ItemStack var2);

        public abstract LittlePreviews getPreviews(ItemStack var1);

        public abstract void setPreviews(LittlePreviews var1, ItemStack var2);

        public LittleTilePreview getSeparateRenderingPreview(ItemStack stack) {
            return this.getPreviews(stack).get(0);
        }

        public abstract void vanillaBlockAction(World var1, ItemStack var2, BlockPos var3, IBlockState var4);

        public abstract void littleBlockAction(World var1, TileEntityLittleTiles var2, LittleTile var3, ItemStack var4, BlockPos var5, NBTTagCompound var6);
    }
}

