/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.items;

import com.creativemd.creativecore.client.rendering.RenderCubeObject;
import com.creativemd.creativecore.client.rendering.model.CreativeBakedModel;
import com.creativemd.creativecore.client.rendering.model.ICreativeRendered;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.api.ILittleTile;
import com.creativemd.littletiles.common.blocks.BlockTile;
import com.creativemd.littletiles.common.container.SubContainerConfigure;
import com.creativemd.littletiles.common.gui.SubGuiChisel;
import com.creativemd.littletiles.common.gui.SubGuiMarkMode;
import com.creativemd.littletiles.common.gui.configure.SubGuiConfigure;
import com.creativemd.littletiles.common.gui.configure.SubGuiModeSelector;
import com.creativemd.littletiles.common.items.ItemLittleGrabber;
import com.creativemd.littletiles.common.items.ItemMultiTiles;
import com.creativemd.littletiles.common.packet.LittleBlockPacket;
import com.creativemd.littletiles.common.packet.LittleVanillaBlockPacket;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.LittleTileBlock;
import com.creativemd.littletiles.common.tiles.LittleTileBlockColored;
import com.creativemd.littletiles.common.tiles.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleBoxes;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTilePos;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.placing.MarkMode;
import com.creativemd.littletiles.common.utils.placing.PlacementHelper;
import com.creativemd.littletiles.common.utils.placing.PlacementMode;
import com.creativemd.littletiles.common.utils.shape.DragShape;
import com.creativemd.littletiles.common.utils.tooltip.TooltipUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.Color;

public class ItemLittleChisel
extends Item
implements ICreativeRendered,
ILittleTile {
    public static PlacementHelper.PositionResult min;
    @SideOnly(value=Side.CLIENT)
    public static PlacementHelper.PositionResult lastMax;
    @SideOnly(value=Side.CLIENT)
    IBakedModel model;
    private static LittleTilePos cachedPos;
    private static LittleBoxes cachedShape;
    private static boolean cachedLow;
    private static NBTTagCompound cachedSettings;
    public static PlacementMode currentMode;

    public ItemLittleChisel() {
        this.func_77637_a(LittleTiles.littleTab);
        this.field_77787_bX = true;
        this.func_77625_d(1);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        DragShape shape = ItemLittleChisel.getShape(stack);
        tooltip.add("shape: " + shape.key);
        shape.addExtraInformation(stack.func_77978_p(), tooltip);
        LittleTilePreview preview = ItemLittleGrabber.SimpleMode.getPreview(stack);
        tooltip.add(TooltipUtils.printRGB(preview.hasColor() ? preview.getColor() : -1));
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return false;
    }

    public static DragShape getShape(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return DragShape.getShape(stack.func_77978_p().func_74779_i("shape"));
    }

    public static void setShape(ItemStack stack, DragShape shape) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74778_a("shape", shape.key);
    }

    public static LittleTilePreview getPreview(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (stack.func_77978_p().func_74764_b("preview")) {
            return LittleTilePreview.loadPreviewFromNBT(stack.func_77978_p().func_74775_l("preview"));
        }
        IBlockState state = stack.func_77978_p().func_74764_b("state") ? Block.func_176220_d((int)stack.func_77978_p().func_74762_e("state")) : Blocks.field_150348_b.func_176223_P();
        LittleTileBlock tile = stack.func_77978_p().func_74764_b("color") ? new LittleTileBlockColored(state.func_177230_c(), state.func_177230_c().func_176201_c(state), stack.func_77978_p().func_74762_e("color")) : new LittleTileBlock(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
        tile.box = new LittleTileBox(LittleGridContext.get().minPos, LittleGridContext.get().minPos, LittleGridContext.get().minPos, LittleGridContext.get().size, LittleGridContext.get().size, LittleGridContext.get().size);
        LittleTilePreview preview = ((LittleTile)tile).getPreviewTile();
        ItemLittleChisel.setPreview(stack, preview);
        return preview;
    }

    public static void setPreview(ItemStack stack, LittleTilePreview preview) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = new NBTTagCompound();
        preview.writeToNBT(nbt);
        stack.func_77978_p().func_74782_a("preview", (NBTBase)nbt);
    }

    @SideOnly(value=Side.CLIENT)
    public List<RenderCubeObject> getRenderingCubes(IBlockState state, TileEntity te, ItemStack stack) {
        return Collections.emptyList();
    }

    @SideOnly(value=Side.CLIENT)
    public void applyCustomOpenGLHackery(ItemStack stack, ItemCameraTransforms.TransformType cameraTransformType) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179094_E();
        if (this.model == null) {
            this.model = mc.func_175599_af().func_175037_a().func_178083_a().func_174953_a(new ModelResourceLocation("littletiles:chisel_background", "inventory"));
        }
        ForgeHooksClient.handleCameraTransforms((IBakedModel)this.model, (ItemCameraTransforms.TransformType)cameraTransformType, (boolean)false);
        mc.func_175599_af().func_180454_a(new ItemStack(Items.field_151121_aF), this.model);
        if (cameraTransformType == ItemCameraTransforms.TransformType.GUI) {
            GlStateManager.func_179139_a((double)0.9, (double)0.9, (double)0.9);
            LittleTilePreview preview = ItemLittleChisel.getPreview(stack);
            ItemStack blockStack = new ItemStack(preview.getPreviewBlock(), 1, preview.getPreviewBlockMeta());
            IBakedModel model = mc.func_175599_af().func_184393_a(blockStack, (World)mc.field_71441_e, (EntityLivingBase)mc.field_71439_g);
            if (!(model instanceof CreativeBakedModel)) {
                ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)cameraTransformType, (boolean)false);
            }
            GlStateManager.func_179097_i();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            try {
                if (model.func_188618_c()) {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179091_B();
                    TileEntityItemStackRenderer.field_147719_a.func_179022_a(blockStack);
                } else {
                    Color color = preview.hasColor() ? ColorUtils.IntToRGBA((int)preview.getColor()) : ColorUtils.IntToRGBA((int)-1);
                    color.setAlpha(255);
                    ReflectionHelper.findMethod(RenderItem.class, (String)"renderModel", (String)"func_191967_a", (Class[])new Class[]{IBakedModel.class, Integer.TYPE, ItemStack.class}).invoke((Object)mc.func_175599_af(), model, preview.hasColor() ? ColorUtils.RGBAToInt((Color)color) : -1, blockStack);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179126_j();
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean hasLittlePreview(ItemStack stack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private static EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public LittleAbsolutePreviews getLittlePreview(ItemStack stack) {
        return null;
    }

    @Override
    public LittleAbsolutePreviews getLittlePreview(ItemStack stack, boolean allowLowResolution, boolean marked) {
        PlacementHelper.PositionResult min = ItemLittleChisel.min;
        if (min == null) {
            min = lastMax;
        }
        if (min != null) {
            if (lastMax == null) {
                lastMax = min.copy();
            }
            min.ensureBothAreEqual(lastMax);
            LittleGridContext context = this.getPositionContext(stack);
            if (context.size < min.getContext().size) {
                context = min.getContext();
            }
            LittleTilePos offset = new LittleTilePos(min.pos, context);
            if (lastMax == null) {
                lastMax = min.copy();
            }
            LittleBoxes boxes = null;
            if (cachedPos == null || !cachedPos.equals(lastMax) || !cachedSettings.equals((Object)stack.func_77978_p()) || cachedLow != allowLowResolution) {
                DragShape shape = ItemLittleChisel.getShape(stack);
                LittleTileBox newBox = new LittleTileBox(new LittleTileBox(min.getRelative(offset).getVec(context)), new LittleTileBox(lastMax.getRelative(offset).getVec(context)));
                boxes = shape.getBoxes(new LittleBoxes(offset.pos, context), newBox.getMinVec(), newBox.getMaxVec(), ItemLittleChisel.getPlayer(), stack.func_77978_p(), allowLowResolution, min, lastMax);
                cachedPos = lastMax.copy();
                cachedShape = boxes.copy();
                cachedSettings = stack.func_77978_p().func_74737_b();
                cachedLow = allowLowResolution;
            } else {
                boxes = cachedShape;
            }
            LittleAbsolutePreviews previews = new LittleAbsolutePreviews(offset.pos, boxes.context);
            LittleTilePreview preview = ItemLittleChisel.getPreview(stack);
            for (int i = 0; i < boxes.size(); ++i) {
                LittleTilePreview newPreview = preview.copy();
                newPreview.box = (LittleTileBox)boxes.get(i);
                previews.addWithoutCheckingPreview(newPreview);
            }
            return previews;
        }
        return null;
    }

    @Override
    public void saveLittlePreview(ItemStack stack, LittlePreviews previews) {
    }

    @Override
    public void rotateLittlePreview(EntityPlayer player, ItemStack stack, Rotation rotation) {
        ItemLittleChisel.getShape(stack).rotate(stack.func_77978_p(), rotation);
    }

    @Override
    public void flipLittlePreview(EntityPlayer player, ItemStack stack, EnumFacing.Axis axis) {
        ItemLittleChisel.getShape(stack).flip(stack.func_77978_p(), axis);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getPreviewAlphaFactor() {
        return 0.4f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void tickPreview(EntityPlayer player, ItemStack stack, PlacementHelper.PositionResult position, RayTraceResult result) {
        lastMax = ItemLittleChisel.getPosition(position, result, currentMode);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldCache() {
        return false;
    }

    @Override
    public void onDeselect(EntityPlayer player, ItemStack stack) {
        min = null;
        lastMax = null;
    }

    protected static PlacementHelper.PositionResult getPosition(PlacementHelper.PositionResult position, RayTraceResult result, PlacementMode mode) {
        position = position.copy();
        EnumFacing facing = position.facing;
        if (mode.mode == PlacementMode.PreviewMode.LINES) {
            facing = facing.func_176734_d();
        }
        if (facing.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
            position.contextVec.vec.add(facing);
        }
        return position;
    }

    @Override
    public boolean onRightClick(EntityPlayer player, ItemStack stack, PlacementHelper.PositionResult position, RayTraceResult result) {
        if (min == null) {
            min = ItemLittleChisel.getPosition(position, result, currentMode);
        } else if (LittleAction.isUsingSecondMode(player)) {
            min = null;
            lastMax = null;
            cachedPos = null;
            cachedSettings = null;
            cachedShape = null;
        } else {
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onMouseWheelClickBlock(EntityPlayer player, ItemStack stack, RayTraceResult result) {
        IBlockState state = player.field_70170_p.func_180495_p(result.func_178782_a());
        if (LittleAction.isBlockValid(state.func_177230_c())) {
            PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleVanillaBlockPacket(result.func_178782_a(), LittleVanillaBlockPacket.VanillaBlockAction.CHISEL));
            return true;
        }
        if (state.func_177230_c() instanceof BlockTile) {
            PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleBlockPacket(result.func_178782_a(), player, LittleBlockPacket.BlockPacketAction.CHISEL, new NBTTagCompound()));
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SubGuiConfigure getConfigureGUI(EntityPlayer player, ItemStack stack) {
        return new SubGuiChisel(stack);
    }

    @Override
    public SubContainerConfigure getConfigureContainer(EntityPlayer player, ItemStack stack) {
        return new SubContainerConfigure(player, stack);
    }

    @Override
    public PlacementMode getPlacementMode(ItemStack stack) {
        return currentMode;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SubGuiConfigure getConfigureGUIAdvanced(EntityPlayer player, ItemStack stack) {
        return new SubGuiModeSelector(stack, ItemMultiTiles.currentContext, currentMode){

            @Override
            public void saveConfiguration(LittleGridContext context, PlacementMode mode) {
                currentMode = mode;
                ItemMultiTiles.currentContext = context;
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public MarkMode onMark(EntityPlayer player, ItemStack stack) {
        if (min == null) {
            if (lastMax != null) {
                min = lastMax.copy();
            } else {
                return null;
            }
        }
        return new MarkMode(){

            @Override
            public SubGui getConfigurationGui() {
                return new SubGuiMarkMode(this){

                    @Override
                    public void createControls() {
                        super.createControls();
                        this.controls.add(new GuiButton(I18n.func_74838_a((String)"markmode.gui.switchpos"), 10, 20){

                            public void onClicked(int x, int y, int button) {
                                if (lastMax == null) {
                                    lastMax = min.copy();
                                }
                                mode.position = min;
                                min = lastMax;
                                lastMax = mode.position;
                            }
                        });
                    }
                };
            }
        };
    }

    @Override
    public boolean containsIngredients(ItemStack stack) {
        return false;
    }

    @Override
    public LittleGridContext getPositionContext(ItemStack stack) {
        return ItemMultiTiles.currentContext;
    }

    static {
        currentMode = PlacementMode.fill;
    }
}

