/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.items;

import com.creativemd.creativecore.common.gui.opener.GuiHandler;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.block.LittleActionColorBoxes;
import com.creativemd.littletiles.common.api.ISpecialBlockSelector;
import com.creativemd.littletiles.common.container.SubContainerConfigure;
import com.creativemd.littletiles.common.gui.SubGuiColorTube;
import com.creativemd.littletiles.common.gui.configure.SubGuiConfigure;
import com.creativemd.littletiles.common.gui.configure.SubGuiGridSelector;
import com.creativemd.littletiles.common.items.ItemHammer;
import com.creativemd.littletiles.common.items.ItemMultiTiles;
import com.creativemd.littletiles.common.packet.LittleBlockPacket;
import com.creativemd.littletiles.common.packet.LittleVanillaBlockPacket;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.vec.LittleBoxes;
import com.creativemd.littletiles.common.tiles.vec.LittleTilePos;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.selection.selector.TileSelector;
import com.creativemd.littletiles.common.utils.shape.SelectShape;
import com.creativemd.littletiles.common.utils.tooltip.TooltipUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemColorTube
extends Item
implements ISpecialBlockSelector {
    public ItemColorTube() {
        this.func_77637_a(LittleTiles.littleTab);
        this.field_77787_bX = true;
        this.func_77625_d(1);
    }

    public static int getColor(ItemStack stack) {
        if (stack == null) {
            return -1;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b("color")) {
            ItemColorTube.setColor(stack, -1);
        }
        return stack.func_77978_p().func_74762_e("color");
    }

    public static void setColor(ItemStack stack, int color) {
        if (stack == null) {
            return;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("color", color);
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return false;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("click: dyes a tile");
        tooltip.add("shift+click: copies tile's color");
        SelectShape shape = ItemColorTube.getShape(stack);
        tooltip.add("shape: " + (shape == null ? "tile" : shape.key));
        tooltip.add(TooltipUtils.printRGB(ItemColorTube.getColor(stack)));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (hand == EnumHand.OFF_HAND) {
            return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
        }
        if (!world.field_72995_K) {
            GuiHandler.openGuiItem((EntityPlayer)player, (World)world);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SubGuiConfigure getConfigureGUI(EntityPlayer player, ItemStack stack) {
        return new SubGuiColorTube(stack);
    }

    @Override
    public SubContainerConfigure getConfigureContainer(EntityPlayer player, ItemStack stack) {
        return new SubContainerConfigure(player, stack);
    }

    public static SelectShape getShape(ItemStack stack) {
        String shape;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((shape = stack.func_77978_p().func_74779_i("shape")).equals("tile") || shape.equals("")) {
            return SelectShape.tileShape;
        }
        return SelectShape.getShape(shape);
    }

    @Override
    public void onDeselect(World world, ItemStack stack, EntityPlayer player) {
        SelectShape shape = ItemColorTube.getShape(stack);
        if (shape != null) {
            shape.deselect(player, stack.func_77978_p(), this.getContext(stack));
        }
    }

    @Override
    public boolean hasCustomBox(World world, ItemStack stack, EntityPlayer player, IBlockState state, RayTraceResult result, LittleTilePos absoluteHit) {
        return ItemColorTube.getShape(stack) != null;
    }

    @Override
    public LittleBoxes getBox(World world, ItemStack stack, EntityPlayer player, RayTraceResult result, LittleTilePos absoluteHit) {
        SelectShape shape = ItemColorTube.getShape(stack);
        return shape.getHighlightBoxes(player, stack.func_77978_p(), result, this.getContext(stack));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onClickBlock(World world, ItemStack stack, EntityPlayer player, RayTraceResult result, LittleTilePos absoluteHit) {
        SelectShape shape = ItemColorTube.getShape(stack);
        if (LittleAction.isUsingSecondMode(player)) {
            if (!world.field_72995_K) {
                return true;
            }
            TileEntity tileEntity = world.func_175625_s(result.func_178782_a());
            if (tileEntity instanceof TileEntityLittleTiles) {
                PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleBlockPacket(result.func_178782_a(), player, LittleBlockPacket.BlockPacketAction.COLOR_TUBE, new NBTTagCompound()));
            } else {
                PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleVanillaBlockPacket(result.func_178782_a(), LittleVanillaBlockPacket.VanillaBlockAction.COLOR_TUBE));
            }
        } else if (shape.leftClick(player, stack.func_77978_p(), result, this.getContext(stack))) {
            if (ItemHammer.isFiltered()) {
                new LittleActionColorBoxes.LittleActionColorBoxesFiltered(shape.getBoxes(player, stack.func_77978_p(), result, this.getContext(stack)), ItemColorTube.getColor(stack), false, ItemHammer.getFilter()).execute();
            } else {
                new LittleActionColorBoxes(shape.getBoxes(player, stack.func_77978_p(), result, this.getContext(stack)), ItemColorTube.getColor(stack), false).execute();
            }
        }
        return true;
    }

    @Override
    public void rotateLittlePreview(ItemStack stack, Rotation rotation) {
        SelectShape shape = ItemColorTube.getShape(stack);
        if (shape != null) {
            shape.rotate(rotation, stack.func_77978_p());
        }
    }

    @Override
    public void flipLittlePreview(ItemStack stack, EnumFacing.Axis axis) {
        SelectShape shape = ItemColorTube.getShape(stack);
        if (shape != null) {
            shape.flip(axis, stack.func_77978_p());
        }
    }

    @Override
    public LittleGridContext getContext(ItemStack stack) {
        return ItemMultiTiles.currentContext;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SubGuiConfigure getConfigureGUIAdvanced(EntityPlayer player, ItemStack stack) {
        return new SubGuiGridSelector(stack, ItemMultiTiles.currentContext, ItemHammer.isFiltered(), ItemHammer.getFilter()){

            @Override
            public void saveConfiguration(LittleGridContext context, boolean activeFilter, TileSelector selector) {
                ItemHammer.setFilter(activeFilter, selector);
                ItemMultiTiles.currentContext = context;
            }
        };
    }
}

