/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.entity;

import com.creativemd.creativecore.common.utils.mc.WorldUtils;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceStack;
import com.creativemd.littletiles.common.entity.EntityAnimationController;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.preview.LittleAbsolutePreviewsStructure;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.animation.AnimationController;
import com.creativemd.littletiles.common.utils.animation.AnimationState;
import com.creativemd.littletiles.common.utils.animation.AnimationTimeline;
import com.creativemd.littletiles.common.utils.placing.PlacementMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DoorController
extends EntityAnimationController {
    protected boolean isWaitingForApprove = false;
    protected int ticksToWait = -1;
    protected static final int waitTimeApprove = 300;
    protected static final int waitTimeRender = 200;
    protected Boolean placed = null;
    public String openedState;
    public String closedState;
    public Boolean turnBack;
    public long duration;
    public EntityPlayer activator;
    protected boolean modifiedTransition;
    @SideOnly(value=Side.CLIENT)
    List<TileEntityLittleTiles> waitingForRender;

    public DoorController() {
    }

    public DoorController(AnimationState closed, AnimationState opened, Boolean turnBack, long duration) {
        this.openedState = opened != null ? opened.name : null;
        this.closedState = closed.name;
        this.turnBack = turnBack;
        this.duration = duration;
        this.addState(opened);
        this.addStateAndSelect(closed);
        this.generateAllTransistions(duration);
        this.modifiedTransition = false;
        this.startTransition(this.openedState);
    }

    public DoorController(AnimationState closed, AnimationState opened, Boolean turnBack, long duration, AnimationTimeline open, AnimationTimeline close) {
        this.openedState = opened != null ? opened.name : null;
        this.closedState = closed.name;
        this.turnBack = turnBack;
        this.duration = duration;
        this.addState(opened);
        this.addStateAndSelect(closed);
        this.addTransition("closed", "opened", open);
        this.addTransition("opened", "closed", close);
        this.startTransition(this.openedState);
    }

    @Override
    public AnimationController addTransition(String from, String to, AnimationTimeline animation) {
        this.modifiedTransition = true;
        return super.addTransition(from, to, animation);
    }

    public DoorController(AnimationState opened, Boolean turnBack, long duration) {
        this(new AnimationState("closed", null, null), opened, turnBack, duration);
    }

    @Override
    public EntityPlayer activator() {
        return this.activator;
    }

    public void markWaitingForApprove() {
        this.isWaitingForApprove = true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void removeWaitingTe(TileEntityLittleTiles te) {
        this.waitingForRender.remove(te);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isWaitingForRender() {
        return this.waitingForRender != null;
    }

    @Override
    public boolean onRightClick() {
        if (this.placed != null) {
            return false;
        }
        boolean isOpen = this.currentState.name.equals(this.openedState);
        if (!this.isChanging() && isOpen ? this.closedState != null : this.openedState != null) {
            this.startTransition(isOpen ? this.closedState : this.openedState);
            return true;
        }
        return false;
    }

    @Override
    public AnimationState tick() {
        if (this.parent.field_70170_p.field_72995_K && this.placed != null) {
            if (this.placed.booleanValue()) {
                --this.ticksToWait;
                if (this.ticksToWait % 10 == 0) {
                    ArrayList<TileEntityLittleTiles> tileEntities = null;
                    for (TileEntityLittleTiles te : this.waitingForRender) {
                        if (te == te.func_145831_w().func_175625_s(te.func_174877_v())) continue;
                        if (tileEntities == null) {
                            tileEntities = new ArrayList<TileEntityLittleTiles>();
                        }
                        tileEntities.add(te);
                    }
                    if (tileEntities != null) {
                        this.waitingForRender.removeAll(tileEntities);
                    }
                }
                if (this.waitingForRender.size() == 0 || this.ticksToWait < 0) {
                    this.parent.unloadRenderCache();
                    this.parent.field_70128_L = true;
                } else {
                    this.parent.field_70128_L = false;
                }
            } else if (this.isWaitingForApprove) {
                if (this.ticksToWait < 0) {
                    this.ticksToWait = 300;
                } else if (this.ticksToWait == 0) {
                    this.parent.field_70128_L = true;
                } else {
                    --this.ticksToWait;
                }
            } else {
                this.place();
            }
        }
        return super.tick();
    }

    @Override
    public void endTransition() {
        super.endTransition();
        if (this.turnBack != null && this.turnBack.booleanValue() == this.currentState.name.equals(this.openedState)) {
            if (this.isWaitingForApprove) {
                this.placed = false;
            } else {
                this.place();
            }
        }
    }

    public void place() {
        LittleStructure placedStructureParent = this.parent.getParentStructure();
        if (placedStructureParent == null) {
            throw new RuntimeException("Failed to find parent structure of animation");
        }
        LittleAbsolutePreviewsStructure previews = this.parent.getAbsolutePreviews(placedStructureParent);
        ArrayList<PlacePreviewTile> placePreviews = new ArrayList<PlacePreviewTile>();
        previews.getPlacePreviews(placePreviews, null, true, LittleTileVec.ZERO);
        LittleStructure newDoor = previews.getStructure();
        World world = this.parent.field_70170_p;
        if (LittleActionPlaceStack.placeTilesWithoutPlayer(world, previews.context, placePreviews, previews.getStructure(), PlacementMode.all, previews.pos, null, null, null, EnumFacing.EAST) != null) {
            if (placedStructureParent.parent != null && placedStructureParent.parent.isConnected(world)) {
                LittleStructure parentStructure = placedStructureParent.parent.getStructureWithoutLoading();
                newDoor.updateParentConnection(placedStructureParent.parent.getChildID(), parentStructure);
                parentStructure.updateChildConnection(placedStructureParent.parent.getChildID(), newDoor);
            }
        } else {
            this.parent.field_70128_L = true;
            if (!world.field_72995_K) {
                WorldUtils.dropItem((World)world, (ItemStack)placedStructureParent.getStructureDrop(), (BlockPos)this.parent.center.baseOffset);
            }
            return;
        }
        if (!world.field_72995_K) {
            this.parent.field_70128_L = true;
        } else {
            this.waitingForRender = new CopyOnWriteArrayList<TileEntityLittleTiles>();
            ArrayList<BlockPos> coordsToCheck = new ArrayList<BlockPos>(LittleActionPlaceStack.getSplittedTiles(previews.context, placePreviews, previews.pos).keySet());
            for (int i = 0; i < coordsToCheck.size(); ++i) {
                TileEntity te = world.func_175625_s(coordsToCheck.get(i));
                if (!(te instanceof TileEntityLittleTiles)) continue;
                ((TileEntityLittleTiles)te).addWaitingAnimation(this.parent);
                this.waitingForRender.add((TileEntityLittleTiles)te);
            }
            this.ticksToWait = 200;
            this.parent.field_70128_L = false;
            this.placed = true;
        }
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        nbt.func_74782_a("closed", (NBTBase)this.getState(this.closedState).writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("opened", (NBTBase)this.getState(this.openedState).writeToNBT(new NBTTagCompound()));
        nbt.func_74757_a("isOpen", this.currentState.name.equals(this.openedState));
        if (this.isChanging()) {
            nbt.func_74772_a("tick", this.animation.progress());
        }
        nbt.func_74772_a("duration", this.duration);
        nbt.func_74774_a("turnBack", (byte)(this.turnBack == null ? 0 : (this.turnBack != false ? 1 : -1)));
        if (this.modifiedTransition) {
            NBTTagList list = new NBTTagList();
            for (Map.Entry entry : this.stateTransition.entrySet()) {
                NBTTagCompound transitionNBT = ((AnimationTimeline)entry.getValue()).writeToNBT(new NBTTagCompound());
                transitionNBT.func_74778_a("key", (String)entry.getKey());
                list.func_74742_a((NBTBase)transitionNBT);
            }
            nbt.func_74782_a("transitions", (NBTBase)list);
        }
    }

    @Override
    protected void readFromNBT(NBTTagCompound nbt) {
        byte turnBackData;
        AnimationState closed = new AnimationState(nbt.func_74775_l("closed"));
        this.closedState = closed.name;
        this.addState(closed);
        AnimationState opened = new AnimationState(nbt.func_74775_l("opened"));
        this.openedState = opened.name;
        this.addState(opened);
        this.duration = nbt.func_74763_f("duration");
        if (nbt.func_74764_b("transitions")) {
            NBTTagList list = nbt.func_150295_c("transitions", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound transitionNBT = list.func_150305_b(i);
                this.addTransition(transitionNBT.func_74779_i("key"), new AnimationTimeline(transitionNBT));
            }
            this.modifiedTransition = true;
        } else {
            this.generateAllTransistions(this.duration);
        }
        boolean isOpen = nbt.func_74767_n("isOpen");
        this.currentState = !isOpen ? closed : opened;
        if (nbt.func_74764_b("tick")) {
            this.startTransition(isOpen ? this.closedState : this.openedState);
            this.animation.setProgress(nbt.func_74763_f("tick"));
        }
        this.turnBack = (turnBackData = nbt.func_74771_c("turnBack")) == 0 ? null : Boolean.valueOf(turnBackData > 0);
    }

    @Override
    public void onServerApproves() {
        this.isWaitingForApprove = false;
    }
}

