/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.block;

import com.creativemd.creativecore.common.utils.mc.WorldUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.LittleActionInteract;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceAbsolute;
import com.creativemd.littletiles.common.blocks.BlockTile;
import com.creativemd.littletiles.common.items.ItemLittleWrench;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittleAbsolutePreviewsStructure;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.utils.placing.PlacementMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class LittleActionDestroy
extends LittleActionInteract {
    public LittleAbsolutePreviews destroyedTiles;
    public StructurePreview structurePreview;

    public LittleActionDestroy(BlockPos blockPos, EntityPlayer player) {
        super(blockPos, player);
    }

    public LittleActionDestroy() {
    }

    @Override
    public boolean canBeReverted() {
        return this.destroyedTiles != null;
    }

    @Override
    public LittleAction revert() {
        if (this.structurePreview != null) {
            return this.structurePreview.getPlaceAction();
        }
        this.destroyedTiles.convertToSmallest();
        return new LittleActionPlaceAbsolute(this.destroyedTiles, PlacementMode.normal);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean action(World world, TileEntityLittleTiles te, LittleTile tile, ItemStack stack, EntityPlayer player, RayTraceResult moving, BlockPos pos, boolean secondMode) throws LittleActionException {
        if (!world.field_72995_K) {
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, te.func_174877_v(), te.getBlockTileState(), player);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                LittleActionDestroy.sendBlockResetToClient((EntityPlayerMP)player, pos, te);
                return false;
            }
        }
        if (tile.isChildOfStructure()) {
            boolean loaded;
            boolean bl = loaded = tile.isConnectedToStructure() && tile.connection.getStructure(world).hasLoaded() && tile.connection.getStructure(world).loadChildren();
            if (!loaded && !(player.func_184614_ca().func_77973_b() instanceof ItemLittleWrench)) throw new LittleActionException.StructureNotLoadedException();
            if (loaded) {
                this.structurePreview = new StructurePreview(tile.connection.getStructure(world));
                if (LittleActionDestroy.needIngredients(player) && !player.field_70170_p.field_72995_K) {
                    WorldUtils.dropItem((World)world, (ItemStack)tile.connection.getStructure(world).getStructureDrop(), (BlockPos)pos);
                }
                tile.destroy();
            } else {
                tile.te.removeTile(tile);
            }
        } else {
            this.destroyedTiles = new LittleAbsolutePreviews(pos, te.getContext());
            ArrayList<LittleTile> tiles = new ArrayList<LittleTile>();
            if (BlockTile.selectEntireBlock(player, secondMode)) {
                ArrayList<LittleTile> remains = new ArrayList<LittleTile>();
                for (LittleTile toDestory : te.getTiles()) {
                    if (!toDestory.isChildOfStructure()) {
                        this.destroyedTiles.addTile(toDestory);
                        tiles.add(toDestory);
                        continue;
                    }
                    remains.add(toDestory);
                }
                if (player.func_184812_l_()) {
                    LittleActionDestroy.addPreviewToInventory(player, this.destroyedTiles);
                } else if (!world.field_72995_K) {
                    ItemStack drop = new ItemStack(LittleTiles.multiTiles);
                    LittleTilePreview.saveTiles(world, te.getContext(), tiles, drop);
                    WorldUtils.dropItem((World)world, (ItemStack)drop, (BlockPos)pos);
                }
                tiles.clear();
                te.getTiles().clear();
                te.getTiles().addAll(remains);
                te.updateTiles();
            } else {
                this.destroyedTiles.addTile(tile);
                LittleActionDestroy.addPreviewToInventory(player, this.destroyedTiles);
                tile.destroy();
            }
        }
        world.func_184133_a((EntityPlayer)null, pos, tile.getSound().func_185845_c(), SoundCategory.BLOCKS, (tile.getSound().func_185843_a() + 1.0f) / 2.0f, tile.getSound().func_185847_b() * 0.8f);
        return true;
    }

    @Override
    protected boolean isRightClick() {
        return false;
    }

    public static class StructurePreview {
        public LittleAbsolutePreviews previews;
        public boolean requiresItemStack;
        public LittleStructure structure;

        public StructurePreview(LittleStructure structure) {
            if (!structure.hasLoaded()) {
                throw new RuntimeException("Structure is not loaded, can't create preview of it!");
            }
            NBTTagCompound structureNBT = new NBTTagCompound();
            structure.writeToNBTPreview(structureNBT, structure.getMainTile().te.func_174877_v());
            this.previews = new LittleAbsolutePreviewsStructure(structureNBT, structure.getMainTile().te.func_174877_v(), structure.getMainTile().getContext());
            for (Map.Entry<TileEntityLittleTiles, ArrayList<LittleTile>> entry : structure.entrySet()) {
                this.previews.addTiles((List<LittleTile>)entry.getValue());
            }
            this.previews.convertToSmallest();
            this.requiresItemStack = structure.canOnlyBePlacedByItemStack();
            this.structure = structure;
        }

        public LittleAction getPlaceAction() {
            if (this.requiresItemStack) {
                return new LittleActionPlaceAbsolute.LittleActionPlaceAbsolutePremade(this.previews, PlacementMode.all, false);
            }
            return new LittleActionPlaceAbsolute(this.previews, PlacementMode.all, false);
        }

        public int hashCode() {
            return this.previews.getStructureData().hashCode();
        }

        public boolean equals(Object paramObject) {
            if (paramObject instanceof StructurePreview) {
                return this.structure == ((StructurePreview)paramObject).structure;
            }
            if (paramObject instanceof LittleStructure) {
                return this.structure == paramObject;
            }
            return false;
        }
    }
}

