/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.block;

import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionCombined;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionBoxes;
import com.creativemd.littletiles.common.config.SpecialServerConfig;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.LittleTileBlock;
import com.creativemd.littletiles.common.tiles.LittleTileBlockColored;
import com.creativemd.littletiles.common.tiles.vec.LittleBoxes;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.ingredients.ColorUnit;
import com.creativemd.littletiles.common.utils.ingredients.Ingredients;
import com.creativemd.littletiles.common.utils.selection.selector.TileSelector;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class LittleActionColorBoxes
extends LittleActionBoxes {
    public int color;
    public boolean toVanilla;
    public HashMapList<Integer, LittleBoxes> revertList;
    public boolean doneSomething;

    public LittleActionColorBoxes(LittleBoxes boxes, int color, boolean toVanilla) {
        super(boxes);
        this.color = color;
        this.toVanilla = toVanilla;
    }

    public LittleActionColorBoxes() {
    }

    @Override
    public void writeBytes(ByteBuf buf) {
        super.writeBytes(buf);
        buf.writeInt(this.color);
        buf.writeBoolean(this.toVanilla);
    }

    @Override
    public void readBytes(ByteBuf buf) {
        super.readBytes(buf);
        this.color = buf.readInt();
        this.toVanilla = buf.readBoolean();
    }

    public void addRevert(int color, BlockPos pos, LittleGridContext context, List<LittleTileBox> boxes) {
        LittleBoxes newBoxes = new LittleBoxes(pos, context);
        for (LittleTileBox box : boxes) {
            newBoxes.add(box.copy());
        }
        this.revertList.add((Object)color, (Object)newBoxes);
    }

    public boolean shouldSkipTile(LittleTile tile) {
        return false;
    }

    public ColorUnit action(TileEntityLittleTiles te, List<LittleTileBox> boxes, ColorUnit gained, boolean simulate, LittleGridContext context) {
        this.doneSomething = false;
        double colorVolume = 0.0;
        for (LittleTile tile : te.getTiles()) {
            if (this.shouldSkipTile(tile)) continue;
            LittleTileBox intersecting = null;
            boolean intersects = false;
            for (int j = 0; j < boxes.size(); ++j) {
                if (!tile.intersectsWith(boxes.get(j))) continue;
                intersects = true;
                intersecting = boxes.get(j);
                break;
            }
            if (!intersects || tile.getClass() != LittleTileBlock.class && !(tile instanceof LittleTileBlockColored) || tile.isConnectedToStructure() && (!tile.isConnectedToStructure() || !tile.connection.getStructure(te.func_145831_w()).hasLoaded()) || !LittleTileBlockColored.needsToBeRecolored((LittleTileBlock)tile, this.color)) continue;
            this.doneSomething = true;
            if (tile.canBeSplitted() && !tile.equalsBox(intersecting)) {
                LittleTile newTile;
                int i;
                if (simulate) {
                    double volume = 0.0;
                    ArrayList<LittleTileBox> cutout = new ArrayList<LittleTileBox>();
                    tile.cutOut(boxes, cutout);
                    for (LittleTileBox box2 : cutout) {
                        colorVolume += box2.getPercentVolume(context);
                        volume += box2.getPercentVolume(context);
                    }
                    gained.addColorUnit(ColorUnit.getColors(tile.getPreviewTile(), volume));
                    continue;
                }
                ArrayList<LittleTileBox> cutout = new ArrayList<LittleTileBox>();
                List<LittleTileBox> newBoxes = tile.cutOut(boxes, cutout);
                if (newBoxes == null) continue;
                this.addRevert(LittleTileBlockColored.getColor((LittleTileBlock)tile), te.func_174877_v(), context, cutout);
                LittleTile tempTile = tile.copy();
                LittleTile changedTile = LittleTileBlockColored.setColor((LittleTileBlock)tempTile, this.color);
                if (changedTile == null) {
                    changedTile = tempTile;
                }
                if (tile.isConnectedToStructure()) {
                    tile.connection.getStructure(te.func_145831_w()).removeTile(tile);
                }
                for (i = 0; i < newBoxes.size(); ++i) {
                    newTile = tile.copy();
                    newTile.box = newBoxes.get(i);
                    newTile.place();
                    if (!tile.isConnectedToStructure()) continue;
                    tile.connection.getStructure(te.func_145831_w()).addTile(newTile);
                }
                for (i = 0; i < cutout.size(); ++i) {
                    newTile = changedTile.copy();
                    newTile.box = (LittleTileBox)cutout.get(i);
                    newTile.place();
                    if (!tile.isConnectedToStructure()) continue;
                    tile.connection.getStructure(te.func_145831_w()).addTile(newTile);
                }
                if (tile.isConnectedToStructure()) {
                    if (tile.connection.isLink()) {
                        tile.connection.getStructure(te.func_145831_w()).updateStructure();
                    } else {
                        tile.connection.getStructureWithoutLoading().selectMainTile();
                    }
                }
                tile.connection = null;
                tile.destroy();
                continue;
            }
            if (simulate) {
                colorVolume += tile.getPercentVolume();
                gained.addColorUnit(ColorUnit.getColors(tile.getPreviewTile(), tile.getPercentVolume()));
                continue;
            }
            ArrayList<LittleTileBox> oldBoxes = new ArrayList<LittleTileBox>();
            oldBoxes.add(tile.box);
            this.addRevert(LittleTileBlockColored.getColor((LittleTileBlock)tile), te.func_174877_v(), context, oldBoxes);
            LittleTileBlock changedTile = LittleTileBlockColored.setColor((LittleTileBlock)tile, this.color);
            if (changedTile == null) continue;
            ((LittleTile)changedTile).place();
            if (tile.isChildOfStructure()) {
                changedTile.connection = tile.connection.copy(changedTile);
                LittleStructure structure = tile.connection.getStructure(te.func_145831_w());
                structure.removeTile(tile);
                structure.addTile(changedTile);
                structure.updateStructure();
                if (!tile.connection.isLink()) {
                    structure.setMainTile(changedTile);
                }
            }
            tile.connection = null;
            tile.destroy();
        }
        ColorUnit toDrain = ColorUnit.getColors(this.color);
        toDrain.scale(colorVolume);
        gained.drain(toDrain);
        return toDrain;
    }

    @Override
    public void action(World world, EntityPlayer player, BlockPos pos, IBlockState state, List<LittleTileBox> boxes, LittleGridContext context) throws LittleActionException {
        if (ColorUtils.getAlpha((int)this.color) < SpecialServerConfig.getMinimumTransparency(player)) {
            throw new SpecialServerConfig.NotAllowedToPlaceColorException();
        }
        TileEntityLittleTiles tileEntity = LittleActionColorBoxes.loadTe(player, world, pos, true);
        if (tileEntity instanceof TileEntityLittleTiles) {
            if (!world.field_72995_K) {
                BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, tileEntity.func_174877_v(), tileEntity.getBlockTileState(), player);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (event.isCanceled()) {
                    LittleActionColorBoxes.sendBlockResetToClient((EntityPlayerMP)player, pos, tileEntity);
                    return;
                }
            }
            TileEntityLittleTiles te = tileEntity;
            te.ensureMinContext(context);
            if (context != te.getContext()) {
                for (LittleTileBox box : boxes) {
                    box.convertTo(context, te.getContext());
                }
                context = te.getContext();
            }
            ArrayList entries = new ArrayList();
            te.preventUpdate = true;
            ColorUnit gained = new ColorUnit();
            ColorUnit toDrain = this.action(te, boxes, gained, true, context);
            if (LittleActionColorBoxes.addIngredients(player, null, gained, true)) {
                LittleActionColorBoxes.drain(player, new Ingredients(toDrain, null));
                LittleActionColorBoxes.addIngredients(player, null, gained);
                this.action(te, boxes, gained, false, context);
            }
            te.preventUpdate = false;
            te.combineTiles();
            if (this.toVanilla || !this.doneSomething) {
                te.convertBlockToVanilla();
            }
        }
    }

    @Override
    protected boolean action(EntityPlayer player) throws LittleActionException {
        this.revertList = new HashMapList();
        return super.action(player);
    }

    @Override
    public boolean canBeReverted() {
        return true;
    }

    @Override
    public LittleAction revert() {
        ArrayList<LittleActionColorBoxes> actions = new ArrayList<LittleActionColorBoxes>();
        for (Map.Entry entry : this.revertList.entrySet()) {
            for (LittleBoxes boxes : (ArrayList)entry.getValue()) {
                boxes.convertToSmallest();
                actions.add(new LittleActionColorBoxes(boxes, (Integer)entry.getKey(), true));
            }
        }
        return new LittleActionCombined(actions.toArray(new LittleAction[0]));
    }

    public static class LittleActionColorBoxesFiltered
    extends LittleActionColorBoxes {
        public TileSelector selector;

        public LittleActionColorBoxesFiltered(LittleBoxes boxes, int color, boolean toVanilla, TileSelector selector) {
            super(boxes, color, toVanilla);
            this.selector = selector;
        }

        public LittleActionColorBoxesFiltered() {
        }

        @Override
        public void writeBytes(ByteBuf buf) {
            super.writeBytes(buf);
            LittleActionColorBoxesFiltered.writeSelector(this.selector, buf);
        }

        @Override
        public void readBytes(ByteBuf buf) {
            super.readBytes(buf);
            this.selector = LittleActionColorBoxesFiltered.readSelector(buf);
        }

        @Override
        public boolean shouldSkipTile(LittleTile tile) {
            return !this.selector.is(tile);
        }
    }
}

