/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.littletiles.LittleTilesConfig;
import com.creativemd.littletiles.client.LittleTilesClient;
import com.creativemd.littletiles.client.tiles.LittleRenderingCube;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.api.ILittleTile;
import com.creativemd.littletiles.common.packet.LittleFlipPacket;
import com.creativemd.littletiles.common.packet.LittleRotatePacket;
import com.creativemd.littletiles.common.tiles.place.FixedHandler;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.placing.MarkMode;
import com.creativemd.littletiles.common.utils.placing.PlacementHelper;
import com.creativemd.littletiles.common.utils.placing.PlacementMode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class PreviewRenderer {
    public static Minecraft mc = Minecraft.func_71410_x();
    public static MarkMode marked = null;

    public static boolean isCentered(EntityPlayer player, ILittleTile iTile) {
        if (iTile.snapToGridByDefault()) {
            return LittleAction.isUsingSecondMode(player) && marked == null;
        }
        return LittleTilesConfig.building.invertStickToGrid == LittleAction.isUsingSecondMode(player) || marked != null;
    }

    public static boolean isFixed(EntityPlayer player, ILittleTile iTile) {
        if (iTile.snapToGridByDefault()) {
            return !LittleAction.isUsingSecondMode(player) && marked == null;
        }
        return LittleTilesConfig.building.invertStickToGrid != LittleAction.isUsingSecondMode(player) && marked == null;
    }

    public static void handleUndoAndRedo(EntityPlayer player) {
        while (LittleTilesClient.undo.func_151468_f()) {
            try {
                LittleAction.undo();
            }
            catch (LittleActionException e) {
                player.func_146105_b((ITextComponent)new TextComponentString(e.getLocalizedMessage()), true);
            }
        }
        while (LittleTilesClient.redo.func_151468_f()) {
            try {
                LittleAction.redo();
            }
            catch (LittleActionException e) {
                player.func_146105_b((ITextComponent)new TextComponentString(e.getLocalizedMessage()), true);
            }
        }
    }

    @SubscribeEvent
    public void tick(RenderWorldLastEvent event) {
        if (PreviewRenderer.mc.field_71439_g != null && PreviewRenderer.mc.field_71415_G) {
            WorldClient world = PreviewRenderer.mc.field_71441_e;
            EntityPlayerSP player = PreviewRenderer.mc.field_71439_g;
            ItemStack stack = PreviewRenderer.mc.field_71439_g.func_184614_ca();
            PreviewRenderer.handleUndoAndRedo((EntityPlayer)player);
            if (PlacementHelper.isLittleBlock(stack) && (marked != null || PreviewRenderer.mc.field_71476_x != null && PreviewRenderer.mc.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK && PreviewRenderer.mc.field_71476_x.field_178784_b != null)) {
                if (marked != null) {
                    marked.renderWorld(event.getPartialTicks());
                }
                ILittleTile iTile = PlacementHelper.getLittleInterface(stack);
                PlacementHelper.PositionResult position = marked != null ? PreviewRenderer.marked.position.copy() : PlacementHelper.getPosition((World)world, PreviewRenderer.mc.field_71476_x, iTile.getPositionContext(stack));
                this.processRotateKeys(position.getContext());
                iTile.tickPreview((EntityPlayer)player, stack, position, PreviewRenderer.mc.field_71476_x);
                PlacementMode mode = iTile.getPlacementMode(stack);
                if (mode.mode == PlacementMode.PreviewMode.PREVIEWS) {
                    GL11.glEnable((int)3042);
                    OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                    GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                    GL11.glDisable((int)3553);
                    GL11.glDepthMask((boolean)false);
                    boolean allowLowResolution = marked != null ? marked.allowLowResolution() : true;
                    PlacementHelper.PreviewResult result = PlacementHelper.getPreviews((World)world, stack, position, PreviewRenderer.isCentered((EntityPlayer)player, iTile), PreviewRenderer.isFixed((EntityPlayer)player, iTile), allowLowResolution, marked != null, mode);
                    if (result != null) {
                        this.processMarkKey((EntityPlayer)player, iTile, stack, result, result.isAbsolute());
                        double x = (double)position.pos.func_177958_n() - TileEntityRendererDispatcher.field_147554_b;
                        double y = (double)position.pos.func_177956_o() - TileEntityRendererDispatcher.field_147555_c;
                        double z = (double)position.pos.func_177952_p() - TileEntityRendererDispatcher.field_147552_d;
                        for (int i = 0; i < result.placePreviews.size(); ++i) {
                            PlacePreviewTile preview = result.placePreviews.get(i);
                            List<LittleRenderingCube> cubes = preview.getPreviews(result.context);
                            for (LittleRenderingCube cube : cubes) {
                                GL11.glPushMatrix();
                                cube.renderCubePreview(x, y, z, iTile);
                                GL11.glPopMatrix();
                            }
                        }
                        if (!result.isAbsolute() && marked == null && LittleAction.isUsingSecondMode((EntityPlayer)player) && result.singleMode) {
                            int i;
                            ArrayList<FixedHandler> shifthandlers = new ArrayList<FixedHandler>();
                            for (i = 0; i < result.placePreviews.size(); ++i) {
                                if (result.placePreviews.get((int)i).preview == null) continue;
                                shifthandlers.addAll(result.placePreviews.get((int)i).preview.fixedhandlers);
                            }
                            for (i = 0; i < shifthandlers.size(); ++i) {
                                ((FixedHandler)shifthandlers.get(i)).handleRendering(result.context, mc, x, y, z);
                            }
                        }
                    }
                    GL11.glDepthMask((boolean)true);
                    GL11.glEnable((int)3553);
                    GL11.glDisable((int)3042);
                }
            } else {
                marked = null;
            }
        }
    }

    public void processMarkKey(EntityPlayer player, ILittleTile iTile, ItemStack stack, PlacementHelper.PreviewResult preview, boolean absolute) {
        while (LittleTilesClient.mark.func_151468_f()) {
            if (marked == null) {
                marked = iTile.onMark(player, stack);
            }
            if (marked == null || !marked.processPosition(player, PlacementHelper.getPosition(player.field_70170_p, PreviewRenderer.mc.field_71476_x, iTile.getPositionContext(stack)), preview, absolute)) continue;
            marked = null;
        }
    }

    public void processRotateKey(Rotation rotation) {
        LittleRotatePacket packet = new LittleRotatePacket(rotation);
        packet.executeClient((EntityPlayer)PreviewRenderer.mc.field_71439_g);
        PacketHandler.sendPacketToServer((CreativeCorePacket)packet);
    }

    public void processRotateKeys(LittleGridContext context) {
        boolean repeated;
        while (LittleTilesClient.flip.func_151468_f()) {
            int i4 = MathHelper.func_76128_c((double)((double)(PreviewRenderer.mc.field_71439_g.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            EnumFacing direction = null;
            switch (i4) {
                case 0: {
                    direction = EnumFacing.SOUTH;
                    break;
                }
                case 1: {
                    direction = EnumFacing.WEST;
                    break;
                }
                case 2: {
                    direction = EnumFacing.NORTH;
                    break;
                }
                case 3: {
                    direction = EnumFacing.EAST;
                }
            }
            if (PreviewRenderer.mc.field_71439_g.field_70125_A > 45.0f) {
                direction = EnumFacing.DOWN;
            }
            if (PreviewRenderer.mc.field_71439_g.field_70125_A < -45.0f) {
                direction = EnumFacing.UP;
            }
            LittleFlipPacket packet = new LittleFlipPacket(direction.func_176740_k());
            packet.executeClient((EntityPlayer)PreviewRenderer.mc.field_71439_g);
            PacketHandler.sendPacketToServer((CreativeCorePacket)packet);
        }
        boolean bl = repeated = marked != null;
        while (LittleTilesClient.up.isPressed(repeated)) {
            if (marked != null) {
                marked.move(context, LittleAction.isUsingSecondMode((EntityPlayer)PreviewRenderer.mc.field_71439_g) ? EnumFacing.UP : EnumFacing.EAST);
                continue;
            }
            this.processRotateKey(Rotation.Z_CLOCKWISE);
        }
        while (LittleTilesClient.down.isPressed(repeated)) {
            if (marked != null) {
                marked.move(context, LittleAction.isUsingSecondMode((EntityPlayer)PreviewRenderer.mc.field_71439_g) ? EnumFacing.DOWN : EnumFacing.WEST);
                continue;
            }
            this.processRotateKey(Rotation.Z_COUNTER_CLOCKWISE);
        }
        while (LittleTilesClient.right.isPressed(repeated)) {
            if (marked != null) {
                marked.move(context, EnumFacing.SOUTH);
                continue;
            }
            this.processRotateKey(Rotation.Y_COUNTER_CLOCKWISE);
        }
        while (LittleTilesClient.left.isPressed(repeated)) {
            if (marked != null) {
                marked.move(context, EnumFacing.NORTH);
                continue;
            }
            this.processRotateKey(Rotation.Y_CLOCKWISE);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void drawHighlight(DrawBlockHighlightEvent event) {
        EntityPlayer player = event.getPlayer();
        World world = player.field_70170_p;
        ItemStack stack = player.func_184614_ca();
        if ((event.getTarget().field_72313_a == RayTraceResult.Type.BLOCK || marked != null) && PlacementHelper.isLittleBlock(stack)) {
            if (marked != null) {
                marked.renderBlockHighlight(player, event.getPartialTicks());
            }
            ILittleTile iTile = PlacementHelper.getLittleInterface(stack);
            PlacementMode mode = iTile.getPlacementMode(stack);
            if (mode.mode == PlacementMode.PreviewMode.LINES) {
                BlockPos pos = event.getTarget().func_178782_a();
                IBlockState state = world.func_180495_p(pos);
                PlacementHelper.PositionResult position = marked != null ? PreviewRenderer.marked.position.copy() : PlacementHelper.getPosition(world, PreviewRenderer.mc.field_71476_x, iTile.getPositionContext(stack));
                boolean allowLowResolution = marked != null ? marked.allowLowResolution() : true;
                PlacementHelper.PreviewResult result = PlacementHelper.getPreviews(world, stack, position, PreviewRenderer.isCentered(player, iTile), PreviewRenderer.isFixed(player, iTile), allowLowResolution, marked != null, mode);
                if (result != null) {
                    this.processMarkKey(player, iTile, stack, result, result.isAbsolute());
                    double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
                    double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
                    double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    GlStateManager.func_187441_d((float)2.0f);
                    GlStateManager.func_179090_x();
                    GlStateManager.func_179132_a((boolean)false);
                    double x = position.pos.func_177958_n();
                    double y = position.pos.func_177956_o();
                    double z = position.pos.func_177952_p();
                    d0 -= x;
                    d1 -= y;
                    d2 -= z;
                    for (int i = 0; i < result.placePreviews.size(); ++i) {
                        PlacePreviewTile preview = result.placePreviews.get(i);
                        List<LittleRenderingCube> cubes = preview.getPreviews(result.context);
                        for (LittleRenderingCube cube : cubes) {
                            cube.renderCubeLines(-d0, -d1, -d2, 0.0f, 0.0f, 0.0f, 0.4f);
                        }
                    }
                    GlStateManager.func_179132_a((boolean)true);
                    GlStateManager.func_179098_w();
                    GlStateManager.func_179084_k();
                    event.setCanceled(true);
                }
            }
        }
    }
}

