/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class ItemModelCache {
    private List<BakedQuad> quads;
    private long lastUsed;
    private static HashMap<ItemModelCacheKey, ItemModelCache> caches = new HashMap();
    private static int ticker = 0;
    public static int timeToExpire = 30000;
    private static int timeToCheck = timeToExpire / 50;

    public ItemModelCache(List<BakedQuad> quads) {
        this.quads = quads;
        this.lastUsed = System.currentTimeMillis();
    }

    public boolean expired() {
        return System.currentTimeMillis() - this.lastUsed >= (long)timeToExpire;
    }

    public List<BakedQuad> getQuads() {
        this.lastUsed = System.currentTimeMillis();
        return this.quads;
    }

    public static void cacheModel(ItemStack stack, EnumFacing facing, List<BakedQuad> quads) {
        caches.put(new ItemModelCacheKey(stack, facing), new ItemModelCache(quads));
    }

    public static List<BakedQuad> getCache(ItemStack stack, EnumFacing facing) {
        ItemModelCache cache = caches.get(new ItemModelCacheKey(stack, facing));
        if (cache != null) {
            return cache.getQuads();
        }
        return null;
    }

    public static void tick() {
        if (++ticker >= timeToCheck) {
            Iterator<ItemModelCache> iterator = caches.values().iterator();
            while (iterator.hasNext()) {
                ItemModelCache cache = iterator.next();
                if (!cache.expired()) continue;
                iterator.remove();
            }
            ticker = 0;
        }
    }

    private static class ItemModelCacheKey {
        public ItemStack stack;
        public EnumFacing facing;

        public ItemModelCacheKey(ItemStack stack, EnumFacing facing) {
            this.stack = stack;
            this.facing = facing;
        }

        public boolean equals(Object object) {
            if (object instanceof ItemModelCacheKey) {
                return ((ItemModelCacheKey)object).stack.equals(this.stack) && ((ItemModelCacheKey)object).facing == this.facing;
            }
            return false;
        }

        public int hashCode() {
            return this.stack.hashCode() + this.facing.hashCode();
        }
    }
}

