/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.data.MCDataInput;
import cofh.redstoneflux.api.IEnergyReceiver;
import com.brandon3055.brandonscore.blocks.TileEnergyBase;
import com.brandon3055.brandonscore.client.particle.BCEffectHandler;
import com.brandon3055.brandonscore.client.particle.BCParticle;
import com.brandon3055.brandonscore.lib.IChangeListener;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedByte;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.client.render.effect.EffectTrackerCelestialManipulator;
import com.brandon3055.draconicevolution.client.sound.CelestialModifierSound;
import com.brandon3055.draconicevolution.helpers.ResourceHelperDE;
import com.brandon3055.draconicevolution.lib.DESoundHandler;
import com.brandon3055.draconicevolution.utils.LogHelper;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileCelestialManipulator
extends TileEnergyBase
implements ITickable,
IEnergyReceiver,
IChangeListener {
    public final ManagedBool WEATHER_MODE = (ManagedBool)this.register("WEATHER_MODE", (IManagedData)new ManagedBool(true)).syncViaTile().saveToTile().finish();
    public final ManagedBool ACTIVE = (ManagedBool)this.register("ACTIVE", (IManagedData)new ManagedBool(false)).syncViaTile().saveToTile().finish();
    public final ManagedBool weatherToggleRunning = (ManagedBool)this.register("weatherToggleRunning", (IManagedData)new ManagedBool(false)).syncViaTile().finish();
    public final ManagedBool timeWarpRunning = (ManagedBool)this.register("timeWarpRunning", (IManagedData)new ManagedBool(false)).syncViaTile().finish();
    public final ManagedBool timeWarpStopping = (ManagedBool)this.register("timeWarpStopping", (IManagedData)new ManagedBool(false)).syncViaTile().finish();
    public final ManagedBool redstoneSignal = (ManagedBool)this.register("redstoneSignal", (IManagedData)new ManagedBool(false)).syncViaTile().saveToTile().finish();
    public final ManagedByte rsMode = (ManagedByte)this.register("rsMode", (IManagedData)new ManagedByte(0)).syncViaContainer().saveToTile().finish();
    public int timer = 0;
    public boolean storm = false;
    public boolean rain = false;
    public long targetTime;
    @SideOnly(value=Side.CLIENT)
    private CelestialModifierSound sound;
    @SideOnly(value=Side.CLIENT)
    private List<EffectTrackerCelestialManipulator> effects;
    private String[] ACTIONS = new String[]{"STOP_RAIN", "START_RAIN", "START_STORM", "SUN_RISE", "MID_DAY", "SUN_SET", "MOON_RISE", "MIDNIGHT", "MOON_SET", "SKIP_24"};

    public TileCelestialManipulator() {
        this.setCapacityAndTransfer(4000000, 4000000, 4000000);
        this.setEnergySyncMode().syncViaContainer();
    }

    public void func_73660_a() {
        super.update();
        if (this.weatherToggleRunning.value) {
            ++this.timer;
            if (this.field_145850_b.field_72995_K) {
                this.updateWeatherEffects();
            } else if (this.timer >= 230) {
                this.timer = 0;
                this.weatherToggleRunning.value = false;
                this.field_145850_b.func_72912_H().func_76084_b(this.rain);
                this.field_145850_b.func_72912_H().func_76069_a(this.storm);
                int time = 12000 + this.field_145850_b.field_73012_v.nextInt(24000);
                this.field_145850_b.func_72912_H().func_76080_g(this.rain ? time : 0);
                this.field_145850_b.func_72912_H().func_176142_i(this.rain ? 0 : time);
            }
        } else if (this.timeWarpRunning.value) {
            ++this.timer;
            if (this.field_145850_b.field_72995_K) {
                this.updateSunEffect();
            }
            if (this.timer > 100) {
                if (this.getEnergyStored() > 320) {
                    int extracted = this.energyStorage.extractEnergy(16000, true);
                    int ticks = extracted / 320;
                    this.energyStorage.extractEnergy(ticks * 320, false);
                    this.field_145850_b.func_72877_b(this.field_145850_b.func_72820_D() + (long)ticks);
                }
                if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_72820_D() >= this.targetTime) {
                    this.stopTimeWarp();
                }
            }
        } else if (this.timeWarpStopping.value) {
            if (this.timer > 100) {
                this.timer = 100;
            }
            --this.timer;
            if (this.timer <= 0 && !this.field_145850_b.field_72995_K) {
                this.timeWarpStopping.value = false;
            }
            if (this.field_145850_b.field_72995_K && this.timer >= 0) {
                this.updateSunEffect();
            } else if (this.field_145850_b.field_72995_K) {
                if (this.effects != null) {
                    this.effects.clear();
                }
                if (this.sound != null) {
                    this.sound.kill();
                    this.sound = null;
                }
            }
        } else if (this.ACTIVE.value) {
            this.ACTIVE.value = false;
        } else if (this.field_145850_b.field_72995_K) {
            this.standbyParticleEffect();
        }
    }

    public void toggleWeather(boolean rain, boolean storm) {
        if (this.field_145850_b.field_72995_K || this.ACTIVE.value) {
            return;
        }
        this.storm = storm;
        this.rain = rain;
        this.timer = 0;
        this.weatherToggleRunning.value = true;
        this.ACTIVE.value = true;
    }

    public void startTimeWarp(long targetTime) {
        this.ACTIVE.value = true;
        this.targetTime = targetTime;
        this.timer = 0;
        this.timeWarpRunning.value = true;
    }

    public void stopTimeWarp() {
        this.timeWarpRunning.value = false;
        this.timeWarpStopping.value = true;
    }

    public void receivePacketFromClient(MCDataInput data, EntityPlayerMP client, int id) {
        int intValue;
        if (id == 0) {
            this.handleInteract(data.readString(), (EntityPlayer)client);
        } else if (id == 1 && (intValue = data.readInt()) >= 0 && intValue <= 9) {
            this.rsMode.value = (byte)intValue;
        }
    }

    public void handleInteract(String action, EntityPlayer player) {
        if (action.endsWith("STOP") && this.ACTIVE.value && this.timeWarpRunning.value) {
            this.stopTimeWarp();
            return;
        }
        if (this.ACTIVE.value) {
            this.sendMessage((ITextComponent)new TextComponentTranslation("msg.de.alreadyRunning.txt", new Object[0]), player);
            return;
        }
        switch (action) {
            case "WEATHER_MODE": {
                this.WEATHER_MODE.value = true;
                return;
            }
            case "SUN_MODE": {
                this.WEATHER_MODE.value = false;
                return;
            }
            case "STOP_RAIN": {
                if (!this.field_145850_b.func_72896_J()) {
                    this.sendMessage((ITextComponent)new TextComponentTranslation("msg.de.notRaining.txt", new Object[0]), player);
                    return;
                }
                if (this.getEnergyStored() < 256000) {
                    this.sendMessage(new TextComponentTranslation("msg.de.insufficientPower.txt", new Object[0]).func_150258_a(" (256000RF)"), player);
                    return;
                }
                this.energyStorage.modifyEnergyStored(-256000);
                this.toggleWeather(false, false);
                LogHelper.info("Stopped rain! Cause: " + this.field_174879_c);
                return;
            }
            case "START_RAIN": {
                if (this.field_145850_b.func_72896_J()) {
                    this.sendMessage((ITextComponent)new TextComponentTranslation("msg.de.alreadyRaining.txt", new Object[0]), player);
                    return;
                }
                if (this.getEnergyStored() < 256000) {
                    this.sendMessage(new TextComponentTranslation("msg.de.insufficientPower.txt", new Object[0]).func_150258_a(" (256000RF)"), player);
                    return;
                }
                this.energyStorage.modifyEnergyStored(-256000);
                this.toggleWeather(true, false);
                LogHelper.info("Started rain! Cause: " + this.field_174879_c);
                return;
            }
            case "START_STORM": {
                if (this.field_145850_b.func_72896_J() && this.field_145850_b.func_72911_I()) {
                    this.sendMessage((ITextComponent)new TextComponentTranslation("msg.de.alreadyStorm.txt", new Object[0]), player);
                    return;
                }
                if (this.getEnergyStored() < 384000) {
                    this.sendMessage(new TextComponentTranslation("msg.de.insufficientPower.txt", new Object[0]).func_150258_a(" (384000RF)"), player);
                    return;
                }
                this.energyStorage.modifyEnergyStored(-384000);
                this.toggleWeather(true, true);
                LogHelper.info("Started storm! Cause: " + this.field_174879_c);
                return;
            }
            case "SUN_RISE": {
                this.startTimeWarp(this.field_145850_b.func_72820_D() + (long)this.calculateTimeTill(0));
                LogHelper.info("Set time to sunrise! Cause: " + this.field_174879_c);
                break;
            }
            case "MID_DAY": {
                this.startTimeWarp(this.field_145850_b.func_72820_D() + (long)this.calculateTimeTill(5900));
                LogHelper.info("Set time to midday! Cause: " + this.field_174879_c);
                break;
            }
            case "SUN_SET": {
                this.startTimeWarp(this.field_145850_b.func_72820_D() + (long)this.calculateTimeTill(12000));
                LogHelper.info("Set time to sunset! Cause: " + this.field_174879_c);
                break;
            }
            case "MOON_RISE": {
                this.startTimeWarp(this.field_145850_b.func_72820_D() + (long)this.calculateTimeTill(13000));
                LogHelper.info("Set time to moonrise! Cause: " + this.field_174879_c);
                break;
            }
            case "MIDNIGHT": {
                this.startTimeWarp(this.field_145850_b.func_72820_D() + (long)this.calculateTimeTill(17900));
                LogHelper.info("Set time to midnight! Cause: " + this.field_174879_c);
                break;
            }
            case "MOON_SET": {
                this.startTimeWarp(this.field_145850_b.func_72820_D() + (long)this.calculateTimeTill(22500));
                LogHelper.info("Set time to moonset! Cause: " + this.field_174879_c);
                break;
            }
            case "SKIP_24": {
                this.startTimeWarp(this.field_145850_b.func_72820_D() + 24000L);
                LogHelper.info("Skipped one day! Cause: " + this.field_174879_c);
            }
        }
    }

    private void sendMessage(ITextComponent message, EntityPlayer player) {
        if (player != null) {
            player.func_145747_a(message);
        }
    }

    private int calculateTimeTill(int time) {
        int currentTime = (int)(this.field_145850_b.func_72820_D() % 24000L);
        return currentTime > time ? 24000 - (currentTime - time) : time - currentTime;
    }

    @SideOnly(value=Side.CLIENT)
    public void startWeatherEffect() {
        this.timer = 0;
        this.effects = new LinkedList<EffectTrackerCelestialManipulator>();
        for (int i = 0; i < 8; ++i) {
            this.effects.add(new EffectTrackerCelestialManipulator(this.field_145850_b, Vec3D.getCenter((BlockPos)this.field_174879_c).add(0.0, 1.5, 0.0), Vec3D.getCenter((BlockPos)this.field_174879_c).add(0.0, 1.5, 0.0)));
        }
        Vec3D vec = Vec3D.getCenter((BlockPos)this.field_174879_c.func_177982_a(0, 1, 0));
        this.sound = new CelestialModifierSound(DESoundHandler.electricBuzz);
        this.sound.updateSound(vec, 0.01f, 0.5f);
        FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)this.sound);
        this.field_145850_b.func_184134_a(vec.x, vec.y, vec.z, DESoundHandler.fusionComplete, SoundCategory.BLOCKS, this.getSoundVolume(), 0.5f, false);
    }

    @SideOnly(value=Side.CLIENT)
    public void updateWeatherEffects() {
        if (this.effects == null || this.effects.size() < 8 || this.sound == null) {
            this.startWeatherEffect();
            return;
        }
        double riseEnd = 20.0;
        double expandStart = 60.0;
        double expandEnd = 100.0;
        double ascendStart = 140.0;
        double ascendStop = 200.0;
        double ascendHeight = 500.0;
        double height = Math.min(riseEnd, (double)this.timer) / riseEnd * 3.0;
        double expansion = (double)this.timer > expandStart ? (Math.min(expandEnd, (double)this.timer) - expandStart) / (expandEnd - expandStart) : 0.0;
        double secondaryExpand = 0.0;
        double ascPos = 0.0;
        if ((double)this.timer > ascendStart) {
            ascPos = ((double)this.timer - ascendStart) / (ascendStop - ascendStart);
            height += ascPos * (ascendHeight * ascPos);
            secondaryExpand = ascPos * ascPos * 100.0;
        }
        Vec3D effectFocus = Vec3D.getCenter((BlockPos)this.field_174879_c).add(0.0, height, 0.0);
        if ((double)this.timer == riseEnd) {
            this.field_145850_b.func_184134_a(effectFocus.x, effectFocus.y, effectFocus.z, DESoundHandler.fusionComplete, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        } else if ((double)this.timer == ascendStart) {
            this.field_145850_b.func_184134_a(effectFocus.x, effectFocus.y, effectFocus.z, DESoundHandler.fusionComplete, SoundCategory.BLOCKS, 1.0f, 2.0f, false);
            for (int i = 0; i < 100; ++i) {
                try {
                    EffectTrackerCelestialManipulator.SubParticle particle = new EffectTrackerCelestialManipulator.SubParticle(this.field_145850_b, this.effects.get((int)this.field_145850_b.field_73012_v.nextInt((int)this.effects.size())).pos);
                    particle.setScale(2.0f);
                    BCEffectHandler.spawnFXDirect((ResourceLocation)DEParticles.DE_SHEET, (BCParticle)particle, (double)128.0, (boolean)true);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.sound.updateSound(effectFocus.copy().add(0.0, -(height * 0.8), 0.0), (float)expansion, (float)expansion + 0.5f);
        for (EffectTrackerCelestialManipulator effect : this.effects) {
            effect.onUpdate();
        }
        double rotation = (double)this.timer * (expansion * 0.05);
        for (EffectTrackerCelestialManipulator effect : this.effects) {
            effect.effectFocus = effectFocus;
            effect.scale = (float)expansion * (1.0f + (float)(ascPos * 5.0));
            double indexPos = (double)this.effects.indexOf(effect) / (double)this.effects.size();
            double offset = indexPos * (Math.PI * 2);
            double offsetX = Math.sin(rotation + offset) * expansion * (3.0 + secondaryExpand);
            double offsetZ = Math.cos(rotation + offset) * expansion * (3.0 + secondaryExpand);
            effect.pos = effectFocus.copy().add(offsetX, 0.0, offsetZ);
            offset = (indexPos + 1.0 / (double)this.effects.size()) * (Math.PI * 2);
            offsetX = Math.sin(rotation + offset) * expansion * (3.0 + secondaryExpand);
            offsetZ = Math.cos(rotation + offset) * expansion * (3.0 + secondaryExpand);
            effect.linkPos = effectFocus.copy().add(offsetX, 0.0, offsetZ);
        }
        if (this.timer >= 220) {
            this.field_145850_b.func_184134_a(effectFocus.x, effectFocus.y, effectFocus.z, DESoundHandler.boom, SoundCategory.BLOCKS, DEConfig.disableLoudCelestialManipulator ? 1.0f : 100.0f, 1.0f, false);
            this.timer = 0;
            this.weatherToggleRunning.value = false;
            this.effects.clear();
            this.sound.kill();
            this.sound = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void startSunEffect() {
        this.timeWarpRunning.value = true;
        this.timeWarpStopping.value = false;
        this.timer = 0;
        this.effects = new LinkedList<EffectTrackerCelestialManipulator>();
        for (int i = 0; i < 12; ++i) {
            this.effects.add(new EffectTrackerCelestialManipulator(this.field_145850_b, Vec3D.getCenter((BlockPos)this.field_174879_c).add(0.0, 1.5, 0.0), Vec3D.getCenter((BlockPos)this.field_174879_c).add(0.0, 1.5, 0.0)));
        }
        this.effects.get((int)0).red = 1.0f;
        this.effects.get((int)0).green = 0.821f;
        this.effects.get((int)0).blue = 0.174f;
        this.effects.get((int)0).renderBolts = false;
        this.effects.get((int)1).red = 1.0f;
        this.effects.get((int)1).green = 1.0f;
        this.effects.get((int)1).blue = 1.0f;
        this.effects.get((int)1).renderBolts = false;
        this.sound = new CelestialModifierSound(DESoundHandler.sunDialEffect);
        this.sound.updateSound(Vec3D.getCenter((BlockPos)this.field_174879_c), this.getSoundVolume(), 0.5f);
        FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)this.sound);
    }

    @SideOnly(value=Side.CLIENT)
    public void stopSunEffect() {
    }

    @SideOnly(value=Side.CLIENT)
    public void updateSunEffect() {
        double offset;
        EffectTrackerCelestialManipulator effect;
        if (this.effects == null || this.effects.size() < 2 || this.sound == null) {
            this.startSunEffect();
        }
        double depProg = Math.min((double)((float)this.timer / 100.0f), 1.0);
        Vec3D focus = Vec3D.getCenter((BlockPos)this.field_174879_c).add(0.0, 5.5 * depProg, 0.0);
        this.sound.updateSound(focus, (float)depProg, 0.5f + (float)depProg);
        if (this.timer % 4 == 0) {
            for (int i = 0; i < (this.timer % 20 <= 10 ? 10 : 2); ++i) {
                BCEffectHandler.spawnFXDirect((ResourceLocation)DEParticles.DE_SHEET, (BCParticle)new EffectTrackerCelestialManipulator.SubParticle2(this.field_145850_b, focus, this.effects.get(i % 2)), (double)128.0, (boolean)true);
            }
        }
        double rotation = (double)(this.field_145850_b.func_72820_D() % 24000L) / 24000.0;
        for (int i = 0; i < 2; ++i) {
            effect = this.effects.get(i);
            effect.scale = (float)depProg;
            effect.onUpdate();
            offset = rotation * (Math.PI * 2);
            double offsetX = Math.cos(offset) * 2.5 * depProg;
            double offsetY = Math.sin(offset) * 2.5 * depProg;
            effect.pos = focus.copy().add(offsetX, offsetY, 0.0);
            rotation += 0.5;
            effect.effectFocus = focus;
        }
        rotation = (double)this.timer / 50.0;
        double inc = 1.0 / (double)(this.effects.size() - 2);
        for (int i = 2; i < this.effects.size(); ++i) {
            effect = this.effects.get(i);
            offset = rotation * (Math.PI * 2);
            double x = Math.cos(offset) * 1.0 * depProg;
            double z = Math.sin(offset) * 1.0 * depProg;
            effect.scale = (float)depProg;
            effect.onUpdate();
            effect.pos = focus.copy().add(x, (i % 2 == 0 ? x : -x) * 0.8, z);
            if (i % 2 == 0) {
                effect.red = 0.9f;
                effect.green = 0.5f;
                effect.blue = 0.1f;
            } else {
                effect.red = 0.3f;
                effect.green = 0.2f;
                effect.blue = 1.0f;
            }
            effect.effectFocus = focus;
            effect.renderBolts = false;
            rotation += inc;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void standbyParticleEffect() {
        EffectTrackerCelestialManipulator.SubParticle particle = new EffectTrackerCelestialManipulator.SubParticle(this.field_145850_b, Vec3D.getCenter((BlockPos)this.field_174879_c));
        particle.setScale(0.2f);
        BCEffectHandler.spawnFXDirect((ResourceLocation)DEParticles.DE_SHEET, (BCParticle)particle);
        if (this.effects != null) {
            this.effects = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderEffects(float partialTicks) {
        if (this.effects != null) {
            if (this.weatherToggleRunning.value) {
                ResourceHelperDE.bindTexture("textures/blocks/fusion_crafting/fusion_particle.png");
            } else {
                ResourceHelperDE.bindTexture("textures/particle/celestial_manipulator.png");
            }
            Tessellator tessellator = Tessellator.func_178181_a();
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            for (EffectTrackerCelestialManipulator effect : this.effects) {
                effect.renderEffect(tessellator, partialTicks);
            }
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public void onNeighborChange(BlockPos blockChanged) {
        if (this.field_145850_b.func_175640_z(this.field_174879_c)) {
            if (!this.redstoneSignal.value) {
                this.redstoneSignal.value = true;
                this.handleInteract(this.ACTIONS[this.rsMode.value], null);
            }
        } else if (this.redstoneSignal.value) {
            this.redstoneSignal.value = false;
            if (this.timeWarpRunning.value && this.rsMode.value == 9) {
                this.stopTimeWarp();
            }
        }
    }

    private float getSoundVolume() {
        return DEConfig.disableLoudCelestialManipulator ? 1.0f : 10.0f;
    }
}

