/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.sprite;

import com.teamwizardry.librarianlib.features.sprite.ISprite;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@SideOnly(value=Side.CLIENT)
@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fJF\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004J\u0006\u0010\u0017\u001a\u00020\tJ\u0006\u0010\u0018\u001a\u00020\tR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/teamwizardry/librarianlib/features/sprite/DrawingUtil;", "", "()V", "isDrawing", "", "()Z", "setDrawing", "(Z)V", "draw", "", "sprite", "Lcom/teamwizardry/librarianlib/features/sprite/ISprite;", "animFrames", "", "x", "", "y", "width", "height", "drawClipped", "animTicks", "reverseX", "reverseY", "endDrawingSession", "startDrawingSession", "librarianlib-1.12.2"})
public final class DrawingUtil {
    private static boolean isDrawing;
    public static final DrawingUtil INSTANCE;

    public final boolean isDrawing() {
        return isDrawing;
    }

    public final void setDrawing(boolean bl) {
        isDrawing = bl;
    }

    public final void startDrawingSession() {
        Tessellator tessellator = Tessellator.func_178181_a();
        Intrinsics.checkExpressionValueIsNotNull((Object)tessellator, (String)"Tessellator.getInstance()");
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        isDrawing = true;
    }

    public final void endDrawingSession() {
        Tessellator.func_178181_a().func_78381_a();
        isDrawing = false;
    }

    public final void draw(@NotNull ISprite sprite, int animFrames, float x, float y, float width, float height) {
        Tessellator tessellator;
        Intrinsics.checkParameterIsNotNull((Object)sprite, (String)"sprite");
        float minX = x;
        float minY = y;
        float maxX = x + width;
        float maxY = y + height;
        Tessellator tessellator2 = tessellator = Tessellator.func_178181_a();
        Intrinsics.checkExpressionValueIsNotNull((Object)tessellator2, (String)"tessellator");
        BufferBuilder vb = tessellator2.func_178180_c();
        if (!isDrawing) {
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        }
        vb.func_181662_b((double)minX, (double)maxY, 0.0).func_187315_a((double)sprite.minU(animFrames), (double)sprite.maxV(animFrames)).func_181675_d();
        vb.func_181662_b((double)maxX, (double)maxY, 0.0).func_187315_a((double)sprite.maxU(animFrames), (double)sprite.maxV(animFrames)).func_181675_d();
        vb.func_181662_b((double)maxX, (double)minY, 0.0).func_187315_a((double)sprite.maxU(animFrames), (double)sprite.minV(animFrames)).func_181675_d();
        vb.func_181662_b((double)minX, (double)minY, 0.0).func_187315_a((double)sprite.minU(animFrames), (double)sprite.minV(animFrames)).func_181675_d();
        if (!isDrawing) {
            tessellator.func_78381_a();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void drawClipped(@NotNull ISprite sprite, int animTicks, float x, float y, int width, int height, boolean reverseX, boolean reverseY) {
        Intrinsics.checkParameterIsNotNull((Object)sprite, (String)"sprite");
        if (!isDrawing) {
            int hor = (int)Math.ceil((double)width / (double)sprite.getWidth());
            int vert = (int)Math.ceil((double)height / (double)sprite.getHeight());
            int n = 0;
            int n2 = hor;
            while (n < n2) {
                void xIndex;
                int n3 = 0;
                int n4 = vert;
                while (n3 < n4) {
                    int cropH;
                    int cropW;
                    void yIndex;
                    boolean croppedX = reverseX && xIndex == false || !reverseX && xIndex == hor - 1;
                    boolean croppedY = reverseY && yIndex == false || !reverseY && yIndex == vert - 1;
                    int n5 = cropW = croppedX ? sprite.getWidth() - width % sprite.getWidth() : 0;
                    if (cropW == sprite.getWidth()) {
                        cropW = 0;
                    }
                    int n6 = cropH = croppedY ? sprite.getHeight() - height % sprite.getHeight() : 0;
                    if (cropH == sprite.getHeight()) {
                        cropH = 0;
                    }
                    float sX = x + (float)(xIndex * sprite.getWidth());
                    float sY = y + (float)(yIndex * sprite.getHeight());
                    double realX = reverseX ? sX + (float)cropW + (float)sprite.getInWidth() - (float)(sprite.getHeight() * hor) : sX;
                    double realY = reverseY ? sY + (float)cropH + (float)sprite.getInHeight() - (float)(sprite.getHeight() * vert) : sY;
                    double maxX = realX + (double)(croppedX ? sprite.getWidth() - cropW : sprite.getWidth());
                    double maxY = realY + (double)(croppedY ? sprite.getHeight() - cropH : sprite.getHeight());
                    double minU = sprite.minU(animTicks);
                    double minV = sprite.minV(animTicks);
                    double maxU = sprite.maxU(animTicks);
                    double maxV = sprite.maxV(animTicks);
                    double uSpan = maxU - minU;
                    double vSpan = maxV - minV;
                    if (croppedX) {
                        if (reverseX) {
                            minU += uSpan * ((double)cropW / (double)sprite.getWidth());
                        } else {
                            maxU -= uSpan * ((double)cropW / (double)sprite.getWidth());
                        }
                    }
                    if (croppedY) {
                        if (reverseY) {
                            minV += vSpan * ((double)cropH / (double)sprite.getHeight());
                        } else {
                            maxV -= vSpan * ((double)cropH / (double)sprite.getHeight());
                        }
                    }
                    Tessellator tessellator = Tessellator.func_178181_a();
                    Intrinsics.checkExpressionValueIsNotNull((Object)tessellator, (String)"Tessellator.getInstance()");
                    BufferBuilder vb1 = tessellator.func_178180_c();
                    this.startDrawingSession();
                    vb1.func_181662_b(realX, realY, 0.0).func_187315_a(minU, minV).func_181675_d();
                    vb1.func_181662_b(realX, maxY, 0.0).func_187315_a(minU, maxV).func_181675_d();
                    vb1.func_181662_b(maxX, maxY, 0.0).func_187315_a(maxU, maxV).func_181675_d();
                    vb1.func_181662_b(maxX, realY, 0.0).func_187315_a(maxU, minV).func_181675_d();
                    this.endDrawingSession();
                    ++yIndex;
                }
                ++xIndex;
            }
        }
    }

    private DrawingUtil() {
    }

    static {
        DrawingUtil drawingUtil;
        INSTANCE = drawingUtil = new DrawingUtil();
    }
}

