/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.base;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.teamwizardry.librarianlib.core.LibrarianLib;
import com.teamwizardry.librarianlib.core.LibrarianLog;
import com.teamwizardry.librarianlib.core.common.LibLibConfig;
import com.teamwizardry.librarianlib.core.common.OwnershipHandler;
import com.teamwizardry.librarianlib.core.common.RegistrationHandler;
import com.teamwizardry.librarianlib.features.helpers.VariantHelper;
import com.teamwizardry.librarianlib.features.kotlin.CommonUtilMethods;
import com.teamwizardry.librarianlib.features.kotlin.JsonMaker;
import com.teamwizardry.librarianlib.features.utilities.JsonGenerationUtilsKt;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B-\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0006\"\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0016J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/teamwizardry/librarianlib/features/base/ModSoundEvent;", "Lnet/minecraft/util/SoundEvent;", "name", "", "subtitle", "sounds", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/lang/String;)V", "(Ljava/lang/String;)V", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "id", "Lnet/minecraft/util/ResourceLocation;", "modid", "json", "Lcom/google/gson/JsonElement;", "", "Companion", "EventHandler", "librarianlib-1.12.2"})
public class ModSoundEvent
extends SoundEvent {
    private final String modid;
    private final String subtitle;
    private final ResourceLocation id;
    private final List<String> sounds;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String name() {
        String string = this.id.func_110623_a();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id.path");
        return string;
    }

    @NotNull
    public Iterable<String> sounds() {
        return this.sounds;
    }

    @Nullable
    public String subtitle() {
        return this.subtitle;
    }

    @NotNull
    public JsonElement json() {
        JsonObject obj = new JsonObject();
        obj.add("sounds", JsonMaker.convertJSON(this.sounds()));
        String sub = this.subtitle();
        if (sub != null) {
            obj.addProperty("subtitle", sub);
        }
        return (JsonElement)obj;
    }

    /*
     * WARNING - void declaration
     */
    public ModSoundEvent(@NotNull String name, @Nullable String subtitle, @NotNull List<String> sounds) {
        Object object;
        void $receiver$iv;
        String string;
        Object object2;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(sounds, (String)"sounds");
        super(ModSoundEvent.Companion.rl(name));
        this.sounds = sounds;
        this.modid = com.teamwizardry.librarianlib.features.helpers.CommonUtilMethods.getCurrentModId();
        ModSoundEvent modSoundEvent = this;
        String string2 = subtitle;
        if (string2 != null) {
            object2 = string2;
            ModSoundEvent modSoundEvent2 = modSoundEvent;
            String it = object2;
            String string3 = this.modid + ".subtitle." + VariantHelper.toSnakeCase(subtitle);
            modSoundEvent = modSoundEvent2;
            string = string3;
        } else {
            string = null;
        }
        modSoundEvent.subtitle = string;
        this.id = ModSoundEvent.Companion.rl(name);
        RegistrationHandler.register((IForgeRegistryEntry)this, this.id);
        object2 = EventHandler.INSTANCE.getModSounds();
        String key$iv = this.modid;
        Object value$iv = $receiver$iv.get(key$iv);
        if (value$iv == null) {
            List answer$iv = new ArrayList();
            $receiver$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((List)object).add(this);
    }

    public ModSoundEvent(@NotNull String name, @Nullable String subtitle, String ... sounds) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)sounds, (String)"sounds");
        this(name, subtitle, CollectionsKt.listOf((Object[])Arrays.copyOf(sounds, sounds.length)));
    }

    public ModSoundEvent(@NotNull String name, @Nullable String subtitle) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this(name, subtitle, CollectionsKt.listOf((Object)ModSoundEvent.Companion.rl(name).toString()));
    }

    public ModSoundEvent(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this(name, null);
    }

    @JvmStatic
    @NotNull
    public static final ModSoundEvent simple(@NotNull String name) {
        return Companion.simple(name);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u0016\u0010\r\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0007J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015R#\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/teamwizardry/librarianlib/features/base/ModSoundEvent$EventHandler;", "", "()V", "modSounds", "", "", "", "Lcom/teamwizardry/librarianlib/features/base/ModSoundEvent;", "getModSounds", "()Ljava/util/Map;", "log", "", "text", "onSoundRegistry", "event", "Lnet/minecraftforge/event/RegistryEvent$Register;", "Lnet/minecraft/util/SoundEvent;", "serialize", "el", "Lcom/google/gson/JsonElement;", "shouldGenerateAnyJson", "", "librarianlib-1.12.2"})
    private static final class EventHandler {
        @NotNull
        private static final Map<String, List<ModSoundEvent>> modSounds;
        public static final EventHandler INSTANCE;

        @NotNull
        public final Map<String, List<ModSoundEvent>> getModSounds() {
            return modSounds;
        }

        public final boolean shouldGenerateAnyJson() {
            return LibrarianLib.DEV_ENVIRONMENT && LibLibConfig.getGenerateJson();
        }

        @NotNull
        public final String serialize(@NotNull JsonElement el) {
            Intrinsics.checkParameterIsNotNull((Object)el, (String)"el");
            return LibLibConfig.getPrettyJsonSerialization() ? JsonMaker.serialize(el) : el.toString() + "\n";
        }

        public final void log(@NotNull String text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            if (LibrarianLib.DEV_ENVIRONMENT) {
                LibrarianLog.INSTANCE.info(text, new Object[0]);
            }
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public final void onSoundRegistry(@NotNull RegistryEvent.Register<SoundEvent> event) {
            Intrinsics.checkParameterIsNotNull(event, (String)"event");
            if (this.shouldGenerateAnyJson()) {
                Map<String, List<ModSoundEvent>> map = modSounds;
                Iterator<Map.Entry<String, List<ModSoundEvent>>> iterator2 = map.entrySet().iterator();
                while (iterator2.hasNext()) {
                    File file;
                    Map.Entry<String, List<ModSoundEvent>> entry;
                    Map.Entry<String, List<ModSoundEvent>> entry2 = entry = iterator2.next();
                    String mod = entry2.getKey();
                    entry2 = entry;
                    List<ModSoundEvent> sounds = entry2.getValue();
                    if (!OwnershipHandler.INSTANCE.getDEV_OWNED().contains(mod)) continue;
                    this.log("" + mod + " | Registering sounds in json");
                    String modpad = CommonUtilMethods.times(" ", mod.length());
                    String soundJsonPath = JsonGenerationUtilsKt.getPathForSounds(mod);
                    File file2 = new File(soundJsonPath);
                    file2.getParentFile().mkdirs();
                    file2.createNewFile();
                    boolean flag = false;
                    try {
                        file = file2;
                        JsonParser jsonParser = new JsonParser();
                        Charset charset = Charsets.UTF_8;
                        Object object = file;
                        object = new FileInputStream((File)object);
                        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object, charset);
                        JsonElement jsonElement = jsonParser.parse((Reader)inputStreamReader);
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"JsonParser().parse(file.reader())");
                        file = jsonElement.getAsJsonObject();
                    }
                    catch (Throwable ignored) {
                        flag = true;
                        file = new JsonObject();
                    }
                    File json = file;
                    for (ModSoundEvent sound : sounds) {
                        String name = sound.name();
                        this.log("" + modpad + " | Registering sound " + name);
                        if (json.has(name)) continue;
                        json.add(name, sound.json());
                        this.log("" + modpad + " | Successfully registered " + name + '!');
                        flag = true;
                    }
                    if (!flag) continue;
                    this.log("" + modpad + " | Writing new sound json");
                    File file3 = json;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"json");
                    FilesKt.writeText$default((File)file2, (String)this.serialize((JsonElement)file3), null, (int)2, null);
                    JsonGenerationUtilsKt.getGeneratedFiles().add(soundJsonPath);
                }
            }
        }

        private EventHandler() {
        }

        static {
            EventHandler eventHandler;
            INSTANCE = eventHandler = new EventHandler();
            modSounds = new LinkedHashMap();
            FMLCommonHandler fMLCommonHandler = FMLCommonHandler.instance();
            Intrinsics.checkExpressionValueIsNotNull((Object)fMLCommonHandler, (String)"FMLCommonHandler.instance()");
            Side side = fMLCommonHandler.getSide();
            Intrinsics.checkExpressionValueIsNotNull((Object)side, (String)"FMLCommonHandler.instance().side");
            if (side.isClient()) {
                MinecraftForge.EVENT_BUS.register((Object)eventHandler);
            }
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\t"}, d2={"Lcom/teamwizardry/librarianlib/features/base/ModSoundEvent$Companion;", "", "()V", "rl", "Lnet/minecraft/util/ResourceLocation;", "name", "", "simple", "Lcom/teamwizardry/librarianlib/features/base/ModSoundEvent;", "librarianlib-1.12.2"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ModSoundEvent simple(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return new ModSoundEvent(name, name);
        }

        private final ResourceLocation rl(String name) {
            return new ResourceLocation(com.teamwizardry.librarianlib.features.helpers.CommonUtilMethods.getCurrentModId(), VariantHelper.toSnakeCase(name));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

