/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.plugins.jei;

import java.util.ArrayList;
import java.util.HashMap;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import xt9.deepmoblearning.client.gui.ExtractionChamberGui;
import xt9.deepmoblearning.common.Registry;
import xt9.deepmoblearning.common.config.Config;
import xt9.deepmoblearning.common.mobmetas.MobMetaData;
import xt9.deepmoblearning.common.trials.TrialFactory;
import xt9.deepmoblearning.common.util.DataModel;
import xt9.deepmoblearning.common.util.Tier;
import xt9.deepmoblearning.common.util.TrialKey;
import xt9.deepmoblearning.plugins.jei.ExtractionChamberRecipe;
import xt9.deepmoblearning.plugins.jei.ExtractionChamberRecipeCategory;
import xt9.deepmoblearning.plugins.jei.ExtractionChamberRecipeWrapper;
import xt9.deepmoblearning.plugins.jei.SimulationChamberRecipe;
import xt9.deepmoblearning.plugins.jei.SimulationChamberRecipeCategory;
import xt9.deepmoblearning.plugins.jei.SimulationChamberRecipeWrapper;
import xt9.deepmoblearning.plugins.jei.TrialKeystoneRecipe;
import xt9.deepmoblearning.plugins.jei.TrialKeystoneRecipeCategory;
import xt9.deepmoblearning.plugins.jei.TrialKeystoneRecipeWrapper;

@JEIPlugin
public class Plugin
implements IModPlugin {
    private static IJeiHelpers jeiHelpers;
    private static SimulationChamberRecipeCategory simChamberCategory;
    private static ExtractionChamberRecipeCategory exChamberCategory;
    private static TrialKeystoneRecipeCategory trialKeystoneCategory;

    public void registerCategories(IRecipeCategoryRegistration registry) {
        jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        simChamberCategory = new SimulationChamberRecipeCategory(guiHelper);
        registry.addRecipeCategories(new IRecipeCategory[]{simChamberCategory});
        exChamberCategory = new ExtractionChamberRecipeCategory(guiHelper);
        registry.addRecipeCategories(new IRecipeCategory[]{exChamberCategory});
        trialKeystoneCategory = new TrialKeystoneRecipeCategory(guiHelper);
        registry.addRecipeCategories(new IRecipeCategory[]{trialKeystoneCategory});
    }

    public void register(IModRegistry registry) {
        jeiHelpers = registry.getJeiHelpers();
        registry.handleRecipes(SimulationChamberRecipe.class, SimulationChamberRecipeWrapper::new, simChamberCategory.getUid());
        registry.handleRecipes(ExtractionChamberRecipe.class, ExtractionChamberRecipeWrapper::new, exChamberCategory.getUid());
        registry.handleRecipes(TrialKeystoneRecipe.class, TrialKeystoneRecipeWrapper::new, trialKeystoneCategory.getUid());
        this.addSimulationChamberRecipes(registry);
        this.addExtractionChamberRecipes(registry);
        this.addTrialKeystoneRecipes(registry);
        this.addItemDescriptions(registry);
    }

    private void addSimulationChamberRecipes(IModRegistry registry) {
        Registry.dataModels.forEach(itemDataModel -> {
            ItemStack dataModel = DataModel.getModelFromMobKey(itemDataModel.getMobKey());
            ItemStack livingMatter = DataModel.getMobMetaData(dataModel).getLivingMatterStack(1);
            ItemStack pristineMatterStack = DataModel.getMobMetaData(dataModel).getPristineMatterStack(1);
            DataModel.setTier(dataModel, 1);
            SimulationChamberRecipe.addRecipe(dataModel, livingMatter, pristineMatterStack);
        });
        registry.addRecipes(new ArrayList<SimulationChamberRecipe>(SimulationChamberRecipe.recipes), simChamberCategory.getUid());
        simChamberCategory.addCatalysts(registry);
    }

    private void addExtractionChamberRecipes(IModRegistry registry) {
        HashMap<ItemStack, NonNullList> pristineTables = new HashMap<ItemStack, NonNullList>();
        Registry.pristineMatter.forEach(pristineItem -> pristineTables.put(new ItemStack((Item)pristineItem, 1), Config.LootParser.getPristineLootEntries(pristineItem.getMobKey())));
        pristineTables.forEach((input, outputs) -> outputs.forEach(output -> ExtractionChamberRecipe.addRecipe(input, output)));
        registry.addRecipes(new ArrayList<ExtractionChamberRecipe>(ExtractionChamberRecipe.recipes), exChamberCategory.getUid());
        registry.addRecipeClickArea(ExtractionChamberGui.class, 84, 23, 6, 35, new String[]{exChamberCategory.getUid()});
        exChamberCategory.addCatalysts(registry);
    }

    private void addTrialKeystoneRecipes(IModRegistry registry) {
        TrialFactory.getValidTrials().forEach(mobkey -> {
            for (int i = 0; i < 5; ++i) {
                ItemStack dataModel = DataModel.getModelFromMobKey(mobkey);
                ItemStack trialKey = new ItemStack((Item)Registry.trialKey);
                MobMetaData data = DataModel.getMobMetaData(dataModel);
                TrialKey.setAttunedNBT(trialKey, dataModel);
                TrialKey.setTier(trialKey, i);
                TrialKeystoneRecipe.addRecipe(trialKey, TrialFactory.getRewards(trialKey), data.getName(), Tier.getTierName(i, false));
            }
        });
        registry.addRecipes(new ArrayList<TrialKeystoneRecipe>(TrialKeystoneRecipe.recipes), trialKeystoneCategory.getUid());
        trialKeystoneCategory.addCatalysts(registry);
    }

    private void addItemDescriptions(IModRegistry registry) {
        registry.addIngredientInfo((Object)new ItemStack((Item)Registry.glitchInfusedIngot), ItemStack.class, Plugin.getInfusedIngotLines());
    }

    public static String[] getInfusedIngotLines() {
        NonNullList lines = NonNullList.func_191196_a();
        lines.add((Object)"TLDR: Drop some fragments, lapis and gold ingots into a body of water and hope for the best");
        lines.add((Object)"");
        lines.add((Object)"You've found that lapis is a good stabilization agent for Unstable glitch fragments.");
        lines.add((Object)"After the fragments are stable, they desperately seek out a material to latch on to, you think that gold might be strong enough as a host.");
        lines.add((Object)"");
        lines.add((Object)"The entire process is delicate, it needs to be performed in water or the materials wont bind properly.");
        return (String[])lines.toArray((Object[])new String[lines.size()]);
    }
}

