/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.common.entity;

import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import xt9.deepmoblearning.DeepMobLearning;
import xt9.deepmoblearning.common.entity.EntityGlitchOrb;

public class EntityGlitch
extends EntityMob {
    private boolean empowered = false;

    public EntityGlitch(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.95f);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("deepmoblearning", "glitch");
    }

    public void setEmpowered(boolean empowered) {
        this.empowered = empowered;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(26.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.29);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIRangedAttack(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            ThreadLocalRandom rand = ThreadLocalRandom.current();
            for (int i = 0; i < 16; ++i) {
                DeepMobLearning.proxy.spawnGlitchParticle(this.field_70170_p, this.field_70165_t + rand.nextDouble(-2.0, 2.0) * (double)this.field_70130_N, this.field_70163_u + rand.current().nextDouble(-0.5, 0.5) * (double)this.field_70131_O, this.field_70161_v + rand.current().nextDouble(-2.0, 2.0) * (double)this.field_70130_N, rand.nextDouble(-0.08, 0.08) - 0.01, rand.nextDouble(-0.08, 0.08) - rand.nextDouble(), rand.nextDouble(-0.08, 0.08) - 0.01);
            }
        }
        super.func_70636_d();
    }

    public boolean func_70652_k(Entity entityIn) {
        return super.func_70652_k(entityIn);
    }

    protected boolean func_70814_o() {
        return true;
    }

    public int func_70641_bl() {
        return 30;
    }

    static class AIRangedAttack
    extends EntityAIBase {
        private final EntityGlitch glitch;
        public int attackTimer;

        public AIRangedAttack(EntityGlitch glitch) {
            this.glitch = glitch;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            if (this.glitch.func_70638_az() instanceof EntityPlayer && (((EntityPlayer)this.glitch.func_70638_az()).func_184812_l_() || ((EntityPlayer)this.glitch.func_70638_az()).func_175149_v())) {
                return false;
            }
            return this.glitch.func_70638_az() != null;
        }

        public void func_75249_e() {
            this.func_75251_c();
        }

        public void func_75251_c() {
            this.attackTimer = this.glitch.empowered ? 70 : 60;
        }

        public void func_75246_d() {
            EntityLivingBase target = this.glitch.func_70638_az();
            if (target == null) {
                this.func_75251_c();
                return;
            }
            this.glitch.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            double distanceToTarget = target.func_70068_e((Entity)this.glitch);
            if (distanceToTarget < 304.0 && this.glitch.func_70685_l((Entity)target)) {
                this.glitch.func_70661_as().func_75499_g();
                World world = this.glitch.field_70170_p;
                --this.attackTimer;
                ThreadLocalRandom rand = ThreadLocalRandom.current();
                if (this.attackTimer == 48) {
                    this.spawnGlitchOrb(world, (Entity)target, rand.nextDouble(-1.2, 1.2), 0.1, rand.nextDouble(-1.2, 1.2));
                } else if (this.attackTimer == 36) {
                    this.spawnGlitchOrb(world, (Entity)target, 0.0, 0.8, 0.0);
                } else if (this.attackTimer == 24 && this.glitch.empowered) {
                    this.spawnGlitchOrb(world, (Entity)target, rand.nextDouble(-1.2, 1.2), 0.3, rand.nextDouble(-1.2, 1.2));
                } else if (this.attackTimer == 0) {
                    this.func_75251_c();
                }
            } else {
                this.glitch.func_70661_as().func_75497_a((Entity)target, 1.0);
            }
            super.func_75246_d();
        }

        private void spawnGlitchOrb(World world, Entity target, double xPad, double yPad, double zPad) {
            Vec3d vec3d = this.glitch.func_70676_i(1.0f);
            double d2 = target.field_70165_t - (this.glitch.field_70165_t + vec3d.field_72450_a * 0.5);
            double d3 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) - (0.5 + this.glitch.field_70163_u + (double)(this.glitch.field_70131_O / 2.0f));
            double d4 = target.field_70161_v - (this.glitch.field_70161_v + vec3d.field_72449_c * 0.5);
            EntityGlitchOrb rangedObject = new EntityGlitchOrb(world, (EntityLivingBase)this.glitch, d2, d3, d4, this.glitch.empowered);
            rangedObject.field_70165_t = this.glitch.field_70165_t + vec3d.field_72450_a * 0.5 + xPad;
            rangedObject.field_70163_u = this.glitch.field_70163_u + (double)(this.glitch.field_70131_O / 2.0f) + yPad + 0.5;
            rangedObject.field_70161_v = this.glitch.field_70161_v + vec3d.field_72449_c * 0.5 + zPad;
            world.func_72838_d((Entity)rangedObject);
            world.func_184148_a(null, target.field_70165_t, target.field_70163_u, target.field_70161_v, SoundEvents.field_187789_eW, SoundCategory.HOSTILE, 1.0f, 1.0f);
            this.glitch.func_184185_a(SoundEvents.field_187789_eW, 1.0f, 1.0f);
        }
    }
}

