/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook.elements;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import gigaherz.guidebook.guidebook.IBookGraphics;
import gigaherz.guidebook.guidebook.IConditionSource;
import gigaherz.guidebook.guidebook.conditions.ConditionContext;
import gigaherz.guidebook.guidebook.drawing.Point;
import gigaherz.guidebook.guidebook.drawing.Rect;
import gigaherz.guidebook.guidebook.drawing.Size;
import gigaherz.guidebook.guidebook.drawing.VisualElement;
import gigaherz.guidebook.guidebook.elements.Element;
import gigaherz.guidebook.guidebook.elements.ElementSpan;
import java.util.List;
import javax.annotation.Nullable;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementParagraph
extends Element {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public int alignment = 0;
    public int indent = 0;
    public int indentFirstLine = 0;
    public int space = 2;
    public final List<Element> inlines = Lists.newArrayList();

    @Override
    public boolean reevaluateConditions(ConditionContext ctx) {
        boolean oldValue = this.conditionResult;
        this.conditionResult = this.condition == null || this.condition.test(ctx);
        boolean anyChanged = this.conditionResult != oldValue;
        for (Element element : this.inlines) {
            anyChanged |= element.reevaluateConditions(ctx);
        }
        return anyChanged;
    }

    @Override
    public int reflow(List<VisualElement> paragraph, IBookGraphics nav, Rect bounds, Rect page) {
        Point adjustedPosition = this.applyPosition(bounds.position, bounds.position);
        int currentLineTop = adjustedPosition.y;
        int currentLineLeft = this.indentFirstLine;
        int currentLineHeight = 0;
        int firstInLine = paragraph.size();
        for (Element element : this.inlines) {
            int firstLineWidth;
            List<VisualElement> pieces = element.measure(nav, bounds.size.width - this.indent, firstLineWidth = bounds.size.width - currentLineLeft - this.indent - this.indentFirstLine);
            if (pieces.size() < 1) continue;
            for (int i = 0; i < pieces.size(); ++i) {
                VisualElement current = pieces.get(i);
                Size size = current.size;
                boolean isLineBreak = "\n".equals(current.getText());
                if (isLineBreak || currentLineLeft + size.width > bounds.size.width && currentLineLeft > 0) {
                    this.processAlignment(paragraph, bounds.size.width - this.indent, currentLineLeft, firstInLine);
                    currentLineTop += currentLineHeight;
                    currentLineLeft = 0;
                    currentLineHeight = 0;
                    firstInLine = paragraph.size();
                }
                if (isLineBreak) continue;
                if (size.height > currentLineHeight) {
                    currentLineHeight = size.height;
                }
                current.position = element.applyPosition(new Point(adjustedPosition.x + currentLineLeft + this.indent, currentLineTop), bounds.position);
                if (size.width > 0) {
                    currentLineLeft += size.width;
                }
                if (currentLineLeft > bounds.size.width) {
                    currentLineTop += currentLineHeight;
                    currentLineLeft = 0;
                    currentLineHeight = 0;
                    firstInLine = paragraph.size();
                }
                paragraph.add(current);
            }
        }
        this.processAlignment(paragraph, bounds.size.width, currentLineLeft, firstInLine);
        if (this.position != 0) {
            return bounds.position.y;
        }
        return currentLineTop + currentLineHeight + this.space;
    }

    private void processAlignment(List<VisualElement> paragraph, int width, int currentLineLeft, int firstInLine) {
        if (paragraph.size() <= firstInLine) {
            return;
        }
        int realWidth = currentLineLeft;
        int leftOffset = 0;
        switch (this.alignment) {
            case 1: {
                leftOffset = (width - realWidth) / 2;
                break;
            }
            case 2: {
                leftOffset = width - realWidth;
            }
        }
        int yMin = Integer.MAX_VALUE;
        int yMax = Integer.MIN_VALUE;
        int yBaseline = Integer.MIN_VALUE;
        for (int i = firstInLine; i < paragraph.size(); ++i) {
            VisualElement e = paragraph.get(i);
            if (e.positionMode != 0) continue;
            e.position = new Point(e.position.x + leftOffset, e.position.y);
            yMin = Math.min(yMin, e.position.y);
            yMax = Math.min(yMax, e.position.y + e.size.height);
            yBaseline = Math.min(yBaseline, e.position.y + (int)((float)e.size.height * e.baseline));
        }
        int yHeight = yMax - yMin;
        int yMin2 = Integer.MAX_VALUE;
        for (int i = firstInLine; i < paragraph.size(); ++i) {
            VisualElement e = paragraph.get(i);
            if (e.positionMode != 0) continue;
            if (e.verticalAlign == 1) {
                e.position = new Point(e.position.x, yMin + (yHeight - e.size.height) / 2);
            } else if (e.verticalAlign == 2) {
                e.position = new Point(e.position.x, yBaseline - (int)((float)e.size.height * e.baseline));
            } else if (e.verticalAlign == 3) {
                e.position = new Point(e.position.x, yMax - e.size.height);
            }
            yMin2 = Math.min(yMin2, e.position.y);
        }
        if (yMin2 != yMin && yMin2 != Integer.MAX_VALUE) {
            int yOffset = yMin - yMin2;
            for (int i = firstInLine; i < paragraph.size(); ++i) {
                VisualElement e = paragraph.get(i);
                if (e.positionMode != 0) continue;
                e.position = new Point(e.position.x, e.position.y + yOffset);
            }
        }
    }

    @Override
    public void parse(IConditionSource book, NamedNodeMap attributes) {
        super.parse(book, attributes);
        Node attr = attributes.getNamedItem("align");
        if (attr != null) {
            String a;
            switch (a = attr.getTextContent()) {
                case "left": {
                    this.alignment = 0;
                    break;
                }
                case "center": {
                    this.alignment = 1;
                    break;
                }
                case "right": {
                    this.alignment = 2;
                }
            }
        }
        if ((attr = attributes.getNamedItem("indent")) != null) {
            this.indent = Ints.tryParse((String)attr.getTextContent());
        }
        if ((attr = attributes.getNamedItem("space")) != null) {
            this.space = Ints.tryParse((String)attr.getTextContent());
        }
    }

    @Override
    public Element copy() {
        ElementParagraph paragraph = super.copy(new ElementParagraph());
        paragraph.alignment = this.alignment;
        paragraph.indent = this.indent;
        paragraph.space = this.space;
        for (Element element : this.inlines) {
            paragraph.inlines.add(element.copy());
        }
        return paragraph;
    }

    @Override
    @Nullable
    public Element applyTemplate(IConditionSource book, List<Element> sourceElements) {
        if (this.inlines.size() == 0) {
            return null;
        }
        ElementParagraph paragraph = super.copy(new ElementParagraph());
        paragraph.alignment = this.alignment;
        paragraph.indent = this.indent;
        paragraph.space = this.space;
        for (Element element : this.inlines) {
            Element t = element.applyTemplate(book, sourceElements);
            if (t == null) continue;
            paragraph.inlines.add(t);
        }
        if (paragraph.inlines.size() == 0) {
            return null;
        }
        return paragraph;
    }

    @Override
    public boolean supportsPageLevel() {
        return true;
    }

    @Override
    public boolean supportsSpanLevel() {
        return false;
    }

    public static ElementParagraph of(String text) {
        ElementParagraph p = new ElementParagraph();
        ElementSpan s = new ElementSpan(text, true, true);
        p.inlines.add(s);
        return p;
    }
}

