/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook.elements;

import com.google.common.primitives.Ints;
import gigaherz.guidebook.guidebook.IBookGraphics;
import gigaherz.guidebook.guidebook.IConditionSource;
import gigaherz.guidebook.guidebook.drawing.Rect;
import gigaherz.guidebook.guidebook.drawing.Size;
import gigaherz.guidebook.guidebook.drawing.VisualElement;
import gigaherz.guidebook.guidebook.drawing.VisualImage;
import gigaherz.guidebook.guidebook.elements.Element;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementImage
extends Element {
    public ResourceLocation textureLocation;
    public int tx = 0;
    public int ty = 0;
    public int tw = 0;
    public int th = 0;

    private Size getVisualSize() {
        int width = (int)((float)(this.w > 0 ? this.w : this.tw) * this.scale);
        int height = (int)((float)(this.h > 0 ? this.h : this.th) * this.scale);
        return new Size(width, height);
    }

    private VisualImage getVisual() {
        return new VisualImage(this.getVisualSize(), this.position, this.baseline, this.verticalAlignment, this.textureLocation, this.tx, this.ty, this.tw, this.th, this.w > 0 ? this.w : this.tw, this.h > 0 ? this.h : this.th, this.scale);
    }

    @Override
    public List<VisualElement> measure(IBookGraphics nav, int width, int firstLineWidth) {
        return Collections.singletonList(this.getVisual());
    }

    @Override
    public int reflow(List<VisualElement> paragraph, IBookGraphics nav, Rect bounds, Rect page) {
        VisualImage element = this.getVisual();
        element.position = this.applyPosition(bounds.position, bounds.position);
        paragraph.add(element);
        if (this.position != 0) {
            return bounds.position.y;
        }
        return bounds.position.y + element.size.height;
    }

    @Override
    public void findTextures(Set<ResourceLocation> textures) {
    }

    @Override
    public void parse(IConditionSource book, NamedNodeMap attributes) {
        super.parse(book, attributes);
        Node attr = attributes.getNamedItem("tx");
        if (attr != null) {
            this.tx = Ints.tryParse((String)attr.getTextContent());
        }
        if ((attr = attributes.getNamedItem("ty")) != null) {
            this.ty = Ints.tryParse((String)attr.getTextContent());
        }
        if ((attr = attributes.getNamedItem("tw")) != null) {
            this.tw = Ints.tryParse((String)attr.getTextContent());
        }
        if ((attr = attributes.getNamedItem("th")) != null) {
            this.th = Ints.tryParse((String)attr.getTextContent());
        }
        if ((attr = attributes.getNamedItem("src")) != null) {
            this.textureLocation = new ResourceLocation(attr.getTextContent());
        }
    }

    @Override
    public Element copy() {
        ElementImage img = super.copy(new ElementImage());
        img.textureLocation = new ResourceLocation(this.textureLocation.toString());
        img.tx = this.tx;
        img.ty = this.ty;
        img.tw = this.tw;
        img.th = this.th;
        return img;
    }

    @Override
    public boolean supportsPageLevel() {
        return true;
    }
}

