/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook.client;

import com.google.common.collect.Lists;
import gigaherz.guidebook.GuidebookMod;
import gigaherz.guidebook.guidebook.BookDocument;
import gigaherz.guidebook.guidebook.IBookGraphics;
import gigaherz.guidebook.guidebook.SectionRef;
import gigaherz.guidebook.guidebook.client.GuiGuidebook;
import gigaherz.guidebook.guidebook.drawing.Point;
import gigaherz.guidebook.guidebook.drawing.Size;
import gigaherz.guidebook.guidebook.drawing.VisualChapter;
import gigaherz.guidebook.guidebook.drawing.VisualElement;
import gigaherz.guidebook.guidebook.drawing.VisualPage;
import gigaherz.guidebook.guidebook.drawing.VisualText;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Mouse;

public class BookRendering
implements IBookGraphics {
    public static final int DEFAULT_BOOK_WIDTH = 276;
    public static final int DEFAULT_BOOK_HEIGHT = 198;
    public static final int DEFAULT_INNER_MARGIN = 22;
    public static final int DEFAULT_OUTER_MARGIN = 10;
    public static final int DEFAULT_BOTTOM_MARGIN = 8;
    public static final int DEFAULT_VERTICAL_MARGIN = 18;
    private BookDocument book;
    private double scaledWidthD;
    private double scaledHeightD;
    private int scaledWidth;
    private int scaledHeight;
    private final Minecraft mc = Minecraft.func_71410_x();
    private final GuiGuidebook gui;
    private int bookWidth;
    private int bookHeight;
    private int innerMargin;
    private int outerMargin;
    private int verticalMargin;
    private int bottomMargin;
    private int pageWidth = this.bookWidth / 2 - this.innerMargin - this.outerMargin;
    private int pageHeight = this.bookHeight - this.verticalMargin;
    private final List<VisualChapter> chapters = Lists.newArrayList();
    private int lastProcessedChapter = 0;
    private final Stack<PageRef> history = new Stack();
    private int currentChapter = 0;
    private int currentPair = 0;
    private boolean hasScale;
    private float scalingFactor;
    private VisualElement previousHovering = null;

    BookRendering(BookDocument book, GuiGuidebook gui) {
        this.book = book;
        this.gui = gui;
    }

    @Override
    public Object owner() {
        return this.gui;
    }

    @Override
    public BookDocument getBook() {
        return this.book;
    }

    public void computeScaledResolution2(float scaleFactorCoef) {
        int i;
        int width = this.mc.field_71443_c;
        int height = this.mc.field_71440_d;
        int scaleFactor = 1;
        double w = 303.6 / (double)scaleFactorCoef;
        double h = 217.8 / (double)scaleFactorCoef;
        boolean flag = this.mc.func_152349_b();
        int n = i = GuidebookMod.bookGUIScale < 0 ? this.mc.field_71474_y.field_74335_Z : GuidebookMod.bookGUIScale;
        if (i == 0) {
            i = 1000;
        }
        while (scaleFactor < i && (double)(width / (scaleFactor + 1)) >= w && (double)(height / (scaleFactor + 1)) >= h) {
            ++scaleFactor;
        }
        if (flag && scaleFactor % 2 != 0 && scaleFactor > 1) {
            --scaleFactor;
        }
        this.scaledWidthD = (double)width / (double)scaleFactor;
        this.scaledHeightD = (double)height / (double)scaleFactor;
        this.scaledWidth = MathHelper.func_76143_f((double)this.scaledWidthD);
        this.scaledHeight = MathHelper.func_76143_f((double)this.scaledHeightD);
    }

    @Override
    public void refreshScalingFactor() {
        float fontSize = this.book.getFontSize();
        if (MathHelper.func_180185_a((float)fontSize, (float)1.0f)) {
            this.hasScale = false;
            this.scalingFactor = 1.0f;
            this.scaledWidth = this.gui.field_146294_l;
            this.scaledHeight = this.gui.field_146295_m;
            this.bookWidth = 276;
            this.bookHeight = 198;
            this.innerMargin = 22;
            this.outerMargin = 10;
            this.verticalMargin = 18;
            this.bottomMargin = 8;
        } else {
            this.computeScaledResolution2(fontSize);
            this.hasScale = true;
            this.scalingFactor = Math.min((float)this.gui.field_146294_l / (float)this.scaledWidth, (float)this.gui.field_146295_m / (float)this.scaledHeight);
            this.bookWidth = (int)(276.0f / fontSize);
            this.bookHeight = (int)(198.0f / fontSize);
            this.innerMargin = (int)(22.0f / fontSize);
            this.outerMargin = (int)(10.0f / fontSize);
            this.verticalMargin = (int)(18.0f / fontSize);
            this.bottomMargin = (int)(8.0f / fontSize);
        }
        this.pageWidth = this.bookWidth / 2 - this.innerMargin - this.outerMargin;
        this.pageHeight = this.bookHeight - this.verticalMargin - this.bottomMargin;
    }

    @Override
    public float getScalingFactor() {
        return this.scalingFactor;
    }

    private void pushHistory() {
        this.history.push(new PageRef(this.currentChapter, this.currentPair * 2));
    }

    @Override
    public boolean canGoNextPage() {
        return this.getNextPair() >= 0 || this.canGoNextChapter();
    }

    @Override
    public void nextPage() {
        int pg = this.getNextPair();
        if (pg >= 0) {
            this.pushHistory();
            this.currentPair = pg;
        } else {
            this.nextChapter();
        }
    }

    @Override
    public boolean canGoPrevPage() {
        return this.getPrevPair() >= 0 || this.canGoPrevChapter();
    }

    @Override
    public void prevPage() {
        int pg = this.getPrevPair();
        if (pg >= 0) {
            this.pushHistory();
            this.currentPair = pg;
        } else {
            this.prevChapter(true);
        }
    }

    @Override
    public boolean canGoNextChapter() {
        return this.getNextChapter() >= 0;
    }

    @Override
    public void nextChapter() {
        int ch = this.getNextChapter();
        if (ch >= 0) {
            this.pushHistory();
            this.currentPair = 0;
            this.currentChapter = ch;
        }
    }

    @Override
    public boolean canGoPrevChapter() {
        return this.getPrevChapter() >= 0;
    }

    @Override
    public void prevChapter() {
        this.prevChapter(false);
    }

    private void prevChapter(boolean lastPage) {
        int ch = this.getPrevChapter();
        if (ch >= 0) {
            this.pushHistory();
            this.currentPair = 0;
            this.currentChapter = ch;
            if (lastPage) {
                this.currentPair = this.getVisualChapter((int)ch).totalPairs - 1;
            }
        }
    }

    @Override
    public boolean canGoBack() {
        return this.history.size() > 0;
    }

    @Override
    public void navigateBack() {
        if (this.history.size() > 0) {
            PageRef target = this.history.pop();
            this.currentChapter = target.chapter;
            this.currentPair = target.page / 2;
        } else {
            this.currentChapter = 0;
            this.currentPair = 0;
        }
    }

    @Override
    public void navigateHome() {
        if (this.book.home != null) {
            this.navigateTo(this.book.home);
        }
    }

    private int getNextChapter() {
        for (int i = this.currentChapter + 1; i < this.book.chapterCount(); ++i) {
            if (!this.needChapter(i)) continue;
            return i;
        }
        return -1;
    }

    private int getPrevChapter() {
        for (int i = this.currentChapter - 1; i >= 0; --i) {
            if (!this.needChapter(i)) continue;
            return i;
        }
        return -1;
    }

    private int getNextPair() {
        VisualChapter ch = this.getVisualChapter(this.currentChapter);
        if (this.currentPair + 1 >= ch.totalPairs) {
            return -1;
        }
        return this.currentPair + 1;
    }

    private int getPrevPair() {
        if (this.currentPair - 1 < 0) {
            return -1;
        }
        return this.currentPair - 1;
    }

    private boolean needChapter(int chapterNumber) {
        if (chapterNumber < 0 || chapterNumber >= this.book.chapterCount()) {
            return false;
        }
        BookDocument.ChapterData ch = this.book.getChapter(chapterNumber);
        return ch.conditionResult && !ch.isEmpty();
    }

    private boolean needSection(int chapterNumber, int sectionNumber) {
        BookDocument.ChapterData ch = this.book.getChapter(chapterNumber);
        if (sectionNumber < 0 || sectionNumber >= ch.sections.size()) {
            return false;
        }
        BookDocument.PageData section = ch.sections.get(sectionNumber);
        return section.conditionResult && !section.isEmpty();
    }

    private int findSectionStart(SectionRef ref) {
        VisualChapter vc = this.getVisualChapter(this.currentChapter);
        for (int i = 0; i < vc.pages.size(); ++i) {
            VisualPage page = vc.pages.get(i);
            if (page.ref.section == ref.section) {
                return i / 2;
            }
            if (page.ref.section <= ref.section) continue;
            return 0;
        }
        return 0;
    }

    @Override
    public void navigateTo(SectionRef target) {
        if (!target.resolve(this.book)) {
            return;
        }
        this.pushHistory();
        if (!this.needChapter(target.chapter)) {
            return;
        }
        if (!this.needSection(target.chapter, target.section)) {
            return;
        }
        this.currentChapter = target.chapter;
        this.currentPair = this.findSectionStart(target);
    }

    private VisualChapter getVisualChapter(int chapter) {
        while (this.chapters.size() <= chapter && this.lastProcessedChapter < this.book.chapterCount()) {
            BookDocument.ChapterData bc = this.book.getChapter(this.lastProcessedChapter++);
            if (!bc.conditionResult) continue;
            VisualChapter ch = new VisualChapter();
            if (this.chapters.size() > 0) {
                VisualChapter prev = this.chapters.get(this.chapters.size() - 1);
                ch.startPair = prev.startPair + prev.totalPairs;
            }
            Size pageSize = new Size(this.pageWidth, this.pageHeight);
            bc.reflow(this, ch, pageSize);
            ch.totalPairs = (ch.pages.size() + 1) / 2;
            this.chapters.add(ch);
        }
        if (chapter >= this.chapters.size()) {
            VisualChapter vc = new VisualChapter();
            vc.pages.add(new VisualPage(new SectionRef(chapter, 0)));
            return vc;
        }
        return this.chapters.get(chapter);
    }

    @Override
    public int addString(int left, int top, String s, int color, float scale) {
        FontRenderer fontRenderer = this.gui.getFontRenderer();
        if (!MathHelper.func_180185_a((float)scale, (float)1.0f)) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)left, (float)top, (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            fontRenderer.func_78276_b(s, 0, 0, color);
            GlStateManager.func_179121_F();
        } else {
            fontRenderer.func_78276_b(s, left, top, color);
        }
        return fontRenderer.field_78288_b;
    }

    @Override
    public boolean mouseClicked(int mouseButton) {
        Minecraft mc = Minecraft.func_71410_x();
        int dw = this.scaledWidth;
        int dh = this.scaledHeight;
        int mouseX = Mouse.getX() * dw / mc.field_71443_c;
        int mouseY = dh - Mouse.getY() * dh / mc.field_71440_d;
        if (mouseButton == 0) {
            VisualPage pgRight;
            VisualChapter ch = this.getVisualChapter(this.currentChapter);
            VisualPage pgLeft = ch.pages.get(this.currentPair * 2);
            if (this.mouseClickPage(mouseX, mouseY, pgLeft, true)) {
                return true;
            }
            if (this.currentPair * 2 + 1 < ch.pages.size() && this.mouseClickPage(mouseX, mouseY, pgRight = ch.pages.get(this.currentPair * 2 + 1), false)) {
                return true;
            }
        }
        return false;
    }

    private boolean mouseClickPage(int mX, int mY, VisualPage pg, boolean isLeftPage) {
        Point offset = this.getPageOffset(isLeftPage);
        mX -= offset.x;
        mY -= offset.y;
        for (VisualElement e : pg.children) {
            if (mX < e.position.x || mX > e.position.x + e.size.width || mY < e.position.y || mY > e.position.y + e.size.height) continue;
            e.click(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseHover(int mouseX, int mouseY) {
        VisualChapter ch = this.getVisualChapter(this.currentChapter);
        VisualPage pgLeft = ch.pages.get(this.currentPair * 2);
        VisualElement hovering = this.mouseHoverPage(pgLeft, true);
        if (hovering == null && this.currentPair * 2 + 1 < ch.pages.size()) {
            VisualPage pgRight = ch.pages.get(this.currentPair * 2 + 1);
            hovering = this.mouseHoverPage(pgRight, false);
        }
        if (hovering != this.previousHovering && this.previousHovering != null) {
            this.previousHovering.mouseOut(this, mouseX, mouseY);
        }
        this.previousHovering = hovering;
        if (hovering != null) {
            hovering.mouseOver(this, mouseX, mouseY);
            return true;
        }
        return false;
    }

    @Nullable
    private VisualElement mouseHoverPage(VisualPage pg, boolean isLeftPage) {
        Minecraft mc = Minecraft.func_71410_x();
        int dw = this.scaledWidth;
        int dh = this.scaledHeight;
        int mX = Mouse.getX() * dw / mc.field_71443_c;
        int mY = dh - Mouse.getY() * dh / mc.field_71440_d;
        Point offset = this.getPageOffset(isLeftPage);
        mX -= offset.x;
        mY -= offset.y;
        for (VisualElement e : pg.children) {
            if (mX < e.position.x || mX > e.position.x + e.size.width || mY < e.position.y || mY > e.position.y + e.size.height || !e.wantsHover()) continue;
            return e;
        }
        return null;
    }

    @Override
    public void drawCurrentPages() {
        if (this.hasScale) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)this.scalingFactor, (float)this.scalingFactor, (float)this.scalingFactor);
        }
        this.drawPage(this.currentPair * 2);
        this.drawPage(this.currentPair * 2 + 1);
        if (this.hasScale) {
            GlStateManager.func_179121_F();
        }
    }

    private Point getPageOffset(boolean leftPage) {
        int left = this.scaledWidth / 2 - this.pageWidth - this.innerMargin;
        int right = this.scaledWidth / 2 + this.innerMargin;
        int top = (this.scaledHeight - this.pageHeight) / 2 - this.bottomMargin;
        return new Point(leftPage ? left : right, top);
    }

    private void drawPage(int page) {
        VisualChapter ch = this.getVisualChapter(this.currentChapter);
        if (page >= ch.pages.size()) {
            return;
        }
        VisualPage pg = ch.pages.get(page);
        Point offset = this.getPageOffset((page & 1) == 0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)offset.x, (float)offset.y, (float)0.0f);
        for (VisualElement e : pg.children) {
            e.draw(this);
        }
        String cnt = String.valueOf(ch.startPair * 2 + page + 1);
        Size sz = this.measure(cnt);
        this.addString((this.pageWidth - sz.width) / 2, this.pageHeight + 2, cnt, -16777216, 1.0f);
        GlStateManager.func_179121_F();
    }

    @Override
    public void drawItemStack(int left, int top, int z, ItemStack stack, int color, float scale) {
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)left, (float)top, (float)z);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        RenderHelper.func_74520_c();
        this.gui.field_146297_k.func_175599_af().func_180450_b(stack, 0, 0);
        RenderHelper.func_74518_a();
        this.gui.field_146297_k.func_175599_af().func_180453_a(this.gui.getFontRenderer(), stack, 0, 0, null);
        GlStateManager.func_179121_F();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
    }

    @Override
    public void drawImage(ResourceLocation loc, int x, int y, int tx, int ty, int w, int h, int tw, int th, float scale) {
        int sh;
        int sw = tw != 0 ? tw : 256;
        int n = sh = th != 0 ? th : 256;
        if (w == 0) {
            w = sw;
        }
        if (h == 0) {
            h = sh;
        }
        ResourceLocation locExpanded = new ResourceLocation(loc.func_110624_b(), "textures/" + loc.func_110623_a() + ".png");
        this.gui.getRenderEngine().func_110577_a(locExpanded);
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BookRendering.drawFlexible(x, y, tx, ty, w, h, sw, sh, scale);
    }

    private static void drawFlexible(int x, int y, float tx, float ty, int w, int h, int tw, int th, float scale) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float hs = (float)h * scale;
        float ws = (float)w * scale;
        float tsw = 1.0f / (float)tw;
        float tsh = 1.0f / (float)th;
        bufferbuilder.func_181662_b((double)x, (double)((float)y + hs), 0.0).func_187315_a((double)(tx * tsw), (double)((ty + (float)h) * tsh)).func_181675_d();
        bufferbuilder.func_181662_b((double)((float)x + ws), (double)((float)y + hs), 0.0).func_187315_a((double)((tx + (float)w) * tsw), (double)((ty + (float)h) * tsh)).func_181675_d();
        bufferbuilder.func_181662_b((double)((float)x + ws), (double)y, 0.0).func_187315_a((double)((tx + (float)w) * tsw), (double)(ty * tsh)).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)(tx * tsw), (double)(ty * tsh)).func_181675_d();
        tessellator.func_78381_a();
    }

    @Override
    public void drawTooltip(ItemStack stack, int x, int y) {
        this.gui.drawTooltip(stack, x, y);
    }

    @Override
    public Size measure(String text) {
        FontRenderer font = this.gui.getFontRenderer();
        int width = font.func_78256_a(text);
        return new Size(width, font.field_78288_b);
    }

    @Override
    public List<VisualElement> measure(String text, int width, int firstLineWidth, float scale, int position, float baseline, int verticalAlignment) {
        FontRenderer font = this.gui.getFontRenderer();
        ArrayList sizes = Lists.newArrayList();
        TextMetrics.wrapFormattedStringToWidth(font, s -> {
            int width2 = font.func_78256_a(s);
            sizes.add(new VisualText((String)s, new Size((int)((float)width2 * scale), (int)((float)font.field_78288_b * scale)), position, baseline, verticalAlignment, scale));
        }, text, width, firstLineWidth, true);
        return sizes;
    }

    @Override
    public int getActualBookHeight() {
        return this.bookHeight;
    }

    @Override
    public int getActualBookWidth() {
        return this.bookWidth;
    }

    private class PageRef {
        public int chapter;
        public int page;

        public PageRef(int currentChapter, int currentPage) {
            this.chapter = currentChapter;
            this.page = currentPage;
        }
    }

    private static class TextMetrics {
        private TextMetrics() {
        }

        private static boolean isFormatColor(char colorChar) {
            return colorChar >= '0' && colorChar <= '9' || colorChar >= 'a' && colorChar <= 'f' || colorChar >= 'A' && colorChar <= 'F';
        }

        private static int sizeStringToWidth(FontRenderer font, String str, int wrapWidth) {
            int k;
            int i = str.length();
            int j = 0;
            int l = -1;
            boolean flag = false;
            for (k = 0; k < i; ++k) {
                char c0 = str.charAt(k);
                switch (c0) {
                    case '\n': {
                        --k;
                        break;
                    }
                    case ' ': {
                        l = k;
                    }
                    default: {
                        j += font.func_78263_a(c0);
                        if (!flag) break;
                        ++j;
                        break;
                    }
                    case '\u00a7': {
                        char c1;
                        if (k >= i - 1) break;
                        if ((c1 = str.charAt(++k)) != 'l' && c1 != 'L') {
                            if (c1 != 'r' && c1 != 'R' && !TextMetrics.isFormatColor(c1)) break;
                            flag = false;
                            break;
                        }
                        flag = true;
                    }
                }
                if (c0 == '\n') {
                    l = ++k;
                    break;
                }
                if (j > wrapWidth) break;
            }
            return k != i && l != -1 && l < k ? l : k;
        }

        private static void wrapFormattedStringToWidth(FontRenderer font, Consumer<String> dest, String str, int wrapWidth, int wrapWidthFirstLine, boolean firstLine) {
            int i = TextMetrics.sizeStringToWidth(font, str, firstLine ? wrapWidthFirstLine : wrapWidth);
            if (str.length() <= i) {
                dest.accept(str);
            } else {
                String s = str.substring(0, i);
                dest.accept(s);
                dest.accept("\n");
                char c0 = str.charAt(i);
                boolean flag = c0 == ' ' || c0 == '\n';
                String s1 = FontRenderer.func_78282_e((String)s) + str.substring(i + (flag ? 1 : 0));
                TextMetrics.wrapFormattedStringToWidth(font, dest, s1, wrapWidth, wrapWidthFirstLine, false);
            }
        }
    }
}

