/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook;

import com.google.common.base.Strings;
import gigaherz.common.ItemRegistered;
import gigaherz.guidebook.GuidebookMod;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemGuidebook
extends ItemRegistered {
    public ItemGuidebook(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77655_b("gbook.guidebook");
        this.func_77637_a(GuidebookMod.tabMagic);
        this.func_77627_a(true);
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.showBook(worldIn, playerIn.func_184586_b(hand));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        EnumActionResult result = this.showBook(worldIn, stack);
        return ActionResult.newResult((EnumActionResult)result, (Object)stack);
    }

    private EnumActionResult showBook(World worldIn, ItemStack stack) {
        if (!worldIn.field_72995_K) {
            return EnumActionResult.FAIL;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b("Book", 8)) {
            return EnumActionResult.FAIL;
        }
        GuidebookMod.proxy.displayBook(nbt.func_74779_i("Book"));
        return EnumActionResult.SUCCESS;
    }

    public ItemStack of(ResourceLocation book) {
        ItemStack stack = new ItemStack((Item)this);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Book", book.toString());
        stack.func_77982_d(tag);
        return stack;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (ResourceLocation resourceLocation : GuidebookMod.proxy.getBooksList()) {
                subItems.add((Object)this.of(resourceLocation));
            }
        }
    }

    @Nullable
    public String getBookLocation(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            return tag.func_74779_i("Book");
        }
        return null;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String book;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (flagIn == ITooltipFlag.TooltipFlags.ADVANCED && !Strings.isNullOrEmpty((String)(book = this.getBookLocation(stack)))) {
            tooltip.add(String.format("Book: " + book, new Object[0]));
        }
    }

    public String func_77653_i(ItemStack stack) {
        String book = this.getBookLocation(stack);
        if (!Strings.isNullOrEmpty((String)book)) {
            return GuidebookMod.proxy.getBookName(book);
        }
        return super.func_77653_i(stack);
    }
}

