/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.voidislandcontrol.world;

import com.bartz24.voidislandcontrol.config.ConfigOptions;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiCustomizeWorldScreen;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.biome.BiomeProviderSingle;
import net.minecraft.world.gen.ChunkGeneratorFlat;
import net.minecraft.world.gen.ChunkGeneratorOverworld;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldTypeVoid
extends WorldType {
    private WorldType overridenWorldType;

    public WorldTypeVoid() {
        super("voidworld");
        if (ConfigOptions.worldGenSettings.worldGenType == ConfigOptions.WorldGenSettings.WorldGenType.WORLDTYPE) {
            this.overridenWorldType = WorldType.func_77130_a((String)ConfigOptions.worldGenSettings.worldGenSpecialParameters);
        }
    }

    public boolean func_151357_h() {
        return true;
    }

    public int getMinimumSpawnHeight(World world) {
        return ConfigOptions.islandSettings.islandYLevel;
    }

    public int getSpawnFuzz() {
        return 2;
    }

    public float getCloudHeight() {
        return ConfigOptions.worldGenSettings.cloudLevel;
    }

    public double getHorizon(World world) {
        return ConfigOptions.worldGenSettings.horizonLevel;
    }

    public BiomeProvider getBiomeProvider(World world) {
        if (this.overridenWorldType != null) {
            return this.overridenWorldType.getBiomeProvider(world);
        }
        if (ConfigOptions.worldGenSettings.worldBiomeID > -1) {
            return new BiomeProviderSingle(Biome.func_150568_d((int)ConfigOptions.worldGenSettings.worldBiomeID));
        }
        return new BiomeProvider(world.func_72912_H());
    }

    @SideOnly(value=Side.CLIENT)
    public void onCustomizeButton(Minecraft mc, GuiCreateWorld guiCreateWorld) {
        if (ConfigOptions.worldGenSettings.worldGenType == ConfigOptions.WorldGenSettings.WorldGenType.CUSTOMIZED) {
            mc.func_147108_a((GuiScreen)new GuiCustomizeWorldScreen((GuiScreen)guiCreateWorld, guiCreateWorld.field_146334_a));
        } else if (ConfigOptions.worldGenSettings.worldGenType == ConfigOptions.WorldGenSettings.WorldGenType.WORLDTYPE && this.overridenWorldType != null) {
            this.overridenWorldType.onCustomizeButton(mc, guiCreateWorld);
        }
    }

    public boolean isCustomizable() {
        return ConfigOptions.worldGenSettings.worldGenType == ConfigOptions.WorldGenSettings.WorldGenType.CUSTOMIZED || ConfigOptions.worldGenSettings.worldGenType == ConfigOptions.WorldGenSettings.WorldGenType.CUSTOMIZED && this.overridenWorldType != null && this.overridenWorldType.isCustomizable();
    }

    public IChunkGenerator getChunkGenerator(World world, String generatorOptions) {
        if (this.overridenWorldType != null) {
            return this.overridenWorldType.getChunkGenerator(world, generatorOptions);
        }
        if (ConfigOptions.worldGenSettings.worldGenType != ConfigOptions.WorldGenSettings.WorldGenType.OVERWORLD && ConfigOptions.worldGenSettings.worldGenType != ConfigOptions.WorldGenSettings.WorldGenType.CUSTOMIZED) {
            String genSettings = "3;1*minecraft:air";
            if (ConfigOptions.worldGenSettings.worldGenType == ConfigOptions.WorldGenSettings.WorldGenType.SUPERFLAT) {
                genSettings = ConfigOptions.worldGenSettings.worldGenSpecialParameters;
            }
            ChunkGeneratorFlat provider = new ChunkGeneratorFlat(world, world.func_72905_C(), false, genSettings);
            world.func_181544_b(63);
            return provider;
        }
        return new ChunkGeneratorOverworld(world, world.func_72905_C(), true, generatorOptions);
    }

    public boolean handleSlimeSpawnReduction(Random random, World world) {
        if (this.overridenWorldType != null) {
            return this.overridenWorldType.handleSlimeSpawnReduction(random, world);
        }
        return super.handleSlimeSpawnReduction(random, world);
    }
}

