/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.voidislandcontrol;

import com.bartz24.voidislandcontrol.EventHandler;
import com.bartz24.voidislandcontrol.api.IslandManager;
import com.bartz24.voidislandcontrol.api.IslandPos;
import com.bartz24.voidislandcontrol.api.event.IslandCreateEvent;
import com.bartz24.voidislandcontrol.api.event.IslandHomeEvent;
import com.bartz24.voidislandcontrol.api.event.IslandInviteEvent;
import com.bartz24.voidislandcontrol.api.event.IslandLeaveEvent;
import com.bartz24.voidislandcontrol.api.event.IslandResetEvent;
import com.bartz24.voidislandcontrol.api.event.IslandSpawnEvent;
import com.bartz24.voidislandcontrol.api.event.IslandVisitEvent;
import com.bartz24.voidislandcontrol.config.ConfigOptions;
import com.bartz24.voidislandcontrol.world.WorldTypeVoid;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class PlatformCommand
extends CommandBase
implements ICommand {
    private static List<String> aliases;

    public PlatformCommand() {
        aliases = new ArrayList<String>();
        if (ConfigOptions.commandSettings.commandName.equals("island")) {
            aliases.add("island");
        } else {
            aliases.add(ConfigOptions.commandSettings.commandName);
        }
    }

    public List<String> func_71514_a() {
        return aliases;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public int func_82362_a() {
        return 2;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return PlatformCommand.func_71530_a((String[])args, (String[])new String[]{"create", "invite", "join", "leave", "kick", "home", "spawn", "reset", "visit", "onechunk"});
        }
        String subCommand = args[0];
        if ((subCommand = subCommand.trim()).equals("create")) {
            return args.length == 2 ? PlatformCommand.func_175762_a((String[])args, IslandManager.getIslandGenTypes()) : Collections.emptyList();
        }
        if (subCommand.equals("invite")) {
            return args.length == 2 ? PlatformCommand.func_71530_a((String[])args, (String[])server.func_71213_z()) : Collections.emptyList();
        }
        if (subCommand.equals("reset")) {
            return args.length == 2 ? PlatformCommand.func_175762_a((String[])args, IslandManager.getIslandGenTypes()) : Collections.emptyList();
        }
        if (subCommand.equals("visit")) {
            return args.length == 2 ? PlatformCommand.func_71530_a((String[])args, (String[])server.func_71213_z()) : Collections.emptyList();
        }
        if (subCommand.equals("kick")) {
            return args.length == 2 ? PlatformCommand.func_71530_a((String[])args, (String[])server.func_71213_z()) : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        World world = sender.func_130014_f_();
        EntityPlayerMP player = (EntityPlayerMP)world.func_72924_a(sender.func_174793_f().func_70005_c_());
        if (!(world.func_72912_H().func_76067_t() instanceof WorldTypeVoid)) {
            player.func_145747_a((ITextComponent)new TextComponentString("You are not in a void world type."));
            return;
        }
        if (args.length == 0) {
            this.showHelp(player);
        } else {
            String subCommand = args[0];
            if ((subCommand = subCommand.trim()).equals("create")) {
                if (args.length > 1 && args[1].equals("bypass")) {
                    args = new String[]{args[0]};
                }
                PlatformCommand.newPlatform(player, args);
                MinecraftForge.EVENT_BUS.post((Event)new IslandCreateEvent((EntityPlayer)player, IslandManager.getPlayerIsland(player.func_146103_bH().getId())));
            } else if (subCommand.equals("invite")) {
                PlatformCommand.inviteOther(player, args, world);
                MinecraftForge.EVENT_BUS.post((Event)new IslandInviteEvent((EntityPlayer)player, IslandManager.getPlayerIsland(player.func_146103_bH().getId())));
            } else if (subCommand.equals("join")) {
                PlatformCommand.joinPlatform(player, args, world);
            } else if (subCommand.equals("leave")) {
                IslandPos pos = IslandManager.getPlayerIsland(player.func_146103_bH().getId());
                PlatformCommand.leavePlatform(player, args);
                MinecraftForge.EVENT_BUS.post((Event)new IslandLeaveEvent((EntityPlayer)player, pos));
            } else if (subCommand.equals("home")) {
                PlatformCommand.tpHome(player, args);
                MinecraftForge.EVENT_BUS.post((Event)new IslandHomeEvent((EntityPlayer)player, IslandManager.getPlayerIsland(player.func_146103_bH().getId())));
            } else if (subCommand.equals("spawn")) {
                PlatformCommand.tpSpawn(player, args);
                MinecraftForge.EVENT_BUS.post((Event)new IslandSpawnEvent((EntityPlayer)player));
            } else if (subCommand.equals("reset")) {
                PlatformCommand.reset(player, args, world);
                MinecraftForge.EVENT_BUS.post((Event)new IslandResetEvent((EntityPlayer)player, IslandManager.getPlayerIsland(player.func_146103_bH().getId())));
            } else if (subCommand.equals("visit")) {
                PlatformCommand.visit(player, args);
                MinecraftForge.EVENT_BUS.post((Event)new IslandVisitEvent((EntityPlayer)player, IslandManager.getPlayerIsland(player.func_146103_bH().getId())));
            } else if (subCommand.equals("kick")) {
                PlatformCommand.kick(player, args);
            } else if (subCommand.equals("onechunk")) {
                if (!ConfigOptions.commandSettings.oneChunkCommandAllowed) {
                    player.func_145747_a((ITextComponent)new TextComponentString("This command is not allowed!"));
                    return;
                }
                if (IslandManager.worldOneChunk) {
                    player.func_145747_a((ITextComponent)new TextComponentString("Already in one chunk mode!"));
                    return;
                }
                IslandManager.CurrentIslandsList.clear();
                IslandManager.CurrentIslandsList.add(new IslandPos(0, 0, new UUID[0]));
                WorldBorder border = world.func_73046_m().field_71305_c[0].func_175723_af();
                border.func_177739_c(0.0, 0.0);
                border.func_177750_a(16.0);
                border.func_177747_c(1);
                IslandManager.worldOneChunk = true;
                PlatformCommand.reset(player, args, world);
            }
        }
    }

    public static void visit(EntityPlayerMP player, String[] args) throws CommandException {
        IslandPos isPos;
        if (!ConfigOptions.commandSettings.allowVisitCommand) {
            player.func_145747_a((ITextComponent)new TextComponentString("This command was disabled"));
            return;
        }
        if (args.length != 2) {
            player.func_145747_a((ITextComponent)new TextComponentString("Must have 1 argument."));
            return;
        }
        if (IslandManager.worldOneChunk) {
            player.func_145747_a((ITextComponent)new TextComponentString("Can't use this command in this mode."));
            return;
        }
        if (IslandManager.initialIslandDistance != ConfigOptions.islandSettings.islandDistance) {
            player.func_145747_a((ITextComponent)new TextComponentString("This isn't going to work. The island distance has changed!"));
            return;
        }
        EntityPlayerMP player2 = (EntityPlayerMP)player.func_130014_f_().func_72924_a(args[1]);
        IslandPos islandPos = isPos = player2 == null ? null : IslandManager.getPlayerIsland(player2.func_146103_bH().getId());
        if (args[1].equals(player.func_70005_c_())) {
            player.func_145747_a((ITextComponent)new TextComponentString("Can't visit your own island."));
            return;
        }
        if (isPos == null) {
            player.func_145747_a((ITextComponent)new TextComponentString("Player doesn't exist or player doesn't have an island."));
            return;
        }
        BlockPos visitPos = new BlockPos(isPos.getX() * ConfigOptions.islandSettings.islandDistance, ConfigOptions.islandSettings.islandYLevel, isPos.getY() * ConfigOptions.islandSettings.islandDistance);
        IslandManager.setVisitLoc((EntityPlayer)player, isPos.getX(), isPos.getY());
        player.func_71033_a(GameType.SPECTATOR);
        player.field_71135_a.func_147364_a((double)visitPos.func_177958_n() + 0.5, (double)visitPos.func_177956_o(), (double)visitPos.func_177952_p() + 0.5, player.field_70177_z, player.field_70125_A);
    }

    public static void kick(EntityPlayerMP player, String[] args) throws CommandException {
        if (args.length != 2) {
            player.func_145747_a((ITextComponent)new TextComponentString("Must have 1 argument."));
            return;
        }
        if (IslandManager.worldOneChunk) {
            player.func_145747_a((ITextComponent)new TextComponentString("Can't use this command in this mode."));
            return;
        }
        EntityPlayerMP player2 = (EntityPlayerMP)player.func_130014_f_().func_72924_a(args[1]);
        IslandPos isPos = IslandManager.getPlayerIsland(player2.func_146103_bH().getId());
        if (args[1].equals(player.func_70005_c_())) {
            player.func_145747_a((ITextComponent)new TextComponentString("Why are you kicking yourself."));
            return;
        }
        if (isPos == null) {
            player.func_145747_a((ITextComponent)new TextComponentString("Player doesn't exist or player doesn't have an island."));
            return;
        }
        if (!isPos.getPlayerUUIDs().contains(player2.func_146103_bH().getId())) {
            player.func_145747_a((ITextComponent)new TextComponentString("Player isn't on your island."));
            return;
        }
        if (!isPos.getPlayerUUIDs().get(0).equals(player.func_146103_bH().getId())) {
            player.func_145747_a((ITextComponent)new TextComponentString("You are not the owner of the island"));
            return;
        }
        for (int i = 0; i < player2.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player2.field_71071_by.func_70301_a(i).func_77946_l();
            EntityItem item = new EntityItem(player.field_70170_p);
            item.func_92058_a(stack);
            item.field_70165_t = player.field_70165_t;
            item.field_70163_u = player.field_70163_u;
            item.field_70161_v = player.field_70161_v;
            player.field_70170_p.func_72838_d((Entity)item);
        }
        EventHandler.spawnPlayer((EntityPlayer)player2, new BlockPos(0, ConfigOptions.islandSettings.islandYLevel, 0), false);
        player2.func_145747_a((ITextComponent)new TextComponentString("You have been kicked..."));
    }

    public static void reset(EntityPlayerMP player, String[] args, World world) throws CommandException {
        if (!ConfigOptions.islandSettings.allowIslandCreation) {
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Not allowed to create islands!"));
            return;
        }
        if (!IslandManager.worldOneChunk) {
            PlatformCommand.leavePlatform(player, new String[]{""});
            PlatformCommand.newPlatform(player, args);
        } else {
            PlayerList players = world.func_73046_m().func_184103_al();
            for (EntityPlayerMP p : players.func_181057_v()) {
                player.func_145747_a((ITextComponent)new TextComponentString("Lag incoming for reset!"));
            }
            for (int x = -8; x < 9; ++x) {
                for (int z = -8; z < 9; ++z) {
                    for (int y = 0; y < 256; ++y) {
                        world.func_180501_a(new BlockPos(x, y, z), Blocks.field_150350_a.func_176223_P(), 2);
                    }
                }
            }
            if (args.length > 1) {
                Integer i = -1;
                try {
                    i = Integer.parseInt(args[1]);
                }
                catch (Exception e) {
                    i = IslandManager.getIndexOfIslandType(args[1]);
                }
                if (i > -1 && i < IslandManager.IslandGenerations.size()) {
                    EventHandler.spawnPlayer((EntityPlayer)player, new BlockPos(0, ConfigOptions.islandSettings.islandYLevel, 0), i);
                }
            } else {
                EventHandler.createSpawn((EntityPlayer)player, world, new BlockPos(0, ConfigOptions.islandSettings.islandYLevel, 0));
            }
            for (EntityPlayerMP p : players.func_181057_v()) {
                p.field_71071_by.func_174888_l();
                EventHandler.spawnPlayer((EntityPlayer)p, new BlockPos(0, ConfigOptions.islandSettings.islandYLevel, 0), false);
                player.func_145747_a((ITextComponent)new TextComponentString("Chunk Reset!"));
            }
        }
    }

    void showHelp(EntityPlayerMP player) {
        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "create (optional int/string)<type>" + TextFormatting.WHITE + " : Spawn a new platform. Must not already be on an island."));
        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "invite <player>" + TextFormatting.WHITE + " : Ask another player join your island team. Player must do join to go to your island team."));
        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "join" + TextFormatting.WHITE + " : Use this to join an island whose team has invited you recently"));
        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "leave" + TextFormatting.WHITE + " : Leave your island, clear inventory, and go to spawn.\n      (If you are the last person, no one can claim that island again.)"));
        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "home" + TextFormatting.WHITE + " : Teleport back to your home island. Must be at least " + ConfigOptions.islandSettings.protectionBuildRange + " blocks away."));
        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "spawn" + TextFormatting.WHITE + " : Teleport back to spawn (0, 0)."));
        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "reset (optional int/string)<type>" + TextFormatting.WHITE + " : Creates a new platform in a new spot and clears the players' inventory.\n      (If it doesn't clear everything, be nice and toss the rest? Maybe?\nNot recommended unless all players for that island are online)"));
        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "onechunk" + TextFormatting.WHITE + " : Play in one chunk, on one island. Also resets the spawn chunk." + (ConfigOptions.commandSettings.oneChunkCommandAllowed ? "" : TextFormatting.RED + "\n THE COMMAND IS NOT ALLOWED TO BE USED. SET THE CONFIG OPTION TO TRUE.")));
        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "visit <player>" + TextFormatting.WHITE + " : Visit another player's island in spectator mode."));
    }

    public static void newPlatform(EntityPlayerMP player, String[] args) throws CommandException {
        if ((args.length == 1 || args.length > 1 && !args[1].equals("bypass")) && !ConfigOptions.islandSettings.allowIslandCreation) {
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Not allowed to create islands!"));
            return;
        }
        if (args.length > 2) {
            player.func_145747_a((ITextComponent)new TextComponentString("Must have 0 or 1 argument"));
            return;
        }
        if (IslandManager.worldOneChunk) {
            player.func_145747_a((ITextComponent)new TextComponentString("Can't use this command in this mode."));
            return;
        }
        if (IslandManager.initialIslandDistance != ConfigOptions.islandSettings.islandDistance) {
            player.func_145747_a((ITextComponent)new TextComponentString("This isn't going to work. The island distance has changed!"));
            return;
        }
        if (IslandManager.playerHasIsland(player.func_146103_bH().getId())) {
            player.func_145747_a((ITextComponent)new TextComponentString("You already have an island!"));
            return;
        }
        IslandPos position = IslandManager.getNextIsland();
        if (args.length > 1 && args[1].equals("bypass")) {
            args = new String[]{args[0]};
        }
        if (args.length > 1 && ConfigOptions.islandSettings.islandSpawnType.equals("random")) {
            Integer i = -1;
            try {
                i = Integer.parseInt(args[1]);
            }
            catch (Exception e) {
                i = IslandManager.getIndexOfIslandType(args[1]);
            }
            if (i > -1 && i < IslandManager.IslandGenerations.size()) {
                EventHandler.spawnPlayer((EntityPlayer)player, new BlockPos(position.getX() * ConfigOptions.islandSettings.islandDistance, ConfigOptions.islandSettings.islandYLevel, position.getY() * ConfigOptions.islandSettings.islandDistance), i);
            }
        } else {
            if (args.length > 1) {
                player.func_145747_a((ITextComponent)new TextComponentString("You can't pick your island as the config overrides it!"));
            }
            EventHandler.spawnPlayer((EntityPlayer)player, new BlockPos(position.getX() * ConfigOptions.islandSettings.islandDistance, ConfigOptions.islandSettings.islandYLevel, position.getY() * ConfigOptions.islandSettings.islandDistance), true);
        }
        if (IslandManager.hasVisitLoc((EntityPlayer)player)) {
            player.func_71033_a(GameType.SURVIVAL);
            IslandManager.removeVisitLoc((EntityPlayer)player);
        }
    }

    public static void inviteOther(EntityPlayerMP player, String[] args, World world) throws CommandException {
        if (args.length != 2) {
            player.func_145747_a((ITextComponent)new TextComponentString("Must have 1 argument"));
            return;
        }
        if (IslandManager.worldOneChunk) {
            player.func_145747_a((ITextComponent)new TextComponentString("Can't use this command in this mode."));
            return;
        }
        if (IslandManager.initialIslandDistance != ConfigOptions.islandSettings.islandDistance) {
            player.func_145747_a((ITextComponent)new TextComponentString("This isn't going to work. The island distance has changed!"));
            return;
        }
        EntityPlayerMP player2 = (EntityPlayerMP)player.func_130014_f_().func_72924_a(args[1]);
        if (player2 == null) {
            player.func_145747_a((ITextComponent)new TextComponentString(args[1] + " doesn't exist."));
            return;
        }
        if (player2.func_70005_c_().equals(player.func_70005_c_())) {
            player.func_145747_a((ITextComponent)new TextComponentString(player2.func_70005_c_() + " is yourself."));
            return;
        }
        if (!IslandManager.playerHasIsland(player.func_146103_bH().getId())) {
            player.func_145747_a((ITextComponent)new TextComponentString("You don't have an island."));
            return;
        }
        if (IslandManager.hasJoinLoc((EntityPlayer)player2)) {
            player.func_145747_a((ITextComponent)new TextComponentString(player2.func_70005_c_() + " has an invite already!"));
            return;
        }
        IslandPos position = IslandManager.getPlayerIsland(player.func_146103_bH().getId());
        IslandManager.setJoinLoc((EntityPlayer)player2, position.getX(), position.getY());
        player.func_145747_a((ITextComponent)new TextComponentString("Invited " + player2.func_70005_c_() + " to your island!"));
        player2.func_145747_a((ITextComponent)new TextComponentString("You have been invited to " + player.func_70005_c_() + "'s island! Type /" + aliases.get(0) + " join to join!"));
    }

    public static void joinPlatform(EntityPlayerMP player, String[] args, World world) throws CommandException {
        IslandPos position = IslandManager.getJoinLoc((EntityPlayer)player);
        if (position == null) {
            player.func_145747_a((ITextComponent)new TextComponentString("You haven't been asked to join recently."));
            return;
        }
        IslandManager.addPlayer(player.func_146103_bH().getId(), position);
        position = IslandManager.getPlayerIsland(player.func_146103_bH().getId());
        for (String name : position.getPlayerUUIDs()) {
            EntityPlayerMP p = (EntityPlayerMP)world.func_72924_a(name);
            if (p == null) continue;
            p.func_145747_a((ITextComponent)new TextComponentString(player.func_70005_c_() + " joined your island!"));
        }
        if (IslandManager.hasVisitLoc((EntityPlayer)player)) {
            player.func_71033_a(GameType.SURVIVAL);
            IslandManager.removeVisitLoc((EntityPlayer)player);
        }
        IslandManager.tpPlayerToPosSpawn((EntityPlayer)player, new BlockPos(position.getX() * ConfigOptions.islandSettings.islandDistance, ConfigOptions.islandSettings.islandYLevel, position.getY() * ConfigOptions.islandSettings.islandDistance), position);
    }

    public static void leavePlatform(EntityPlayerMP player, String[] args) throws CommandException {
        if (!ConfigOptions.islandSettings.allowIslandCreation) {
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Not allowed to leave islands!"));
            return;
        }
        if (args.length > 1) {
            player.func_145747_a((ITextComponent)new TextComponentString("Must have no arguments"));
            return;
        }
        if (IslandManager.worldOneChunk) {
            player.func_145747_a((ITextComponent)new TextComponentString("Can't use this command in this mode."));
            return;
        }
        if (IslandManager.initialIslandDistance != ConfigOptions.islandSettings.islandDistance) {
            player.func_145747_a((ITextComponent)new TextComponentString("This isn't going to work. The island distance has changed!"));
            return;
        }
        if (IslandManager.getPlayerIsland(player.func_146103_bH().getId()).getPlayerUUIDs().size() == 1 && !IslandManager.hasLeaveConfirm((EntityPlayer)player)) {
            IslandManager.setLeaveConfirm((EntityPlayer)player);
            player.func_145747_a((ITextComponent)new TextComponentString("Type /" + ConfigOptions.commandSettings.commandName + " leave again soon to confirm"));
            return;
        }
        if (!IslandManager.playerHasIsland(player.func_146103_bH().getId())) {
            player.func_145747_a((ITextComponent)new TextComponentString("You don't have an island!"));
            return;
        }
        IslandManager.removePlayer(player.func_146103_bH().getId());
        player.func_145747_a((ITextComponent)new TextComponentString("You are now free to join another island!"));
        if (!ConfigOptions.islandSettings.resetInventory) {
            player.field_71071_by.func_174888_l();
        }
        if (IslandManager.hasVisitLoc((EntityPlayer)player)) {
            player.func_71033_a(GameType.SURVIVAL);
            IslandManager.removeVisitLoc((EntityPlayer)player);
        }
        IslandManager.tpPlayerToPosSpawn((EntityPlayer)player, new BlockPos(0, ConfigOptions.islandSettings.islandYLevel, 0), IslandManager.getIslandAtPos(0, 0));
    }

    public static void tpHome(EntityPlayerMP player, String[] args) throws CommandException {
        if (!ConfigOptions.commandSettings.allowHomeCommand) {
            player.func_145747_a((ITextComponent)new TextComponentString("This command was disabled"));
            return;
        }
        if (args.length > 1) {
            player.func_145747_a((ITextComponent)new TextComponentString("Must have no arguments"));
            return;
        }
        if (IslandManager.worldOneChunk) {
            player.func_145747_a((ITextComponent)new TextComponentString("Can't use this command in this mode."));
            return;
        }
        if (IslandManager.initialIslandDistance != ConfigOptions.islandSettings.islandDistance) {
            player.func_145747_a((ITextComponent)new TextComponentString("This isn't going to work. The island distance has changed!"));
            return;
        }
        IslandPos isPos = IslandManager.getPlayerIsland(player.func_146103_bH().getId());
        if (isPos == null) {
            player.func_145747_a((ITextComponent)new TextComponentString("You don't have an island yet."));
            return;
        }
        BlockPos home = new BlockPos(isPos.getX() * ConfigOptions.islandSettings.islandDistance, ConfigOptions.islandSettings.islandYLevel, isPos.getY() * ConfigOptions.islandSettings.islandDistance);
        if (player.field_71093_bK == ConfigOptions.worldGenSettings.baseDimension && Math.hypot(player.field_70165_t - (double)home.func_177958_n() - 0.5, player.field_70161_v - (double)home.func_177952_p() - 0.5) < (double)ConfigOptions.islandSettings.protectionBuildRange) {
            player.func_145747_a((ITextComponent)new TextComponentString("You are too close to home!\nYou must be at least " + ConfigOptions.islandSettings.protectionBuildRange + " blocks away!"));
            return;
        }
        if (IslandManager.hasVisitLoc((EntityPlayer)player)) {
            player.func_71033_a(GameType.SURVIVAL);
            IslandManager.removeVisitLoc((EntityPlayer)player);
        }
        IslandManager.tpPlayerToPos((EntityPlayer)player, home, isPos);
    }

    public static void tpSpawn(EntityPlayerMP player, String[] args) throws CommandException {
        if (IslandManager.worldOneChunk) {
            player.func_145747_a((ITextComponent)new TextComponentString("Can't use this command in this mode."));
            return;
        }
        if (IslandManager.hasVisitLoc((EntityPlayer)player)) {
            player.func_71033_a(GameType.SURVIVAL);
            IslandManager.removeVisitLoc((EntityPlayer)player);
        }
        IslandManager.tpPlayerToPos((EntityPlayer)player, new BlockPos(0, ConfigOptions.islandSettings.islandYLevel, 0), IslandManager.getIslandAtPos(0, 0));
    }

    public String func_71517_b() {
        return aliases.get(0);
    }

    public String func_71518_a(ICommandSender sender) {
        return ConfigOptions.commandSettings.commandName;
    }
}

