/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import org.lwjgl.input.Keyboard;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiDropDown;
import xaero.common.gui.GuiWaypointSets;
import xaero.common.gui.MySmallButton;
import xaero.common.gui.MySuperTinyButton;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;
import xaero.common.validator.NumericFieldValidator;

public class GuiAddWaypoint
extends GuiScreen {
    private IXaeroMinimap modMain;
    private WaypointsManager waypointsManager;
    private GuiScreen parentGuiScreen;
    protected String screenTitle;
    private GuiTextField nameTextField;
    private String nameText;
    private GuiTextField xTextField;
    private GuiTextField yTextField;
    private GuiTextField zTextField;
    private GuiTextField yawTextField;
    private GuiTextField charTextField;
    private String initial;
    private String yaw;
    private ArrayList<GuiDropDown> dropDowns;
    private GuiWaypointSets sets;
    private String fromSet;
    private int color;
    private Waypoint point;
    private boolean dropped;
    private NumericFieldValidator fieldValidator;

    public GuiAddWaypoint(IXaeroMinimap modMain, GuiScreen par1GuiScreen, Waypoint point) {
        this.parentGuiScreen = par1GuiScreen;
        this.point = point;
        this.modMain = modMain;
        this.waypointsManager = modMain.getWaypointsManager();
        this.fromSet = this.waypointsManager.getCurrentWorld().getCurrent();
        this.sets = new GuiWaypointSets(this.waypointsManager, false);
        this.nameText = "";
        this.dropDowns = new ArrayList();
        this.initial = "";
        this.yaw = "";
        this.fieldValidator = modMain.getFieldValidators().getNumericFieldValidator();
    }

    public String[] createColorOptions() {
        String[] options = new String[ModSettings.ENCHANT_COLOR_NAMES.length];
        for (int i = 0; i < options.length; ++i) {
            options[i] = i == 0 ? I18n.func_135052_a((String)ModSettings.ENCHANT_COLOR_NAMES[i], (Object[])new Object[0]) : "\u00a7" + ModSettings.ENCHANT_COLORS[i] + I18n.func_135052_a((String)ModSettings.ENCHANT_COLOR_NAMES[i], (Object[])new Object[0]);
        }
        return options;
    }

    public int[] createValues() {
        int[] values = new int[ModSettings.ENCHANT_COLOR_NAMES.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = i;
        }
        return values;
    }

    public void func_73866_w_() {
        this.modMain.getInterfaces().setSelectedId(-1);
        this.modMain.getInterfaces().setDraggingId(-1);
        this.field_146292_n.clear();
        this.field_146292_n.add(new MySmallButton(200, this.field_146294_l / 2 - 155, this.field_146295_m / 6 + 168, I18n.func_135052_a((String)"gui.xaero_confirm", (Object[])new Object[0])));
        this.field_146292_n.add(new MySmallButton(201, this.field_146294_l / 2 + 5, this.field_146295_m / 6 + 168, I18n.func_135052_a((String)"gui.xaero_cancel", (Object[])new Object[0])));
        this.field_146292_n.add(new MySuperTinyButton(203, this.field_146294_l / 2 - 165, 99, I18n.func_135052_a((String)"* 8", (Object[])new Object[0])));
        this.field_146292_n.add(new MySuperTinyButton(204, this.field_146294_l / 2 - 165, 125, I18n.func_135052_a((String)"/ 8", (Object[])new Object[0])));
        this.nameTextField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 100, 82, 200, 20);
        this.xTextField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 109, 112, 50, 20);
        this.yTextField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 53, 112, 50, 20);
        this.zTextField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 + 3, 112, 50, 20);
        this.yawTextField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 + 59, 112, 50, 20);
        this.charTextField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 25, 142, 50, 20);
        if (this.point == null) {
            this.screenTitle = I18n.func_135052_a((String)"gui.xaero_new_waypoint", (Object[])new Object[0]);
            this.nameTextField.func_146180_a(this.nameText);
            boolean divideBy8 = this.waypointsManager.divideBy8();
            this.xTextField.func_146180_a("" + OptimizedMath.myFloor(this.field_146297_k.field_71439_g.field_70165_t) * (divideBy8 ? 8 : 1));
            this.yTextField.func_146180_a("" + OptimizedMath.myFloor(this.field_146297_k.field_71439_g.field_70163_u));
            this.zTextField.func_146180_a("" + OptimizedMath.myFloor(this.field_146297_k.field_71439_g.field_70161_v) * (divideBy8 ? 8 : 1));
            this.yawTextField.func_146180_a("\u00a78" + I18n.func_135052_a((String)"gui.xaero_yaw", (Object[])new Object[0]));
            this.charTextField.func_146180_a("\u00a78" + I18n.func_135052_a((String)"gui.xaero_initial", (Object[])new Object[0]));
            this.color = (int)(Math.random() * (double)(ModSettings.ENCHANT_COLORS.length - 1));
        } else {
            this.screenTitle = I18n.func_135052_a((String)"gui.xaero_edit_waypoint", (Object[])new Object[0]);
            this.nameTextField.func_146180_a(this.point.getLocalizedName());
            this.xTextField.func_146180_a("" + this.point.getX());
            this.yTextField.func_146180_a("" + this.point.getY());
            this.zTextField.func_146180_a("" + this.point.getZ());
            this.initial = this.point.getSymbol();
            if (this.point.isRotation()) {
                this.yaw = "" + this.point.getYaw();
            }
            this.yawTextField.func_146180_a(this.yaw);
            this.charTextField.func_146180_a(this.initial);
            this.color = this.point.getColor();
        }
        if (!this.dropDowns.isEmpty()) {
            this.color = this.dropDowns.get(0).getSelected();
        }
        this.dropDowns.clear();
        GuiDropDown colorSelect = new GuiDropDown(this.createColorOptions(), this.field_146294_l / 2 - 60, 60, 120, this.color);
        this.dropDowns.add(colorSelect);
        this.dropDowns.add(new GuiDropDown(this.sets.getOptions(), this.field_146294_l / 2 - 101, 38, 201, this.sets.getCurrentSet()));
        this.nameTextField.func_146195_b(true);
        Keyboard.enableRepeatEvents((boolean)true);
        this.updateConfirmButton();
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        if (this.nameTextField.func_146206_l()) {
            if (par2 == 15) {
                this.nameTextField.func_146195_b(false);
                this.xTextField.func_146195_b(true);
            }
            this.nameTextField.func_146201_a(par1, par2);
            if (this.initial.length() == 0 && this.nameTextField.func_146179_b().length() > 0) {
                this.initial = this.nameTextField.func_146179_b().substring(0, 1);
            }
        } else if (this.xTextField.func_146206_l()) {
            if (par2 == 15) {
                this.xTextField.func_146195_b(false);
                this.yTextField.func_146195_b(true);
            }
            this.xTextField.func_146201_a(par1, par2);
        } else if (this.yTextField.func_146206_l()) {
            if (par2 == 15) {
                this.yTextField.func_146195_b(false);
                this.zTextField.func_146195_b(true);
            }
            this.yTextField.func_146201_a(par1, par2);
        } else if (this.zTextField.func_146206_l()) {
            if (par2 == 15) {
                this.zTextField.func_146195_b(false);
                this.yawTextField.func_146195_b(true);
            }
            this.zTextField.func_146201_a(par1, par2);
        } else if (this.yawTextField.func_146206_l()) {
            if (par2 == 15) {
                this.yawTextField.func_146195_b(false);
                this.charTextField.func_146195_b(true);
            }
            this.yawTextField.func_146180_a(this.yaw);
            this.yawTextField.func_146201_a(par1, par2);
            this.fieldValidator.validate(this.yawTextField);
            this.yaw = this.yawTextField.func_146179_b();
        } else if (this.charTextField.func_146206_l()) {
            if (par2 == 15) {
                this.charTextField.func_146195_b(false);
                this.nameTextField.func_146195_b(true);
            }
            this.charTextField.func_146180_a(this.initial);
            if (par2 != 57) {
                this.charTextField.func_146201_a(par1, par2);
            }
            this.initial = this.charTextField.func_146179_b();
        }
        if (par2 == 28 || par2 == 156) {
            this.func_146284_a((GuiButton)this.field_146292_n.get(0));
        }
        this.checkFields();
        this.updateConfirmButton();
        super.func_73869_a(par1, par2);
    }

    private void updateConfirmButton() {
        ((GuiButton)this.field_146292_n.get((int)0)).field_146124_l = this.nameTextField.func_146179_b().length() > 0 && this.initial.length() > 0 && this.xTextField.func_146179_b().length() > 0 && this.yTextField.func_146179_b().length() > 0 && this.zTextField.func_146179_b().length() > 0;
    }

    protected void checkFields() {
        this.fieldValidator.validate(this.xTextField);
        this.fieldValidator.validate(this.yTextField);
        this.fieldValidator.validate(this.zTextField);
        this.initial = this.initial.toUpperCase();
        if (this.initial.length() > 1) {
            this.initial = this.initial.substring(0, 1);
        }
        if (this.yaw.length() > 4) {
            this.yaw = this.yaw.substring(0, 4);
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) throws IOException {
        for (GuiDropDown d : this.dropDowns) {
            if (!d.isClosed() && d.onDropDown(par1, par2)) {
                d.mouseClicked(par1, par2, par3);
                return;
            }
            d.setClosed(true);
        }
        for (GuiDropDown d : this.dropDowns) {
            if (d.onDropDown(par1, par2)) {
                d.mouseClicked(par1, par2, par3);
                return;
            }
            d.setClosed(true);
        }
        super.func_73864_a(par1, par2, par3);
        this.nameTextField.func_146192_a(par1, par2, par3);
        this.xTextField.func_146192_a(par1, par2, par3);
        this.yTextField.func_146192_a(par1, par2, par3);
        this.zTextField.func_146192_a(par1, par2, par3);
        this.yawTextField.func_146192_a(par1, par2, par3);
        this.charTextField.func_146192_a(par1, par2, par3);
    }

    public void func_73876_c() {
        if (this.field_146297_k.field_71439_g == null) {
            this.field_146297_k.func_147108_a(null);
            return;
        }
        this.nameTextField.func_146178_a();
        this.xTextField.func_146178_a();
        this.yTextField.func_146178_a();
        this.zTextField.func_146178_a();
        this.yawTextField.func_146178_a();
        this.charTextField.func_146178_a();
        if (this.yawTextField.func_146206_l() || this.yaw.length() > 0) {
            this.yawTextField.func_146180_a(this.yaw);
        } else {
            this.yawTextField.func_146180_a("\u00a78" + I18n.func_135052_a((String)"gui.xaero_yaw", (Object[])new Object[0]));
        }
        if (this.charTextField.func_146206_l() || this.initial.length() > 0) {
            this.charTextField.func_146180_a(this.initial);
        } else {
            this.charTextField.func_146180_a("\u00a78" + I18n.func_135052_a((String)"gui.xaero_initial", (Object[])new Object[0]));
        }
        this.color = this.dropDowns.get(0).getSelected();
        if (this.sets.getCurrentSet() != this.dropDowns.get(1).getSelected()) {
            this.sets.setCurrentSet(this.dropDowns.get(1).getSelected());
            this.waypointsManager.getCurrentWorld().setCurrent(this.dropDowns.get(1).getSelectedOption());
            this.waypointsManager.updateWaypoints();
            try {
                this.modMain.getSettings().saveWaypoints(this.waypointsManager.getCurrentWorld());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        if (par1GuiButton.field_146124_l) {
            int var2 = this.field_146297_k.field_71474_y.field_74335_Z;
            if (par1GuiButton.field_146127_k < 100 && par1GuiButton instanceof MySmallButton) {
                try {
                    this.modMain.getSettings().setOptionValue(((MySmallButton)par1GuiButton).returnModOptions(), 1);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                par1GuiButton.field_146126_j = this.modMain.getSettings().getKeyBinding(ModOptions.getModOptions(par1GuiButton.field_146127_k));
            }
            if (par1GuiButton.field_146127_k == 200) {
                int x = this.xTextField.func_146179_b().equals("-") ? 0 : Integer.parseInt(this.xTextField.func_146179_b());
                int y = this.yTextField.func_146179_b().equals("-") ? 0 : Integer.parseInt(this.yTextField.func_146179_b());
                int z = this.zTextField.func_146179_b().equals("-") ? 0 : Integer.parseInt(this.zTextField.func_146179_b());
                String name = this.nameTextField.func_146179_b();
                Waypoint created = new Waypoint(x, y, z, name, this.initial, this.color);
                if (this.yaw.length() > 0 && !this.yaw.equals("-")) {
                    created.setRotation(true);
                    created.setYaw(Integer.parseInt(this.yawTextField.func_146179_b()));
                }
                this.waypointsManager.getWaypoints().getList().add(created);
                if (this.point != null) {
                    this.waypointsManager.getCurrentWorld().getSets().get(this.fromSet).getList().remove(this.point);
                }
                try {
                    this.modMain.getSettings().saveWaypoints(this.waypointsManager.getCurrentWorld());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.field_146297_k.func_147108_a(this.parentGuiScreen);
            }
            if (par1GuiButton.field_146127_k == 201) {
                this.field_146297_k.func_147108_a(this.parentGuiScreen);
            }
            if (par1GuiButton.field_146127_k == 202) {
                this.color = (this.color + 1) % (ModSettings.ENCHANT_COLORS.length - 1);
            }
            if (par1GuiButton.field_146127_k == 203) {
                this.multiplyCoordinates(8.0);
            } else if (par1GuiButton.field_146127_k == 204) {
                this.multiplyCoordinates(0.125);
            }
            if (this.field_146297_k.field_71474_y.field_74335_Z != var2) {
                ScaledResolution var3 = new ScaledResolution(this.field_146297_k);
                int var4 = var3.func_78326_a();
                int var5 = var3.func_78328_b();
                this.func_146280_a(this.field_146297_k, var4, var5);
            }
        }
    }

    public List getButtons() {
        return this.field_146292_n;
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, this.screenTitle, this.field_146294_l / 2, 20, 0xFFFFFF);
        this.nameTextField.func_146194_f();
        this.xTextField.func_146194_f();
        this.yTextField.func_146194_f();
        this.zTextField.func_146194_f();
        this.yawTextField.func_146194_f();
        this.charTextField.func_146194_f();
        if (this.dropped) {
            super.func_73863_a(0, 0, par3);
        } else {
            super.func_73863_a(par1, par2, par3);
        }
        this.dropped = false;
        for (int k = 0; k < this.dropDowns.size(); ++k) {
            if (!this.dropDowns.get(k).isClosed()) {
                this.dropped = true;
            }
            this.dropDowns.get(k).drawButton(par1, par2);
        }
    }

    private void multiplyCoordinates(double factor) {
        this.multiplyCoordinateField(this.xTextField, factor);
        this.multiplyCoordinateField(this.zTextField, factor);
    }

    private void multiplyCoordinateField(GuiTextField field, double factor) {
        if (field.func_146179_b().isEmpty() || field.func_146179_b().equals("-")) {
            return;
        }
        int value = Integer.parseInt(field.func_146179_b());
        value = (int)Math.floor((double)value * factor);
        field.func_146180_a("" + value);
    }
}

