/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.item.block.ItemBlockPlacementProperty;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageSyncNBTTag;
import fi.dy.masa.enderutilities.util.ItemType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;

public class PlacementProperties {
    private static final String FILE_NAME_BASE = "placement_properties";
    private static PlacementProperties instance;
    private Map<UUID, Map<ItemType, NBTTagCompound>> properties = new HashMap<UUID, Map<ItemType, NBTTagCompound>>();
    private Map<UUID, Map<ItemType, Integer>> indices = new HashMap<UUID, Map<ItemType, Integer>>();
    private boolean dirty = false;

    public static PlacementProperties getInstance() {
        if (instance == null) {
            instance = new PlacementProperties();
        }
        return instance;
    }

    public int getPropertyIndex(UUID uuid, ItemType type) {
        Map<ItemType, Integer> map = this.indices.get(uuid);
        if (map != null) {
            Integer value = map.get(type);
            return value != null ? value : 0;
        }
        return 0;
    }

    public void setPropertyIndex(UUID uuid, ItemType type, int index) {
        Map<ItemType, Integer> map = this.indices.get(uuid);
        if (map == null) {
            map = new HashMap<ItemType, Integer>();
            this.indices.put(uuid, map);
        }
        map.put(type, index);
        this.dirty = true;
    }

    public void setPropertyValue(UUID uuid, ItemType itemType, String key, Integer valueType, int value) {
        NBTTagCompound tag = this.getOrCreatePropertyTag(uuid, itemType);
        switch (valueType) {
            case 1: {
                tag.func_74774_a(key, (byte)value);
                break;
            }
            case 2: {
                tag.func_74777_a(key, (short)value);
                break;
            }
            case 3: {
                tag.func_74768_a(key, value);
                break;
            }
        }
        this.dirty = true;
    }

    public int getPropertyValue(UUID uuid, ItemType itemType, String key, Integer valueType) {
        NBTTagCompound tag = this.getPropertyTag(uuid, itemType);
        if (tag != null) {
            switch (valueType) {
                case 1: {
                    return tag.func_74771_c(key) & 0xFF;
                }
                case 2: {
                    return tag.func_74765_d(key) & 0xFFFF;
                }
                case 3: {
                    return tag.func_74762_e(key);
                }
            }
        }
        return 0;
    }

    @Nullable
    public NBTTagCompound getPropertyTag(UUID uuid, ItemType type) {
        Map<ItemType, NBTTagCompound> map = this.properties.get(uuid);
        return map != null ? map.get(type) : null;
    }

    @Nonnull
    private NBTTagCompound getOrCreatePropertyTag(UUID uuid, ItemType type) {
        NBTTagCompound tag;
        Map<ItemType, NBTTagCompound> map = this.properties.get(uuid);
        if (map == null) {
            map = new HashMap<ItemType, NBTTagCompound>();
            this.properties.put(uuid, map);
        }
        if ((tag = map.get(type)) == null) {
            tag = new NBTTagCompound();
            map.put(type, tag);
        }
        return tag;
    }

    public void readFromDisk() {
        this.properties.clear();
        this.indices.clear();
        try {
            File saveDir = DimensionManager.getCurrentSaveRootDirectory();
            if (saveDir == null) {
                return;
            }
            File file = new File(new File(saveDir, "enderutilities"), "placement_properties.dat");
            if (file.exists() && file.isFile()) {
                this.readFromNBT(CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file)));
            }
        }
        catch (Exception e) {
            EnderUtilities.logger.warn("Failed to read Placement Properties data from file");
        }
    }

    public void writeToDisk() {
        if (!this.dirty) {
            return;
        }
        try {
            File saveDir = DimensionManager.getCurrentSaveRootDirectory();
            if (saveDir == null) {
                return;
            }
            if (!(saveDir = new File(saveDir, "enderutilities")).exists() && !saveDir.mkdirs()) {
                EnderUtilities.logger.warn("Failed to create the save directory '{}'", (Object)saveDir.toString());
                return;
            }
            File fileTmp = new File(saveDir, "placement_properties.dat.tmp");
            File fileReal = new File(saveDir, "placement_properties.dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.writeToNBT(new NBTTagCompound()), (OutputStream)new FileOutputStream(fileTmp));
            if (fileReal.exists()) {
                fileReal.delete();
            }
            fileTmp.renameTo(fileReal);
            this.dirty = false;
        }
        catch (Exception e) {
            EnderUtilities.logger.warn("Failed to write Placement Properties data to file", (Throwable)e);
        }
    }

    private void readFromNBT(NBTTagCompound nbt) {
        if (nbt == null || !nbt.func_150297_b("PlacementProperties", 9)) {
            return;
        }
        NBTTagList tagListPlayers = nbt.func_150295_c("PlacementProperties", 10);
        int countPlayers = tagListPlayers.func_74745_c();
        for (int playerIndex = 0; playerIndex < countPlayers; ++playerIndex) {
            this.readAllDataForPlayerFromNBT(tagListPlayers.func_150305_b(playerIndex));
        }
    }

    public void readAllDataForPlayerFromNBT(NBTTagCompound tagPlayer) {
        if (tagPlayer.func_150297_b("UUID", 8) && tagPlayer.func_150297_b("Data", 9)) {
            UUID uuid = UUID.fromString(tagPlayer.func_74779_i("UUID"));
            NBTTagList tagListData = tagPlayer.func_150295_c("Data", 10);
            int countData = tagListData.func_74745_c();
            HashMap<ItemType, NBTTagCompound> mapTags = new HashMap<ItemType, NBTTagCompound>();
            HashMap<ItemType, Integer> mapIndices = new HashMap<ItemType, Integer>();
            this.properties.put(uuid, mapTags);
            this.indices.put(uuid, mapIndices);
            for (int dataIndex = 0; dataIndex < countData; ++dataIndex) {
                this.readDataForItemTypeFromNBT(tagListData.func_150305_b(dataIndex), mapTags, mapIndices);
            }
        }
    }

    private void readDataForItemTypeFromNBT(NBTTagCompound tagData, Map<ItemType, NBTTagCompound> mapTags, Map<ItemType, Integer> mapIndices) {
        ItemBlockPlacementProperty item;
        ItemStack stack;
        if (tagData.func_150297_b("ItemType", 10) && tagData.func_150297_b("Tag", 10) && !(stack = new ItemStack(tagData.func_74775_l("ItemType"))).func_190926_b() && stack.func_77973_b() instanceof ItemBlockPlacementProperty && (item = (ItemBlockPlacementProperty)stack.func_77973_b()).hasPlacementProperty(stack)) {
            boolean nbtSensitive = item.getPlacementProperty(stack).isNBTSensitive();
            ItemType type = new ItemType(stack, nbtSensitive);
            mapTags.put(type, tagData.func_74775_l("Tag"));
            if (tagData.func_150297_b("Index", 1)) {
                mapIndices.put(type, Integer.valueOf(tagData.func_74771_c("Index")));
            }
        }
    }

    public void readSyncedItemData(UUID uuid, NBTTagCompound tag) {
        Map<ItemType, NBTTagCompound> mapTags = this.properties.get(uuid);
        Map<ItemType, Integer> mapIndices = this.indices.get(uuid);
        if (mapTags == null) {
            mapTags = new HashMap<ItemType, NBTTagCompound>();
            this.properties.put(uuid, mapTags);
        }
        if (mapIndices == null) {
            mapIndices = new HashMap<ItemType, Integer>();
            this.indices.put(uuid, mapIndices);
        }
        this.readDataForItemTypeFromNBT(tag, mapTags, mapIndices);
    }

    private NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList tagListPlayers = new NBTTagList();
        for (Map.Entry<UUID, Map<ItemType, NBTTagCompound>> playerEntry : this.properties.entrySet()) {
            tagListPlayers.func_74742_a((NBTBase)this.writeDataForPlayerToNBT(playerEntry.getKey(), playerEntry.getValue()));
        }
        nbt.func_74782_a("PlacementProperties", (NBTBase)tagListPlayers);
        return nbt;
    }

    private NBTTagCompound writeDataForPlayerToNBT(UUID uuid, Map<ItemType, NBTTagCompound> playerData) {
        NBTTagCompound tagPlayer = new NBTTagCompound();
        NBTTagList tagListData = new NBTTagList();
        tagPlayer.func_74778_a("UUID", uuid.toString());
        tagPlayer.func_74782_a("Data", (NBTBase)tagListData);
        for (Map.Entry<ItemType, NBTTagCompound> dataEntry : playerData.entrySet()) {
            NBTTagCompound tagData = new NBTTagCompound();
            tagData.func_74782_a("ItemType", (NBTBase)dataEntry.getKey().getStack().func_77955_b(new NBTTagCompound()));
            tagData.func_74782_a("Tag", (NBTBase)dataEntry.getValue());
            int index = this.getPropertyIndex(uuid, dataEntry.getKey());
            if (index != 0) {
                tagData.func_74774_a("Index", (byte)index);
            }
            tagListData.func_74742_a((NBTBase)tagData);
        }
        return tagPlayer;
    }

    public void syncCurrentlyHeldItemDataForPlayer(EntityPlayerMP player, ItemStack stack) {
        boolean nbtSensitive;
        ItemType type;
        UUID uuid;
        NBTTagCompound props;
        ItemBlockPlacementProperty item;
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemBlockPlacementProperty && (item = (ItemBlockPlacementProperty)stack.func_77973_b()).hasPlacementProperty(stack) && (props = this.getPropertyTag(uuid = player.func_110124_au(), type = new ItemType(stack, nbtSensitive = item.getPlacementProperty(stack).isNBTSensitive()))) != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("UUID", uuid.toString());
            tag.func_74782_a("ItemType", (NBTBase)stack.func_77955_b(new NBTTagCompound()));
            tag.func_74774_a("Index", (byte)this.getPropertyIndex(uuid, type));
            tag.func_74782_a("Tag", (NBTBase)props);
            MessageSyncNBTTag message = new MessageSyncNBTTag(uuid, MessageSyncNBTTag.Type.PLACEMENT_PROPERTIES_CURRENT, tag);
            PacketHandler.INSTANCE.sendTo((IMessage)message, player);
        }
    }

    public void syncAllDataForPlayer(EntityPlayerMP player) {
        UUID uuid = player.func_110124_au();
        Map<ItemType, NBTTagCompound> playerData = this.properties.get(uuid);
        if (playerData != null) {
            NBTTagCompound tag = this.writeDataForPlayerToNBT(uuid, playerData);
            MessageSyncNBTTag message = new MessageSyncNBTTag(uuid, MessageSyncNBTTag.Type.PLACEMENT_PROPERTIES_FULL, tag);
            PacketHandler.INSTANCE.sendTo((IMessage)message, player);
        }
    }

    public static class PlacementProperty {
        private boolean isNBTSensitive;
        private List<Pair<String, Integer>> propertyTypes = new ArrayList<Pair<String, Integer>>();
        private List<Pair<Integer, Integer>> propertyValueRange = new ArrayList<Pair<Integer, Integer>>();
        private Map<String, String[]> propertyValueNames = new HashMap<String, String[]>();

        public boolean hasPlacementProperties() {
            return !this.propertyTypes.isEmpty();
        }

        public boolean isNBTSensitive() {
            return this.isNBTSensitive;
        }

        public void setIsNBTSensitive(boolean checkNBT) {
            this.isNBTSensitive = checkNBT;
        }

        public void addProperty(String key, int type, int minValue, int maxValue) {
            this.propertyTypes.add((Pair<String, Integer>)Pair.of((Object)key, (Object)type));
            this.propertyValueRange.add((Pair<Integer, Integer>)Pair.of((Object)minValue, (Object)maxValue));
        }

        public void addValueNames(String key, String[] names) {
            this.propertyValueNames.put(key, names);
        }

        @Nullable
        public Pair<String, Integer> getProperty(int selection) {
            return selection >= 0 && selection < this.propertyTypes.size() ? this.propertyTypes.get(selection) : null;
        }

        @Nullable
        public Pair<Integer, Integer> getPropertyValueRange(int selection) {
            return selection >= 0 && selection < this.propertyValueRange.size() ? this.propertyValueRange.get(selection) : null;
        }

        @Nullable
        public String getPropertyValueName(String key, int value) {
            String[] names = this.propertyValueNames.get(key);
            if (names != null && value >= 0 && value < names.length) {
                return names[value];
            }
            return null;
        }

        public int getPropertyCount() {
            return this.propertyTypes.size();
        }
    }
}

