/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import fi.dy.masa.enderutilities.gui.client.GuiHandyChest;
import fi.dy.masa.enderutilities.inventory.IModularInventoryHolder;
import fi.dy.masa.enderutilities.inventory.ItemStackHandlerTileEntity;
import fi.dy.masa.enderutilities.inventory.container.ContainerHandyChest;
import fi.dy.masa.enderutilities.inventory.container.base.SlotRange;
import fi.dy.masa.enderutilities.inventory.item.InventoryItemCallback;
import fi.dy.masa.enderutilities.inventory.wrapper.ItemHandlerWrapperPermissions;
import fi.dy.masa.enderutilities.inventory.wrapper.ItemHandlerWrapperSelectiveModifiable;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.nbt.OwnerData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.items.wrapper.PlayerOffhandInvWrapper;

public class TileEntityHandyChest
extends TileEntityEnderUtilitiesInventory
implements IModularInventoryHolder {
    public static final int GUI_ACTION_SELECT_MODULE = 0;
    public static final int GUI_ACTION_LOCK_MODULE = 1;
    public static final int GUI_ACTION_MOVE_ITEMS = 2;
    public static final int GUI_ACTION_SET_QUICK_ACTION = 3;
    public static final int GUI_ACTION_SORT_ITEMS = 4;
    public static final int INV_ID_MEMORY_CARDS = 0;
    public static final int INV_ID_ITEMS = 1;
    public static final int MAX_TIER = 3;
    public static final int[] INV_SIZES = new int[]{18, 36, 54, 104};
    private final IItemHandler itemHandlerMemoryCards;
    protected InventoryItemCallback itemInventory;
    protected ItemHandlerWrapperPermissions wrappedInventory;
    protected int selectedModule;
    protected int chestTier;
    protected int actionMode;
    protected int lockedModules;
    protected int invSize;
    protected final Map<UUID, Long> clickTimes = new HashMap<UUID, Long>();

    public TileEntityHandyChest() {
        super("handy_chest");
        this.itemHandlerBase = new ItemStackHandlerTileEntity(0, 4, 1, false, "Items", this);
        this.itemHandlerMemoryCards = new ItemHandlerWrapperMemoryCards(this.getBaseItemHandler());
    }

    private void initStorage(int invSize, boolean isRemote) {
        this.itemInventory = new InventoryItemCallback(null, invSize, true, isRemote, this);
        this.itemInventory.setContainerItemStack(this.getContainerStack());
        this.wrappedInventory = new ItemHandlerWrapperPermissions(this.itemInventory, null);
        this.itemHandlerExternal = this.wrappedInventory;
    }

    public void onLoad() {
        super.onLoad();
        this.initStorage(this.invSize, this.func_145831_w().field_72995_K);
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        this.chestTier = MathHelper.func_76125_a((int)nbt.func_74771_c("ChestTier"), (int)0, (int)3);
        this.actionMode = nbt.func_74771_c("QuickMode");
        this.setSelectedModule(nbt.func_74771_c("SelModule"));
        this.setLockMask(nbt.func_74771_c("LockMask"));
        this.invSize = INV_SIZES[this.chestTier];
        super.readFromNBTCustom(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74774_a("ChestTier", (byte)this.chestTier);
        nbt.func_74774_a("QuickMode", (byte)this.actionMode);
        nbt.func_74774_a("SelModule", (byte)this.selectedModule);
        nbt.func_74774_a("LockMask", (byte)this.lockedModules);
        super.func_189515_b(nbt);
        return nbt;
    }

    @Override
    public NBTTagCompound getUpdatePacketTag(NBTTagCompound nbt) {
        nbt = super.getUpdatePacketTag(nbt);
        nbt.func_74774_a("tier", (byte)this.chestTier);
        nbt.func_74774_a("msel", (byte)this.selectedModule);
        nbt.func_74774_a("lck", (byte)this.lockedModules);
        return nbt;
    }

    @Override
    public void handleUpdateTag(NBTTagCompound tag) {
        this.chestTier = tag.func_74771_c("tier");
        this.selectedModule = tag.func_74771_c("msel");
        this.setLockMask(tag.func_74771_c("lck"));
        this.invSize = INV_SIZES[this.chestTier];
        this.initStorage(this.invSize, this.func_145831_w().field_72995_K);
        super.handleUpdateTag(tag);
    }

    @Override
    public ItemHandlerWrapperPermissions getWrappedInventoryForContainer(EntityPlayer player) {
        return new ItemHandlerWrapperPermissions(this.itemInventory, (Entity)player);
    }

    public boolean isInventoryAccessible(EntityPlayer player) {
        return this.wrappedInventory.isAccessibleByPlayer(player);
    }

    public IItemHandler getModuleInventory() {
        return this.itemHandlerMemoryCards;
    }

    public int getQuickMode() {
        return this.actionMode;
    }

    public void setQuickMode(int mode) {
        this.actionMode = mode;
    }

    public int getLockMask() {
        return this.lockedModules;
    }

    public void setLockMask(int mask) {
        this.lockedModules = mask;
    }

    public int getSelectedModule() {
        return this.selectedModule;
    }

    public void setSelectedModule(int index) {
        this.selectedModule = MathHelper.func_76125_a((int)index, (int)0, (int)(this.itemHandlerMemoryCards.getSlots() - 1));
    }

    @Override
    public ItemStack getContainerStack() {
        return this.itemHandlerMemoryCards.getStackInSlot(this.selectedModule);
    }

    @Override
    public void inventoryChanged(int inventoryId, int slot) {
        this.itemInventory.setContainerItemStack(this.getContainerStack());
    }

    public int getStorageTier() {
        return this.chestTier;
    }

    public void setStorageTier(World world, int tier) {
        this.chestTier = MathHelper.func_76125_a((int)tier, (int)0, (int)3);
        this.invSize = INV_SIZES[this.chestTier];
        this.initStorage(this.invSize, world.field_72995_K);
    }

    @Override
    public boolean isMovableBy(EntityPlayer player) {
        return this.getLockMask() == 0 || this.isOwner(player);
    }

    @Override
    public void onLeftClickBlock(EntityPlayer player) {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        Long last = this.clickTimes.get(player.func_110124_au());
        if (last != null && this.func_145831_w().func_82737_E() - last < 5L) {
            this.performGuiAction(player, 2, this.actionMode);
            this.func_145831_w().func_184133_a(null, this.func_174877_v(), SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 0.2f, 1.8f);
            this.clickTimes.remove(player.func_110124_au());
        } else {
            this.clickTimes.put(player.func_110124_au(), this.func_145831_w().func_82737_E());
        }
    }

    private void toggleCardLocked(EntityPlayer player, int cardIndex) {
        OwnerData ownerData;
        ItemStack stack = this.itemHandlerMemoryCards.getStackInSlot(cardIndex);
        if (!stack.func_190926_b() && (ownerData = OwnerData.getOwnerDataFromItem(stack)) != null && ownerData.isOwner((Entity)player)) {
            this.lockedModules ^= 1 << cardIndex;
            this.func_70296_d();
        }
    }

    @Override
    public void performGuiAction(EntityPlayer player, int action, int element) {
        if (action == 0 && element >= 0 && element < 4) {
            this.setSelectedModule(element);
            this.inventoryChanged(0, element);
            this.func_70296_d();
        } else if (action == 1 && element >= 0 && element < 4) {
            this.toggleCardLocked(player, element);
        } else if (action == 2 && element >= 0 && element < 6) {
            ItemHandlerWrapperPermissions inventory = this.getWrappedInventoryForContainer(player);
            if (!inventory.isAccessibleByPlayer(player)) {
                return;
            }
            PlayerMainInvWrapper playerMainInv = new PlayerMainInvWrapper(player.field_71071_by);
            PlayerOffhandInvWrapper offhandInv = new PlayerOffhandInvWrapper(player.field_71071_by);
            CombinedInvWrapper playerInv = new CombinedInvWrapper(new IItemHandlerModifiable[]{playerMainInv, offhandInv});
            switch (element) {
                case 0: {
                    InventoryUtils.tryMoveAllItemsWithinSlotRange((IItemHandler)playerInv, inventory, new SlotRange(9, 27), new SlotRange(inventory));
                    break;
                }
                case 1: {
                    InventoryUtils.tryMoveMatchingItemsWithinSlotRange((IItemHandler)playerInv, inventory, new SlotRange(9, 27), new SlotRange(inventory));
                    break;
                }
                case 2: {
                    InventoryUtils.leaveOneFullStackOfEveryItem((IItemHandler)playerInv, inventory, true);
                    break;
                }
                case 3: {
                    InventoryUtils.fillStacksOfMatchingItems(inventory, (IItemHandler)playerInv);
                    break;
                }
                case 4: {
                    InventoryUtils.tryMoveMatchingItems(inventory, (IItemHandler)playerInv);
                    break;
                }
                case 5: {
                    InventoryUtils.tryMoveAllItems(inventory, (IItemHandler)playerInv);
                }
            }
            this.func_70296_d();
        } else if (action == 3 && element >= 0 && element < 6) {
            this.actionMode = element;
        } else if (action == 4 && element >= 0 && element <= 1) {
            if (element == 0) {
                ItemHandlerWrapperPermissions inventory = this.getWrappedInventoryForContainer(player);
                if (!inventory.isAccessibleByPlayer(player)) {
                    return;
                }
                InventoryUtils.sortInventoryWithinRange(inventory, new SlotRange(this.itemInventory));
            } else {
                IItemHandlerModifiable inv = (IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
                InventoryUtils.sortInventoryWithinRange(inv, new SlotRange(9, 27));
            }
        }
    }

    @Override
    public ContainerHandyChest getContainer(EntityPlayer player) {
        return new ContainerHandyChest(player, this);
    }

    @Override
    public Object getGui(EntityPlayer player) {
        return new GuiHandyChest(this.getContainer(player), this);
    }

    public static class ItemHandlerWrapperMemoryCards
    extends ItemHandlerWrapperSelectiveModifiable {
        public ItemHandlerWrapperMemoryCards(IItemHandlerModifiable baseHandler) {
            super(baseHandler);
        }

        @Override
        public boolean isItemValidForSlot(int slot, ItemStack stack) {
            if (stack.func_190926_b()) {
                return false;
            }
            if (!(stack.func_77973_b() instanceof IModule)) {
                return false;
            }
            IModule module = (IModule)stack.func_77973_b();
            ItemModule.ModuleType type = module.getModuleType(stack);
            return type.equals(ItemModule.ModuleType.TYPE_MEMORY_CARD_ITEMS) && module.getModuleTier(stack) >= 6 && module.getModuleTier(stack) <= 12;
        }
    }
}

