/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import fi.dy.masa.enderutilities.gui.client.GuiCreationStation;
import fi.dy.masa.enderutilities.inventory.IModularInventoryHolder;
import fi.dy.masa.enderutilities.inventory.ItemStackHandlerTileEntity;
import fi.dy.masa.enderutilities.inventory.container.ContainerCreationStation;
import fi.dy.masa.enderutilities.inventory.container.base.SlotRange;
import fi.dy.masa.enderutilities.inventory.item.InventoryItemCallback;
import fi.dy.masa.enderutilities.inventory.wrapper.InventoryCraftingPermissions;
import fi.dy.masa.enderutilities.inventory.wrapper.ItemHandlerCraftResult;
import fi.dy.masa.enderutilities.inventory.wrapper.ItemHandlerWrapperPermissions;
import fi.dy.masa.enderutilities.inventory.wrapper.ItemHandlerWrapperSelectiveModifiable;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderFurnace;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.tileentity.TileEntityHandyChest;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.ItemType;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.PlayerOffhandInvWrapper;

public class TileEntityCreationStation
extends TileEntityEnderUtilitiesInventory
implements IModularInventoryHolder,
ITickable {
    public static final int GUI_ACTION_SELECT_MODULE = 0;
    public static final int GUI_ACTION_MOVE_ITEMS = 1;
    public static final int GUI_ACTION_SET_QUICK_ACTION = 2;
    public static final int GUI_ACTION_CLEAR_CRAFTING_GRID = 3;
    public static final int GUI_ACTION_RECIPE_LOAD = 4;
    public static final int GUI_ACTION_RECIPE_STORE = 5;
    public static final int GUI_ACTION_RECIPE_CLEAR = 6;
    public static final int GUI_ACTION_TOGGLE_MODE = 7;
    public static final int GUI_ACTION_SORT_ITEMS = 8;
    public static final int INV_SIZE_ITEMS = 27;
    public static final int INV_ID_MODULES = 1;
    public static final int INV_ID_CRAFTING_LEFT = 2;
    public static final int INV_ID_CRAFTING_RIGHT = 3;
    public static final int INV_ID_FURNACE = 4;
    public static final int COOKTIME_INC_SLOW = 12;
    public static final int COOKTIME_INC_FAST = 30;
    public static final int COOKTIME_DEFAULT = 1200;
    public static final int BURNTIME_USAGE_SLOW = 20;
    public static final int BURNTIME_USAGE_FAST = 120;
    public static final int MODE_BIT_LEFT_CRAFTING_OREDICT = 1;
    public static final int MODE_BIT_LEFT_CRAFTING_KEEPONE = 2;
    public static final int MODE_BIT_LEFT_CRAFTING_AUTOUSE = 4;
    public static final int MODE_BIT_RIGHT_CRAFTING_OREDICT = 8;
    public static final int MODE_BIT_RIGHT_CRAFTING_KEEPONE = 16;
    public static final int MODE_BIT_RIGHT_CRAFTING_AUTOUSE = 32;
    public static final int MODE_BIT_LEFT_FAST = 64;
    public static final int MODE_BIT_RIGHT_FAST = 128;
    public static final int MODE_BIT_SHOW_RECIPE_LEFT = 16384;
    public static final int MODE_BIT_SHOW_RECIPE_RIGHT = 32768;
    private InventoryItemCallback itemInventory;
    private ItemHandlerWrapperPermissions wrappedInventory;
    private final IItemHandler itemHandlerMemoryCards;
    private final ItemStackHandlerTileEntity furnaceInventory;
    private final IItemHandler furnaceInventoryWrapper;
    private final InventoryItemCallback[] craftingInventories;
    private final List<NonNullList<ItemStack>> craftingGridTemplates;
    private final ItemHandlerCraftResult[] craftResults;
    private final NonNullList<ItemStack> recipeItems0;
    private final NonNullList<ItemStack> recipeItems1;
    private int selectedModule;
    private int actionMode;
    private Map<UUID, Long> clickTimes;
    private ItemStack[] smeltingResultCache;
    private int[] burnTimeRemaining;
    private int[] burnTimeFresh;
    private int[] cookTime;
    private boolean[] inputDirty;
    private int modeMask;
    private int recipeLoadClickCount;
    public int lastInteractedCraftingGrid;

    public TileEntityCreationStation() {
        super("creation_station");
        this.itemHandlerBase = new ItemStackHandlerTileEntity(1, 4, 1, false, "Items", this);
        this.itemHandlerMemoryCards = new TileEntityHandyChest.ItemHandlerWrapperMemoryCards(this.getBaseItemHandler());
        this.craftingInventories = new InventoryItemCallback[2];
        this.craftingGridTemplates = new ArrayList<NonNullList<ItemStack>>();
        this.craftingGridTemplates.add(null);
        this.craftingGridTemplates.add(null);
        this.recipeItems0 = NonNullList.func_191197_a((int)10, (Object)ItemStack.field_190927_a);
        this.recipeItems1 = NonNullList.func_191197_a((int)10, (Object)ItemStack.field_190927_a);
        this.craftResults = new ItemHandlerCraftResult[]{new ItemHandlerCraftResult(), new ItemHandlerCraftResult()};
        this.furnaceInventory = new ItemStackHandlerTileEntity(4, 6, 1024, true, "FurnaceItems", this);
        this.furnaceInventoryWrapper = new ItemHandlerWrapperFurnace(this.furnaceInventory);
        this.clickTimes = new HashMap<UUID, Long>();
        this.smeltingResultCache = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a};
        this.burnTimeRemaining = new int[2];
        this.burnTimeFresh = new int[2];
        this.cookTime = new int[2];
        this.inputDirty = new boolean[]{true, true};
        this.modeMask = 0;
    }

    public void onLoad() {
        super.onLoad();
        this.initStorage(this.func_145831_w().field_72995_K);
    }

    private void initStorage(boolean isRemote) {
        this.itemInventory = new InventoryItemCallback(null, 27, true, isRemote, this);
        this.wrappedInventory = new ItemHandlerWrapperPermissions(this.itemInventory, null);
        this.itemHandlerExternal = this.wrappedInventory;
        this.craftingInventories[0] = new InventoryItemCallback(null, 9, 64, false, isRemote, this, "CraftItems_0");
        this.craftingInventories[1] = new InventoryItemCallback(null, 9, 64, false, isRemote, this, "CraftItems_1");
        if (!isRemote) {
            ItemStack containerStack = this.getContainerStack();
            this.itemInventory.setContainerItemStack(containerStack);
            this.craftingInventories[0].setContainerItemStack(containerStack);
            this.craftingInventories[1].setContainerItemStack(containerStack);
        }
        this.readModeMaskFromModule();
        this.loadRecipe(0, this.getRecipeId(0));
        this.loadRecipe(1, this.getRecipeId(1));
    }

    public ItemHandlerWrapperPermissions getItemInventory(EntityPlayer player) {
        return new ItemHandlerWrapperPermissions(this.itemInventory, (Entity)player);
    }

    @Override
    public IItemHandler getWrappedInventoryForContainer(EntityPlayer player) {
        return this.getItemInventory(player);
    }

    public InventoryCraftingPermissions getCraftingInventory(int invId, EntityPlayer player, Container container) {
        ItemHandlerWrapperPermissions invPerm = new ItemHandlerWrapperPermissions(this.craftingInventories[invId], (Entity)player);
        return new InventoryCraftingPermissions(3, 3, invPerm, this.craftResults[invId], player, container);
    }

    public ItemHandlerCraftResult getCraftResultInventory(int invId) {
        return this.craftResults[invId];
    }

    public IItemHandler getMemoryCardInventory() {
        return this.itemHandlerMemoryCards;
    }

    public IItemHandler getFurnaceInventory() {
        return this.furnaceInventoryWrapper;
    }

    @Nullable
    private IItemHandler getWrappedCraftingInventoryFromContainer(int gridId, EntityPlayer player) {
        if (player.field_71070_bA instanceof ContainerCreationStation) {
            return new InvWrapper((IInventory)((ContainerCreationStation)player.field_71070_bA).getCraftingInventory(gridId));
        }
        return null;
    }

    private boolean canAccessCraftingGrid(int gridId, EntityPlayer player) {
        if (player.field_71070_bA instanceof ContainerCreationStation) {
            return ((ContainerCreationStation)player.field_71070_bA).getCraftingInventory(gridId).getBaseInventory().isAccessibleByPlayer(player);
        }
        return false;
    }

    private void updateCraftingResults(EntityPlayer player) {
        if (player.field_71070_bA instanceof ContainerCreationStation) {
            ((ContainerCreationStation)player.field_71070_bA).getCraftingInventory(0).func_70296_d();
            ((ContainerCreationStation)player.field_71070_bA).getCraftingInventory(1).func_70296_d();
        }
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        this.setSelectedModuleSlot(nbt.func_74771_c("SelModule"));
        this.actionMode = nbt.func_74771_c("QuickMode");
        this.modeMask = nbt.func_74771_c("FurnaceMode");
        for (int i = 0; i < 2; ++i) {
            this.burnTimeRemaining[i] = nbt.func_74762_e("BurnTimeRemaining" + i);
            this.burnTimeFresh[i] = nbt.func_74762_e("BurnTimeFresh" + i);
            this.cookTime[i] = nbt.func_74762_e("CookTime" + i);
        }
        super.readFromNBTCustom(nbt);
    }

    @Override
    protected void readItemsFromNBT(NBTTagCompound nbt) {
        super.readItemsFromNBT(nbt);
        this.furnaceInventory.deserializeNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74774_a("QuickMode", (byte)this.actionMode);
        nbt.func_74774_a("SelModule", (byte)this.selectedModule);
        nbt.func_74774_a("FurnaceMode", (byte)(this.modeMask & 0xC0));
        for (int i = 0; i < 2; ++i) {
            nbt.func_74768_a("BurnTimeRemaining" + i, this.burnTimeRemaining[i]);
            nbt.func_74768_a("BurnTimeFresh" + i, this.burnTimeFresh[i]);
            nbt.func_74768_a("CookTime" + i, this.cookTime[i]);
        }
        super.func_189515_b(nbt);
        return nbt;
    }

    @Override
    public void writeItemsToNBT(NBTTagCompound nbt) {
        super.writeItemsToNBT(nbt);
        nbt.func_179237_a(this.furnaceInventory.serializeNBT());
    }

    @Override
    public NBTTagCompound getUpdatePacketTag(NBTTagCompound nbt) {
        nbt = super.getUpdatePacketTag(nbt);
        nbt.func_74774_a("msel", (byte)this.selectedModule);
        return nbt;
    }

    @Override
    public void handleUpdateTag(NBTTagCompound tag) {
        this.selectedModule = tag.func_74771_c("msel");
        super.handleUpdateTag(tag);
    }

    public int getQuickMode() {
        return this.actionMode;
    }

    public void setModeMask(int mask) {
        this.modeMask = mask;
    }

    public void setQuickMode(int mode) {
        this.actionMode = mode;
    }

    public int getSelectedModuleSlot() {
        return this.selectedModule;
    }

    public void setSelectedModuleSlot(int index) {
        this.selectedModule = MathHelper.func_76125_a((int)index, (int)0, (int)(this.itemHandlerMemoryCards.getSlots() - 1));
    }

    public int getModeMask() {
        return this.modeMask;
    }

    protected int readModeMaskFromModule() {
        NBTTagCompound tag;
        this.modeMask &= 0xC0;
        ItemStack containerStack = this.getContainerStack();
        if (!containerStack.func_190926_b() && (tag = NBTUtils.getCompoundTag(containerStack, null, "CreationStation", false)) != null) {
            this.modeMask |= tag.func_74765_d("ConfigMask");
        }
        return this.modeMask;
    }

    protected void writeModeMaskToModule() {
        int modeMask = this.modeMask;
        ItemStack stack = this.itemHandlerMemoryCards.extractItem(this.selectedModule, 1, false);
        if (!stack.func_190926_b()) {
            NBTTagCompound tag = NBTUtils.getCompoundTag(stack, null, "CreationStation", true);
            tag.func_74777_a("ConfigMask", (short)(modeMask & 0xFFFFFF3F));
            this.itemHandlerMemoryCards.insertItem(this.selectedModule, stack, false);
        }
    }

    protected int getRecipeId(int invId) {
        int s = invId == 1 ? 11 : 8;
        return this.modeMask >> s & 7;
    }

    protected void setRecipeId(int invId, int recipeId) {
        int shift = invId == 1 ? 11 : 8;
        int mask = invId == 1 ? 14336 : 1792;
        this.modeMask = this.modeMask & ~mask | (recipeId & 7) << shift;
    }

    public boolean getShowRecipe(int invId) {
        return invId == 1 ? (this.modeMask & 0x8000) != 0 : (this.modeMask & 0x4000) != 0;
    }

    protected void setShowRecipe(int invId, boolean show) {
        int mask;
        int n = mask = invId == 1 ? 32768 : 16384;
        this.modeMask = show ? (this.modeMask |= mask) : (this.modeMask &= ~mask);
    }

    public NonNullList<ItemStack> getRecipeItems(int invId) {
        return invId == 1 ? this.recipeItems1 : this.recipeItems0;
    }

    protected NBTTagCompound getRecipeTag(int invId, int recipeId, boolean create) {
        ItemStack containerStack = this.getContainerStack();
        if (!containerStack.func_190926_b()) {
            return NBTUtils.getCompoundTag(containerStack, "CreationStation", "Recipes_" + invId, create);
        }
        return null;
    }

    protected void loadRecipe(int invId, int recipeId) {
        NBTTagCompound tag = this.getRecipeTag(invId, recipeId, false);
        if (tag != null) {
            this.clearLoadedRecipe(invId);
            NBTUtils.readStoredItemsFromTag(tag, this.getRecipeItems(invId), "Recipe_" + recipeId);
        } else {
            this.removeRecipe(invId, recipeId);
        }
    }

    protected void storeRecipe(IItemHandler invCrafting, int invId, int recipeId) {
        NBTTagCompound tag = this.getRecipeTag(invId = MathHelper.func_76125_a((int)invId, (int)0, (int)1), recipeId, true);
        if (tag != null) {
            int invSize = invCrafting.getSlots();
            NonNullList<ItemStack> items = this.getRecipeItems(invId);
            for (int i = 0; i < invSize; ++i) {
                ItemStack stack = invCrafting.getStackInSlot(i);
                if (!stack.func_190926_b()) {
                    stack = stack.func_77946_l();
                    stack.func_190920_e(1);
                }
                items.set(i, (Object)stack);
            }
            ItemStack stack = this.craftResults[invId].getStackInSlot(0);
            items.set(items.size() - 1, (Object)(stack.func_190926_b() ? ItemStack.field_190927_a : stack.func_77946_l()));
            NBTUtils.writeItemsToTag(tag, items, "Recipe_" + recipeId, true);
        }
    }

    protected void clearLoadedRecipe(int invId) {
        this.getRecipeItems(invId).clear();
    }

    protected void removeRecipe(int invId, int recipeId) {
        NBTTagCompound tag = this.getRecipeTag(invId, recipeId, false);
        if (tag != null) {
            tag.func_82580_o("Recipe_" + recipeId);
        }
        this.clearLoadedRecipe(invId);
    }

    protected boolean addOneSetOfRecipeItemsIntoGrid(IItemHandler invCrafting, int invId, int recipeId, EntityPlayer player) {
        int maskOreDict = (invId = MathHelper.func_76125_a((int)invId, (int)0, (int)1)) == 1 ? 8 : 1;
        boolean useOreDict = (this.modeMask & maskOreDict) != 0;
        IItemHandlerModifiable playerInv = (IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
        CombinedInvWrapper invWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemInventory, playerInv});
        NonNullList<ItemStack> template = this.getRecipeItems(invId);
        InventoryUtils.clearInventoryToMatchTemplate(invCrafting, (IItemHandler)invWrapper, template);
        return InventoryUtils.restockInventoryBasedOnTemplate(invCrafting, (IItemHandler)invWrapper, template, 1, true, useOreDict);
    }

    protected void fillCraftingGrid(IItemHandler invCrafting, int invId, int recipeId, EntityPlayer player) {
        invId = MathHelper.func_76125_a((int)invId, (int)0, (int)1);
        int largestStack = InventoryUtils.getLargestExistingStackSize(invCrafting);
        if (largestStack == 1) {
            largestStack = 64;
        }
        NonNullList<ItemStack> template = InventoryUtils.createInventorySnapshot(invCrafting);
        int maskOreDict = invId == 1 ? 8 : 1;
        boolean useOreDict = (this.modeMask & maskOreDict) != 0;
        Map<ItemType, Integer> slotCounts = InventoryUtils.getSlotCountPerItem(invCrafting);
        if (InventoryUtils.tryMoveAllItems(invCrafting, this.itemInventory) == InventoryUtils.InvResult.MOVED_ALL) {
            IItemHandlerModifiable playerInv = (IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
            CombinedInvWrapper invWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemInventory, playerInv});
            for (Map.Entry<ItemType, Integer> entry : slotCounts.entrySet()) {
                int numSlots;
                int numFound;
                int maxSize;
                ItemType item = entry.getKey();
                if (item.getStack().func_77976_d() == 1 || (maxSize = (numFound = InventoryUtils.getNumberOfMatchingItemsInInventory((IItemHandler)invWrapper, item.getStack(), useOreDict)) / (numSlots = entry.getValue().intValue())) >= largestStack) continue;
                largestStack = maxSize;
            }
            InventoryUtils.restockInventoryBasedOnTemplate(invCrafting, (IItemHandler)invWrapper, template, largestStack, false, useOreDict);
        }
    }

    protected InventoryUtils.InvResult clearCraftingGrid(IItemHandler invCrafting, int invId, EntityPlayer player) {
        if (InventoryUtils.tryMoveAllItems(invCrafting, this.itemInventory) != InventoryUtils.InvResult.MOVED_ALL) {
            return InventoryUtils.tryMoveAllItems(invCrafting, (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP));
        }
        return InventoryUtils.InvResult.MOVED_ALL;
    }

    public boolean canCraftItems(IItemHandler invCrafting, int invId) {
        boolean useOreDict;
        if (invCrafting == null) {
            return false;
        }
        int maskKeepOne = (invId = MathHelper.func_76125_a((int)invId, (int)0, (int)1)) == 1 ? 16 : 2;
        int maskAutoUse = invId == 1 ? 32 : 4;
        this.craftingGridTemplates.set(invId, null);
        if ((this.modeMask & maskAutoUse) != 0) {
            this.craftingGridTemplates.set(invId, InventoryUtils.createInventorySnapshot(invCrafting));
        }
        if ((this.modeMask & maskKeepOne) == 0) {
            return true;
        }
        if ((this.modeMask & maskAutoUse) == 0 && InventoryUtils.getMinNonEmptyStackSize(invCrafting) <= 1) {
            return false;
        }
        int maskOreDict = invId == 1 ? 8 : 1;
        boolean bl = useOreDict = (this.modeMask & maskOreDict) != 0;
        return InventoryUtils.getMinNonEmptyStackSize(invCrafting) > 1 || InventoryUtils.checkInventoryHasAllItems(this.itemInventory, invCrafting, 1, useOreDict);
    }

    public void restockCraftingGrid(IItemHandler invCrafting, int invId) {
        int maskAutoUse;
        invId = MathHelper.func_76125_a((int)invId, (int)0, (int)1);
        NonNullList<ItemStack> template = this.craftingGridTemplates.get(invId);
        if (invCrafting == null || template == null) {
            return;
        }
        this.recipeLoadClickCount = 0;
        int n = maskAutoUse = invId == 1 ? 32 : 4;
        if ((this.modeMask & maskAutoUse) == 0) {
            return;
        }
        int maskOreDict = invId == 1 ? 8 : 1;
        boolean useOreDict = (this.modeMask & maskOreDict) != 0;
        InventoryUtils.clearInventoryToMatchTemplate(invCrafting, this.itemInventory, template);
        InventoryUtils.restockInventoryBasedOnTemplate(invCrafting, this.itemInventory, template, 1, true, useOreDict);
        this.craftingGridTemplates.set(invId, null);
    }

    @Override
    public ItemStack getContainerStack() {
        return this.itemHandlerMemoryCards.getStackInSlot(this.selectedModule);
    }

    @Override
    public void inventoryChanged(int inventoryId, int slot) {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (inventoryId == 4) {
            this.inputDirty[1] = true;
            this.inputDirty[0] = true;
            return;
        }
        ItemStack containerStack = this.getContainerStack();
        this.itemInventory.setContainerItemStack(containerStack);
        this.craftingInventories[0].setContainerItemStack(containerStack);
        this.craftingInventories[1].setContainerItemStack(containerStack);
        this.readModeMaskFromModule();
        this.loadRecipe(0, this.getRecipeId(0));
        this.loadRecipe(1, this.getRecipeId(1));
    }

    public boolean isInventoryAccessible(EntityPlayer player) {
        return this.wrappedInventory.isAccessibleByPlayer(player);
    }

    @Override
    public void onLeftClickBlock(EntityPlayer player) {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        Long last = this.clickTimes.get(player.func_110124_au());
        if (last != null && this.func_145831_w().func_82737_E() - last < 5L) {
            this.performGuiAction(player, 1, this.actionMode);
            this.func_145831_w().func_184133_a(null, this.func_174877_v(), SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 0.2f, 1.8f);
            this.clickTimes.remove(player.func_110124_au());
        } else {
            this.clickTimes.put(player.func_110124_au(), this.func_145831_w().func_82737_E());
        }
    }

    @Override
    public void performGuiAction(EntityPlayer player, int action, int element) {
        if (action == 0 && element >= 0 && element < 4) {
            this.setSelectedModuleSlot(element);
            this.inventoryChanged(1, element);
            this.func_70296_d();
            this.updateCraftingResults(player);
        } else if (action == 1 && element >= 0 && element < 6) {
            ItemHandlerWrapperPermissions inventory = new ItemHandlerWrapperPermissions(this.itemInventory, (Entity)player);
            if (!inventory.isAccessibleByPlayer(player)) {
                return;
            }
            IItemHandlerModifiable playerMainInv = (IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
            PlayerOffhandInvWrapper offhandInv = new PlayerOffhandInvWrapper(player.field_71071_by);
            CombinedInvWrapper playerInv = new CombinedInvWrapper(new IItemHandlerModifiable[]{playerMainInv, offhandInv});
            switch (element) {
                case 0: {
                    InventoryUtils.tryMoveAllItemsWithinSlotRange((IItemHandler)playerInv, inventory, new SlotRange(9, 27), new SlotRange(inventory));
                    break;
                }
                case 1: {
                    InventoryUtils.tryMoveMatchingItemsWithinSlotRange((IItemHandler)playerInv, inventory, new SlotRange(9, 27), new SlotRange(inventory));
                    break;
                }
                case 2: {
                    InventoryUtils.leaveOneFullStackOfEveryItem((IItemHandler)playerInv, inventory, true);
                    break;
                }
                case 3: {
                    InventoryUtils.fillStacksOfMatchingItems(inventory, (IItemHandler)playerInv);
                    break;
                }
                case 4: {
                    InventoryUtils.tryMoveMatchingItems(inventory, (IItemHandler)playerInv);
                    break;
                }
                case 5: {
                    InventoryUtils.tryMoveAllItems(inventory, (IItemHandler)playerInv);
                }
            }
        } else if (action == 2 && element >= 0 && element < 6) {
            this.actionMode = element;
        } else if (action == 3 && element >= 0 && element <= 1) {
            int gridId = element;
            if (!this.canAccessCraftingGrid(gridId, player)) {
                return;
            }
            IItemHandler inv = this.getWrappedCraftingInventoryFromContainer(gridId, player);
            if (InventoryUtils.isInventoryEmpty(inv)) {
                this.setShowRecipe(gridId, false);
                this.clearLoadedRecipe(gridId);
                this.writeModeMaskToModule();
            } else {
                this.clearCraftingGrid(inv, gridId, player);
            }
            this.recipeLoadClickCount = 0;
            this.lastInteractedCraftingGrid = gridId;
        } else if (action == 4 && element >= 0 && element < 10) {
            int gridId = element / 5;
            int recipeId = element % 5;
            if (!this.canAccessCraftingGrid(gridId, player)) {
                return;
            }
            IItemHandler inv = this.getWrappedCraftingInventoryFromContainer(gridId, player);
            if (this.getRecipeId(gridId) == recipeId && this.getShowRecipe(gridId)) {
                if (this.recipeLoadClickCount == 0) {
                    if (this.addOneSetOfRecipeItemsIntoGrid(inv, gridId, recipeId, player)) {
                        ++this.recipeLoadClickCount;
                    }
                } else {
                    this.fillCraftingGrid(inv, gridId, recipeId, player);
                }
            } else {
                this.loadRecipe(gridId, recipeId);
                this.setRecipeId(gridId, recipeId);
                this.recipeLoadClickCount = 0;
            }
            this.setShowRecipe(gridId, true);
            this.writeModeMaskToModule();
            this.lastInteractedCraftingGrid = gridId;
        } else if (action == 5 && element >= 0 && element < 10) {
            int gridId = element / 5;
            int recipeId = element % 5;
            if (!this.canAccessCraftingGrid(gridId, player)) {
                return;
            }
            IItemHandler inv = this.getWrappedCraftingInventoryFromContainer(gridId, player);
            this.storeRecipe(inv, gridId, recipeId);
            this.setShowRecipe(gridId, true);
            this.setRecipeId(gridId, recipeId);
            this.writeModeMaskToModule();
            this.lastInteractedCraftingGrid = gridId;
        } else if (action == 6 && element >= 0 && element < 10) {
            int gridId = element / 5;
            int recipeId = element % 5;
            if (!this.canAccessCraftingGrid(gridId, player)) {
                return;
            }
            this.removeRecipe(gridId, recipeId);
            this.setShowRecipe(gridId, false);
            this.writeModeMaskToModule();
            this.recipeLoadClickCount = 0;
            this.lastInteractedCraftingGrid = gridId;
        } else if (action == 7 && element >= 0 && element < 8) {
            switch (element) {
                case 0: {
                    this.modeMask ^= 1;
                    break;
                }
                case 1: {
                    this.modeMask ^= 2;
                    break;
                }
                case 2: {
                    this.modeMask ^= 4;
                    break;
                }
                case 3: {
                    this.modeMask ^= 0x20;
                    break;
                }
                case 4: {
                    this.modeMask ^= 0x10;
                    break;
                }
                case 5: {
                    this.modeMask ^= 8;
                    break;
                }
                case 6: {
                    this.modeMask ^= 0x40;
                    break;
                }
                case 7: {
                    this.modeMask ^= 0x80;
                    break;
                }
            }
            if (element <= 5) {
                this.lastInteractedCraftingGrid = element / 3;
            }
            this.writeModeMaskToModule();
        } else if (action == 8 && element >= 0 && element <= 1) {
            if (element == 0) {
                ItemHandlerWrapperPermissions inventory = new ItemHandlerWrapperPermissions(this.itemInventory, (Entity)player);
                if (!inventory.isAccessibleByPlayer(player)) {
                    return;
                }
                InventoryUtils.sortInventoryWithinRange(this.itemInventory, new SlotRange(this.itemInventory));
            } else {
                IItemHandlerModifiable inv = (IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
                InventoryUtils.sortInventoryWithinRange(inv, new SlotRange(9, 27));
            }
        }
    }

    private void updateSmeltingResult(int id) {
        if (this.inputDirty[id]) {
            ItemStack inputStack = this.furnaceInventory.getStackInSlot(id * 3);
            this.smeltingResultCache[id] = !inputStack.func_190926_b() ? FurnaceRecipes.func_77602_a().func_151395_a(inputStack) : ItemStack.field_190927_a;
            this.inputDirty[id] = false;
        }
    }

    private boolean hasFuelAvailable(int id) {
        return TileEntityEnderFurnace.consumeFuelItem(this.furnaceInventory, id * 3 + 1, true) > 0;
    }

    private int consumeFuelItem(int id) {
        int fuelSlot = id * 3 + 1;
        int burnTime = TileEntityEnderFurnace.consumeFuelItem(this.furnaceInventory, fuelSlot, false);
        if (burnTime > 0) {
            this.burnTimeFresh[id] = burnTime;
        }
        return burnTime;
    }

    private boolean canSmelt(int id) {
        ItemStack inputStack = this.furnaceInventory.getStackInSlot(id * 3);
        if (inputStack.func_190926_b() || this.smeltingResultCache[id].func_190926_b()) {
            return false;
        }
        int amount = 0;
        ItemStack outputStack = this.furnaceInventory.getStackInSlot(id * 3 + 2);
        if (!outputStack.func_190926_b()) {
            if (!InventoryUtils.areItemStacksEqual(this.smeltingResultCache[id], outputStack)) {
                return false;
            }
            amount = outputStack.func_190916_E();
        }
        return this.furnaceInventory.getInventoryStackLimit() - amount >= this.smeltingResultCache[id].func_190916_E();
    }

    private void smeltItem(int id) {
        if (this.canSmelt(id)) {
            this.furnaceInventory.insertItem(id * 3 + 2, this.smeltingResultCache[id], false);
            this.furnaceInventory.extractItem(id * 3, 1, false);
            if (this.furnaceInventory.getStackInSlot(id * 3).func_190926_b()) {
                this.inputDirty[id] = true;
            }
        }
    }

    private void smeltingLogic(int id) {
        this.updateSmeltingResult(id);
        boolean dirty = false;
        boolean hasFuel = this.hasFuelAvailable(id);
        boolean isFastMode = id == 0 ? (this.modeMask & 0x40) != 0 : (this.modeMask & 0x80) != 0;
        int cookTimeIncrement = 12;
        if (this.burnTimeRemaining[id] == 0 && !hasFuel) {
            return;
        }
        if (isFastMode) {
            cookTimeIncrement = 30;
        }
        boolean canSmelt = this.canSmelt(id);
        if (this.burnTimeRemaining[id] > 0) {
            int btUse;
            int n = btUse = isFastMode ? 120 : 20;
            if (btUse > this.burnTimeRemaining[id]) {
                if (hasFuel && canSmelt) {
                    int n2 = id;
                    this.burnTimeRemaining[n2] = this.burnTimeRemaining[n2] + this.consumeFuelItem(id);
                    hasFuel = this.hasFuelAvailable(id);
                } else {
                    cookTimeIncrement = this.burnTimeRemaining[id] * cookTimeIncrement / btUse;
                    btUse = this.burnTimeRemaining[id];
                }
            }
            int n3 = id;
            this.burnTimeRemaining[n3] = this.burnTimeRemaining[n3] - btUse;
            dirty = true;
        } else if (canSmelt && hasFuel) {
            int n = id;
            this.burnTimeRemaining[n] = this.burnTimeRemaining[n] + this.consumeFuelItem(id);
            hasFuel = this.hasFuelAvailable(id);
            dirty = true;
        }
        if (canSmelt) {
            int n = id;
            this.cookTime[n] = this.cookTime[n] + cookTimeIncrement;
            if (this.cookTime[id] >= 1200) {
                this.smeltItem(id);
                canSmelt = this.canSmelt(id);
                if (canSmelt && this.cookTime[id] > 1200) {
                    int n4 = id;
                    this.cookTime[n4] = this.cookTime[n4] - 1200;
                } else {
                    this.cookTime[id] = 0;
                }
            }
            if (this.burnTimeRemaining[id] == 0 && hasFuel && canSmelt) {
                int n5 = id;
                this.burnTimeRemaining[n5] = this.burnTimeRemaining[n5] + this.consumeFuelItem(id);
            }
            dirty = true;
        } else if (this.cookTime[id] > 0) {
            int n = id;
            this.cookTime[n] = this.cookTime[n] - Math.min(this.cookTime[id], 6);
            dirty = true;
        }
        if (dirty) {
            this.func_70296_d();
        }
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.smeltingLogic(0);
            this.smeltingLogic(1);
        }
    }

    public int getSmeltProgressScaled(int id, int i) {
        return this.cookTime[id] * i / 1200;
    }

    public int getBurnTimeRemainingScaled(int id, int i) {
        if (this.burnTimeFresh[id] == 0) {
            return 0;
        }
        return this.burnTimeRemaining[id] * i / this.burnTimeFresh[id];
    }

    @Override
    public ContainerCreationStation getContainer(EntityPlayer player) {
        return new ContainerCreationStation(player, this);
    }

    @Override
    public Object getGui(EntityPlayer player) {
        return new GuiCreationStation(this.getContainer(player), this);
    }

    private class ItemHandlerWrapperFurnace
    extends ItemHandlerWrapperSelectiveModifiable {
        public ItemHandlerWrapperFurnace(IItemHandlerModifiable baseHandler) {
            super(baseHandler);
        }

        @Override
        public boolean isItemValidForSlot(int slot, ItemStack stack) {
            if (stack.func_190926_b()) {
                return false;
            }
            if (slot == 0 || slot == 3) {
                return !FurnaceRecipes.func_77602_a().func_151395_a(stack).func_190926_b();
            }
            return (slot == 1 || slot == 4) && TileEntityEnderFurnace.isItemFuel(stack);
        }
    }
}

