/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import fi.dy.masa.enderutilities.block.BlockBarrel;
import fi.dy.masa.enderutilities.config.Configs;
import fi.dy.masa.enderutilities.gui.client.GuiBarrel;
import fi.dy.masa.enderutilities.inventory.ItemStackHandlerLockable;
import fi.dy.masa.enderutilities.inventory.ItemStackHandlerTileEntity;
import fi.dy.masa.enderutilities.inventory.container.ContainerBarrel;
import fi.dy.masa.enderutilities.inventory.wrapper.ItemHandlerWrapperContainer;
import fi.dy.masa.enderutilities.inventory.wrapper.ItemHandlerWrapperCreative;
import fi.dy.masa.enderutilities.item.part.ItemEnderPart;
import fi.dy.masa.enderutilities.network.message.ISyncableTile;
import fi.dy.masa.enderutilities.network.message.MessageSyncTileEntity;
import fi.dy.masa.enderutilities.reference.HotKeys;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityBarrel
extends TileEntityEnderUtilitiesInventory
implements ISyncableTile {
    private ItemStackHandlerLockable itemHandlerLockable;
    private ItemHandlerBarrelUpgrades itemHandlerUpgrades;
    private Map<UUID, Long> rightClickTimes = new HashMap<UUID, Long>();
    private List<EnumFacing> labels = new ArrayList<EnumFacing>();
    private int labelMask;
    private int maxStacks = 64;
    private boolean hasStructureUpgrade;
    private boolean hasVoidUpgrade;
    private ItemStack cachedStack = ItemStack.field_190927_a;
    public ItemStack renderStack = ItemStack.field_190927_a;
    public String cachedStackSizeString;
    public float cachedFullness;

    public TileEntityBarrel() {
        super("barrel", true);
        this.initStorage();
    }

    private void initStorage() {
        int maxUpgrades = Configs.barrelMaxCapacityUpgrades;
        this.itemHandlerLockable = new ItemStackHandlerLockable(0, 1, 4096, true, "Items", this);
        this.itemHandlerBase = this.itemHandlerLockable;
        this.itemHandlerUpgrades = new ItemHandlerBarrelUpgrades(1, 4, maxUpgrades, true, "ItemsUpgrades", this);
        this.itemHandlerExternal = new ItemHandlerBarrel(this.itemHandlerLockable, this);
    }

    public ItemStackHandlerLockable getInventoryBarrel() {
        return this.itemHandlerLockable;
    }

    public IItemHandler getUpgradeInventory() {
        return new ItemHandlerWrapperContainer(this.itemHandlerUpgrades, this.itemHandlerUpgrades, true);
    }

    public boolean retainsContentsWhenBroken() {
        return this.hasStructureUpgrade;
    }

    @Override
    protected boolean hasCamouflageAbility() {
        return true;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean isOverSpillCapacity() {
        ItemStack stack = this.itemHandlerLockable.getStackInSlot(0);
        return !stack.func_190926_b() && stack.func_190916_E() > 4096;
    }

    public List<EnumFacing> getLabeledFaces() {
        return this.labels;
    }

    public boolean hasVoidUpgrade() {
        return this.hasVoidUpgrade;
    }

    @Override
    protected void readItemsFromNBT(NBTTagCompound nbt) {
        this.itemHandlerUpgrades.deserializeNBT(nbt);
        super.readItemsFromNBT(nbt);
        this.hasStructureUpgrade = !this.itemHandlerUpgrades.getStackInSlot(1).func_190926_b();
        this.hasVoidUpgrade = !this.itemHandlerUpgrades.getStackInSlot(3).func_190926_b();
        ItemStack stack = this.itemHandlerLockable.getStackInSlot(0);
        this.cachedStack = stack.func_190926_b() ? ItemStack.field_190927_a : stack.func_77946_l();
    }

    @Override
    public void writeItemsToNBT(NBTTagCompound nbt) {
        nbt.func_179237_a(this.itemHandlerUpgrades.serializeNBT());
        super.writeItemsToNBT(nbt);
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        super.readFromNBTCustom(nbt);
        this.setCreative(nbt.func_74767_n("Creative"));
        this.setLabelsFromMask(nbt.func_74771_c("Labels"));
        this.updateLabels(false);
        this.setMaxStacksFromUpgrades();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_74774_a("Labels", (byte)this.labelMask);
        nbt.func_74757_a("Creative", this.isCreative());
        return nbt;
    }

    @Override
    public NBTTagCompound getUpdatePacketTag(NBTTagCompound nbt) {
        nbt = super.getUpdatePacketTag(nbt);
        ItemStack stack = this.itemHandlerExternal.getStackInSlot(0);
        if (!stack.func_190926_b()) {
            nbt.func_74782_a("st", (NBTBase)NBTUtils.storeItemStackInTag(stack, new NBTTagCompound()));
        }
        if (!(stack = this.itemHandlerLockable.getTemplateStackInSlot(0)).func_190926_b()) {
            nbt.func_74782_a("stl", (NBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
        short mask = 0;
        mask = (short)(mask | (this.isCreative() ? 32768 : 0));
        mask = (short)(mask | (this.itemHandlerLockable.isSlotLocked(0) ? 16384 : 0));
        mask = (short)(mask | (this.hasStructureUpgrade ? 2048 : 0));
        mask = (short)(mask | (this.hasVoidUpgrade ? 1024 : 0));
        mask = (short)(mask | this.getLabelMask(true) & 0xFF);
        nbt.func_74777_a("msk", mask);
        nbt.func_74768_a("mxs", this.maxStacks);
        return nbt;
    }

    @Override
    public void handleUpdateTag(NBTTagCompound tag) {
        short mask = tag.func_74765_d("msk");
        this.setCreative((mask & 0x8000) != 0);
        this.itemHandlerLockable.setSlotLocked(0, (mask & 0x4000) != 0);
        this.hasStructureUpgrade = (mask & 0x800) != 0;
        this.hasVoidUpgrade = (mask & 0x400) != 0;
        this.setLabelsFromMask(mask & 0xFF);
        if (tag.func_150297_b("stl", 10)) {
            this.itemHandlerLockable.setTemplateStackInSlot(0, new ItemStack(tag.func_74775_l("stl")));
        }
        if (tag.func_150297_b("st", 10)) {
            this.itemHandlerLockable.setStackInSlot(0, NBTUtils.loadItemStackFromTag(tag.func_74775_l("st")));
        }
        this.setMaxStacks(tag.func_74762_e("mxs"));
        this.updateCachedStack();
        super.handleUpdateTag(tag);
    }

    @Override
    public void func_189667_a(Rotation rotationIn) {
        ArrayList<EnumFacing> newList = new ArrayList<EnumFacing>();
        for (EnumFacing side : this.labels) {
            newList.add(rotationIn.func_185831_a(side));
        }
        this.labels.clear();
        this.labels.addAll(newList);
        this.labelMask = this.getLabelMask(false);
        super.func_189667_a(rotationIn);
    }

    @Override
    public void setFacing(EnumFacing facing) {
        super.setFacing(facing);
        this.updateLabels(true);
    }

    private void updateLabels(boolean notifyBlockUpdate) {
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            if (this.itemHandlerUpgrades.getStackInSlot(0).func_190926_b()) {
                this.labels.clear();
            }
            if (!this.labels.contains(this.getFacing())) {
                this.labels.add(this.getFacing());
            }
            this.labelMask = this.getLabelMask(false);
            if (notifyBlockUpdate) {
                this.notifyBlockUpdate(this.func_174877_v());
            }
        }
    }

    private void setMaxStacksFromUpgrades() {
        ItemStack stackCapacityUpgrades = this.itemHandlerUpgrades.getStackInSlot(2);
        int upgrades = !stackCapacityUpgrades.func_190926_b() ? stackCapacityUpgrades.func_190916_E() : 0;
        this.setMaxStacks(64 + upgrades * Configs.barrelCapacityUpgradeStacksPer);
    }

    private void setMaxStacks(int maxStacks) {
        this.maxStacks = maxStacks;
        ItemStack stack = this.itemHandlerLockable.getStackInSlot(0);
        this.itemHandlerLockable.setStackLimit(this.maxStacks * (!stack.func_190926_b() ? stack.func_77976_d() : 64));
    }

    public int getLabelMask(boolean cached) {
        if (cached) {
            return this.labelMask;
        }
        int mask = 0;
        for (EnumFacing side : this.labels) {
            mask |= 1 << side.func_176745_a();
        }
        return mask;
    }

    private void setLabelsFromMask(int mask) {
        this.labels.clear();
        this.labelMask = mask;
        for (EnumFacing side : EnumFacing.values()) {
            if ((mask & 1 << side.func_176745_a()) == 0) continue;
            this.labels.add(side);
        }
    }

    private boolean tryApplyLabel(EntityPlayer player, EnumHand hand, EnumFacing side) {
        if (!this.labels.contains(side) && side != this.getFacing() && this.tryApplyUpgrade(player, hand, 0, EnderUtilitiesItems.ENDER_PART, 70)) {
            this.labels.add(side);
            this.updateLabels(false);
            return true;
        }
        return false;
    }

    private boolean tryApplyUpgrade(EntityPlayer player, EnumHand hand, int slot, Item item, int meta) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == item && stack.func_77960_j() == meta && this.itemHandlerUpgrades.insertItem(slot, new ItemStack((Item)EnderUtilitiesItems.ENDER_PART, 1, meta), false).func_190926_b()) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
                player.func_184611_a(hand, stack.func_190926_b() ? ItemStack.field_190927_a : stack);
            }
            this.func_145831_w().func_184133_a(null, this.func_174877_v(), SoundEvents.field_187626_cN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    private boolean tryToggleLocked(ItemStack stack) {
        if (ItemEnderPart.itemMatches(stack, ItemEnderPart.ItemPartType.STORAGE_KEY)) {
            this.itemHandlerLockable.setTemplateStackInSlot(0, this.itemHandlerLockable.getStackInSlot(0));
            this.itemHandlerLockable.toggleSlotLocked(0);
            int[] ints = new int[]{this.itemHandlerLockable.isSlotLocked(0) ? 1 : 0};
            ItemStack[] stacks = new ItemStack[]{this.itemHandlerLockable.getTemplateStackInSlot(0)};
            this.sendPacketToWatchers(new MessageSyncTileEntity(this.func_174877_v(), ints, stacks));
            this.func_145831_w().func_184133_a(null, this.func_174877_v(), SoundEvents.field_187629_cO, SoundCategory.BLOCKS, 0.7f, 1.0f);
            return true;
        }
        return false;
    }

    private boolean tryToggleCreativeMode(EntityPlayer player, ItemStack stack) {
        if (ItemEnderPart.itemMatches(stack, ItemEnderPart.ItemPartType.CREATIVE_STORAGE_KEY)) {
            return this.toggleCreativeMode(player, true);
        }
        return false;
    }

    @Override
    public boolean onRightClickBlock(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.func_145831_w().field_72995_K) {
            return !player.func_70093_af();
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b()) {
            if (this.tryToggleLocked(stack) || this.tryApplyLabel(player, hand, side) || this.tryApplyUpgrade(player, hand, 1, EnderUtilitiesItems.ENDER_PART, 71) || this.tryApplyUpgrade(player, hand, 2, EnderUtilitiesItems.ENDER_PART, 72) || this.tryApplyUpgrade(player, hand, 3, EnderUtilitiesItems.ENDER_PART, 73) || this.tryToggleCreativeMode(player, stack)) {
                this.notifyBlockUpdate(this.func_174877_v());
                return true;
            }
            player.func_184611_a(hand, (stack = InventoryUtils.tryInsertItemStackToInventory(this.itemHandlerExternal, stack)).func_190926_b() ? ItemStack.field_190927_a : stack);
        }
        long time = System.currentTimeMillis();
        Long last = this.rightClickTimes.get(player.func_110124_au());
        if (last != null && time - last < 300L) {
            InventoryUtils.tryMoveMatchingItems((IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), this.itemHandlerExternal);
            player.field_71070_bA.func_75142_b();
        }
        this.rightClickTimes.put(player.func_110124_au(), time);
        return !player.func_70093_af();
    }

    @Override
    public boolean onInputAction(int keyMask, EntityPlayer player, RayTraceResult trace, World world, BlockPos pos) {
        if (HotKeys.EnumKey.MIDDLE_CLICK.matches(keyMask, 0, 65536)) {
            Vec3d hit = trace.field_72307_f;
            return this.tryApplyCamouflage(player, EnumHand.OFF_HAND, trace.field_178784_b, (float)hit.field_72450_a, (float)hit.field_72448_b, (float)hit.field_72449_c);
        }
        return false;
    }

    @Override
    public void onLeftClickBlock(EntityPlayer player) {
        long time = System.currentTimeMillis();
        Long last = this.rightClickTimes.get(player.func_110124_au());
        if (last != null && time - last < 80L) {
            return;
        }
        this.rightClickTimes.put(player.func_110124_au(), time);
        int amount = player.func_70093_af() ? 1 : 64;
        ItemStack stack = this.itemHandlerExternal.extractItem(0, amount, false);
        if (!stack.func_190926_b()) {
            EnumFacing side = this.getFacing();
            RayTraceResult rayTrace = EntityUtils.getRayTraceFromPlayer(this.func_145831_w(), player, false);
            if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK && this.func_174877_v().equals((Object)rayTrace.func_178782_a())) {
                side = rayTrace.field_178784_b;
            }
            EntityUtils.dropItemStacksInWorld(this.func_145831_w(), this.getSpawnedItemPosition(side), stack, -1, true, false);
        }
    }

    private boolean toggleCreativeMode(EntityPlayer player, boolean isStorageKey) {
        if (isStorageKey || player.field_71075_bZ.field_75098_d) {
            this.setCreative(!this.isCreative());
            this.func_70296_d();
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            state = state.func_177226_a((IProperty)BlockBarrel.CREATIVE, (Comparable)Boolean.valueOf(this.isCreative()));
            this.func_145831_w().func_175656_a(this.func_174877_v(), state);
            if (isStorageKey) {
                this.func_145831_w().func_184133_a(null, this.func_174877_v(), SoundEvents.field_187629_cO, SoundCategory.BLOCKS, 0.7f, 1.0f);
            }
            return true;
        }
        return false;
    }

    @Override
    public void performGuiAction(EntityPlayer player, int action, int element) {
        if (action == 1) {
            this.toggleCreativeMode(player, false);
        }
    }

    @Override
    public void inventoryChanged(int inventoryId, int slot) {
        if (this.func_145831_w() != null && this.func_145831_w().field_72995_K) {
            return;
        }
        if (inventoryId == 0) {
            ItemStack stack = this.itemHandlerLockable.getStackInSlot(0);
            if (!InventoryUtils.areItemStacksEqual(stack, this.cachedStack)) {
                this.setMaxStacksFromUpgrades();
                this.cachedStack = stack.func_190926_b() ? ItemStack.field_190927_a : stack.func_77946_l();
                this.sendPacketToWatchers(new MessageSyncTileEntity(this.func_174877_v(), this.cachedStack));
            } else if (!stack.func_190926_b() && stack.func_190916_E() != this.cachedStack.func_190916_E()) {
                this.cachedStack.func_190920_e(stack.func_190916_E());
                this.sendPacketToWatchers(new MessageSyncTileEntity(this.func_174877_v(), this.cachedStack.func_190916_E(), this.maxStacks));
            }
        } else if (inventoryId == 1) {
            if (slot == 0) {
                ItemStack stack = this.itemHandlerUpgrades.getStackInSlot(0);
                if (stack.func_190926_b() || stack.func_190916_E() < this.labels.size() - 1) {
                    this.labels.clear();
                    this.labels.add(this.getFacing());
                }
                this.updateLabels(true);
            } else if (slot == 1) {
                this.hasStructureUpgrade = !this.itemHandlerUpgrades.getStackInSlot(1).func_190926_b();
                this.notifyBlockUpdate(this.func_174877_v());
            } else if (slot == 2) {
                this.setMaxStacksFromUpgrades();
            } else if (slot == 3) {
                this.hasVoidUpgrade = !this.itemHandlerUpgrades.getStackInSlot(3).func_190926_b();
                this.notifyBlockUpdate(this.func_174877_v());
            }
            int stackSize = this.cachedStack.func_190926_b() ? 0 : this.cachedStack.func_190916_E();
            this.sendPacketToWatchers(new MessageSyncTileEntity(this.func_174877_v(), stackSize, this.maxStacks));
        }
    }

    @Override
    public void syncTile(int[] intValues, ItemStack[] stacks) {
        if (stacks.length == 1 && intValues.length == 1) {
            this.itemHandlerLockable.setSlotLocked(0, intValues[0] == 1);
            this.itemHandlerLockable.setTemplateStackInSlot(0, stacks[0]);
        } else if (stacks.length == 1) {
            this.itemHandlerLockable.setStackInSlot(0, stacks[0]);
        } else if (intValues.length == 2) {
            this.setMaxStacks(intValues[1]);
            if (!this.itemHandlerLockable.getStackInSlot(0).func_190926_b()) {
                this.itemHandlerLockable.getStackInSlot(0).func_190920_e(intValues[0]);
            }
        }
        this.updateCachedStack();
    }

    private void updateCachedStack() {
        ItemStack stackStored = this.itemHandlerLockable.getStackInSlot(0);
        ItemStack stackTemplate = this.itemHandlerLockable.getTemplateStackInSlot(0);
        ItemStack itemStack = this.renderStack = !stackStored.func_190926_b() ? stackStored : stackTemplate;
        if (!stackStored.func_190926_b()) {
            int count = stackStored.func_190916_E();
            int max = stackStored.func_77976_d();
            int stacks = count / max;
            int remainder = count % max;
            this.cachedStackSizeString = max == 1 || count <= max ? String.valueOf(count) : (remainder != 0 ? String.format("%dx%d + %d", stacks, max, remainder) : String.format("%dx%d", stacks, max));
            this.cachedFullness = (float)count / ((float)this.maxStacks * (float)max);
        } else {
            this.cachedStackSizeString = "-";
            this.cachedFullness = 0.0f;
        }
    }

    protected Vec3d getSpawnedItemPosition(EnumFacing side) {
        double x = (double)this.func_174877_v().func_177958_n() + 0.5 + (double)side.func_82601_c() * 0.625;
        double y = (double)this.func_174877_v().func_177956_o() + 0.5 + (double)side.func_96559_d() * 0.5;
        double z = (double)this.func_174877_v().func_177952_p() + 0.5 + (double)side.func_82599_e() * 0.625;
        if (side == EnumFacing.DOWN) {
            y -= 0.25;
        }
        return new Vec3d(x, y, z);
    }

    @Override
    public ContainerBarrel getContainer(EntityPlayer player) {
        return new ContainerBarrel(player, this);
    }

    @Override
    public Object getGui(EntityPlayer player) {
        return new GuiBarrel(this.getContainer(player), this);
    }

    private class ItemHandlerBarrelUpgrades
    extends ItemStackHandlerTileEntity {
        private final TileEntityBarrel te;

        public ItemHandlerBarrelUpgrades(int inventoryId, int invSize, int stackLimit, boolean allowCustomStackSizes, String tagName, TileEntityBarrel te) {
            super(inventoryId, invSize, stackLimit, allowCustomStackSizes, tagName, te);
            this.te = te;
        }

        @Override
        public int getItemStackLimit(int slot, ItemStack stack) {
            if (!stack.func_190926_b() && stack.func_77973_b() == EnderUtilitiesItems.ENDER_PART) {
                int meta = stack.func_77960_j();
                if (meta == 71 || meta == 73) {
                    return 1;
                }
                if (meta == 72) {
                    return this.getInventoryStackLimit();
                }
            }
            return 64;
        }

        @Override
        public boolean isItemValidForSlot(int slot, ItemStack stack) {
            if (!stack.func_190926_b() && stack.func_77973_b() == EnderUtilitiesItems.ENDER_PART) {
                int meta = stack.func_77960_j();
                switch (slot) {
                    case 0: {
                        return meta == 70;
                    }
                    case 1: {
                        return meta == 71;
                    }
                    case 2: {
                        return meta == 72;
                    }
                    case 3: {
                        return meta == 73;
                    }
                }
                return false;
            }
            return false;
        }

        @Override
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 2) {
                ItemStack stackStored = this.te.itemHandlerLockable.getStackInSlot(0);
                ItemStack upgradeStack = this.getStackInSlot(2);
                if (!stackStored.func_190926_b() && stackStored.func_190916_E() > 4096 && !upgradeStack.func_190926_b()) {
                    int needed = (int)Math.ceil((double)(stackStored.func_190916_E() - 4096) / (double)stackStored.func_77976_d() / (double)Configs.barrelCapacityUpgradeStacksPer);
                    int toRemove = Math.min(amount, upgradeStack.func_190916_E() - needed);
                    if (toRemove > 0) {
                        return super.extractItem(slot, toRemove, simulate);
                    }
                    return ItemStack.field_190927_a;
                }
            }
            return super.extractItem(slot, amount, simulate);
        }
    }

    private class ItemHandlerBarrel
    extends ItemHandlerWrapperCreative {
        private final TileEntityBarrel te;

        public ItemHandlerBarrel(IItemHandler baseHandler, TileEntityBarrel te) {
            super(baseHandler, te);
            this.te = te;
        }

        @Override
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            stack = super.insertItem(slot, stack, simulate);
            if (!this.te.isCreative() && this.te.hasVoidUpgrade && this.getStackInSlot(slot).func_190916_E() == this.getInventoryStackLimit() && !stack.func_190926_b() && InventoryUtils.areItemStacksEqual(stack, this.getStackInSlot(slot))) {
                return ItemStack.field_190927_a;
            }
            return stack;
        }
    }
}

