/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import com.google.common.collect.Sets;
import fi.dy.masa.enderutilities.config.Configs;
import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.reference.HotKeys;
import fi.dy.masa.enderutilities.util.EUStringUtils;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.PositionHelper;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemLivingManipulator
extends ItemModular
implements IKeyBound {
    public static final int MAX_ENTITIES_PER_CARD = 16;
    public static final String WRAPPER_TAG_NAME = "LivingManipulator";
    public static final String TAG_NAME_MODE = "Mode";
    public static final String TAG_NAME_POS = "Position";

    public ItemLivingManipulator(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77656_e(0);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        Mode mode = Mode.getMode(stack);
        if (mode == Mode.NORMAL || mode == Mode.RELEASE) {
            if (world.field_72995_K) {
                return EnumActionResult.SUCCESS;
            }
            return this.releaseEntity(stack, player, world, pos, (float)pos.func_177958_n() + hitX, (float)pos.func_177956_o() + hitY, (float)pos.func_177952_p() + hitZ, side);
        }
        return EnumActionResult.PASS;
    }

    public EnumActionResult handleInteraction(ItemStack stack, EntityPlayer player, EntityLivingBase livingBase) {
        if (player.func_130014_f_().field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        Mode mode = Mode.getMode(stack);
        if (mode == Mode.RELEASE) {
            return this.releaseEntity(stack, player, player.func_130014_f_(), livingBase.func_180425_c(), livingBase.field_70165_t, livingBase.field_70163_u, livingBase.field_70161_v, EnumFacing.UP);
        }
        return this.captureEntity(stack, player, livingBase);
    }

    private EnumActionResult captureEntity(ItemStack stack, EntityPlayer player, EntityLivingBase livingBase) {
        if (livingBase == null || livingBase instanceof EntityPlayer) {
            return EnumActionResult.PASS;
        }
        int count = this.getStoredEntityCount(stack);
        if (count < 16) {
            return this.storeEntity(stack, livingBase, player);
        }
        player.func_146105_b((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.memorycard.full", new Object[0]), true);
        return EnumActionResult.FAIL;
    }

    private EnumActionResult releaseEntity(ItemStack containerStack, EntityPlayer player, World world, BlockPos pos, double x, double y, double z, EnumFacing side) {
        NBTTagCompound tag;
        int numEntities;
        ItemStack moduleStack = this.getSelectedModuleStack(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        if (moduleStack.func_190926_b()) {
            return EnumActionResult.PASS;
        }
        NBTTagList tagList = NBTUtils.getTagList(moduleStack, WRAPPER_TAG_NAME, "Entities", 10, false);
        if (tagList == null || tagList.func_74745_c() == 0) {
            return EnumActionResult.PASS;
        }
        int current = NBTUtils.getByte(moduleStack, WRAPPER_TAG_NAME, "Current");
        if (current >= (numEntities = tagList.func_74745_c())) {
            int n = current = numEntities > 0 ? numEntities - 1 : 0;
        }
        if ((tag = tagList.func_150305_b(current)) != null) {
            Entity entity;
            boolean isShulker = false;
            if ((tag.func_74779_i("id").equals("minecraft:shulker") || tag.func_74779_i("id").equals("Shulker")) && tag.func_150297_b("APX", 3)) {
                int xi = pos.func_177958_n() + side.func_82601_c();
                int yi = pos.func_177956_o() + side.func_96559_d();
                int zi = pos.func_177952_p() + side.func_82599_e();
                tag.func_74782_a("Pos", (NBTBase)NBTUtils.writeDoubles((double)xi + 0.5, yi, (double)zi + 0.5));
                tag.func_74768_a("APX", xi);
                tag.func_74768_a("APY", yi);
                tag.func_74768_a("APZ", zi);
                tag.func_74774_a("AttachFace", (byte)side.func_176745_a());
                isShulker = true;
            }
            if ((entity = EntityList.func_75615_a((NBTTagCompound)tag, (World)world)) == null) {
                return EnumActionResult.FAIL;
            }
            if (!isShulker) {
                if (tag.func_150297_b("playerYaw", 5)) {
                    float yawDiff = player.field_70177_z - tag.func_74760_g("playerYaw");
                    entity.field_70177_z = (entity.field_70177_z + yawDiff) % 360.0f;
                }
                PositionHelper posHelper = new PositionHelper(x, y, z);
                posHelper.adjustPositionToTouchFace(entity, side);
                entity.func_70012_b(posHelper.posX, posHelper.posY, posHelper.posZ, entity.field_70177_z, entity.field_70125_A);
            }
            entity.field_70181_x = 0.0;
            entity.field_70143_R = 0.0f;
            entity.field_70122_E = true;
            if (entity instanceof EntityLiving && this.getInstalledModuleCount(containerStack, ItemModule.ModuleType.TYPE_MOBPERSISTENCE) > 0) {
                EntityUtils.applyMobPersistence((EntityLiving)entity);
            }
            world.func_72838_d(entity);
            tagList.func_74744_a(current);
        }
        if (current >= (numEntities = tagList.func_74745_c())) {
            current = numEntities > 0 ? numEntities - 1 : 0;
        }
        NBTUtils.setByte(moduleStack, WRAPPER_TAG_NAME, "Current", (byte)current);
        this.setSelectedModuleStack(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC, moduleStack);
        return EnumActionResult.SUCCESS;
    }

    private EnumActionResult storeEntity(ItemStack containerStack, EntityLivingBase livingBase, EntityPlayer player) {
        ItemStack moduleStack = this.getSelectedModuleStack(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        if (moduleStack.func_190926_b() || !this.canStoreEntity((Entity)livingBase)) {
            return EnumActionResult.PASS;
        }
        livingBase.func_184210_p();
        livingBase.func_184226_ay();
        NBTTagCompound nbtEntity = new NBTTagCompound();
        if (!livingBase.func_70039_c(nbtEntity)) {
            return EnumActionResult.FAIL;
        }
        String str = EntityList.func_75621_b((Entity)livingBase);
        if (str != null) {
            nbtEntity.func_74778_a("EntityString", str);
        }
        nbtEntity.func_74776_a("playerYaw", player.field_70177_z);
        NBTTagList tagList = NBTUtils.getTagList(moduleStack, WRAPPER_TAG_NAME, "Entities", 10, true);
        tagList = NBTUtils.insertToTagList(tagList, (NBTBase)nbtEntity, NBTUtils.getByte(moduleStack, WRAPPER_TAG_NAME, "Current"));
        NBTUtils.setTagList(moduleStack, WRAPPER_TAG_NAME, "Entities", tagList);
        this.setSelectedModuleStack(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC, moduleStack);
        livingBase.field_70128_L = true;
        return EnumActionResult.SUCCESS;
    }

    private int getStoredEntityCount(ItemStack containerStack) {
        ItemStack moduleStack = this.getSelectedModuleStack(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        if (!moduleStack.func_190926_b()) {
            NBTTagList tagList = NBTUtils.getTagList(moduleStack, WRAPPER_TAG_NAME, "Entities", 10, false);
            return tagList != null ? tagList.func_74745_c() : 0;
        }
        return 0;
    }

    private int getCurrentIndex(ItemStack containerStack) {
        ItemStack moduleStack = this.getSelectedModuleStack(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        return moduleStack.func_190926_b() ? 0 : (int)NBTUtils.getByte(moduleStack, WRAPPER_TAG_NAME, "Current");
    }

    @Nullable
    private String getEntityName(ItemStack containerStack, int index, boolean useDisplayNameFormatting) {
        ItemStack moduleStack = this.getSelectedModuleStack(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        if (moduleStack.func_190926_b()) {
            return null;
        }
        NBTTagList tagList = NBTUtils.getTagList(moduleStack, WRAPPER_TAG_NAME, "Entities", 10, false);
        if (tagList != null && tagList.func_74745_c() > index) {
            return this.getNameForEntityFromTag(tagList.func_150305_b(index), useDisplayNameFormatting);
        }
        return null;
    }

    @Nullable
    private String getNameForEntityFromTag(NBTTagCompound tag, boolean useDisplayNameFormatting) {
        if (tag != null) {
            String pre = TextFormatting.WHITE.toString() + TextFormatting.ITALIC.toString();
            String rst = TextFormatting.RESET.toString() + (useDisplayNameFormatting ? TextFormatting.WHITE.toString() : TextFormatting.GRAY.toString());
            String name = tag.func_74779_i("CustomName");
            String id = null;
            if (tag.func_150297_b("EntityString", 8)) {
                id = tag.func_74779_i("EntityString");
            } else if (tag.func_150297_b("id", 8)) {
                id = tag.func_74779_i("id");
            }
            if (id != null) {
                String translated = I18n.func_135052_a((String)("entity." + id + ".name"), (Object[])new Object[0]);
                if (!id.equals(translated)) {
                    id = translated;
                }
                String string = name = name.length() > 0 ? pre + name + rst + " (" + id + ")" : id;
                if (tag.func_74764_b("Health")) {
                    name = name + String.format(" (%.1f HP)", Float.valueOf(tag.func_74760_g("Health")));
                }
            }
            return name;
        }
        return null;
    }

    private void changeEntitySelection(ItemStack containerStack, boolean reverse) {
        ItemStack moduleStack = this.getSelectedModuleStack(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        if (moduleStack.func_190926_b()) {
            return;
        }
        int numEntities = this.getStoredEntityCount(containerStack);
        int current = this.getCurrentIndex(containerStack);
        if (reverse) {
            if (--current < 0) {
                current = numEntities > 0 ? numEntities - 1 : 0;
            }
        } else if (++current >= numEntities) {
            current = 0;
        }
        NBTUtils.setByte(moduleStack, WRAPPER_TAG_NAME, "Current", (byte)current);
        this.setSelectedModuleStack(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC, moduleStack);
    }

    private boolean canStoreEntity(Entity entity) {
        if (Configs.lmmListIsWhitelist) {
            return Sets.newHashSet((Object[])Configs.lmmWhitelist).contains(EntityList.func_75621_b((Entity)entity));
        }
        return !Sets.newHashSet((Object[])Configs.lmmBlacklist).contains(EntityList.func_75621_b((Entity)entity));
    }

    public String func_77653_i(ItemStack stack) {
        String str = super.func_77653_i(stack);
        String preGreen = TextFormatting.GREEN.toString();
        String preGreenIta = preGreen + TextFormatting.ITALIC.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.WHITE.toString();
        ItemStack moduleStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        if (!moduleStack.func_190926_b()) {
            if (str.length() >= 14) {
                str = EUStringUtils.getInitialsWithDots(str);
            }
            str = moduleStack.func_82837_s() ? str + " " + preGreenIta + moduleStack.func_82833_r() + rst : str + " MC: " + preGreen + (UtilItemModular.getClampedModuleSelection(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC) + 1) + rst;
            int index = this.getCurrentIndex(stack);
            int count = this.getStoredEntityCount(stack);
            str = str + " E: " + preGreen + (index + 1) + "/" + count + rst;
            String entityName = this.getEntityName(stack, index, true);
            if (entityName != null) {
                str = str + " -> " + entityName;
            }
        }
        return str;
    }

    @Override
    public void addTooltipLines(ItemStack stack, EntityPlayer player, List<String> list, boolean verbose) {
        if (stack.func_77978_p() == null) {
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.usetoolworkstation", (Object[])new Object[0]));
            return;
        }
        ItemStack memoryCardStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        String preDGreen = TextFormatting.DARK_GREEN.toString();
        String preBlue = TextFormatting.BLUE.toString();
        String preWhiteIta = TextFormatting.WHITE.toString() + TextFormatting.ITALIC.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.GRAY.toString();
        list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.mode", (Object[])new Object[0]) + ": " + preDGreen + Mode.getMode(stack).getDisplayName() + rst);
        if (verbose && this.getMaxModules(stack, ItemModule.ModuleType.TYPE_MOBPERSISTENCE) > 0) {
            String s = this.getInstalledModuleCount(stack, ItemModule.ModuleType.TYPE_MOBPERSISTENCE) > 0 ? I18n.func_135052_a((String)"enderutilities.tooltip.item.jailer", (Object[])new Object[0]) + ": " + TextFormatting.GREEN + I18n.func_135052_a((String)"enderutilities.tooltip.item.yes", (Object[])new Object[0]) + rst : I18n.func_135052_a((String)"enderutilities.tooltip.item.jailer", (Object[])new Object[0]) + ": " + TextFormatting.RED + I18n.func_135052_a((String)"enderutilities.tooltip.item.no", (Object[])new Object[0]) + rst;
            list.add(s);
        }
        if (!memoryCardStack.func_190926_b()) {
            if (verbose) {
                int num = UtilItemModular.getInstalledModuleCount(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
                int sel = UtilItemModular.getClampedModuleSelection(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC) + 1;
                String dName = memoryCardStack.func_82837_s() ? preWhiteIta + memoryCardStack.func_82833_r() + rst + " " : "";
                list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.selectedmemorycard.short", (Object[])new Object[0]) + String.format(" %s(%s%d%s / %s%d%s)", dName, preBlue, sel, rst, preBlue, num, rst));
                NBTTagList tagList = NBTUtils.getTagList(memoryCardStack, WRAPPER_TAG_NAME, "Entities", 10, false);
                if (tagList == null) {
                    return;
                }
                int current = this.getCurrentIndex(stack);
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    NBTTagCompound tag = tagList.func_150305_b(i);
                    if (tag == null) continue;
                    String name = this.getNameForEntityFromTag(tag, false);
                    name = i == current ? "=> " + name : "   " + name;
                    list.add(name);
                }
            }
        } else {
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.nomemorycards", (Object[])new Object[0]));
        }
    }

    @Override
    public boolean doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (HotKeys.EnumKey.TOGGLE.matches(key, 131072, 65536) || HotKeys.EnumKey.SCROLL.matches(key, 131072)) {
            this.changeSelectedModule(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC, HotKeys.EnumKey.keypressActionIsReversed(key) || HotKeys.EnumKey.keypressContainsShift(key));
            return true;
        }
        if (HotKeys.EnumKey.TOGGLE.matches(key, 65536) || HotKeys.EnumKey.SCROLL.matches(key, 65536)) {
            this.changeEntitySelection(stack, HotKeys.EnumKey.keypressActionIsReversed(key));
            return true;
        }
        if (HotKeys.EnumKey.TOGGLE.matches(key, 0)) {
            NBTUtils.cycleByteValue(stack, WRAPPER_TAG_NAME, TAG_NAME_MODE, Mode.values().length - 1);
            return true;
        }
        return false;
    }

    @Override
    public int getMaxModules(ItemStack containerStack) {
        return 5;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        if (moduleType.equals(ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC)) {
            return 4;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_MOBPERSISTENCE)) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemStack moduleStack) {
        if (moduleStack.func_190926_b() || !(moduleStack.func_77973_b() instanceof IModule)) {
            return 0;
        }
        return this.getMaxModules(containerStack, ((IModule)moduleStack.func_77973_b()).getModuleType(moduleStack));
    }

    @Override
    public ResourceLocation[] getItemVariants() {
        String rl = "enderutilities:item_" + this.name;
        return new ResourceLocation[]{new ModelResourceLocation(rl, "mode=normal"), new ModelResourceLocation(rl, "mode=capture"), new ModelResourceLocation(rl, "mode=release")};
    }

    @Override
    public ModelResourceLocation getModelLocation(ItemStack stack) {
        String rl = "enderutilities:item_" + this.name;
        return new ModelResourceLocation(rl, "mode=" + Mode.getMode(stack).getVariant());
    }

    public static enum Mode {
        NORMAL("enderutilities.tooltip.item.normal", "normal"),
        CAPTURE("enderutilities.tooltip.item.capture", "capture"),
        RELEASE("enderutilities.tooltip.item.release", "release");

        private String unlocName;
        private String variant;

        private Mode(String unlocName, String variant) {
            this.unlocName = unlocName;
            this.variant = variant;
        }

        public String getDisplayName() {
            return I18n.func_135052_a((String)this.unlocName, (Object[])new Object[0]);
        }

        public String getVariant() {
            return this.variant;
        }

        public static Mode getMode(ItemStack stack) {
            return Mode.getMode(NBTUtils.getByte(stack, ItemLivingManipulator.WRAPPER_TAG_NAME, ItemLivingManipulator.TAG_NAME_MODE));
        }

        public static Mode getMode(int id) {
            return id >= 0 && id < Mode.values().length ? Mode.values()[id] : NORMAL;
        }
    }
}

