/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import fi.dy.masa.enderutilities.config.Configs;
import fi.dy.masa.enderutilities.entity.EntityEnderArrow;
import fi.dy.masa.enderutilities.item.base.IAnvilRepairable;
import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.ItemLocationBoundModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.OwnerData;
import fi.dy.masa.enderutilities.util.nbt.TargetData;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemEnderBow
extends ItemLocationBoundModular
implements IKeyBound,
IAnvilRepairable {
    public static final int ENDER_CHARGE_COST_MOB_TP = 1000;
    public static final byte BOW_MODE_TP_TARGET = 0;
    public static final byte BOW_MODE_TP_SELF = 1;
    private final ItemStack repairMaterial;

    public ItemEnderBow(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77656_e(384);
        this.setNoRepair();
        this.commonTooltip = "enderutilities.tooltips.itemlocationboundmodular";
        this.repairMaterial = new ItemStack((Item)EnderUtilitiesItems.ENDER_PART, 1, 1);
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase livingBase, int itemInUseCount) {
        EntityPlayer player = null;
        if (livingBase instanceof EntityPlayer) {
            player = (EntityPlayer)livingBase;
        }
        if (this.isBroken(stack)) {
            return;
        }
        byte mode = this.getBowMode(stack);
        if (world.field_72995_K || mode == 0 && player != null && !OwnerData.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, (Entity)player)) {
            return;
        }
        if (mode == 1 && !Configs.enderBowAllowSelfTP) {
            return;
        }
        if (player != null && !player.field_71075_bZ.field_75098_d && !player.field_71071_by.func_70431_c(new ItemStack((Item)EnderUtilitiesItems.ENDER_ARROW))) {
            return;
        }
        float f = (float)(this.func_77626_a(stack) - itemInUseCount) / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) < 0.1f) {
            return;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        EntityEnderArrow entityenderarrow = new EntityEnderArrow(world, livingBase, f * 2.0f);
        entityenderarrow.setTpMode(mode);
        if (mode == 0) {
            TargetData target = TargetData.getTargetFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
            if (target == null) {
                return;
            }
            entityenderarrow.setTpTarget(target);
            if (UtilItemModular.getInstalledModuleCount(stack, ItemModule.ModuleType.TYPE_MOBPERSISTENCE) > 0) {
                entityenderarrow.setPersistence(true);
            }
        }
        if (player != null && !player.field_71075_bZ.field_75098_d) {
            if (mode == 0 && !UtilItemModular.useEnderCharge(stack, 1000, false)) {
                return;
            }
            IItemHandler inv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            InventoryUtils.extractItems(inv, EnderUtilitiesItems.ENDER_ARROW, 1);
            stack.func_77972_a(1, (EntityLivingBase)player);
            if (this.isBroken(stack)) {
                player.func_70669_a(stack);
            }
        }
        if (f == 1.0f) {
            entityenderarrow.func_70243_d(true);
        }
        world.func_184148_a(null, livingBase.field_70165_t, livingBase.field_70163_u, livingBase.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
        world.func_72838_d((Entity)entityenderarrow);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.isBroken(stack)) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (!(this.getBowMode(stack) != 0 || (player.field_71075_bZ.field_75098_d || UtilItemModular.useEnderCharge(stack, 1000, true)) && OwnerData.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, (Entity)player) && TargetData.selectedModuleHasTargetTag(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL))) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (player.field_71075_bZ.field_75098_d || player.field_71071_by.func_70431_c(new ItemStack((Item)EnderUtilitiesItems.ENDER_ARROW))) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public boolean isBroken(ItemStack stack) {
        return stack.func_77952_i() >= this.getMaxDamage(stack);
    }

    @Override
    public boolean repairItem(ItemStack stack, int amount) {
        int damage;
        if (amount == -1) {
            amount = this.getMaxDamage(stack);
        }
        boolean repaired = (damage = Math.max(this.getDamage(stack) - amount, 0)) != this.getDamage(stack);
        this.setDamage(stack, damage);
        return repaired;
    }

    @Override
    public boolean isRepairItem(@Nonnull ItemStack stackTool, @Nonnull ItemStack stackMaterial) {
        return InventoryUtils.areItemStacksEqual(stackMaterial, this.repairMaterial);
    }

    @Override
    public boolean canApplyEnchantment(ItemStack stackTool, Enchantment enchantment) {
        return enchantment.field_77351_y == EnumEnchantmentType.ALL || enchantment.field_77351_y == EnumEnchantmentType.BREAKABLE;
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        if (this.getBowMode(stack) == 1) {
            return this.getBaseItemDisplayName(stack);
        }
        return super.func_77653_i(stack);
    }

    @Override
    public void addTooltipLines(ItemStack stack, EntityPlayer player, List<String> list, boolean verbose) {
        String preDGreen = TextFormatting.DARK_GREEN.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.GRAY.toString();
        if (this.getBowMode(stack) == 1) {
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.mode", (Object[])new Object[0]) + ": " + preDGreen + I18n.func_135052_a((String)"enderutilities.tooltip.item.tpself", (Object[])new Object[0]) + rst);
        } else {
            super.addTooltipLines(stack, player, list, verbose);
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.mode", (Object[])new Object[0]) + ": " + preDGreen + I18n.func_135052_a((String)"enderutilities.tooltip.item.tptarget", (Object[])new Object[0]) + rst);
        }
    }

    private byte getBowMode(ItemStack stack) {
        if (stack.func_77978_p() != null) {
            return stack.func_77978_p().func_74771_c("Mode");
        }
        return 0;
    }

    public void toggleBowMode(EntityPlayer player, ItemStack stack) {
        if (!Configs.enderBowAllowSelfTP) {
            NBTUtils.setByte(stack, null, "Mode", (byte)0);
        } else {
            NBTUtils.cycleByteValue(stack, null, "Mode", 1);
        }
    }

    @Override
    public boolean doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (key == 1) {
            this.toggleBowMode(player, stack);
            return true;
        }
        return super.doKeyBindingAction(player, stack, key);
    }

    @Override
    public boolean useBindLocking(ItemStack stack) {
        return true;
    }

    @Override
    public int getMaxModules(ItemStack containerStack) {
        return 10;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCAPACITOR)) {
            return 1;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL)) {
            return 8;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_MOBPERSISTENCE)) {
            return 1;
        }
        return 0;
    }

    @Override
    protected void addItemOverrides() {
        this.func_185043_a(new ResourceLocation("enderutilities", "pull"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                stack = entityIn.func_184607_cu();
                if (!stack.func_190926_b()) {
                    return (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f;
                }
                return 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("enderutilities", "pulling"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("enderutilities", "broken"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                return ItemEnderBow.this.isBroken(stack) ? 1.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("enderutilities", "mode"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                return ItemEnderBow.this.getBowMode(stack) == 1 ? 1.0f : 0.0f;
            }
        });
    }
}

