/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory.container.base;

import fi.dy.masa.enderutilities.inventory.IItemHandlerSize;
import fi.dy.masa.enderutilities.inventory.ItemStackHandlerLockable;
import fi.dy.masa.enderutilities.inventory.container.base.ContainerEnderUtilities;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerCraftResult;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerGeneric;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ContainerCustomSlotClick
extends ContainerEnderUtilities {
    @Nullable
    protected IItemHandlerSize inventoryNonWrapped;
    protected boolean isDragging;
    protected boolean draggingRightClick;
    protected final Set<Integer> draggedSlots = new HashSet<Integer>();
    protected int selectedSlot = -1;
    private int selectedSlotLast = -1;

    public ContainerCustomSlotClick(EntityPlayer player, IItemHandler inventory) {
        super(player, inventory);
    }

    public int getSelectedSlot() {
        return this.selectedSlot;
    }

    @Override
    public void func_75142_b() {
        if (!this.isClient) {
            for (int i = 0; i < this.field_75149_d.size(); ++i) {
                if (this.selectedSlot == this.selectedSlotLast) continue;
                ((IContainerListener)this.field_75149_d.get(i)).func_71112_a((Container)this, 256, this.selectedSlot & 0xFFFF);
            }
            this.selectedSlotLast = this.selectedSlot;
        }
        super.func_75142_b();
    }

    public void func_75137_b(int id, int data) {
        if (id == 256) {
            this.selectedSlot = (short)data;
        } else {
            super.func_75137_b(id, data);
        }
    }

    protected void startDragging(boolean isRightClick) {
        this.isDragging = true;
        this.draggingRightClick = isRightClick;
        this.draggedSlots.clear();
    }

    private void dragging(int slotNum) {
        this.draggedSlots.add(slotNum);
    }

    protected ItemStack putItemsToSlot(SlotItemHandlerGeneric slot, ItemStack stack, int amount) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (amount < stack.func_190916_E()) {
            ItemStack stackInsert = stack.func_77979_a(amount);
            if (!(stackInsert = slot.insertItem(stackInsert, false)).func_190926_b()) {
                stack.func_190917_f(stackInsert.func_190916_E());
            }
            return stack;
        }
        return slot.insertItem(stack, false);
    }

    protected boolean takeItemsFromSlotToCursor(SlotItemHandlerGeneric slot, int amount) {
        ItemStack stackCursor = this.inventoryPlayer.func_70445_o();
        ItemStack stackSlot = slot.func_75211_c();
        if (!slot.func_82869_a(this.player) || stackSlot.func_190926_b() || !stackCursor.func_190926_b() && !InventoryUtils.areItemStacksEqual(stackCursor, stackSlot)) {
            return false;
        }
        amount = Math.min(amount, stackSlot.func_77976_d());
        int spaceAvailable = stackSlot.func_77976_d();
        if (!stackCursor.func_190926_b()) {
            spaceAvailable = stackCursor.func_77976_d() - stackCursor.func_190916_E();
        }
        if ((amount = Math.min(amount, spaceAvailable)) <= 0 || slot instanceof SlotItemHandlerCraftResult && spaceAvailable < stackSlot.func_190916_E()) {
            return false;
        }
        stackSlot = slot.func_75209_a(amount);
        if (!stackSlot.func_190926_b()) {
            slot.func_190901_a(this.player, stackSlot);
            if (stackCursor.func_190926_b()) {
                stackCursor = stackSlot;
            } else {
                stackCursor.func_190917_f(stackSlot.func_190916_E());
            }
            this.inventoryPlayer.func_70437_b(stackCursor);
            return true;
        }
        return false;
    }

    protected boolean swapSlots(SlotItemHandlerGeneric slot1, SlotItemHandlerGeneric slot2) {
        if (slot1.func_75216_d() && !slot1.func_82869_a(this.player) || slot2.func_75216_d() && !slot2.func_82869_a(this.player)) {
            return false;
        }
        ItemStack stack1 = slot1.func_75211_c();
        ItemStack stack2 = slot2.func_75211_c();
        if (!stack1.func_190926_b() && !slot2.func_75214_a(stack1) || !stack2.func_190926_b() && !slot1.func_75214_a(stack2)) {
            return false;
        }
        if (!stack1.func_190926_b()) {
            slot1.func_190901_a(this.player, stack1);
        }
        if (!stack2.func_190926_b()) {
            slot2.func_190901_a(this.player, stack2);
        }
        slot1.func_75215_d(stack2.func_190926_b() ? ItemStack.field_190927_a : stack2.func_77946_l());
        slot2.func_75215_d(stack1.func_190926_b() ? ItemStack.field_190927_a : stack1.func_77946_l());
        return true;
    }

    protected void endDragging() {
        if (!this.inventoryPlayer.func_70445_o().func_190926_b()) {
            ItemStack stackCursor = this.inventoryPlayer.func_70445_o().func_77946_l();
            int numSlots = this.draggedSlots.size();
            int itemsPerSlot = this.draggingRightClick ? 1 : (numSlots > 0 ? stackCursor.func_190916_E() / numSlots : stackCursor.func_190916_E());
            for (int slotNum : this.draggedSlots) {
                if (stackCursor.func_190926_b()) break;
                SlotItemHandlerGeneric slot = this.getSlotItemHandler(slotNum);
                if (slot == null) continue;
                int amount = Math.min(itemsPerSlot, this.getMaxStackSizeFromSlotAndStack((Slot)slot, stackCursor));
                amount = Math.min(amount, stackCursor.func_190916_E());
                stackCursor = this.putItemsToSlot(slot, stackCursor, amount);
            }
            this.inventoryPlayer.func_70437_b(stackCursor);
        }
        this.isDragging = false;
    }

    protected void leftClickOutsideInventory(EntityPlayer player) {
        ItemStack stackCursor = this.inventoryPlayer.func_70445_o();
        if (!stackCursor.func_190926_b()) {
            int max = stackCursor.func_77976_d();
            while (stackCursor.func_190916_E() > max) {
                ItemStack stackDrop = stackCursor.func_77946_l();
                stackDrop.func_190920_e(max);
                player.func_71019_a(stackDrop, true);
            }
            player.func_71019_a(stackCursor, true);
            this.inventoryPlayer.func_70437_b(ItemStack.field_190927_a);
        }
    }

    protected void rightClickOutsideInventory(EntityPlayer player) {
        ItemStack stackCursor = this.inventoryPlayer.func_70445_o();
        if (!stackCursor.func_190926_b()) {
            ItemStack stackDrop = stackCursor.func_77979_a(1);
            player.func_71019_a(stackDrop, true);
            this.inventoryPlayer.func_70437_b(stackCursor.func_190926_b() ? ItemStack.field_190927_a : stackCursor);
        }
    }

    protected void leftClickSlot(int slotNum, EntityPlayer player) {
        SlotItemHandlerGeneric slot = this.getSlotItemHandler(slotNum);
        if (slot == null) {
            return;
        }
        ItemStack stackCursor = this.inventoryPlayer.func_70445_o();
        ItemStack stackSlot = slot.func_75211_c();
        if (!stackCursor.func_190926_b()) {
            if (stackSlot.func_190926_b() || InventoryUtils.areItemStacksEqual(stackCursor, stackSlot)) {
                if (slot.func_75214_a(stackCursor)) {
                    this.inventoryPlayer.func_70437_b(slot.insertItem(stackCursor, false));
                } else if (!stackSlot.func_190926_b()) {
                    this.takeItemsFromSlotToCursor(slot, stackSlot.func_190916_E());
                }
            } else if (slot.func_82869_a(this.player) && slot.canTakeAll() && slot.func_75214_a(stackCursor) && stackSlot.func_190916_E() <= stackSlot.func_77976_d() && slot.func_178170_b(stackCursor) >= stackCursor.func_190916_E()) {
                this.inventoryPlayer.func_70437_b(slot.func_75209_a(stackSlot.func_190916_E()));
                slot.func_190901_a(this.player, stackSlot);
                slot.insertItem(stackCursor, false);
            }
        } else if (!stackSlot.func_190926_b()) {
            this.takeItemsFromSlotToCursor(slot, stackSlot.func_190916_E());
        }
    }

    protected void rightClickSlot(int slotNum, EntityPlayer player) {
        SlotItemHandlerGeneric slot = this.getSlotItemHandler(slotNum);
        if (slot == null) {
            return;
        }
        ItemStack stackCursor = this.inventoryPlayer.func_70445_o();
        ItemStack stackSlot = slot.func_75211_c();
        if (!stackCursor.func_190926_b()) {
            if (stackSlot.func_190926_b() || InventoryUtils.areItemStacksEqual(stackCursor, stackSlot)) {
                if (slot.func_75214_a(stackCursor)) {
                    if (!slot.insertItem(stackCursor.func_77979_a(1), false).func_190926_b()) {
                        stackCursor.func_190917_f(1);
                    }
                    this.inventoryPlayer.func_70437_b(stackCursor.func_190926_b() ? ItemStack.field_190927_a : stackCursor);
                } else if (!stackSlot.func_190926_b()) {
                    this.takeItemsFromSlotToCursor(slot, Math.min(stackSlot.func_77976_d() / 2, stackSlot.func_190916_E()));
                }
            } else if (slot.func_82869_a(this.player) && slot.canTakeAll() && slot.func_75214_a(stackCursor) && stackSlot.func_190916_E() <= stackSlot.func_77976_d() && slot.func_178170_b(stackCursor) >= stackCursor.func_190916_E()) {
                this.inventoryPlayer.func_70437_b(slot.func_75209_a(stackSlot.func_190916_E()));
                slot.func_190901_a(this.player, stackSlot);
                slot.insertItem(stackCursor, false);
            }
        } else if (!stackSlot.func_190926_b()) {
            int amount = stackSlot.func_190916_E();
            if (!(slot instanceof SlotItemHandlerCraftResult)) {
                amount = Math.min((int)Math.ceil((double)stackSlot.func_190916_E() / 2.0), (int)Math.ceil((double)stackSlot.func_77976_d() / 2.0));
            }
            this.takeItemsFromSlotToCursor(slot, amount);
        }
    }

    protected void middleClickSlot(int slotNum, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d && this.playerMainSlotsIncHotbar.contains(slotNum) && player.field_71071_by.func_70445_o().func_190926_b() && this.func_75139_a(slotNum).func_75216_d()) {
            ItemStack stack = this.func_75139_a(slotNum).func_75211_c().func_77946_l();
            stack.func_190920_e(stack.func_77976_d());
            player.field_71071_by.func_70437_b(stack);
        } else {
            this.swapSlots(slotNum, player);
        }
    }

    protected void swapSlots(int slotNum, EntityPlayer player) {
        SlotItemHandlerGeneric slot1 = this.getSlotItemHandler(slotNum);
        if (slot1 != null && slot1.getItemHandler() == this.inventory) {
            if (this.selectedSlot >= 0 && this.selectedSlot < this.field_75151_b.size()) {
                SlotItemHandlerGeneric slot2;
                if (this.selectedSlot != slotNum && (slot2 = this.getSlotItemHandler(this.selectedSlot)) != null) {
                    this.swapSlots(slot1, slot2);
                }
                this.selectedSlot = -1;
            } else {
                this.selectedSlot = slotNum;
            }
        }
    }

    protected boolean toggleSlotLocked(int slotNum, ItemStackHandlerLockable inv) {
        Slot slot = this.func_75139_a(slotNum);
        int slotIndex = slot != null ? slot.getSlotIndex() : -1;
        ItemStack stackCursor = this.player.field_71071_by.func_70445_o();
        if (slotIndex != -1) {
            if (!stackCursor.func_190926_b()) {
                inv.setTemplateStackInSlot(slotIndex, stackCursor);
            } else {
                inv.setTemplateStackInSlot(slotIndex, slot.func_75211_c());
            }
            inv.toggleSlotLocked(slotIndex);
            return true;
        }
        return false;
    }

    protected boolean cycleStackSize(int slotNum, IItemHandlerSize inv) {
        SlotItemHandlerGeneric slot = this.getSlotItemHandler(slotNum);
        ItemStack stackCursor = this.player.field_71071_by.func_70445_o();
        if (slot != null && !stackCursor.func_190926_b()) {
            ItemStack stackSlot = slot.func_75211_c();
            if (InventoryUtils.areItemStacksEqual(stackCursor, stackSlot)) {
                int max = inv.getItemStackLimit(slotNum, stackCursor);
                if (stackCursor.func_190916_E() == 1) {
                    long newSize = (long)stackSlot.func_190916_E() * 10L;
                    if (newSize >= 0L && newSize <= (long)max) {
                        stackSlot = stackSlot.func_77946_l();
                        stackSlot.func_190920_e((int)newSize);
                        slot.func_75215_d(stackSlot);
                    } else {
                        slot.func_75215_d(ItemStack.field_190927_a);
                    }
                } else if (stackSlot.func_190916_E() < max) {
                    stackSlot = stackSlot.func_77946_l();
                    stackSlot.func_190920_e(max);
                    slot.func_75215_d(stackSlot);
                } else {
                    slot.func_75215_d(ItemStack.field_190927_a);
                }
            } else {
                slot.func_75215_d(stackCursor.func_77946_l());
            }
            return true;
        }
        return false;
    }

    protected void leftDoubleClickSlot(int slotNum, EntityPlayer player) {
        ItemStack stackTmp;
        SlotItemHandlerGeneric slot = this.getSlotItemHandler(slotNum);
        ItemStack stackCursor = this.inventoryPlayer.func_70445_o();
        if (slot != null && !stackCursor.func_190926_b() && this.func_94530_a(stackCursor, (Slot)slot) && !(stackTmp = InventoryUtils.collectItemsFromInventory(slot.getItemHandler(), stackCursor, stackCursor.func_77976_d() - stackCursor.func_190916_E(), true)).func_190926_b()) {
            stackCursor.func_190917_f(stackTmp.func_190916_E());
            this.inventoryPlayer.func_70437_b(stackCursor);
        }
    }

    protected void shiftClickSlot(int slotNum, EntityPlayer player) {
        ItemStack stackSlot;
        SlotItemHandlerGeneric slot = this.getSlotItemHandler(slotNum);
        ItemStack itemStack = stackSlot = slot != null ? slot.func_75211_c() : ItemStack.field_190927_a;
        if (!stackSlot.func_190926_b() && this.transferStackFromSlot(player, slotNum)) {
            slot.func_190901_a(player, stackSlot);
        }
    }

    protected void pressDropKey(int slotNum, EntityPlayer player, boolean wholeStack) {
        ItemStack stackDrop;
        ItemStack stackSlot;
        SlotItemHandlerGeneric slot = this.getSlotItemHandler(slotNum);
        ItemStack itemStack = stackSlot = slot != null ? slot.func_75211_c() : ItemStack.field_190927_a;
        if (!stackSlot.func_190926_b() && slot.func_82869_a(this.player) && !(stackDrop = slot.func_75209_a(wholeStack ? stackSlot.func_190916_E() : 1)).func_190926_b()) {
            slot.func_190901_a(player, stackDrop);
            player.func_71019_a(stackDrop, true);
        }
    }

    protected void pressHotbarKey(int slotNum, int button, EntityPlayer player) {
        SlotItemHandlerGeneric slot = this.getSlotItemHandler(slotNum);
        if (slot == null) {
            return;
        }
        ItemStack stackSlot = slot != null ? slot.func_75211_c() : ItemStack.field_190927_a;
        ItemStack stackHotbar = this.playerInv.getStackInSlot(button);
        if ((stackSlot.func_190926_b() || stackSlot.func_190916_E() <= stackSlot.func_77976_d()) && (stackHotbar.func_190926_b() || stackHotbar.func_190916_E() <= this.getMaxStackSizeFromSlotAndStack((Slot)slot, stackHotbar)) && slot.func_82869_a(this.player) && slot.func_75214_a(stackHotbar)) {
            slot.func_75215_d(stackHotbar);
            this.playerInv.setStackInSlot(button, stackSlot);
            if (!stackSlot.func_190926_b()) {
                slot.func_190901_a(player, stackSlot);
            }
        } else if (stackHotbar.func_190926_b() && !stackSlot.func_190926_b()) {
            int num = Math.min(stackSlot.func_77976_d(), this.inventoryPlayer.func_70297_j_());
            num = Math.min(num, stackSlot.func_190916_E());
            stackHotbar = slot.func_75209_a(num);
            slot.func_190901_a(player, stackHotbar);
            this.playerInv.setStackInSlot(button, stackHotbar);
        } else if (!stackHotbar.func_190926_b() && !stackSlot.func_190926_b() && InventoryUtils.areItemStacksEqual(stackHotbar, stackSlot)) {
            int num = Math.min(stackHotbar.func_77976_d() - stackHotbar.func_190916_E(), stackSlot.func_190916_E());
            if (num > 0) {
                stackHotbar.func_190917_f(num);
                slot.func_75209_a(num);
                slot.func_190901_a(player, stackSlot);
                this.playerInv.setStackInSlot(button, stackHotbar);
            } else if (slot.func_75214_a(stackHotbar)) {
                this.playerInv.setStackInSlot(button, this.putItemsToSlot(slot, stackHotbar, stackHotbar.func_190916_E()));
            }
        }
    }

    public ItemStack func_184996_a(int slotNum, int dragType, ClickType clickType, EntityPlayer player) {
        if (this.isDragging) {
            if (clickType == ClickType.QUICK_CRAFT && (dragType == 2 || dragType == 6)) {
                this.endDragging();
            } else if (clickType == ClickType.QUICK_CRAFT && (dragType == 1 || dragType == 5)) {
                this.dragging(slotNum);
            }
        } else if (clickType == ClickType.QUICK_CRAFT && (dragType == 0 || dragType == 4)) {
            this.startDragging(dragType == 4);
        } else if (clickType == ClickType.PICKUP && slotNum == -999) {
            if (dragType == 0) {
                this.leftClickOutsideInventory(player);
            } else if (dragType == 1) {
                this.rightClickOutsideInventory(player);
            }
        } else if (clickType == ClickType.PICKUP && dragType == 0) {
            this.leftClickSlot(slotNum, player);
        } else if (clickType == ClickType.PICKUP && dragType == 1) {
            this.rightClickSlot(slotNum, player);
        } else if (clickType == ClickType.QUICK_MOVE && (dragType == 0 || dragType == 1)) {
            this.shiftClickSlot(slotNum, player);
        } else if (clickType == ClickType.THROW && (dragType == 0 || dragType == 1)) {
            this.pressDropKey(slotNum, player, dragType == 1);
        } else if (clickType == ClickType.SWAP && dragType >= 0 && dragType <= 8) {
            this.pressHotbarKey(slotNum, dragType, player);
        } else if (clickType == ClickType.PICKUP_ALL && dragType == 0) {
            this.leftDoubleClickSlot(slotNum, player);
        } else {
            if (this.inventoryNonWrapped instanceof ItemStackHandlerLockable) {
                ItemStackHandlerLockable inv = (ItemStackHandlerLockable)this.inventoryNonWrapped;
                if ((clickType == ClickType.CLONE || clickType == ClickType.QUICK_CRAFT && dragType == 9) && slotNum >= 0 && slotNum < inv.getSlots()) {
                    this.toggleSlotLocked(slotNum, inv);
                    return ItemStack.field_190927_a;
                }
            }
            if (clickType == ClickType.CLONE) {
                this.middleClickSlot(slotNum, player);
            }
        }
        if (!this.isClient) {
            this.func_75142_b();
        }
        return ItemStack.field_190927_a;
    }
}

