/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.gui;

import fi.dy.masa.enderutilities.gui.client.GuiHandyBag;
import fi.dy.masa.enderutilities.gui.client.GuiInventorySwapper;
import fi.dy.masa.enderutilities.gui.client.GuiNullifier;
import fi.dy.masa.enderutilities.gui.client.GuiPickupManager;
import fi.dy.masa.enderutilities.gui.client.GuiQuickStacker;
import fi.dy.masa.enderutilities.inventory.container.ContainerHandyBag;
import fi.dy.masa.enderutilities.inventory.container.ContainerInventorySwapper;
import fi.dy.masa.enderutilities.inventory.container.ContainerNullifier;
import fi.dy.masa.enderutilities.inventory.container.ContainerPickupManager;
import fi.dy.masa.enderutilities.inventory.container.ContainerQuickStacker;
import fi.dy.masa.enderutilities.item.ItemHandyBag;
import fi.dy.masa.enderutilities.item.ItemQuickStacker;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import fi.dy.masa.enderutilities.util.EntityUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;

public class EnderUtilitiesGUIHandler
implements IGuiHandler {
    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (player == null || world == null) {
            return null;
        }
        switch (id) {
            case 0: {
                TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
                if (te == null || !(te instanceof TileEntityEnderUtilities)) break;
                return ((TileEntityEnderUtilities)te).getContainer(player);
            }
            case 1001: {
                ItemStack stack = ItemHandyBag.getOpenableBag(player);
                if (stack.func_190926_b()) break;
                return new ContainerHandyBag(player, stack);
            }
            case 1002: {
                ItemStack stack = EntityUtils.getHeldItemOfType((EntityLivingBase)player, EnderUtilitiesItems.HANDY_BAG);
                if (stack.func_190926_b()) break;
                return new ContainerHandyBag(player, stack);
            }
            case 1003: {
                ItemStack stack = EntityUtils.getHeldItemOfType((EntityLivingBase)player, EnderUtilitiesItems.INVENTORY_SWAPPER);
                if (stack.func_190926_b()) break;
                return new ContainerInventorySwapper(player, stack);
            }
            case 1004: {
                ItemStack stack = EntityUtils.getHeldItemOfType((EntityLivingBase)player, EnderUtilitiesItems.PICKUP_MANAGER);
                if (stack.func_190926_b()) break;
                return new ContainerPickupManager(player, stack);
            }
            case 1005: {
                ItemStack stack = ItemQuickStacker.getEnabledItem(player);
                if (stack.func_190926_b()) break;
                return new ContainerQuickStacker(player, stack);
            }
            case 1006: {
                ItemStack stack = EntityUtils.getHeldItemOfType((EntityLivingBase)player, EnderUtilitiesItems.NULLIFIER);
                if (stack.func_190926_b()) break;
                return new ContainerNullifier(player, stack);
            }
        }
        return null;
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (player == null || world == null) {
            return null;
        }
        switch (id) {
            case 0: {
                TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
                if (te == null || !(te instanceof TileEntityEnderUtilities)) break;
                return ((TileEntityEnderUtilities)te).getGui(player);
            }
            case 1001: {
                ItemStack stack = ItemHandyBag.getOpenableBag(player);
                if (stack.func_190926_b()) break;
                return new GuiHandyBag(new ContainerHandyBag(player, stack));
            }
            case 1002: {
                ItemStack stack = EntityUtils.getHeldItemOfType((EntityLivingBase)player, EnderUtilitiesItems.HANDY_BAG);
                if (stack.func_190926_b()) break;
                return new GuiHandyBag(new ContainerHandyBag(player, stack));
            }
            case 1003: {
                ItemStack stack = EntityUtils.getHeldItemOfType((EntityLivingBase)player, EnderUtilitiesItems.INVENTORY_SWAPPER);
                if (stack.func_190926_b()) break;
                return new GuiInventorySwapper(new ContainerInventorySwapper(player, stack));
            }
            case 1004: {
                ItemStack stack = EntityUtils.getHeldItemOfType((EntityLivingBase)player, EnderUtilitiesItems.PICKUP_MANAGER);
                if (stack.func_190926_b()) break;
                return new GuiPickupManager(new ContainerPickupManager(player, stack));
            }
            case 1005: {
                ItemStack stack = ItemQuickStacker.getEnabledItem(player);
                if (stack.func_190926_b()) break;
                return new GuiQuickStacker(new ContainerQuickStacker(player, stack));
            }
            case 1006: {
                ItemStack stack = EntityUtils.getHeldItemOfType((EntityLivingBase)player, EnderUtilitiesItems.NULLIFIER);
                if (stack.func_190926_b()) break;
                return new GuiNullifier(new ContainerNullifier(player, stack));
            }
        }
        return null;
    }
}

