/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.event;

import com.google.common.base.Predicates;
import fi.dy.masa.enderutilities.block.base.BlockEnderUtilities;
import fi.dy.masa.enderutilities.block.base.BlockEnderUtilitiesTileEntity;
import fi.dy.masa.enderutilities.client.renderer.item.BuildersWandRenderer;
import fi.dy.masa.enderutilities.client.renderer.item.RulerRenderer;
import fi.dy.masa.enderutilities.client.renderer.util.RenderUtils;
import fi.dy.masa.enderutilities.config.Configs;
import fi.dy.masa.enderutilities.entity.EntityChair;
import fi.dy.masa.enderutilities.item.block.ItemBlockEnderUtilities;
import fi.dy.masa.enderutilities.item.block.ItemBlockPlacementProperty;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesBlocks;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.tileentity.TileEntityPortalPanel;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.ItemType;
import fi.dy.masa.enderutilities.util.PlacementProperties;
import fi.dy.masa.enderutilities.util.PositionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RenderEventHandler {
    private static RenderEventHandler INSTANCE;
    public Minecraft mc;
    protected BuildersWandRenderer buildersWandRenderer;
    protected RulerRenderer rulerRenderer;
    protected BlockPos pointedPosLast = BlockPos.field_177992_a;
    protected EnumFacing pointedBlockFacingLast = EnumFacing.DOWN;
    protected float partialTicks;

    public RenderEventHandler() {
        this.mc = Minecraft.func_71410_x();
        this.buildersWandRenderer = new BuildersWandRenderer();
        this.rulerRenderer = new RulerRenderer();
        INSTANCE = this;
    }

    public static RenderEventHandler getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        this.renderItemExtras((World)this.mc.field_71441_e, (EntityPlayer)this.mc.field_71439_g, (EntityPlayer)this.mc.field_71439_g, event.getPartialTicks());
        if (Configs.buildersWandRenderForOtherPlayers) {
            for (EntityPlayer player : this.mc.field_71441_e.func_175661_b(EntityPlayer.class, EntitySelectors.field_180132_d)) {
                this.renderItemExtras((World)this.mc.field_71441_e, player, (EntityPlayer)this.mc.field_71439_g, event.getPartialTicks());
            }
        }
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (!(this.mc.field_71462_r instanceof GuiChat) && this.mc.field_71439_g != null) {
            this.buildersWandRenderer.renderHud((EntityPlayer)this.mc.field_71439_g);
            this.rulerRenderer.renderHud();
            this.renderPlacementPropertiesHud((EntityPlayer)this.mc.field_71439_g);
        }
    }

    @SubscribeEvent
    public void onBlockHilight(DrawBlockHighlightEvent event) {
        RayTraceResult trace = event.getTarget();
        if (trace != null && trace.field_72313_a == RayTraceResult.Type.BLOCK) {
            WorldClient world = this.mc.field_71441_e;
            BlockPos pos = trace.func_178782_a();
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block == EnderUtilitiesBlocks.PORTAL_PANEL || block == EnderUtilitiesBlocks.INSERTER) {
                state = state.func_185899_b((IBlockAccess)world, pos);
                this.updatePointedBlockHilight((World)world, trace.func_178782_a(), state, (BlockEnderUtilities)block, event.getPartialTicks());
            }
            if (block == EnderUtilitiesBlocks.PORTAL_PANEL) {
                this.renderPortalPanelText((World)this.mc.field_71441_e, trace.func_178782_a(), (BlockEnderUtilities)block, (EntityPlayer)this.mc.field_71439_g, event.getPartialTicks());
            }
        }
    }

    private void renderItemExtras(World world, EntityPlayer usingPlayer, EntityPlayer clientPlayer, float partialTicks) {
        ItemStack stack = EntityUtils.getHeldItemOfType((EntityLivingBase)usingPlayer, EnderUtilitiesItems.BUILDERS_WAND);
        if (!stack.func_190926_b() && stack.func_77973_b() == EnderUtilitiesItems.BUILDERS_WAND) {
            this.buildersWandRenderer.renderSelectedArea(world, usingPlayer, stack, clientPlayer, partialTicks);
        }
        if (!(stack = EntityUtils.getHeldItemOfType((EntityLivingBase)usingPlayer, EnderUtilitiesItems.CHAIR_WAND)).func_190926_b()) {
            List chairs = world.func_175644_a(EntityChair.class, Predicates.alwaysTrue());
            for (Entity entity : chairs) {
                RenderUtils.renderEntityDebugBoundingBox(entity, partialTicks, false, false);
            }
        }
        this.rulerRenderer.renderAllPositionPairs(usingPlayer, clientPlayer, partialTicks);
    }

    private void renderPortalPanelText(World world, BlockPos pos, BlockEnderUtilities block, EntityPlayer player, float partialTicks) {
        EnumFacing facing;
        Integer elementId;
        String name;
        IBlockState state = world.func_180495_p(pos);
        TileEntityPortalPanel te = BlockEnderUtilitiesTileEntity.getTileEntitySafely((IBlockAccess)world, pos, TileEntityPortalPanel.class);
        if (te != null && !StringUtils.isBlank((CharSequence)(name = (elementId = (Integer)block.getPointedElementId(world, pos, facing = (EnumFacing)state.func_177229_b((IProperty)block.propFacing), (Entity)player)) != null && elementId >= 0 && elementId <= 7 ? te.getTargetDisplayName(elementId) : te.getPanelDisplayName())) && name.length() > 0) {
            this.renderPortalPanelText(name, player, pos, facing, partialTicks);
        }
    }

    protected void renderPortalPanelText(String text, EntityPlayer player, BlockPos pos, EnumFacing facing, float partialTicks) {
        double x = pos.func_177958_n();
        double y = pos.func_177956_o();
        double z = pos.func_177952_p();
        double dx = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double dy = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double dz = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        float angleH = 0.0f;
        float angleV = 0.0f;
        double frontOffset = 0.32;
        if (facing.func_176740_k().func_176722_c()) {
            int frontX = facing.func_82601_c();
            int frontZ = facing.func_82599_e();
            if (facing == EnumFacing.NORTH || facing == EnumFacing.WEST) {
                frontX = -frontX;
                frontZ = -frontZ;
                frontOffset = 1.0 - frontOffset;
            }
            x += (double)frontX * frontOffset + (double)frontZ * 0.5;
            z += (double)frontZ * frontOffset + (double)frontX * 0.5;
            y += 1.25;
            angleH = facing.func_185119_l() + 180.0f;
        } else {
            if (facing == EnumFacing.DOWN) {
                frontOffset = 1.0 - frontOffset;
                x += 0.5;
                z -= 0.25;
            } else {
                x += 0.5;
                z += 1.25;
            }
            y += frontOffset;
            angleV = (float)facing.func_96559_d() * -90.0f;
        }
        this.renderLabel(text, x - dx, y - dy, z - dz, angleH, angleV);
    }

    protected void renderLabel(String text, double x, double y, double z, float angleH, float angleV) {
        boolean flag = false;
        FontRenderer fontrenderer = this.mc.field_71466_p;
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-angleH), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-angleV), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-0.025f, (float)-0.025f, (float)0.025f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        int strLenHalved = fontrenderer.func_78256_a(text) / 2;
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b((double)(-strLenHalved - 1), -1.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        vertexbuffer.func_181662_b((double)(-strLenHalved - 1), 8.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        vertexbuffer.func_181662_b((double)(strLenHalved + 1), 8.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        vertexbuffer.func_181662_b((double)(strLenHalved + 1), -1.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        fontrenderer.func_78276_b(text, -strLenHalved, 0, 0x20FFFFFF);
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        fontrenderer.func_78276_b(text, -strLenHalved, 0, flag ? 0x20FFFFFF : -1);
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public static void renderText(List<String> lines, int offsetX, int offsetY, HudAlignment align, boolean useTextBackground, boolean useFontShadow, Minecraft mc) {
        ScaledResolution scaledResolution = new ScaledResolution(mc);
        int scaledY = scaledResolution.func_78328_b();
        int lineHeight = mc.field_71466_p.field_78288_b + 2;
        int posX = offsetX;
        int posY = offsetY;
        switch (align) {
            case TOP_LEFT: 
            case TOP_RIGHT: 
            case BOTTOM_RIGHT: {
                break;
            }
            case BOTTOM_LEFT: {
                posY = scaledY - lineHeight * lines.size() - offsetY;
            }
        }
        int textBgColor = Integer.MIN_VALUE;
        FontRenderer fontRenderer = mc.field_71466_p;
        for (String line : lines) {
            if (useTextBackground) {
                Gui.func_73734_a((int)(posX - 2), (int)(posY - 2), (int)(posX + fontRenderer.func_78256_a(line) + 2), (int)(posY + fontRenderer.field_78288_b), (int)textBgColor);
            }
            if (useFontShadow) {
                mc.field_71456_v.func_73731_b(fontRenderer, line, posX, posY, -1);
            } else {
                fontRenderer.func_78276_b(line, posX, posY, -1);
            }
            posY += fontRenderer.field_78288_b + 2;
        }
    }

    private void renderPlacementPropertiesHud(EntityPlayer player) {
        ItemBlockPlacementProperty item;
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBlockEnderUtilities)) {
            stack = player.func_184592_cb();
        }
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemBlockPlacementProperty && (item = (ItemBlockPlacementProperty)stack.func_77973_b()).hasPlacementProperty(stack)) {
            RenderEventHandler.renderText(this.getPlacementPropertiesText(item, stack, player), 4, 0, HudAlignment.BOTTOM_LEFT, true, true, this.mc);
        }
    }

    private List<String> getPlacementPropertiesText(ItemBlockPlacementProperty item, ItemStack stack, EntityPlayer player) {
        String preGreen = TextFormatting.GREEN.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.WHITE.toString();
        ArrayList<String> lines = new ArrayList<String>();
        PlacementProperties props = PlacementProperties.getInstance();
        UUID uuid = player.func_110124_au();
        PlacementProperties.PlacementProperty pp = item.getPlacementProperty(stack);
        boolean nbtSensitive = pp.isNBTSensitive();
        ItemType type = new ItemType(stack, nbtSensitive);
        int index = props.getPropertyIndex(uuid, type);
        int count = pp.getPropertyCount();
        for (int i = 0; i < count; ++i) {
            Pair<String, Integer> pair = pp.getProperty(i);
            if (pair == null) continue;
            String key = (String)pair.getLeft();
            String pre = i == index ? "> " : "  ";
            String name = I18n.func_135052_a((String)("enderutilities.placement_properties." + key), (Object[])new Object[0]);
            int value = props.getPropertyValue(uuid, type, key, (Integer)pair.getRight());
            String valueName = pp.getPropertyValueName(key, value);
            valueName = valueName == null ? String.valueOf(value) : I18n.func_135052_a((String)("enderutilities.placement_properties.valuenames." + key + "." + valueName), (Object[])new Object[0]);
            lines.add(String.format("%s%s: %s%s%s", pre, name, preGreen, valueName, rst));
        }
        return lines;
    }

    public <T> AxisAlignedBB getPointedHilightBox(BlockEnderUtilities block) {
        Map boxMap = block.getHilightBoxMap();
        Object key = EntityUtils.getPointedBox(this.mc.func_175606_aa(), 6.0, boxMap, this.partialTicks);
        if (key != null) {
            return boxMap.get(key);
        }
        return PositionUtils.ZERO_BB;
    }

    protected void updatePointedBlockHilight(World world, BlockPos pos, IBlockState state, BlockEnderUtilities block, float partialTicks) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)block.propFacing);
        if (!pos.equals((Object)this.pointedPosLast) || facing != this.pointedBlockFacingLast) {
            block.updateBlockHilightBoxes(world, pos, facing);
            this.pointedPosLast = pos;
            this.pointedBlockFacingLast = facing;
        }
        this.partialTicks = partialTicks;
    }

    public static enum HudAlignment {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

