/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.block;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.enderutilities.block.base.BlockEnderUtilities;
import fi.dy.masa.enderutilities.block.base.BlockEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.event.RenderEventHandler;
import fi.dy.masa.enderutilities.item.block.ItemBlockPlacementProperty;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import fi.dy.masa.enderutilities.tileentity.TileEntityInserter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class BlockInserter
extends BlockEnderUtilitiesInventory {
    protected static final AxisAlignedBB BOUNDS_MAIN_NS = new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 1.0);
    protected static final AxisAlignedBB BOUNDS_MAIN_WE = new AxisAlignedBB(0.0, 0.25, 0.25, 1.0, 0.75, 0.75);
    protected static final AxisAlignedBB BOUNDS_MAIN_DU = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
    protected static final AxisAlignedBB BOUNDS_SIDE_DOWN = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.25, 0.75);
    protected static final AxisAlignedBB BOUNDS_SIDE_UP = new AxisAlignedBB(0.25, 0.75, 0.25, 0.75, 1.0, 0.75);
    protected static final AxisAlignedBB BOUNDS_SIDE_NORTH = new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 0.25);
    protected static final AxisAlignedBB BOUNDS_SIDE_SOUTH = new AxisAlignedBB(0.25, 0.25, 0.75, 0.75, 0.75, 1.0);
    protected static final AxisAlignedBB BOUNDS_SIDE_WEST = new AxisAlignedBB(0.0, 0.25, 0.25, 0.25, 0.75, 0.75);
    protected static final AxisAlignedBB BOUNDS_SIDE_EAST = new AxisAlignedBB(0.75, 0.25, 0.25, 1.0, 0.75, 0.75);
    public static final PropertyEnum<InserterType> TYPE = PropertyEnum.func_177709_a((String)"type", InserterType.class);
    public static final PropertyEnum<Connection> CONN_UP = PropertyEnum.func_177709_a((String)"up", Connection.class);
    public static final PropertyEnum<Connection> CONN_DOWN = PropertyEnum.func_177709_a((String)"down", Connection.class);
    public static final PropertyEnum<Connection> CONN_NORTH = PropertyEnum.func_177709_a((String)"north", Connection.class);
    public static final PropertyEnum<Connection> CONN_SOUTH = PropertyEnum.func_177709_a((String)"south", Connection.class);
    public static final PropertyEnum<Connection> CONN_WEST = PropertyEnum.func_177709_a((String)"west", Connection.class);
    public static final PropertyEnum<Connection> CONN_EAST = PropertyEnum.func_177709_a((String)"east", Connection.class);
    public static final List<PropertyEnum<Connection>> CONNECTIONS = new ArrayList<PropertyEnum<Connection>>();
    private static final AxisAlignedBB[] SIDE_BOUNDS_BY_FACING = new AxisAlignedBB[]{BOUNDS_SIDE_DOWN, BOUNDS_SIDE_UP, BOUNDS_SIDE_NORTH, BOUNDS_SIDE_SOUTH, BOUNDS_SIDE_WEST, BOUNDS_SIDE_EAST};
    private final Map<Pair<Part, EnumFacing>, AxisAlignedBB> hilightBoxMap = new ConcurrentHashMap<Pair<Part, EnumFacing>, AxisAlignedBB>();

    public BlockInserter(String name, float hardness, float resistance, int harvestLevel, Material material) {
        super(name, hardness, resistance, harvestLevel, material);
        this.propFacing = FACING;
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(TYPE, (Comparable)((Object)InserterType.NORMAL)).func_177226_a((IProperty)FACING, (Comparable)BlockEnderUtilities.DEFAULT_FACING).func_177226_a(CONN_UP, (Comparable)((Object)Connection.NONE)).func_177226_a(CONN_DOWN, (Comparable)((Object)Connection.NONE)).func_177226_a(CONN_NORTH, (Comparable)((Object)Connection.NONE)).func_177226_a(CONN_SOUTH, (Comparable)((Object)Connection.NONE)).func_177226_a(CONN_WEST, (Comparable)((Object)Connection.NONE)).func_177226_a(CONN_EAST, (Comparable)((Object)Connection.NONE)));
        CONNECTIONS.add(CONN_DOWN);
        CONNECTIONS.add(CONN_UP);
        CONNECTIONS.add(CONN_NORTH);
        CONNECTIONS.add(CONN_SOUTH);
        CONNECTIONS.add(CONN_WEST);
        CONNECTIONS.add(CONN_EAST);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, FACING, CONN_UP, CONN_DOWN, CONN_NORTH, CONN_SOUTH, CONN_WEST, CONN_EAST});
    }

    @Override
    protected String[] generateUnlocalizedNames() {
        return new String[]{"inserter_normal", "inserter_filtered"};
    }

    @Override
    protected String[] generateTooltipNames() {
        return this.generateUnlocalizedNames();
    }

    @Override
    public ItemBlock createItemBlock() {
        ItemBlockPlacementProperty item = new ItemBlockPlacementProperty(this);
        item.addPlacementProperty(Short.MAX_VALUE, "inserter.delay", 3, 0, 72000);
        item.addPlacementProperty(Short.MAX_VALUE, "inserter.redstone_mode", 1, 0, 2);
        item.addPlacementProperty(Short.MAX_VALUE, "inserter.stack_limit", 1, 1, 64);
        String[] names = new String[]{"ignored", "low", "high"};
        item.addPlacementPropertyValueNames(Short.MAX_VALUE, "inserter.redstone_mode", names);
        return item;
    }

    @Override
    protected TileEntityEnderUtilities createTileEntityInstance(World worldIn, IBlockState state) {
        TileEntityInserter te = new TileEntityInserter();
        te.setIsFiltered(state.func_177229_b(TYPE) == InserterType.FILTERED);
        return te;
    }

    @Override
    protected EnumFacing getPlacementFacing(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        return EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer).func_176734_d();
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        TileEntityInserter te = BlockInserter.getTileEntitySafely((IBlockAccess)world, pos, TileEntityInserter.class);
        if (te != null) {
            te.onNeighborBlockChange(world, pos, state, state.func_177230_c());
        }
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af() && player.func_184614_ca().func_190926_b() && player.func_184592_cb().func_190926_b()) {
            TileEntityInserter te;
            if (!world.field_72995_K && (te = BlockInserter.getTileEntitySafely((IBlockAccess)world, pos, TileEntityInserter.class)) != null) {
                Pair key = (Pair)this.getPointedElementId(world, pos, (EnumFacing)state.func_185899_b((IBlockAccess)world, pos).func_177229_b((IProperty)FACING), (Entity)player);
                if (key != null && key.getLeft() == Part.SIDE) {
                    side = (EnumFacing)key.getRight();
                }
                if (side == te.getFacing() || side == te.getFacing().func_176734_d()) {
                    te.setFacing(te.getFacing().func_176734_d());
                } else {
                    te.toggleOutputSide(side);
                }
            }
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntityInserter te;
        if (world instanceof World && !((World)world).field_72995_K && (te = BlockInserter.getTileEntitySafely(world, pos, TileEntityInserter.class)) != null) {
            te.onNeighborTileChange(world, pos, neighbor);
        }
    }

    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random random) {
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        TileEntityInserter te;
        if (!world.field_72995_K && (te = BlockInserter.getTileEntitySafely((IBlockAccess)world, pos, TileEntityInserter.class)) != null) {
            te.onScheduledBlockUpdate(world, pos, state, rand);
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)InserterType.fromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((InserterType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityInserter te = BlockInserter.getTileEntitySafely(world, pos, TileEntityInserter.class);
        if (te != null) {
            ImmutableList<EnumFacing> validSides = te.getValidOutputSides();
            ArrayList<EnumFacing> invalidSides = new ArrayList<EnumFacing>((Collection<EnumFacing>)te.getEnabledOutputSides());
            invalidSides.removeAll((Collection<?>)validSides);
            state = state.func_177226_a((IProperty)FACING, (Comparable)te.getFacing());
            for (EnumFacing side : validSides) {
                state = state.func_177226_a((IProperty)CONNECTIONS.get(side.func_176745_a()), (Comparable)((Object)Connection.VALID));
            }
            for (EnumFacing side : invalidSides) {
                state = state.func_177226_a((IProperty)CONNECTIONS.get(side.func_176745_a()), (Comparable)((Object)Connection.INVALID));
            }
        }
        return state;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        state = this.func_176221_a(state, blockAccess, pos);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (facing) {
            case NORTH: 
            case SOUTH: {
                return BOUNDS_MAIN_NS;
            }
            case WEST: 
            case EAST: {
                return BOUNDS_MAIN_WE;
            }
        }
        return BOUNDS_MAIN_DU;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entity, boolean p_185477_7_) {
        super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entity, p_185477_7_);
        TileEntityInserter te = BlockInserter.getTileEntitySafely((IBlockAccess)world, pos, TileEntityInserter.class);
        if (te != null) {
            for (EnumFacing side : te.getEnabledOutputSides()) {
                switch (side) {
                    case DOWN: {
                        BlockInserter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDS_SIDE_DOWN);
                        break;
                    }
                    case UP: {
                        BlockInserter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDS_SIDE_UP);
                        break;
                    }
                    case NORTH: {
                        BlockInserter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDS_SIDE_NORTH);
                        break;
                    }
                    case SOUTH: {
                        BlockInserter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDS_SIDE_SOUTH);
                        break;
                    }
                    case WEST: {
                        BlockInserter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDS_SIDE_WEST);
                        break;
                    }
                    case EAST: {
                        BlockInserter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDS_SIDE_EAST);
                    }
                }
            }
        }
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end) {
        this.updateBlockHilightBoxes(world, pos, (EnumFacing)state.func_185899_b((IBlockAccess)world, pos).func_177229_b((IProperty)FACING));
        ArrayList<RayTraceResult> list = new ArrayList<RayTraceResult>();
        for (AxisAlignedBB bb : this.getHilightBoxMap().values()) {
            RayTraceResult trace = bb.func_72327_a(start, end);
            if (trace == null) continue;
            list.add(new RayTraceResult(trace.field_72307_f, trace.field_178784_b, pos));
        }
        RayTraceResult trace = null;
        double closest = 0.0;
        for (RayTraceResult traceTmp : list) {
            double dist;
            if (traceTmp == null || !((dist = traceTmp.field_72307_f.func_72436_e(end)) > closest)) continue;
            trace = traceTmp;
            closest = dist;
        }
        return trace;
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        AxisAlignedBB bb = RenderEventHandler.getInstance().getPointedHilightBox(this);
        if (bb != null) {
            return bb;
        }
        return state.func_185900_c((IBlockAccess)world, pos).func_186670_a(pos);
    }

    public Map<Pair<Part, EnumFacing>, AxisAlignedBB> getHilightBoxMap() {
        return this.hilightBoxMap;
    }

    @Override
    public void updateBlockHilightBoxes(World world, BlockPos pos, EnumFacing facing) {
        TileEntityInserter te = BlockInserter.getTileEntitySafely((IBlockAccess)world, pos, TileEntityInserter.class);
        Map<Pair<Part, EnumFacing>, AxisAlignedBB> boxMap = this.getHilightBoxMap();
        boxMap.clear();
        if (te != null) {
            for (EnumFacing side : te.getEnabledOutputSides()) {
                boxMap.put((Pair<Part, EnumFacing>)Pair.of((Object)((Object)Part.SIDE), (Object)side), SIDE_BOUNDS_BY_FACING[side.func_176745_a()].func_186670_a(pos));
            }
        }
        switch (facing) {
            case DOWN: 
            case UP: {
                boxMap.put((Pair<Part, EnumFacing>)Pair.of((Object)((Object)Part.MAIN), (Object)EnumFacing.DOWN), BOUNDS_MAIN_DU.func_186670_a(pos));
                break;
            }
            case NORTH: 
            case SOUTH: {
                boxMap.put((Pair<Part, EnumFacing>)Pair.of((Object)((Object)Part.MAIN), (Object)EnumFacing.NORTH), BOUNDS_MAIN_NS.func_186670_a(pos));
                break;
            }
            case WEST: 
            case EAST: {
                boxMap.put((Pair<Part, EnumFacing>)Pair.of((Object)((Object)Part.MAIN), (Object)EnumFacing.WEST), BOUNDS_MAIN_WE.func_186670_a(pos));
            }
        }
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < InserterType.values().length; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, InserterType.values()[i].getMeta()));
        }
    }

    private static enum Part {
        MAIN,
        SIDE;

    }

    public static enum Connection implements IStringSerializable
    {
        NONE("none"),
        VALID("valid"),
        INVALID("invalid");

        private final String name;

        private Connection(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }

    public static enum InserterType implements IStringSerializable
    {
        NORMAL(0, "normal"),
        FILTERED(1, "filtered");

        private final int meta;
        private final String name;

        private InserterType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static InserterType fromMeta(int meta) {
            return InserterType.values()[meta % InserterType.values().length];
        }
    }
}

