/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.arl.block.BlockMetaVariants;
import vazkii.arl.block.BlockMod;
import vazkii.quark.base.block.IQuarkBlock;

public class BlockSpeleothem
extends BlockMod
implements IQuarkBlock {
    public static PropertyEnum<EnumSize> SIZE = PropertyEnum.func_177709_a((String)"size", EnumSize.class);

    public BlockSpeleothem(String name) {
        super(name + "_speleothem", Material.field_151576_e, new String[0]);
        this.func_149711_c(1.5f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(SIZE, (Comparable)((Object)EnumSize.MEDIUM)));
    }

    public BlockSpeleothem setNetherrack() {
        this.func_149711_c(0.4f);
        return this;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return this.getBearing((IBlockAccess)worldIn, pos) > 0;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        EnumSize size = EnumSize.values()[Math.max(0, this.getBearing((IBlockAccess)worldIn, pos) - 1)];
        worldIn.func_175656_a(pos, state.func_177226_a(SIZE, (Comparable)((Object)size)));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        int size = ((EnumSize)((Object)state.func_177229_b(BlockSpeleothem.SIZE))).strength;
        if (this.getBearing((IBlockAccess)worldIn, pos) < size + 1) {
            worldIn.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)worldIn.func_180495_p(pos)));
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    private int getBearing(IBlockAccess world, BlockPos pos) {
        return Math.max(this.getStrength(world, pos.func_177977_b()), this.getStrength(world, pos.func_177984_a()));
    }

    private int getStrength(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c().func_149730_j(state)) {
            return 3;
        }
        if (state.func_177227_a().contains(SIZE)) {
            return ((EnumSize)((Object)state.func_177229_b(BlockSpeleothem.SIZE))).strength;
        }
        return 0;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return ((EnumSize)((Object)state.func_177229_b(BlockSpeleothem.SIZE))).aabb;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return this.func_185496_a(blockState, worldIn, pos);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SIZE});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumSize)((Object)state.func_177229_b(SIZE))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(SIZE, (Comparable)((Object)EnumSize.values()[Math.min(EnumSize.values().length - 1, meta)]));
    }

    public static enum EnumSize implements BlockMetaVariants.EnumBase
    {
        SMALL(0, 2),
        MEDIUM(1, 4),
        BIG(2, 8);

        public final int strength;
        public final AxisAlignedBB aabb;

        private EnumSize(int strength, int width) {
            this.strength = strength;
            float pad = (float)((16 - width) / 2) / 16.0f;
            this.aabb = new AxisAlignedBB((double)pad, 0.0, (double)pad, (double)(1.0f - pad), 1.0, (double)(1.0f - pad));
        }
    }
}

