/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.gear;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.altar.IAltarManipulator;
import WayofTime.bloodmagic.altar.IBloodAltar;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.iface.IItemLPContainer;
import WayofTime.bloodmagic.util.helper.ItemHelper;
import WayofTime.bloodmagic.util.helper.NBTHelper;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import WayofTime.bloodmagic.util.helper.TextHelper;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class ItemPackSelfSacrifice
extends ItemArmor
implements IAltarManipulator,
IItemLPContainer,
IVariantProvider {
    public final int CONVERSION = 100;
    public final int CAPACITY = 10000;
    public final int INTERVAL = 20;
    public final float HEALTHREQ = 0.5f;

    public ItemPackSelfSacrifice() {
        super(ItemArmor.ArmorMaterial.CHAIN, 0, EntityEquipmentSlot.CHEST);
        this.func_77655_b("bloodmagic.pack.selfSacrifice");
        this.func_77637_a(BloodMagic.TAB_BM);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        RayTraceResult position = this.func_77621_a(world, player, false);
        if (position == null) {
            return super.func_77659_a(world, player, EnumHand.MAIN_HAND);
        }
        if (position.field_72313_a == RayTraceResult.Type.BLOCK) {
            TileEntity tile = world.func_175625_s(position.func_178782_a());
            if (!(tile instanceof IBloodAltar)) {
                return super.func_77659_a(world, player, EnumHand.MAIN_HAND);
            }
            ItemHelper.LPContainer.tryAndFillAltar((IBloodAltar)tile, stack, world, position.func_178782_a());
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (world.field_72995_K || player.field_71075_bZ.field_75098_d) {
            return;
        }
        boolean shouldSyphon = player.func_110143_aJ() / player.func_110138_aP() > 0.5f && this.getStoredLP(stack) < 10000;
        if (shouldSyphon & world.func_82737_E() % 20L == 0L) {
            NetworkHelper.getSoulNetwork(player).hurtPlayer(player, 1.0f);
            ItemHelper.LPContainer.addLPToItem(stack, 100, 10000);
        }
        if (this.getStoredLP(stack) > 10000) {
            this.setStoredLP(stack, 10000);
        }
    }

    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flag) {
        if (!stack.func_77942_o()) {
            return;
        }
        list.add(TextHelper.localize("tooltip.bloodmagic.pack.selfSacrifice.desc", new Object[0]));
        list.add(TextHelper.localize("tooltip.bloodmagic.pack.stored", this.getStoredLP(stack)));
    }

    @Override
    public void gatherVariants(@Nonnull Int2ObjectMap<String> variants) {
        variants.put(0, (Object)"type=normal");
    }

    @Override
    public int getCapacity() {
        return this.CAPACITY;
    }

    @Override
    public int getStoredLP(ItemStack stack) {
        return stack != null ? NBTHelper.checkNBT(stack).func_77978_p().func_74762_e("storedLP") : 0;
    }

    @Override
    public void setStoredLP(ItemStack stack, int lp) {
        if (stack != null) {
            NBTHelper.checkNBT(stack).func_77978_p().func_74768_a("storedLP", lp);
        }
    }
}

