/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.common.inventory;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.inventory.BaseContainer;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.shared.inventory.InventoryCraftingPersistent;
import slimeknights.tconstruct.tools.common.inventory.ContainerSideInventory;
import slimeknights.tconstruct.tools.common.inventory.ContainerTinkerStation;
import slimeknights.tconstruct.tools.common.inventory.SlotCraftingFastWorkbench;
import slimeknights.tconstruct.tools.common.network.LastRecipeMessage;
import slimeknights.tconstruct.tools.common.tileentity.TileCraftingStation;

@Mod.EventBusSubscriber
public class ContainerCraftingStation
extends ContainerTinkerStation<TileCraftingStation> {
    public static final Logger log = LogManager.getLogger((String)"test");
    private static final int SLOT_RESULT = 0;
    private final EntityPlayer player;
    private final InventoryCraftingPersistent craftMatrix;
    private final InventoryCraftResult craftResult = new InventoryCraftResult();
    private IRecipe lastRecipe;
    private IRecipe lastLastRecipe;

    @SubscribeEvent
    public static void onCraftingStationGuiOpened(PlayerContainerEvent.Open event) {
        if (event.getContainer() instanceof ContainerCraftingStation) {
            ((ContainerCraftingStation)event.getContainer()).onCraftMatrixChanged();
        }
    }

    public ContainerCraftingStation(InventoryPlayer playerInventory, TileCraftingStation tile) {
        super(tile);
        this.craftMatrix = new InventoryCraftingPersistent((Container)this, (IInventory)tile, 3, 3);
        this.player = playerInventory.field_70458_d;
        this.func_75146_a((Slot)new SlotCraftingFastWorkbench(this, playerInventory.field_70458_d, this.craftMatrix, (IInventory)this.craftResult, 0, 124, 35));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a(new Slot((IInventory)this.craftMatrix, j + i * 3, 30 + j * 18, 17 + i * 18));
            }
        }
        TileEntity inventoryTE = null;
        EnumFacing accessDir = null;
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            TileEntity te;
            BlockPos neighbor = this.pos.func_177972_a(dir);
            boolean stationPart = false;
            for (Pair tinkerPos : this.tinkerStationBlocks) {
                if (!((BlockPos)tinkerPos.getLeft()).equals((Object)neighbor)) continue;
                stationPart = true;
                break;
            }
            if (stationPart || (te = this.world.func_175625_s(neighbor)) == null || te instanceof TileCraftingStation || this.blacklisted(te.getClass())) continue;
            if (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) instanceof IItemHandlerModifiable) {
                inventoryTE = te;
                accessDir = null;
                break;
            }
            if (!te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d()) || !(te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d()) instanceof IItemHandlerModifiable)) continue;
            inventoryTE = te;
            accessDir = dir.func_176734_d();
            break;
        }
        if (inventoryTE != null) {
            this.addSubContainer((Container)new ContainerSideInventory<Object>(inventoryTE, accessDir, -114, 8, 6), false);
        }
        this.addPlayerInventory(playerInventory, 8, 84);
    }

    private boolean blacklisted(Class<? extends TileEntity> clazz) {
        if (Config.craftingStationBlacklist.isEmpty()) {
            return false;
        }
        ResourceLocation registryName = TileEntity.func_190559_a(clazz);
        if (registryName != null && Config.craftingStationBlacklist.contains(registryName.toString())) {
            return true;
        }
        return Config.craftingStationBlacklist.contains(clazz.getName());
    }

    public void func_190896_a(List<ItemStack> p_190896_1_) {
        this.craftMatrix.setDoNotCallUpdates(true);
        super.func_190896_a(p_190896_1_);
        this.craftMatrix.setDoNotCallUpdates(false);
        this.craftMatrix.onCraftMatrixChanged();
    }

    public void onCraftMatrixChanged() {
        this.func_75130_a((IInventory)this.craftMatrix);
    }

    public void func_75130_a(IInventory inventoryIn) {
        this.func_192389_a(this.world, this.player, this.craftMatrix, this.craftResult);
    }

    protected void func_192389_a(World world, EntityPlayer player, InventoryCrafting inv, InventoryCraftResult result) {
        ItemStack itemstack = ItemStack.field_190927_a;
        if (this.lastRecipe == null || !this.lastRecipe.func_77569_a(inv, world)) {
            this.lastRecipe = CraftingManager.func_192413_b((InventoryCrafting)inv, (World)world);
            TConstruct.log.info("Finding new recipe for {}", (Object)player.getDisplayNameString());
        }
        if (this.lastRecipe != null) {
            itemstack = this.lastRecipe.func_77572_b(inv);
        }
        result.func_70299_a(0, itemstack);
        if (!world.field_72995_K) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)player;
            List<EntityPlayerMP> relevantPlayers = this.getAllPlayersWithThisContainerOpen((BaseContainer)this, entityplayermp.func_71121_q());
            this.syncResultToAllOpenWindows(itemstack, relevantPlayers);
            if (this.lastLastRecipe != this.lastRecipe) {
                this.syncRecipeToAllOpenWindows(this.lastRecipe, relevantPlayers);
                this.lastLastRecipe = this.lastRecipe;
            }
        }
    }

    private void syncResultToAllOpenWindows(ItemStack stack, List<EntityPlayerMP> players) {
        players.forEach(otherPlayer -> otherPlayer.field_71070_bA.func_75141_a(0, stack));
    }

    private void syncRecipeToAllOpenWindows(IRecipe lastRecipe, List<EntityPlayerMP> players) {
        players.forEach(otherPlayer -> {
            ((ContainerCraftingStation)otherPlayer.field_71070_bA).lastRecipe = lastRecipe;
            TinkerNetwork.sendTo(new LastRecipeMessage(lastRecipe), otherPlayer);
        });
    }

    private <T extends TileEntity> List<EntityPlayerMP> getAllPlayersWithThisContainerOpen(BaseContainer<T> container, WorldServer server) {
        return server.field_73010_i.stream().filter(player -> this.hasSameContainerOpen(container, (EntityPlayer)player)).map(player -> (EntityPlayerMP)player).collect(Collectors.toList());
    }

    private <T extends TileEntity> boolean hasSameContainerOpen(BaseContainer<T> container, EntityPlayer playerToCheck) {
        return playerToCheck instanceof EntityPlayerMP && playerToCheck.field_71070_bA.getClass().isAssignableFrom(container.getClass()) && this.sameGui((BaseContainer)playerToCheck.field_71070_bA);
    }

    public boolean func_94530_a(ItemStack p_94530_1_, Slot p_94530_2_) {
        return p_94530_2_.field_75224_c != this.craftResult && super.func_94530_a(p_94530_1_, p_94530_2_);
    }

    protected TileEntity detectInventory() {
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            TileEntity te;
            BlockPos neighbor = this.pos.func_177972_a(dir);
            boolean stationPart = false;
            for (Pair tinkerPos : this.tinkerStationBlocks) {
                if (!((BlockPos)tinkerPos.getLeft()).equals((Object)neighbor)) continue;
                stationPart = true;
                break;
            }
            if (stationPart || (te = this.world.func_175625_s(neighbor)) == null || !te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d()) || !(te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d()) instanceof IItemHandlerModifiable)) continue;
            return te;
        }
        return null;
    }

    public int getPlayerInventoryStart() {
        return this.playerInventoryStart;
    }

    public InventoryCrafting getCraftMatrix() {
        return this.craftMatrix;
    }

    public void updateLastRecipeFromServer(IRecipe recipe) {
        this.lastRecipe = recipe;
        this.craftResult.func_70299_a(0, recipe != null ? recipe.func_77572_b((InventoryCrafting)this.craftMatrix) : ItemStack.field_190927_a);
    }

    public NonNullList<ItemStack> getRemainingItems() {
        if (this.lastRecipe != null && this.lastRecipe.func_77569_a((InventoryCrafting)this.craftMatrix, this.world)) {
            return this.lastRecipe.func_179532_b((InventoryCrafting)this.craftMatrix);
        }
        return this.craftMatrix.field_70466_a;
    }
}

