/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct;

import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.common.GuiHandler;
import slimeknights.mantle.pulsar.config.IConfiguration;
import slimeknights.mantle.pulsar.control.PulseManager;
import slimeknights.tconstruct.TinkerIntegration;
import slimeknights.tconstruct.common.ClientProxy;
import slimeknights.tconstruct.common.CommonProxy;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.common.TinkerOredict;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.common.config.ConfigSync;
import slimeknights.tconstruct.debug.TinkerDebug;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.book.TinkerBook;
import slimeknights.tconstruct.library.capability.piggyback.CapabilityTinkerPiggyback;
import slimeknights.tconstruct.library.capability.projectile.CapabilityTinkerProjectile;
import slimeknights.tconstruct.library.utils.HarvestLevels;
import slimeknights.tconstruct.plugin.Chisel;
import slimeknights.tconstruct.plugin.ChiselAndBits;
import slimeknights.tconstruct.plugin.CraftingTweaks;
import slimeknights.tconstruct.plugin.theoneprobe.TheOneProbe;
import slimeknights.tconstruct.plugin.waila.Waila;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerFluids;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.AggregateModelRegistrar;
import slimeknights.tconstruct.tools.TinkerMaterials;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.harvest.TinkerHarvestTools;
import slimeknights.tconstruct.tools.melee.TinkerMeleeWeapons;
import slimeknights.tconstruct.tools.ranged.TinkerRangedWeapons;
import slimeknights.tconstruct.world.TinkerWorld;

@Mod(modid="tconstruct", name="Tinkers' Construct", version="1.12.2-2.12.0.123", guiFactory="slimeknights.tconstruct.common.config.ConfigGui$ConfigGuiFactory", dependencies="required-after:forge@[14.23.1.2577,);required-after:mantle@[1.12-1.3.3,);after:jei@[4.8,);before:taiga@(1.3.0,);after:chisel", acceptedMinecraftVersions="[1.12, 1.13)")
public class TConstruct {
    public static final String modID = "tconstruct";
    public static final String modVersion = "1.12.2-2.12.0.123";
    public static final String modName = "Tinkers' Construct";
    public static final Logger log = LogManager.getLogger((String)"tconstruct");
    public static final Random random = new Random();
    @Mod.Instance(value="tconstruct")
    public static TConstruct instance;
    @SidedProxy(clientSide="slimeknights.tconstruct.common.CommonProxy", serverSide="slimeknights.tconstruct.common.CommonProxy")
    public static CommonProxy proxy;
    public static PulseManager pulseManager;
    public static GuiHandler guiHandler;
    private static final String TINKERS_SKYBLOCK_MODID = "tinkerskyblock";
    private static final String WOODEN_HOPPER = "wooden_hopper";

    public TConstruct() {
        if (Loader.isModLoaded((String)"Natura")) {
            log.info("Natura, what are we going to do tomorrow night?");
            LogManager.getLogger((String)"Natura").info("TConstruct, we're going to take over the world!");
        } else {
            log.info("Preparing to take over the world");
        }
    }

    @NetworkCheckHandler
    public boolean matchModVersions(Map<String, String> remoteVersions, Side side) {
        if (side == Side.CLIENT) {
            return remoteVersions.containsKey(modID);
        }
        return !remoteVersions.containsKey(modID) || modVersion.equals(remoteVersions.get(modID));
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Config.load(event);
        HarvestLevels.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)guiHandler);
        if (event.getSide().isClient()) {
            ClientProxy.initClient();
            ClientProxy.initRenderMaterials();
        }
        TinkerNetwork.instance.setup();
        CapabilityTinkerPiggyback.register();
        CapabilityTinkerProjectile.register();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (event.getSide().isClient()) {
            ClientProxy.initRenderer();
        } else {
            MinecraftForge.EVENT_BUS.register((Object)new ConfigSync());
        }
    }

    @SubscribeEvent
    public void missingItemMappings(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping entry : event.getAllMappings()) {
            String path = entry.key.toString();
            if (path.equals(Util.resource("bucket")) || path.equals(Util.resource("glow")) || path.equals(Util.resource("blood")) || path.equals(Util.resource("milk")) || path.equals(Util.resource("purpleslime")) || path.equals(Util.resource("blueslime")) || path.contains(Util.resource("molten"))) {
                entry.ignore();
            }
            if (!entry.key.func_110624_b().equals(TINKERS_SKYBLOCK_MODID) || !entry.key.func_110623_a().equals(WOODEN_HOPPER)) continue;
            entry.remap((IForgeRegistryEntry)Item.func_150898_a((Block)TinkerGadgets.woodenHopper));
        }
    }

    @SubscribeEvent
    public void missingBlockMappings(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping entry : event.getAllMappings()) {
            if (!entry.key.func_110624_b().equals(TINKERS_SKYBLOCK_MODID) || !entry.key.func_110623_a().equals(WOODEN_HOPPER)) continue;
            entry.remap((IForgeRegistryEntry)TinkerGadgets.woodenHopper);
        }
    }

    static {
        pulseManager = new PulseManager((IConfiguration)Config.pulseConfig);
        guiHandler = new GuiHandler();
        pulseManager.registerPulse((Object)new TinkerCommons());
        pulseManager.registerPulse((Object)new TinkerWorld());
        pulseManager.registerPulse((Object)new TinkerTools());
        pulseManager.registerPulse((Object)new TinkerHarvestTools());
        pulseManager.registerPulse((Object)new TinkerMeleeWeapons());
        pulseManager.registerPulse((Object)new TinkerRangedWeapons());
        pulseManager.registerPulse((Object)new TinkerModifiers());
        pulseManager.registerPulse((Object)new TinkerSmeltery());
        pulseManager.registerPulse((Object)new TinkerGadgets());
        pulseManager.registerPulse((Object)new TinkerOredict());
        pulseManager.registerPulse((Object)new TinkerIntegration());
        pulseManager.registerPulse((Object)new TinkerFluids());
        pulseManager.registerPulse((Object)new TinkerMaterials());
        pulseManager.registerPulse((Object)new AggregateModelRegistrar());
        pulseManager.registerPulse((Object)new Chisel());
        pulseManager.registerPulse((Object)new ChiselAndBits());
        pulseManager.registerPulse((Object)new CraftingTweaks());
        pulseManager.registerPulse((Object)new Waila());
        pulseManager.registerPulse((Object)new TheOneProbe());
        pulseManager.registerPulse((Object)new TinkerDebug());
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            TinkerBook.init();
        }
    }
}

