/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.entities.shot;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import xreliquary.entities.shot.EntityBlazeShot;
import xreliquary.entities.shot.EntityBusterShot;
import xreliquary.entities.shot.EntityConcussiveShot;
import xreliquary.entities.shot.EntityEnderShot;
import xreliquary.entities.shot.EntityExorcismShot;
import xreliquary.entities.shot.EntityNeutralShot;
import xreliquary.entities.shot.EntitySandShot;
import xreliquary.entities.shot.EntitySeekerShot;
import xreliquary.entities.shot.EntityStormShot;
import xreliquary.reference.ClientReference;
import xreliquary.reference.Settings;
import xreliquary.util.potions.XRPotionHelper;

public abstract class EntityShotBase
extends Entity
implements IProjectile {
    private static final DataParameter<Byte> CRITICAL = EntityDataManager.func_187226_a(EntityShotBase.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityShotBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private boolean inGround = false;
    private List<PotionEffect> potionEffects;
    EntityPlayer shootingEntity;
    protected int ticksInAir = 0;
    private int ricochetCounter = 0;
    private boolean scheduledForDeath = false;

    public EntityShotBase(World world) {
        super(world);
        this.func_70105_a(0.01f, 0.01f);
    }

    public EntityShotBase(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
    }

    public EntityShotBase(World world, EntityPlayer player, EnumHand hand) {
        this(world);
        this.shootingEntity = player;
        float par3 = 0.8f;
        this.func_70012_b(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, player.field_70177_z, player.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * (float)(hand == EnumHand.MAIN_HAND ? 1 : -1) * 0.16f);
        this.field_70163_u -= 0.2;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * (float)(hand == EnumHand.MAIN_HAND ? 1 : -1) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, par3 * 1.5f, 1.0f);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(CRITICAL, (Object)0);
        this.field_70180_af.func_187214_a(COLOR, (Object)0);
    }

    public EntityShotBase addPotionEffects(List<PotionEffect> effects) {
        if (effects != null && !effects.isEmpty()) {
            this.potionEffects = effects;
            this.field_70180_af.func_187227_b(COLOR, (Object)PotionUtils.func_185181_a(effects));
        }
        return this;
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float var9 = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)var9;
        y /= (double)var9;
        z /= (double)var9;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float var10 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, var10) * 180.0 / Math.PI);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean p_180426_10_) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double par1, double par3, double par5) {
        this.field_70159_w = par1;
        this.field_70181_x = par3;
        this.field_70179_y = par5;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float var7 = MathHelper.func_76133_a((double)(par1 * par1 + par5 * par5));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(par1, par5) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(par3, var7) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    private void ensurePlayerShooterEntity() {
        if (this.shootingEntity == null) {
            List players = this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.field_70165_t - 1.0, this.field_70163_u - 1.0, this.field_70161_v - 1.0, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0));
            Iterator i = players.iterator();
            double closestDistance = Double.MAX_VALUE;
            EntityPlayer closestPlayer = null;
            while (i.hasNext()) {
                EntityPlayer e = (EntityPlayer)i.next();
                double distance = e.func_70032_d((Entity)this);
                if (!(distance < closestDistance)) continue;
                closestPlayer = e;
            }
            if (closestPlayer != null) {
                this.shootingEntity = closestPlayer;
            }
        }
    }

    public void func_70071_h_() {
        AxisAlignedBB axisalignedbb;
        IBlockState blockState;
        Block block;
        super.func_70071_h_();
        if (this.ticksInAir > 200) {
            this.func_70106_y();
        }
        this.ensurePlayerShooterEntity();
        if (this.field_70170_p.field_72995_K) {
            this.spawnPotionParticles();
        }
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float pythingy = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, pythingy) * 180.0 / Math.PI);
        }
        if ((block = (blockState = this.field_70170_p.func_180495_p(new BlockPos(this.xTile, this.yTile, this.zTile))).func_177230_c()) != Blocks.field_150350_a && (axisalignedbb = blockState.func_185900_c((IBlockAccess)this.field_70170_p, new BlockPos(this.xTile, this.yTile, this.zTile))).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            this.inGround = true;
        }
        if (!this.inGround) {
            ++this.ticksInAir;
            if (this.ticksInAir > 1 && this.ticksInAir < 3) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + this.smallGauss(0.1), this.field_70163_u + this.smallGauss(0.1), this.field_70161_v + this.smallGauss(0.1), 0.0, 0.0, 0.0, new int[0]);
                for (int particles = 0; particles < 3; ++particles) {
                    this.doFiringEffects();
                }
            } else {
                this.doFlightEffects();
            }
            Vec3d posVector = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d approachVector = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            RayTraceResult objectStruckByVector = this.field_70170_p.func_147447_a(posVector, approachVector, false, true, false);
            Entity hitEntity = null;
            List struckEntitiesInAABB = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double var7 = 0.0;
            for (Entity struckEntity : struckEntitiesInAABB) {
                double var14;
                if (!struckEntity.func_70067_L() || struckEntity == this.shootingEntity && this.ticksInAir < 5) continue;
                float var11 = 0.5f;
                AxisAlignedBB var12 = struckEntity.func_174813_aQ().func_72314_b((double)var11, (double)var11, (double)var11);
                RayTraceResult var13 = var12.func_72327_a(posVector, approachVector);
                if (var13 == null || !((var14 = posVector.func_72438_d(var13.field_72307_f)) < var7) && var7 != 0.0) continue;
                hitEntity = struckEntity;
                var7 = var14;
            }
            if (hitEntity != null) {
                objectStruckByVector = new RayTraceResult(hitEntity);
            }
            if (objectStruckByVector != null) {
                this.applyPotionEffects(objectStruckByVector);
                this.onImpact(objectStruckByVector);
            }
            if (this.scheduledForDeath) {
                this.func_70106_y();
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
    }

    private void spawnPotionParticles() {
        int color = this.getColor();
        if (color != 0) {
            double d0 = (double)(color >> 16 & 0xFF) / 255.0;
            double d1 = (double)(color >> 8 & 0xFF) / 255.0;
            double d2 = (double)(color & 0xFF) / 255.0;
            for (int j = 0; j < 2; ++j) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, d0, d1, d2, new int[0]);
            }
        }
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    private void applyPotionEffects(RayTraceResult objectStruckByVector) {
        if (objectStruckByVector.field_72313_a == RayTraceResult.Type.ENTITY && objectStruckByVector.field_72308_g instanceof EntityLivingBase && this.potionEffects != null && !this.potionEffects.isEmpty()) {
            EntityLivingBase living = (EntityLivingBase)objectStruckByVector.field_72308_g;
            XRPotionHelper.applyEffectsToEntity(this.potionEffects, this, (Entity)this.shootingEntity, living);
        }
    }

    public void func_70014_b(@Nonnull NBTTagCompound compound) {
        compound.func_74777_a("xTile", (short)this.xTile);
        compound.func_74777_a("yTile", (short)this.yTile);
        compound.func_74777_a("zTile", (short)this.zTile);
        compound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        XRPotionHelper.addPotionEffectsToCompoundTag(compound, this.potionEffects);
    }

    public void func_70037_a(@Nonnull NBTTagCompound compound) {
        this.xTile = compound.func_74765_d("xTile");
        this.yTile = compound.func_74765_d("yTile");
        this.zTile = compound.func_74765_d("zTile");
        this.inGround = compound.func_74771_c("inGround") == 1;
        this.potionEffects = XRPotionHelper.getPotionEffectsFromCompoundTag(compound);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = 64.0;
        return distance < d0 * d0;
    }

    public boolean func_70075_an() {
        return false;
    }

    int d3() {
        return this.field_70146_Z.nextInt(3) + 1;
    }

    int d6() {
        return this.field_70146_Z.nextInt(6) + 1;
    }

    int d12() {
        return this.field_70146_Z.nextInt(12) + 1;
    }

    void doDamage(EntityLivingBase e) {
        e.func_70097_a(this.getDamageSource(), (e instanceof EntityPlayer ? 0.5f : 1.0f) * this.adjustDamageForPotionShots(this.getDamageOfShot(e)));
    }

    private float adjustDamageForPotionShots(int damageOfShot) {
        return this.potionEffects != null && !this.potionEffects.isEmpty() ? 4.0f : (float)damageOfShot;
    }

    protected DamageSource getDamageSource() {
        return DamageSource.func_76365_a((EntityPlayer)this.shootingEntity);
    }

    protected void groundImpact(EnumFacing sideHit) {
        this.ricochet(sideHit);
    }

    protected double smallGauss(double d) {
        return ((double)this.field_70170_p.field_73012_v.nextFloat() - 0.5) * d;
    }

    double posGauss(double d) {
        return (double)this.field_70146_Z.nextFloat() * 0.5 * d;
    }

    protected double gaussian(double d) {
        return d + d * (((double)this.field_70146_Z.nextFloat() - 0.5) / 4.0);
    }

    double lowGauss(double d) {
        return d - d * ((double)(this.field_70146_Z.nextFloat() / 4.0f) + 0.5);
    }

    private void ricochet(EnumFacing sideHit) {
        switch (sideHit) {
            case DOWN: 
            case UP: {
                this.field_70181_x *= -1.0;
                break;
            }
            case WEST: 
            case EAST: {
                this.field_70159_w *= -1.0;
                break;
            }
            case SOUTH: 
            case NORTH: {
                this.field_70179_y *= -1.0;
            }
        }
        ++this.ricochetCounter;
        if (this.ricochetCounter > this.getRicochetMax()) {
            this.doBurstEffect(sideHit);
            this.scheduledForDeath = true;
            block13: for (int particles = 0; particles < 4; ++particles) {
                switch (sideHit) {
                    case DOWN: {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.gaussian(0.1), -this.gaussian(0.1), this.gaussian(0.1), new int[0]);
                        continue block13;
                    }
                    case UP: {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.gaussian(0.1), this.gaussian(0.1), this.gaussian(0.1), new int[0]);
                        continue block13;
                    }
                    case NORTH: {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.gaussian(0.1), this.gaussian(0.1), -this.gaussian(0.1), new int[0]);
                        continue block13;
                    }
                    case SOUTH: {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.gaussian(0.1), this.gaussian(0.1), this.gaussian(0.1), new int[0]);
                        continue block13;
                    }
                    case WEST: {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, -this.gaussian(0.1), this.gaussian(0.1), this.gaussian(0.1), new int[0]);
                        continue block13;
                    }
                    case EAST: {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.gaussian(0.1), this.gaussian(0.1), this.gaussian(0.1), new int[0]);
                    }
                }
            }
        }
    }

    void seekTarget() {
        Entity closestTarget = null;
        Object[] huntableEntitiesBlacklist = Settings.Items.SeekerShot.huntableEntitiesBlacklist;
        List targetsList = this.field_70170_p.func_175674_a((Entity)this, new AxisAlignedBB(this.field_70165_t - 5.0, this.field_70163_u - 5.0, this.field_70161_v - 5.0, this.field_70165_t + 5.0, this.field_70163_u + 5.0, this.field_70161_v + 5.0), e -> e instanceof EntityLiving);
        Iterator iTarget = targetsList.iterator();
        double closestDistance = Double.MAX_VALUE;
        while (iTarget.hasNext()) {
            Entity currentTarget = (Entity)iTarget.next();
            String entityName = EntityList.func_75621_b((Entity)currentTarget);
            if (ArrayUtils.contains((Object[])huntableEntitiesBlacklist, (Object)entityName) || currentTarget == this.shootingEntity || currentTarget.field_70128_L || !((double)this.func_70032_d(currentTarget) < closestDistance)) continue;
            closestDistance = this.func_70032_d(currentTarget);
            closestTarget = currentTarget;
        }
        if (closestTarget != null && this.shootingEntity != null) {
            double x = closestTarget.func_174813_aQ().field_72340_a + closestTarget.func_174813_aQ().field_72336_d;
            x /= 2.0;
            double y = closestTarget.func_174813_aQ().field_72338_b + Math.max(closestTarget.func_70033_W(), (double)closestTarget.field_70131_O);
            double z = closestTarget.func_174813_aQ().field_72339_c + closestTarget.func_174813_aQ().field_72334_f;
            double trueX = this.func_174813_aQ().field_72340_a + this.func_174813_aQ().field_72336_d;
            double trueY = this.func_174813_aQ().field_72338_b + this.func_70033_W();
            double trueZ = this.func_174813_aQ().field_72339_c + this.func_174813_aQ().field_72334_f;
            Vec3d seekVector = new Vec3d(x - (trueX /= 2.0), (y -= (double)closestTarget.field_70131_O / 2.0) - (trueY -= (double)this.field_70131_O / 2.0), (z /= 2.0) - (trueZ /= 2.0));
            seekVector = seekVector.func_72432_b();
            this.field_70159_w = seekVector.field_72450_a * 0.4;
            this.field_70181_x = seekVector.field_72448_b * 0.4;
            this.field_70179_y = seekVector.field_72449_c * 0.4;
            if (this.field_70170_p.field_72995_K) {
                this.func_70016_h(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
        }
    }

    abstract int getRicochetMax();

    abstract int getDamageOfShot(EntityLivingBase var1);

    protected void onImpact(EntityLivingBase entityLiving) {
        if (!this.field_70170_p.field_72995_K) {
            if (entityLiving != this.shootingEntity || this.ticksInAir > 3) {
                this.doDamage(entityLiving);
            }
            this.spawnHitParticles(8);
            this.scheduledForDeath = true;
        }
    }

    protected void onImpact(RayTraceResult result) {
        if (result.field_72313_a == RayTraceResult.Type.ENTITY && result.field_72308_g != null) {
            if (result.field_72308_g == this.shootingEntity) {
                return;
            }
            if (!(result.field_72308_g instanceof EntityLivingBase)) {
                return;
            }
            this.onImpact((EntityLivingBase)result.field_72308_g);
        } else if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
            this.groundImpact(result.field_178784_b);
        }
    }

    abstract void doBurstEffect(EnumFacing var1);

    abstract void doFiringEffects();

    abstract void doFlightEffects();

    abstract void spawnHitParticles(int var1);

    private int getShotType() {
        if (this instanceof EntityNeutralShot) {
            return 1;
        }
        if (this instanceof EntityExorcismShot) {
            return 2;
        }
        if (this instanceof EntityBlazeShot) {
            return 3;
        }
        if (this instanceof EntityEnderShot) {
            return 4;
        }
        if (this instanceof EntityConcussiveShot) {
            return 5;
        }
        if (this instanceof EntityBusterShot) {
            return 6;
        }
        if (this instanceof EntitySeekerShot) {
            return 7;
        }
        if (this instanceof EntitySandShot) {
            return 8;
        }
        if (this instanceof EntityStormShot) {
            return 9;
        }
        return 0;
    }

    public ResourceLocation getShotTexture() {
        switch (this.getShotType()) {
            case 0: 
            case 1: {
                return ClientReference.NEUTRAL;
            }
            case 2: {
                return ClientReference.EXORCISM;
            }
            case 3: {
                return ClientReference.BLAZE;
            }
            case 4: {
                return ClientReference.ENDER;
            }
            case 5: {
                return ClientReference.CONCUSSIVE;
            }
            case 6: {
                return ClientReference.BUSTER;
            }
            case 7: {
                return ClientReference.SEEKER;
            }
            case 8: {
                return ClientReference.SAND;
            }
            case 9: {
                return ClientReference.STORM;
            }
        }
        return ClientReference.NEUTRAL;
    }
}

