/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tools;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public abstract class NetworkIO<P extends IStackProvider>
implements IItemHandler {
    private final List<P> stackProviders;
    protected final EntityPlayer player;

    protected NetworkIO(EntityPlayer player, @Nullable Collection<P> stackProviders) {
        this.player = player;
        this.stackProviders = stackProviders != null ? ImmutableList.copyOf(stackProviders) : ImmutableList.of((Object)new StackProviderVanilla(ItemStack.field_190927_a));
    }

    public int getSlots() {
        return this.stackProviders.size();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.getStackProviderInSlot(slot).getStack();
    }

    protected P getStackProviderInSlot(int slot) {
        return (P)((IStackProvider)this.stackProviders.get(slot));
    }

    @Nullable
    public abstract ItemStack insertItemInternal(ItemStack var1, boolean var2);

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return this.getNonNullStack(this.insertItemInternal(stack, simulate));
    }

    @Nullable
    public abstract ItemStack extractItemInternal(int var1, int var2, boolean var3);

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.getNonNullStack(this.extractItemInternal(slot, amount, simulate));
    }

    @Nonnull
    private ItemStack getNonNullStack(@Nullable ItemStack stack) {
        return stack == null ? ItemStack.field_190927_a : stack;
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    public static class StackProviderVanilla
    implements IStackProvider {
        @Nonnull
        private ItemStack stack;

        public StackProviderVanilla(@Nonnull ItemStack stack) {
            this.stack = stack;
        }

        @Override
        @Nonnull
        public ItemStack getStack() {
            return this.stack;
        }
    }

    public static interface IStackProvider {
        @Nonnull
        public ItemStack getStack();
    }

    public static enum Operation {
        EXTRACT,
        INSERT;

    }
}

