/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.proxy;

import com.direwolf20.buildinggadgets.client.gui.GuiProxy;
import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.ModSounds;
import com.direwolf20.buildinggadgets.common.blocks.ConstructionBlock;
import com.direwolf20.buildinggadgets.common.blocks.ConstructionBlockPowder;
import com.direwolf20.buildinggadgets.common.blocks.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.blocks.ModBlocks;
import com.direwolf20.buildinggadgets.common.blocks.templatemanager.TemplateManager;
import com.direwolf20.buildinggadgets.common.blocks.templatemanager.TemplateManagerTileEntity;
import com.direwolf20.buildinggadgets.common.config.CompatConfig;
import com.direwolf20.buildinggadgets.common.config.SyncedConfig;
import com.direwolf20.buildinggadgets.common.entities.ModEntities;
import com.direwolf20.buildinggadgets.common.integration.IntegrationHandler;
import com.direwolf20.buildinggadgets.common.items.Template;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetBuilding;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetDestruction;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetExchanger;
import com.direwolf20.buildinggadgets.common.items.pastes.ConstructionPaste;
import com.direwolf20.buildinggadgets.common.items.pastes.ConstructionPasteContainer;
import com.direwolf20.buildinggadgets.common.items.pastes.ConstructionPasteContainerCreative;
import com.direwolf20.buildinggadgets.common.items.pastes.RegularPasteContainerTypes;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class CommonProxy {
    private boolean applyCompatConfig = false;

    public void preInit(FMLPreInitializationEvent e) {
        ModEntities.init();
        PacketHandler.registerMessages();
        File cfgFile = new File(e.getModConfigurationDirectory(), "BuildingGadgets.cfg");
        if (cfgFile.exists()) {
            BuildingGadgets.logger.info("Preparing to migrate old config Data to new Format");
            this.applyCompatConfig = CompatConfig.readConfig(cfgFile);
        }
        IntegrationHandler.preInit(e);
    }

    public void init() {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)BuildingGadgets.instance, (IGuiHandler)new GuiProxy());
        if (this.applyCompatConfig) {
            BuildingGadgets.logger.info("Migrating old config Data.");
            CompatConfig.applyCompatConfig();
        }
    }

    public void postInit() {
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().register((IForgeRegistryEntry)new EffectBlock());
        event.getRegistry().register((IForgeRegistryEntry)new TemplateManager());
        GameRegistry.registerTileEntity(TemplateManagerTileEntity.class, (ResourceLocation)new ResourceLocation("buildinggadgets", "templateManager"));
        if (SyncedConfig.enablePaste) {
            event.getRegistry().register((IForgeRegistryEntry)new ConstructionBlock());
            event.getRegistry().register((IForgeRegistryEntry)new ConstructionBlockPowder());
            GameRegistry.registerTileEntity(ConstructionBlockTileEntity.class, (ResourceLocation)new ResourceLocation("buildinggadgets", "_constructionBlock"));
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)new GadgetBuilding());
        event.getRegistry().register((IForgeRegistryEntry)new GadgetExchanger());
        event.getRegistry().register((IForgeRegistryEntry)new GadgetCopyPaste());
        event.getRegistry().register(new ItemBlock((Block)ModBlocks.templateManager).setRegistryName(ModBlocks.templateManager.getRegistryName()));
        event.getRegistry().register((IForgeRegistryEntry)new Template());
        if (SyncedConfig.enableDestructionGadget) {
            event.getRegistry().register((IForgeRegistryEntry)new GadgetDestruction());
        }
        if (SyncedConfig.enablePaste) {
            event.getRegistry().register(new ItemBlock((Block)ModBlocks.constructionBlock).setRegistryName(ModBlocks.constructionBlock.getRegistryName()));
            event.getRegistry().register(new ItemBlock((Block)ModBlocks.constructionBlockPowder).setRegistryName(ModBlocks.constructionBlockPowder.getRegistryName()));
            event.getRegistry().register((IForgeRegistryEntry)new ConstructionPaste());
            for (RegularPasteContainerTypes type : RegularPasteContainerTypes.values()) {
                event.getRegistry().register((IForgeRegistryEntry)new ConstructionPasteContainer(type.itemSuffix, type.capacitySupplier));
            }
            event.getRegistry().register((IForgeRegistryEntry)new ConstructionPasteContainerCreative());
        }
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (ModSounds sound : ModSounds.values()) {
            event.getRegistry().register((IForgeRegistryEntry)sound.getSound());
        }
    }
}

