/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.gadgets;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.blocks.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.blocks.ModBlocks;
import com.direwolf20.buildinggadgets.common.config.SyncedConfig;
import com.direwolf20.buildinggadgets.common.entities.BlockBuildEntity;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetGeneric;
import com.direwolf20.buildinggadgets.common.tools.BlockMapIntState;
import com.direwolf20.buildinggadgets.common.tools.GadgetUtils;
import com.direwolf20.buildinggadgets.common.tools.VectorTools;
import com.direwolf20.buildinggadgets.common.tools.WorldSave;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class GadgetDestruction
extends GadgetGeneric {
    public GadgetDestruction() {
        this.setRegistryName("destructiontool");
        this.func_77655_b("buildinggadgets.destructiontool");
        this.func_77625_d(1);
        this.func_77656_e(SyncedConfig.durabilityDestruction);
    }

    public int getMaxDamage(ItemStack stack) {
        return SyncedConfig.poweredByFE ? 0 : SyncedConfig.durabilityDestruction;
    }

    @Override
    public int getEnergyMax() {
        return SyncedConfig.energyMaxDestruction;
    }

    @Override
    public int getEnergyCost(ItemStack tool) {
        return SyncedConfig.energyCostDestruction * this.getCostMultiplier(tool);
    }

    @Override
    public int getDamageCost(ItemStack tool) {
        return SyncedConfig.damageCostDestruction * this.getCostMultiplier(tool);
    }

    private int getCostMultiplier(ItemStack tool) {
        return (int)(SyncedConfig.nonFuzzyEnabledDestruction && !GadgetDestruction.getFuzzy(tool) ? SyncedConfig.nonFuzzyMultiplierDestruction : 1.0);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag b) {
        super.func_77624_a(stack, world, list, b);
        list.add(TextFormatting.RED + I18n.func_135052_a((String)"tooltip.gadget.destroywarning", (Object[])new Object[0]));
        list.add(TextFormatting.AQUA + I18n.func_135052_a((String)"tooltip.gadget.destroyshowoverlay", (Object[])new Object[0]) + ": " + GadgetDestruction.getOverlay(stack));
        list.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"tooltip.gadget.connectedarea", (Object[])new Object[0]) + ": " + GadgetDestruction.getConnectedArea(stack));
        if (SyncedConfig.nonFuzzyEnabledDestruction) {
            list.add(TextFormatting.GOLD + I18n.func_135052_a((String)"tooltip.gadget.fuzzy", (Object[])new Object[0]) + ": " + GadgetDestruction.getFuzzy(stack));
        }
        GadgetDestruction.addInformationRayTraceFluid(list, stack);
        this.addEnergyInformation(list, stack);
    }

    @Nullable
    public static String getUUID(ItemStack stack) {
        String uuid;
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if ((uuid = tagCompound.func_74779_i("UUID")).isEmpty()) {
            UUID uid = UUID.randomUUID();
            tagCompound.func_74778_a("UUID", uid.toString());
            stack.func_77982_d(tagCompound);
            uuid = uid.toString();
        }
        return uuid;
    }

    public static void setAnchor(ItemStack stack, BlockPos pos) {
        GadgetUtils.writePOSToNBT(stack, pos, "anchor");
    }

    public static BlockPos getAnchor(ItemStack stack) {
        return GadgetUtils.getPOSFromNBT(stack, "anchor");
    }

    public static void setAnchorSide(ItemStack stack, EnumFacing side) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (side == null) {
            if (tagCompound.func_74781_a("anchorSide") != null) {
                tagCompound.func_82580_o("anchorSide");
                stack.func_77982_d(tagCompound);
            }
            return;
        }
        tagCompound.func_74778_a("anchorSide", side.func_176610_l());
        stack.func_77982_d(tagCompound);
    }

    public static EnumFacing getAnchorSide(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        String facing = tagCompound.func_74779_i("anchorSide");
        if (facing.isEmpty()) {
            return null;
        }
        return EnumFacing.func_176739_a((String)facing);
    }

    public static void setToolValue(ItemStack stack, int value, String valueName) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        tagCompound.func_74768_a(valueName, value);
        stack.func_77982_d(tagCompound);
    }

    public static int getToolValue(ItemStack stack, String valueName) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        return tagCompound.func_74762_e(valueName);
    }

    public static boolean getOverlay(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            tagCompound.func_74757_a("overlay", true);
            tagCompound.func_74757_a("fuzzy", true);
            stack.func_77982_d(tagCompound);
            return true;
        }
        if (tagCompound.func_74764_b("overlay")) {
            return tagCompound.func_74767_n("overlay");
        }
        tagCompound.func_74757_a("overlay", true);
        stack.func_77982_d(tagCompound);
        return true;
    }

    public static void setOverlay(ItemStack stack, boolean showOverlay) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        tagCompound.func_74757_a("overlay", showOverlay);
        stack.func_77982_d(tagCompound);
    }

    public void switchOverlay(EntityPlayer player, ItemStack stack) {
        boolean overlay = !GadgetDestruction.getOverlay(stack);
        GadgetDestruction.setOverlay(stack, overlay);
        player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("tooltip.gadget.destroyshowoverlay", new Object[0]).func_150261_e() + ": " + overlay), true);
    }

    public static List<EnumFacing> assignDirections(EnumFacing side, EntityPlayer player) {
        ArrayList<EnumFacing> dirs = new ArrayList<EnumFacing>();
        EnumFacing depth = side.func_176734_d();
        boolean vertical = side.func_176740_k() == EnumFacing.Axis.Y;
        EnumFacing up = vertical ? player.func_174811_aO() : EnumFacing.UP;
        EnumFacing left = vertical ? up.func_176746_e() : side.func_176735_f();
        EnumFacing right = left.func_176734_d();
        if (side == EnumFacing.DOWN) {
            up = up.func_176734_d();
        }
        EnumFacing down = up.func_176734_d();
        dirs.add(left);
        dirs.add(right);
        dirs.add(up);
        dirs.add(down);
        dirs.add(depth);
        return dirs;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        if (!world.field_72995_K) {
            if (!player.func_70093_af()) {
                RayTraceResult lookingAt = VectorTools.getLookingAt(player, stack);
                if (lookingAt == null && GadgetDestruction.getAnchor(stack) == null) {
                    return new ActionResult(EnumActionResult.FAIL, (Object)stack);
                }
                BlockPos startBlock = GadgetDestruction.getAnchor(stack) == null ? lookingAt.func_178782_a() : GadgetDestruction.getAnchor(stack);
                EnumFacing sideHit = GadgetDestruction.getAnchorSide(stack) == null ? lookingAt.field_178784_b : GadgetDestruction.getAnchorSide(stack);
                this.clearArea(world, startBlock, sideHit, player, stack);
                if (GadgetDestruction.getAnchor(stack) != null) {
                    GadgetDestruction.setAnchor(stack, null);
                    GadgetDestruction.setAnchorSide(stack, null);
                    player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget.anchorremove", new Object[0]).func_150261_e()), true);
                }
            }
        } else if (player.func_70093_af()) {
            player.openGui((Object)BuildingGadgets.instance, 1, world, hand.ordinal(), 0, 0);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public static void anchorBlocks(EntityPlayer player, ItemStack stack) {
        BlockPos currentAnchor = GadgetDestruction.getAnchor(stack);
        if (currentAnchor == null) {
            RayTraceResult lookingAt = VectorTools.getLookingAt(player, stack);
            if (lookingAt == null) {
                return;
            }
            currentAnchor = lookingAt.func_178782_a();
            GadgetDestruction.setAnchor(stack, currentAnchor);
            GadgetDestruction.setAnchorSide(stack, lookingAt.field_178784_b);
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget.anchorrender", new Object[0]).func_150261_e()), true);
        } else {
            GadgetDestruction.setAnchor(stack, null);
            GadgetDestruction.setAnchorSide(stack, null);
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget.anchorremove", new Object[0]).func_150261_e()), true);
        }
    }

    public static SortedSet<BlockPos> getArea(World world, BlockPos pos, EnumFacing incomingSide, EntityPlayer player, ItemStack stack) {
        IBlockState stateTarget;
        TreeSet<Vec3i> voidPositions = new TreeSet<Vec3i>(Comparator.comparingInt(Vec3i::func_177958_n).thenComparingInt(Vec3i::func_177956_o).thenComparingInt(Vec3i::func_177952_p));
        int depth = GadgetDestruction.getToolValue(stack, "depth");
        if (depth == 0) {
            return voidPositions;
        }
        BlockPos startPos = GadgetDestruction.getAnchor(stack) == null ? pos : GadgetDestruction.getAnchor(stack);
        EnumFacing side = GadgetDestruction.getAnchorSide(stack) == null ? incomingSide : GadgetDestruction.getAnchorSide(stack);
        List<EnumFacing> directions = GadgetDestruction.assignDirections(side, player);
        IBlockState iBlockState = stateTarget = !SyncedConfig.nonFuzzyEnabledDestruction || GadgetGeneric.getFuzzy(stack) ? null : world.func_180495_p(pos);
        if (GadgetGeneric.getConnectedArea(stack)) {
            String[] directionNames = new String[]{"right", "left", "up", "down", "depth"};
            AxisAlignedBB area = new AxisAlignedBB(pos);
            for (int i = 0; i < directionNames.length; ++i) {
                area = area.func_111270_a(new AxisAlignedBB(pos.func_177967_a(directions.get(i), GadgetDestruction.getToolValue(stack, directionNames[i]) - (i == 4 ? 1 : 0))));
            }
            GadgetDestruction.addConnectedCoords(world, player, startPos, stateTarget, voidPositions, (int)area.field_72340_a, (int)area.field_72338_b, (int)area.field_72339_c, (int)area.field_72336_d - 1, (int)area.field_72337_e - 1, (int)area.field_72334_f - 1);
        } else {
            int left = -GadgetDestruction.getToolValue(stack, "left");
            int right = GadgetDestruction.getToolValue(stack, "right");
            int down = -GadgetDestruction.getToolValue(stack, "down");
            int up = GadgetDestruction.getToolValue(stack, "up");
            for (int d = 0; d < depth; ++d) {
                for (int x = left; x <= right; ++x) {
                    for (int y = down; y <= up; ++y) {
                        BlockPos voidPos = new BlockPos((Vec3i)startPos);
                        voidPos = voidPos.func_177967_a(directions.get(0), x);
                        voidPos = voidPos.func_177967_a(directions.get(2), y);
                        if (!GadgetDestruction.validBlock(world, voidPos = voidPos.func_177967_a(directions.get(4), d), player, stateTarget)) continue;
                        voidPositions.add((Vec3i)voidPos);
                    }
                }
            }
        }
        return voidPositions;
    }

    public static void addConnectedCoords(World world, EntityPlayer player, BlockPos loc, IBlockState state, SortedSet<BlockPos> coords, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        if (coords.contains(loc) || loc.func_177958_n() < minX || loc.func_177956_o() < minY || loc.func_177952_p() < minZ || loc.func_177958_n() > maxX || loc.func_177956_o() > maxY || loc.func_177952_p() > maxZ) {
            return;
        }
        if (!GadgetDestruction.validBlock(world, loc, player, state)) {
            return;
        }
        coords.add(loc);
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    GadgetDestruction.addConnectedCoords(world, player, loc.func_177982_a(x, y, z), state, coords, minX, minY, minZ, maxX, maxY, maxZ);
                }
            }
        }
    }

    public static boolean validBlock(World world, BlockPos voidPos, EntityPlayer player, @Nullable IBlockState stateTarget) {
        IBlockState currentBlock = world.func_180495_p(voidPos);
        if (stateTarget != null && currentBlock != stateTarget) {
            return false;
        }
        TileEntity te = world.func_175625_s(voidPos);
        if (currentBlock.func_185904_a() == Material.field_151579_a) {
            return false;
        }
        if (currentBlock.equals(ModBlocks.effectBlock.func_176223_P())) {
            return false;
        }
        if (te != null && !(te instanceof ConstructionBlockTileEntity)) {
            return false;
        }
        if (currentBlock.func_185887_b(world, voidPos) < 0.0f) {
            return false;
        }
        ItemStack tool = GadgetDestruction.getGadget(player);
        if (tool.func_190926_b()) {
            return false;
        }
        if (!player.func_175142_cm()) {
            return false;
        }
        if (!world.func_175660_a(player, voidPos)) {
            return false;
        }
        if (!world.field_72995_K) {
            BlockSnapshot blockSnapshot = BlockSnapshot.getBlockSnapshot((World)world, (BlockPos)voidPos);
            if (ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)player, (BlockSnapshot)blockSnapshot, (EnumFacing)EnumFacing.UP, (EnumHand)EnumHand.MAIN_HAND).isCanceled()) {
                return false;
            }
            BlockEvent.BreakEvent e = new BlockEvent.BreakEvent(world, voidPos, currentBlock, player);
            if (MinecraftForge.EVENT_BUS.post((Event)e)) {
                return false;
            }
        }
        return true;
    }

    public void clearArea(World world, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        SortedSet<BlockPos> voidPosArray = GadgetDestruction.getArea(world, pos, side, player, stack);
        HashMap<BlockPos, IBlockState> posStateMap = new HashMap<BlockPos, IBlockState>();
        HashMap<BlockPos, IBlockState> pasteStateMap = new HashMap<BlockPos, IBlockState>();
        for (BlockPos voidPos : voidPosArray) {
            boolean success;
            TileEntity te;
            IBlockState blockState = world.func_180495_p(voidPos);
            IBlockState pasteState = Blocks.field_150350_a.func_176223_P();
            if (blockState.func_177230_c() == ModBlocks.constructionBlock && (te = world.func_175625_s(voidPos)) instanceof ConstructionBlockTileEntity) {
                pasteState = ((ConstructionBlockTileEntity)te).getActualBlockState();
            }
            if (success = this.destroyBlock(world, voidPos, player)) {
                posStateMap.put(voidPos, blockState);
            }
            if (pasteState == Blocks.field_150350_a.func_176223_P()) continue;
            pasteStateMap.put(voidPos, pasteState);
        }
        if (posStateMap.size() > 0) {
            BlockPos startPos = GadgetDestruction.getAnchor(stack) == null ? pos : GadgetDestruction.getAnchor(stack);
            GadgetDestruction.storeUndo(world, posStateMap, pasteStateMap, startPos, stack, player);
        }
    }

    public static void storeUndo(World world, Map<BlockPos, IBlockState> posStateMap, Map<BlockPos, IBlockState> pasteStateMap, BlockPos startBlock, ItemStack stack, EntityPlayer player) {
        WorldSave worldSave = WorldSave.getWorldSaveDestruction(world);
        NBTTagCompound tagCompound = new NBTTagCompound();
        ArrayList<Integer> posIntArrayList = new ArrayList<Integer>();
        ArrayList<Integer> stateIntArrayList = new ArrayList<Integer>();
        ArrayList<Integer> pastePosArrayList = new ArrayList<Integer>();
        ArrayList<Integer> pasteStateArrayList = new ArrayList<Integer>();
        BlockMapIntState blockMapIntState = new BlockMapIntState();
        String UUID2 = GadgetDestruction.getUUID(stack);
        for (Map.Entry<BlockPos, IBlockState> entry : posStateMap.entrySet()) {
            posIntArrayList.add(GadgetUtils.relPosToInt(startBlock, entry.getKey()));
            blockMapIntState.addToMap(entry.getValue());
            stateIntArrayList.add(Integer.valueOf(blockMapIntState.findSlot(entry.getValue()).shortValue()));
            if (!pasteStateMap.containsKey(entry.getKey())) continue;
            pastePosArrayList.add(GadgetUtils.relPosToInt(startBlock, entry.getKey()));
            IBlockState pasteBlockState = pasteStateMap.get(entry.getKey());
            blockMapIntState.addToMap(pasteBlockState);
            pasteStateArrayList.add(Integer.valueOf(blockMapIntState.findSlot(pasteBlockState).shortValue()));
        }
        tagCompound.func_74782_a("mapIntState", (NBTBase)blockMapIntState.putIntStateMapIntoNBT());
        int[] posIntArray = posIntArrayList.stream().mapToInt(i -> i).toArray();
        int[] stateIntArray = stateIntArrayList.stream().mapToInt(i -> i).toArray();
        int[] posPasteArray = pastePosArrayList.stream().mapToInt(i -> i).toArray();
        int[] statePasteArray = pasteStateArrayList.stream().mapToInt(i -> i).toArray();
        tagCompound.func_74783_a("posIntArray", posIntArray);
        tagCompound.func_74783_a("stateIntArray", stateIntArray);
        tagCompound.func_74783_a("posPasteArray", posPasteArray);
        tagCompound.func_74783_a("statePasteArray", statePasteArray);
        tagCompound.func_74782_a("startPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)startBlock));
        tagCompound.func_74768_a("dim", player.field_71093_bK);
        tagCompound.func_74778_a("UUID", UUID2);
        worldSave.addToMap(UUID2, tagCompound);
        worldSave.markForSaving();
    }

    public void undo(EntityPlayer player, ItemStack stack) {
        World world = player.field_70170_p;
        WorldSave worldSave = WorldSave.getWorldSaveDestruction(world);
        NBTTagCompound tagCompound = worldSave.getCompoundFromUUID(GadgetDestruction.getUUID(stack));
        if (tagCompound == null) {
            return;
        }
        BlockPos startPos = NBTUtil.func_186861_c((NBTTagCompound)tagCompound.func_74775_l("startPos"));
        if (startPos == null) {
            return;
        }
        int[] posIntArray = tagCompound.func_74759_k("posIntArray");
        int[] stateIntArray = tagCompound.func_74759_k("stateIntArray");
        int[] posPasteArray = tagCompound.func_74759_k("posPasteArray");
        int[] statePasteArray = tagCompound.func_74759_k("statePasteArray");
        NBTTagList MapIntStateTag = (NBTTagList)tagCompound.func_74781_a("mapIntState");
        if (MapIntStateTag == null) {
            return;
        }
        BlockMapIntState MapIntState = new BlockMapIntState();
        MapIntState.getIntStateMapFromNBT(MapIntStateTag);
        boolean success = false;
        for (int i = 0; i < posIntArray.length; ++i) {
            BlockPos placePos = GadgetUtils.relIntToPos(startPos, posIntArray[i]);
            IBlockState currentState = world.func_180495_p(placePos);
            if (currentState.func_185904_a() != Material.field_151579_a && !currentState.func_185904_a().func_76224_d()) continue;
            IBlockState placeState = MapIntState.getStateFromSlot((short)stateIntArray[i]);
            if (placeState.func_177230_c() == ModBlocks.constructionBlock) {
                IBlockState pasteState = Blocks.field_150350_a.func_176223_P();
                for (int j = 0; j < posPasteArray.length; ++j) {
                    if (posPasteArray[j] != posIntArray[i]) continue;
                    pasteState = MapIntState.getStateFromSlot((short)statePasteArray[j]);
                    break;
                }
                if (pasteState == Blocks.field_150350_a.func_176223_P()) continue;
                world.func_72838_d((Entity)new BlockBuildEntity(world, placePos, (EntityLivingBase)player, pasteState, 1, pasteState, true));
                success = true;
                continue;
            }
            world.func_72838_d((Entity)new BlockBuildEntity(world, placePos, (EntityLivingBase)player, placeState, 1, placeState, false));
            success = true;
        }
        if (success) {
            NBTTagCompound newTag = new NBTTagCompound();
            worldSave.addToMap(GadgetDestruction.getUUID(stack), newTag);
            worldSave.markForSaving();
        }
    }

    private boolean destroyBlock(World world, BlockPos voidPos, EntityPlayer player) {
        ItemStack tool = GadgetDestruction.getGadget(player);
        if (tool.func_190926_b()) {
            return false;
        }
        if (!this.canUse(tool, player)) {
            return false;
        }
        this.applyDamage(tool, player);
        world.func_72838_d((Entity)new BlockBuildEntity(world, voidPos, (EntityLivingBase)player, world.func_180495_p(voidPos), 2, Blocks.field_150350_a.func_176223_P(), false));
        return true;
    }

    public static ItemStack getGadget(EntityPlayer player) {
        ItemStack stack = GadgetGeneric.getGadget(player);
        if (!(stack.func_77973_b() instanceof GadgetDestruction)) {
            return ItemStack.field_190927_a;
        }
        return stack;
    }
}

