/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.integration;

import com.direwolf20.buildinggadgets.common.integration.IntegrationHandler;
import com.direwolf20.buildinggadgets.common.tools.NetworkIO;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeProxy;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.api.util.Action;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.IItemHandler;

@IntegrationHandler.IntegratedMod(value="refinedstorage")
public class RefinedStorage
implements IntegrationHandler.IIntegratedMod {
    private static boolean isLoaded;

    @Override
    public void initialize() {
        isLoaded = true;
    }

    @Nullable
    public static IItemHandler getWrappedNetwork(TileEntity te, EntityPlayer player, NetworkIO.Operation operation) {
        INetwork network;
        if (isLoaded && te instanceof INetworkNodeProxy && (network = ((INetworkNodeProxy)te).getNode().getNetwork()) != null && network.getSecurityManager().hasPermission(operation == NetworkIO.Operation.EXTRACT ? Permission.EXTRACT : Permission.INSERT, player)) {
            return new NetworkRefinedStorageIO(player, network, operation);
        }
        return null;
    }

    private static class NetworkRefinedStorageIO
    extends NetworkIO {
        private INetwork network;

        public NetworkRefinedStorageIO(EntityPlayer player, INetwork network, NetworkIO.Operation operation) {
            super(player, operation == NetworkIO.Operation.INSERT ? null : (Collection)network.getItemStorageCache().getList().getStacks().stream().map(stack -> new NetworkIO.StackProviderVanilla((ItemStack)stack)).collect(Collectors.toList()));
            this.network = network;
        }

        @Override
        @Nullable
        public ItemStack insertItemInternal(ItemStack stack, boolean simulate) {
            return this.network.insertItem(stack, stack.func_190916_E(), this.getAction(simulate));
        }

        @Override
        @Nullable
        public ItemStack extractItemInternal(int slot, int amount, boolean simulate) {
            return this.network.extractItem(this.getStackInSlot(slot), amount, this.getAction(simulate));
        }

        private Action getAction(boolean simulate) {
            return simulate ? Action.SIMULATE : Action.PERFORM;
        }
    }
}

