/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.gui;

import com.direwolf20.buildinggadgets.client.KeyBindings;
import com.direwolf20.buildinggadgets.client.gui.GuiButtonAction;
import com.direwolf20.buildinggadgets.client.gui.GuiButtonSound;
import com.direwolf20.buildinggadgets.common.ModSounds;
import com.direwolf20.buildinggadgets.common.config.SyncedConfig;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetBuilding;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetDestruction;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetExchanger;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetGeneric;
import com.direwolf20.buildinggadgets.common.network.PacketChangeRange;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.PacketToggleBlockPlacement;
import com.direwolf20.buildinggadgets.common.network.PacketToggleConnectedArea;
import com.direwolf20.buildinggadgets.common.network.PacketToggleFuzzy;
import com.direwolf20.buildinggadgets.common.network.PacketToggleMode;
import com.direwolf20.buildinggadgets.common.network.PacketToggleRayTraceFluid;
import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public class ModeRadialMenu
extends GuiScreen {
    private static final ResourceLocation[] signsBuilding = new ResourceLocation[]{new ResourceLocation("buildinggadgets", "textures/ui/build_to_me.png"), new ResourceLocation("buildinggadgets", "textures/ui/vertical_column.png"), new ResourceLocation("buildinggadgets", "textures/ui/horizontal_column.png"), new ResourceLocation("buildinggadgets", "textures/ui/vertical_wall.png"), new ResourceLocation("buildinggadgets", "textures/ui/horizontal_wall.png"), new ResourceLocation("buildinggadgets", "textures/ui/stairs.png"), new ResourceLocation("buildinggadgets", "textures/ui/grid.png"), new ResourceLocation("buildinggadgets", "textures/ui/surface.png")};
    private static final ResourceLocation[] signsExchanger = new ResourceLocation[]{new ResourceLocation("buildinggadgets", "textures/ui/surface.png"), new ResourceLocation("buildinggadgets", "textures/ui/vertical_column.png"), new ResourceLocation("buildinggadgets", "textures/ui/horizontal_column.png"), new ResourceLocation("buildinggadgets", "textures/ui/grid.png")};
    private static final ResourceLocation[] signsCopyPaste = new ResourceLocation[]{new ResourceLocation("buildinggadgets", "textures/ui/copy.png"), new ResourceLocation("buildinggadgets", "textures/ui/paste.png")};
    private int timeIn = 0;
    private int slotSelected = -1;
    private int segments;

    public ModeRadialMenu(ItemStack stack) {
        this.field_146297_k = Minecraft.func_71410_x();
        if (stack.func_77973_b() instanceof GadgetGeneric) {
            this.setSocketable(stack);
        }
    }

    public void setSocketable(ItemStack stack) {
        if (stack.func_77973_b() instanceof GadgetBuilding) {
            this.segments = GadgetBuilding.ToolMode.values().length;
        } else if (stack.func_77973_b() instanceof GadgetExchanger) {
            this.segments = GadgetExchanger.ToolMode.values().length;
        } else if (stack.func_77973_b() instanceof GadgetCopyPaste) {
            this.segments = GadgetCopyPaste.ToolMode.values().length;
        }
    }

    public void func_73866_w_() {
        ItemStack tool = this.getGadget();
        boolean destruction = false;
        if (tool.func_77973_b() instanceof GadgetDestruction) {
            destruction = true;
            this.field_146292_n.add(new GuiButtonAction(I18n.func_135052_a((String)"tooltip.gadget.destroy.overlay", (Object[])new Object[0]), send -> {
                if (send.booleanValue()) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketChangeRange());
                }
                return GadgetDestruction.getOverlay(this.getGadget());
            }));
        }
        if (!(tool.func_77973_b() instanceof GadgetCopyPaste)) {
            if (!destruction || SyncedConfig.nonFuzzyEnabledDestruction) {
                this.field_146292_n.add(new GuiButtonAction(I18n.func_135052_a((String)"tooltip.gadget.fuzzy", (Object[])new Object[0]), send -> {
                    if (send.booleanValue()) {
                        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketToggleFuzzy());
                    }
                    return GadgetGeneric.getFuzzy(this.getGadget());
                }));
            }
            this.field_146292_n.add(new GuiButtonAction(I18n.func_135052_a((String)("message.gadget.connected" + (destruction ? "area" : "surface")), (Object[])new Object[0]), send -> {
                if (send.booleanValue()) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketToggleConnectedArea());
                }
                return GadgetGeneric.getConnectedArea(this.getGadget());
            }));
        }
        this.func_189646_b(new GuiButtonAction(I18n.func_135052_a((String)"tooltip.gadget.raytrace_fluid", (Object[])new Object[0]), send -> {
            if (send.booleanValue()) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketToggleRayTraceFluid());
            }
            return GadgetGeneric.shouldRayTraceFluid(this.getGadget());
        }));
        if (tool.func_77973_b() instanceof GadgetBuilding) {
            this.func_189646_b(new GuiButtonAction(I18n.func_135052_a((String)"tooltip.gadget.building.place_atop", (Object[])new Object[0]), send -> {
                if (send.booleanValue()) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketToggleBlockPlacement());
                }
                return GadgetBuilding.shouldPlaceAtop(this.getGadget());
            }));
        }
        this.updateButtons(tool);
    }

    private void updateButtons(ItemStack tool) {
        int x = 0;
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            GuiButtonSound button = (GuiButtonSound)((Object)this.field_146292_n.get(i));
            SoundEvent sound = ModSounds.BEEP.getSound();
            button.setSounds(sound, sound, 0.6f, 1.0f);
            if (!button.field_146125_m) continue;
            int len = this.field_146297_k.field_71466_p.func_78256_a(button.field_146126_j) + 6;
            x += len + 10;
            button.field_146120_f = len;
            button.field_146121_g = this.field_146297_k.field_71466_p.field_78288_b + 3;
            button.field_146129_i = this.field_146295_m / 2 - (tool.func_77973_b() instanceof GadgetDestruction ? button.field_146121_g + 4 : 110);
        }
        x = this.field_146294_l / 2 - (x - 10) / 2;
        for (GuiButtonSound button : this.field_146292_n) {
            if (!button.field_146125_m) continue;
            button.field_146128_h = x;
            x += button.field_146120_f + 10;
        }
    }

    private ItemStack getGadget() {
        return GadgetGeneric.getGadget((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }

    public void func_73863_a(int mx, int my, float partialTicks) {
        ResourceLocation[] signs;
        int modeIndex;
        boolean inRange;
        float stime = 5.0f;
        float fract = Math.min(stime, (float)this.timeIn + partialTicks) / stime;
        int x = this.field_146294_l / 2;
        int y = this.field_146295_m / 2;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((1.0f - fract) * (float)x), (float)((1.0f - fract) * (float)y), (float)0.0f);
        GlStateManager.func_179152_a((float)fract, (float)fract, (float)fract);
        super.func_73863_a(mx, my, partialTicks);
        GlStateManager.func_179121_F();
        if (this.segments == 0) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        int maxRadius = 80;
        float angle = ModeRadialMenu.mouseAngle(x, y, mx, my);
        int highlight = 5;
        GlStateManager.func_179147_l();
        GlStateManager.func_179103_j((int)7425);
        float totalDeg = 0.0f;
        float degPer = 360.0f / (float)this.segments;
        ArrayList<int[]> stringPositions = new ArrayList<int[]>();
        ItemStack tool = this.getGadget();
        if (tool.func_190926_b()) {
            return;
        }
        this.slotSelected = -1;
        float offset = 8.5f;
        double dist = new Vec3d((double)x, (double)y, 0.0).func_72438_d(new Vec3d((double)mx, (double)my, 0.0));
        boolean bl = inRange = dist > 35.0 && dist < 81.0;
        if (tool.func_77973_b() instanceof GadgetBuilding) {
            modeIndex = GadgetBuilding.getToolMode(tool).ordinal();
            signs = signsBuilding;
        } else if (tool.func_77973_b() instanceof GadgetExchanger) {
            modeIndex = GadgetExchanger.getToolMode(tool).ordinal();
            signs = signsExchanger;
        } else {
            modeIndex = GadgetCopyPaste.getToolMode(tool).ordinal();
            signs = signsCopyPaste;
        }
        for (int seg = 0; seg < this.segments; ++seg) {
            boolean mouseInSector = inRange && angle > totalDeg && angle < totalDeg + degPer;
            float radius = Math.max(0.0f, Math.min(((float)this.timeIn + partialTicks - (float)seg * 6.0f / (float)this.segments) * 40.0f, (float)maxRadius));
            GL11.glBegin((int)5);
            float gs = 0.25f;
            if (seg % 2 == 0) {
                gs += 0.1f;
            }
            float r = gs;
            float g = gs + (seg == modeIndex ? 1.0f : 0.0f);
            float b = gs;
            float a = 0.4f;
            if (mouseInSector) {
                this.slotSelected = seg;
                b = 1.0f;
                g = 1.0f;
                r = 1.0f;
            }
            GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
            for (float i = degPer; i >= 0.0f; i -= 1.0f) {
                float rad = (float)((double)((i + totalDeg) / 180.0f) * Math.PI);
                double xp = (double)x + Math.cos(rad) * (double)radius;
                double yp = (double)y + Math.sin(rad) * (double)radius;
                if ((int)i == (int)(degPer / 2.0f)) {
                    stringPositions.add(new int[]{(int)xp, (int)yp, mouseInSector ? 110 : 114});
                }
                GL11.glVertex2d((double)((double)x + Math.cos(rad) * (double)radius / (double)2.3f), (double)((double)y + Math.sin(rad) * (double)radius / (double)2.3f));
                GL11.glVertex2d((double)xp, (double)yp);
            }
            totalDeg += degPer;
            GL11.glEnd();
            if (!mouseInSector) continue;
            radius -= (float)highlight;
        }
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179098_w();
        for (int i = 0; i < stringPositions.size(); ++i) {
            int[] pos = (int[])stringPositions.get(i);
            int xp = pos[0];
            int yp = pos[1];
            char c = (char)pos[2];
            String name = "";
            name = tool.func_77973_b() instanceof GadgetBuilding ? GadgetBuilding.ToolMode.values()[i].toString() : (tool.func_77973_b() instanceof GadgetExchanger ? GadgetExchanger.ToolMode.values()[i].toString() : GadgetCopyPaste.ToolMode.values()[i].toString());
            name = "\u00a7" + c + name;
            int xsp = xp - 4;
            int ysp = yp;
            int width = this.field_146289_q.func_78256_a(name);
            double mod = 0.6;
            int xdp = (int)((double)(xp - x) * mod + (double)x);
            int ydp = (int)((double)(yp - y) * mod + (double)y);
            if (xsp < x) {
                xsp -= width - 8;
            }
            if (ysp < y) {
                ysp -= 9;
            }
            this.field_146289_q.func_175063_a(name, (float)xsp, (float)ysp, i == modeIndex ? Color.GREEN.getRGB() : Color.WHITE.getRGB());
            mod = 0.7;
            xdp = (int)((double)(xp - x) * mod + (double)x);
            ydp = (int)((double)(yp - y) * mod + (double)y);
            this.field_146297_k.field_71446_o.func_110577_a(signs[i]);
            ModeRadialMenu.func_146110_a((int)(xdp - 8), (int)(ydp - 8), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        }
        GlStateManager.func_179091_B();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74520_c();
        float s = 3.0f * fract;
        GlStateManager.func_179152_a((float)s, (float)s, (float)s);
        GlStateManager.func_179109_b((float)((float)x / s - offset), (float)((float)y / s - 8.0f), (float)0.0f);
        this.field_146297_k.func_175599_af().func_180450_b(tool, 0, 0);
        RenderHelper.func_74518_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
    }

    private void changeMode() {
        if (this.slotSelected >= 0) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketToggleMode(this.slotSelected));
            ModSounds.BEEP.playSound();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.changeMode();
    }

    public void func_73876_c() {
        if (!GameSettings.func_100015_a((KeyBinding)KeyBindings.modeSwitch)) {
            this.field_146297_k.func_147108_a(null);
            this.changeMode();
        }
        ImmutableSet set = ImmutableSet.of((Object)this.field_146297_k.field_71474_y.field_74351_w, (Object)this.field_146297_k.field_71474_y.field_74370_x, (Object)this.field_146297_k.field_71474_y.field_74368_y, (Object)this.field_146297_k.field_71474_y.field_74366_z, (Object)this.field_146297_k.field_71474_y.field_74311_E, (Object)this.field_146297_k.field_71474_y.field_151444_V, (Object[])new KeyBinding[]{this.field_146297_k.field_71474_y.field_74314_A});
        for (KeyBinding k : set) {
            KeyBinding.func_74510_a((int)k.func_151463_i(), (boolean)GameSettings.func_100015_a((KeyBinding)k));
        }
        ++this.timeIn;
        ItemStack tool = this.getGadget();
        boolean builder = tool.func_77973_b() instanceof GadgetBuilding;
        if (!builder && !(tool.func_77973_b() instanceof GadgetExchanger)) {
            return;
        }
        boolean changed = false;
        for (int i = 0; i < 2; ++i) {
            boolean curent;
            GuiButton button = (GuiButton)this.field_146292_n.get(i);
            if (builder) {
                curent = GadgetBuilding.getToolMode(tool) == GadgetBuilding.ToolMode.Surface;
            } else {
                boolean bl = curent = i == 0 || GadgetExchanger.getToolMode(tool) == GadgetExchanger.ToolMode.Surface;
            }
            if (button.field_146125_m == curent) continue;
            button.field_146125_m = curent;
            changed = true;
        }
        if (changed) {
            this.updateButtons(tool);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private static float mouseAngle(int x, int y, int mx, int my) {
        Vector2f baseVec = new Vector2f(1.0f, 0.0f);
        Vector2f mouseVec = new Vector2f((float)(mx - x), (float)(my - y));
        float ang = (float)(Math.acos(Vector2f.dot((Vector2f)baseVec, (Vector2f)mouseVec) / (baseVec.length() * mouseVec.length())) * 57.29577951308232);
        return my < y ? 360.0f - ang : ang;
    }
}

