/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.plugin.ceramics;

import com.google.common.eventbus.Subscribe;
import knightminer.tcomplement.common.CommonProxy;
import knightminer.tcomplement.common.Config;
import knightminer.tcomplement.common.PulseBase;
import knightminer.tcomplement.library.TCompRegistry;
import knightminer.tcomplement.shared.CommonsModule;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import slimeknights.tconstruct.shared.TinkerFluids;
import slimeknights.tconstruct.smeltery.block.BlockCasting;

@Pulse(id="CeramicsPlugin", description="Adds casting supplies made from porcelain", modsRequired="ceramics")
public class CeramicsPlugin
extends PulseBase {
    public static final String pulseID = "CeramicsPlugin";
    @SidedProxy(clientSide="knightminer.tcomplement.plugin.ceramics.CeramicsPluginClientProxy", serverSide="knightminer.tcomplement.common.CommonProxy")
    public static CommonProxy proxy;
    public static Block porcelainCasting;

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry r = event.getRegistry();
        porcelainCasting = CeramicsPlugin.registerBlock((IForgeRegistry<Block>)r, new BlockCasting(), "porcelain_casting");
        porcelainCasting.func_149647_a((CreativeTabs)TCompRegistry.tabGeneral);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry r = event.getRegistry();
        CeramicsPlugin.registerItemBlock((IForgeRegistry<Item>)r, porcelainCasting, BlockCasting.TYPE);
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        proxy.init();
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        ItemStack bucket;
        if (Config.general.bucketCast && this.isSmelteryLoaded() && !(bucket = GameRegistry.makeItemStack((String)"ceramics:clay_bucket", (int)0, (int)1, null)).func_190926_b()) {
            TinkerRegistry.registerTableCasting((ItemStack)bucket, (ItemStack)CommonsModule.castBucket, (Fluid)TinkerFluids.clay, (int)432);
            TinkerRegistry.registerTableCasting((ICastingRecipe)new CastingRecipe(bucket.func_77946_l(), RecipeMatch.of((ItemStack)CommonsModule.castBucketClay), (Fluid)TinkerFluids.clay, 432, true, false));
        }
    }
}

