/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.library;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import knightminer.tcomplement.library.IBlacklist;
import knightminer.tcomplement.library.RecipeMatchBlacklist;
import knightminer.tcomplement.library.Util;
import knightminer.tcomplement.library.events.TCompRegisterEvent;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.client.CreativeTab;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;

public class TCompRegistry {
    public static final Logger log = Util.getLogger("API");
    public static CreativeTab tabGeneral = new CreativeTab("TCompGeneral", new ItemStack(Blocks.field_150336_V));
    public static CreativeTab tabTools = new CreativeTab("TCompTools", new ItemStack(Items.field_151035_b));
    private static List<MeltingRecipe> meltingOverrides = Lists.newLinkedList();
    private static List<IBlacklist> meltingBlacklist = Lists.newLinkedList();

    public static void registerMelterOverride(MeltingRecipe recipe) {
        if (new TCompRegisterEvent.MelterOverrideRegisterEvent(recipe).fire()) {
            meltingOverrides.add(recipe);
        } else {
            try {
                String input = recipe.input.getInputs().stream().findFirst().map(ItemStack::func_77977_a).orElse("?");
                log.debug("Registration of melting recipe for " + recipe.getResult().getUnlocalizedName() + " from " + input + " has been cancelled by event");
            }
            catch (Exception e) {
                log.error("Error when logging melting event", (Throwable)e);
            }
        }
    }

    public static List<MeltingRecipe> getAllMeltingOverrides() {
        return ImmutableList.copyOf(meltingOverrides);
    }

    public static void registerMelterBlacklist(IBlacklist blacklist) {
        if (new TCompRegisterEvent.MelterBlackListRegisterEvent(blacklist).fire()) {
            meltingBlacklist.add(blacklist);
        } else {
            try {
                log.debug("Registration of melter blacklist recipe has been cancelled by event");
            }
            catch (Exception e) {
                log.error("Error when logging melting event", (Throwable)e);
            }
        }
    }

    public static void registerMelterBlacklist(RecipeMatch blacklist) {
        TCompRegistry.registerMelterBlacklist(new RecipeMatchBlacklist(blacklist));
    }

    public static boolean isSmeltingHidden(MeltingRecipe recipe) {
        List inputs = recipe.input.getInputs();
        for (IBlacklist blacklist : meltingBlacklist) {
            if (!inputs.stream().anyMatch(blacklist::matches)) continue;
            return true;
        }
        for (MeltingRecipe override : meltingOverrides) {
            if (!inputs.stream().anyMatch(arg_0 -> ((MeltingRecipe)override).matches(arg_0))) continue;
            return true;
        }
        return false;
    }

    public static MeltingRecipe getMelting(ItemStack stack) {
        for (MeltingRecipe recipe : meltingOverrides) {
            if (!recipe.matches(stack)) continue;
            return recipe;
        }
        for (IBlacklist blacklist : meltingBlacklist) {
            if (!blacklist.matches(stack)) continue;
            return null;
        }
        return TinkerRegistry.getMelting((ItemStack)stack);
    }
}

