/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.common;

import java.util.Locale;
import knightminer.tcomplement.TinkersComplement;
import knightminer.tcomplement.library.Util;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.block.BlockStairsBase;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.mantle.block.EnumBlockSlab;
import slimeknights.mantle.item.ItemBlockMeta;
import slimeknights.mantle.item.ItemBlockSlab;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.tools.Pattern;
import slimeknights.tconstruct.library.tools.ToolPart;
import slimeknights.tconstruct.tools.TinkerTools;

public class PulseBase {
    protected boolean isToolsLoaded() {
        return TConstruct.pulseManager.isPulseLoaded("TinkerTools");
    }

    protected boolean isSmelteryLoaded() {
        return TConstruct.pulseManager.isPulseLoaded("TinkerSmeltery");
    }

    protected boolean isMelterLoaded() {
        return TinkersComplement.pulseManager.isPulseLoaded("ModuleMelter");
    }

    protected boolean isCeramicsPluginLoaded() {
        return TinkersComplement.pulseManager.isPulseLoaded("CeramicsPlugin");
    }

    protected static <T extends Block> T registerBlock(IForgeRegistry<Block> registry, T block, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! Block: %s", name));
        }
        String prefixedName = Util.prefix(name);
        block.func_149663_c(prefixedName);
        PulseBase.register(registry, block, name);
        return block;
    }

    protected static <E extends Enum<E> & IStringSerializable> BlockStairsBase registerBlockStairsFrom(IForgeRegistry<Block> registry, EnumBlock<E> block, E value, String name) {
        return PulseBase.registerBlock(registry, new BlockStairsBase(block.func_176223_P().func_177226_a((IProperty)block.prop, value)), name);
    }

    protected static <T extends Block> T registerItemBlock(IForgeRegistry<Item> registry, T block) {
        ItemBlockMeta itemBlock = new ItemBlockMeta(block);
        itemBlock.func_77655_b(block.func_149739_a());
        PulseBase.register(registry, itemBlock, block.getRegistryName());
        return block;
    }

    protected static <T extends EnumBlock<?>> T registerEnumItemBlock(IForgeRegistry<Item> registry, T block) {
        ItemBlockMeta itemBlock = new ItemBlockMeta(block);
        itemBlock.func_77655_b(block.func_149739_a());
        PulseBase.register(registry, itemBlock, block.getRegistryName());
        ItemBlockMeta.setMappingProperty(block, (IProperty)block.prop);
        return block;
    }

    protected static <T extends Block> T registerItemBlock(IForgeRegistry<Item> registry, ItemBlock itemBlock) {
        itemBlock.func_77655_b(itemBlock.func_179223_d().func_149739_a());
        PulseBase.register(registry, itemBlock, itemBlock.func_179223_d().getRegistryName());
        return (T)itemBlock.func_179223_d();
    }

    protected static <T extends ItemBlock> T registerItemBlock(IForgeRegistry<Item> registry, T itemBlock, IProperty<?> property) {
        itemBlock.func_77655_b(itemBlock.func_179223_d().func_149739_a());
        PulseBase.register(registry, itemBlock, itemBlock.func_179223_d().getRegistryName());
        ItemBlockMeta.setMappingProperty((Block)itemBlock.func_179223_d(), property);
        return itemBlock;
    }

    protected static ItemBlockMeta registerItemBlock(IForgeRegistry<Item> registry, Block block, IProperty<?> property) {
        return PulseBase.registerItemBlock(registry, new ItemBlockMeta(block), property);
    }

    protected static <T extends EnumBlockSlab<?>> T registerEnumItemBlockSlab(IForgeRegistry<Item> registry, T block) {
        ItemBlockSlab itemBlock = new ItemBlockSlab(block);
        itemBlock.func_77655_b(block.func_149739_a());
        PulseBase.register(registry, itemBlock, block.getRegistryName());
        ItemBlockMeta.setMappingProperty(block, (IProperty)block.prop);
        return block;
    }

    protected static <T extends Item> T registerItem(IForgeRegistry<Item> registry, T item, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! Item: %s", name));
        }
        item.func_77655_b(Util.prefix(name));
        item.setRegistryName(Util.getResource(name));
        registry.register(item);
        return item;
    }

    protected static <T extends IForgeRegistryEntry<T>> T register(IForgeRegistry<T> registry, T thing, String name) {
        thing.setRegistryName(Util.getResource(name));
        registry.register(thing);
        return thing;
    }

    protected static <T extends IForgeRegistryEntry<T>> T register(IForgeRegistry<T> registry, T thing, ResourceLocation name) {
        thing.setRegistryName(name);
        registry.register(thing);
        return thing;
    }

    protected static void registerTE(Class<? extends TileEntity> teClazz, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! TE: %s", name));
        }
        GameRegistry.registerTileEntity(teClazz, (String)Util.resource(name));
    }

    protected static void registerStencil(ToolPart part) {
        TinkerRegistry.registerStencilTableCrafting((ItemStack)Pattern.setTagForPart((ItemStack)new ItemStack((Item)TinkerTools.pattern), (Item)part));
    }
}

