/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.Logger;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.client.ThEItemColors;
import thaumicenergistics.client.gui.GuiHandler;
import thaumicenergistics.integration.IThEIntegration;
import thaumicenergistics.integration.appeng.ThEAppliedEnergistics;
import thaumicenergistics.integration.thaumcraft.ThEThaumcraft;
import thaumicenergistics.network.PacketHandler;
import thaumicenergistics.util.ForgeUtil;
import thaumicenergistics.util.ThELog;

@Mod(modid="thaumicenergistics", name="Thaumic Energistics", version="2.2.1", dependencies="required-after:appliedenergistics2@[rv6-stable-6,);required-after:thaumcraft@[6.1.BETA26,);after:thaumicjei", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class ThaumicEnergistics {
    @Mod.Instance(value="thaumicenergistics")
    public static ThaumicEnergistics INSTANCE;
    public static Logger LOGGER;
    private static List<IThEIntegration> INTEGRATIONS;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOGGER = event.getModLog();
        ThEApi.instance();
        MinecraftForge.EVENT_BUS.register((Object)this);
        PacketHandler.register();
        INTEGRATIONS.add(new ThEThaumcraft());
        INTEGRATIONS.add(new ThEAppliedEnergistics());
        INTEGRATIONS.removeIf(in -> !in.isLoaded());
        ThELog.info("Integrations: PreInit", new Object[0]);
        INTEGRATIONS.forEach(IThEIntegration::preInit);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)new GuiHandler());
        if (ForgeUtil.isClient()) {
            ThEItemColors.registerItemColors();
        }
        ThEApi.instance().items().arcaneTerminal().maybeStack(1).ifPresent(stack -> ThEApi.instance().upgrades().arcaneCharger().registerItem((ItemStack)stack, 1));
        ThELog.info("Integrations: Init", new Object[0]);
        INTEGRATIONS.forEach(IThEIntegration::init);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ThELog.info("Integrations: PostInit", new Object[0]);
        INTEGRATIONS.forEach(IThEIntegration::postInit);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("thaumicenergistics")) {
            ConfigManager.sync((String)"thaumicenergistics", (Config.Type)Config.Type.INSTANCE);
        }
    }

    static {
        INTEGRATIONS = new ArrayList<IThEIntegration>();
    }
}

